/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.netbeans.api.vcs.FileStatusInfo;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.search.VcsSearchTypeFileSystem;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusListener;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataObject;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.EmptyEnumeration;

public abstract class VersioningFileSystem
extends AbstractFileSystem
implements VcsSearchTypeFileSystem {
    private static final SystemAction[] NO_ACTIONS = new SystemAction[0];
    public static final String VERSIONING_PROPERTIES_SAVE_METHOD = "saveVersioningFileSystemProperties";
    private AbstractFileSystem fileSystem;
    private transient EventListenerList listenerList = new EventListenerList();
    private static final long serialVersionUID = 1437726745709092169L;
    private StatusChangeUpdater statusUpdateRunnable;
    private RequestProcessor.Task statusUpdateTask;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener;

    public VersioningFileSystem() {
    }

    public VersioningFileSystem(AbstractFileSystem underlyingFs) {
        this();
        this.fileSystem = underlyingFs;
    }

    public abstract Versions getVersions();

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Image getFSIcon(int type) {
        FileSystem fs = this.getFileSystem();
        if (fs != null) {
            try {
                BeanInfo bi = Utilities.getBeanInfo(fs.getClass());
                if (bi != null) {
                    return bi.getIcon(type);
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getFSCustomizer() {
        block8: {
            FileSystem fs = this.getFileSystem();
            if (fs != null) {
                try {
                    BeanInfo bi = Utilities.getBeanInfo(fs.getClass());
                    if (bi == null) break block8;
                    Class<?> c = bi.getBeanDescriptor().getCustomizerClass();
                    if (c == null) {
                        return null;
                    }
                    try {
                        Object i = c.newInstance();
                        if (i instanceof Customizer) {
                            Customizer cust = (Customizer)i;
                            cust.setObject(fs);
                        }
                        return i;
                    }
                    catch (InstantiationException iex) {
                    }
                    catch (IllegalAccessException iaex) {
                    }
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected final void propagatePropertyChange(String[] properties) {
        Method method = null;
        try {
            method = this.fileSystem.getClass().getMethod(VERSIONING_PROPERTIES_SAVE_METHOD, class$java$lang$String == null ? (class$java$lang$String = VersioningFileSystem.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = VersioningFileSystem.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (NoSuchMethodException nsmExc) {
            method = null;
        }
        catch (SecurityException sExc) {
            method = null;
        }
        final Method changeMethod = method;
        if (changeMethod == null) {
            return;
        }
        final WeakReference<AbstractFileSystem> ref = new WeakReference<AbstractFileSystem>(this.fileSystem);
        final String[] props = properties;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                Object chFS = ref.get();
                if (chFS == null) {
                    VersioningFileSystem.this.removePropertyChangeListener(this);
                    return;
                }
                int i = 0;
                while (i < props.length) {
                    if (props[i].equals(prop)) {
                        try {
                            changeMethod.invoke(chFS, prop, evt.getNewValue());
                        }
                        catch (IllegalAccessException iaExc) {
                        }
                        catch (IllegalArgumentException iarExc) {
                        }
                        catch (InvocationTargetException itExc) {
                            // empty catch block
                        }
                        return;
                    }
                    ++i;
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    public String getDisplayName() {
        return this.fileSystem.getDisplayName();
    }

    public SystemAction[] getActions(Set vfoSet) {
        SystemAction[] actions = this.fileSystem.getActions(vfoSet);
        SystemAction myAction = SystemAction.get((Class)(class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction == null ? (class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction = VersioningFileSystem.class$("org.netbeans.modules.vcscore.actions.VersioningExplorerAction")) : class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction));
        int index = 0;
        while (index < actions.length) {
            if (myAction.equals((Object)actions[index])) break;
            ++index;
        }
        if (index < actions.length) {
            SystemAction[] actions1 = new SystemAction[actions.length - 1];
            if (index > 0) {
                System.arraycopy(actions, 0, actions1, 0, index);
            }
            if (index < actions1.length) {
                System.arraycopy(actions, index + 1, actions1, index, actions1.length - index);
            }
            actions = actions1;
        }
        return actions;
    }

    public FileStatusProvider getFileStatusProvider() {
        return null;
    }

    public String[] getPossibleFileStatuses() {
        FileStatusProvider statusProvider = this.getFileStatusProvider();
        if (statusProvider != null) {
            Set statusInfos = statusProvider.getPossibleFileStatusInfos();
            String[] statuses = new String[statusInfos.size()];
            int i = 0;
            Iterator it = statusInfos.iterator();
            while (it.hasNext()) {
                FileStatusInfo statusInfo = (FileStatusInfo)it.next();
                statuses[i] = statusInfo.getDisplayName();
                ++i;
            }
            return statuses;
        }
        return new String[0];
    }

    public String getStatus(DataObject dObject) {
        if (dObject instanceof VersioningDataObject) {
            VersioningDataObject vdo = (VersioningDataObject)dObject;
            return vdo.getStatus();
        }
        return "";
    }

    public void statusChanged(final String path, final boolean recursively) {
        VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fo = VersioningFileSystem.this.findExistingResource(path);
                if (fo == null) {
                    return;
                }
                Enumeration enumeration = VersioningFileSystem.super.existingFileObjects(fo);
                HashSet hs = new HashSet();
                if (enumeration.hasMoreElements()) {
                    hs.add(enumeration.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    FileObject chfo = (FileObject)enumeration.nextElement();
                    if (!recursively && !fo.equals(chfo.getParent())) break;
                    hs.add(chfo);
                }
                Set s = Collections.synchronizedSet(hs);
                VersioningFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VersioningFileSystem.this, s, true, true));
            }
        });
    }

    public void statusChanged(String name) {
        if (this.statusUpdateTask == null) {
            this.statusUpdateRunnable = new StatusChangeUpdater();
            this.statusUpdateTask = VcsFileSystem.getStatusChangeRequestProcessor().post((Runnable)this.statusUpdateRunnable, 200, 1);
        }
        this.statusUpdateRunnable.addNameToUpdate(name);
        this.statusUpdateTask.schedule(200);
    }

    public SystemAction[] getRevisionActions(FileObject fo, Set revisionItems) {
        return NO_ACTIONS;
    }

    public FileObject findExistingResource(String name) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        FileObject fo = null;
        while (enumeration.hasMoreElements()) {
            FileObject obj = (FileObject)enumeration.nextElement();
            if (!name.equals(obj.getPackageNameExt('/', '.'))) continue;
            fo = obj;
            break;
        }
        return fo;
    }

    private Set findExistingResources(Collection names) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        HashSet<FileObject> fos = new HashSet<FileObject>();
        Iterator namesIt = names.iterator();
        boolean hasNext = namesIt.hasNext();
        String name = hasNext ? (String)namesIt.next() : null;
        while (enumeration.hasMoreElements() && hasNext) {
            FileObject obj = (FileObject)enumeration.nextElement();
            if (!name.equals(obj.getPackageNameExt('/', '.'))) continue;
            fos.add(obj);
            hasNext = namesIt.hasNext();
            if (hasNext) {
                name = (String)namesIt.next();
                continue;
            }
            name = null;
            break;
        }
        return fos;
    }

    protected void refreshExistingFolders() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Enumeration e = VersioningFileSystem.super.existingFileObjects(VersioningFileSystem.this.getRoot());
                while (e.hasMoreElements()) {
                    FileObject fo = (FileObject)e.nextElement();
                    if (!fo.isFolder()) continue;
                    fo.refresh(true);
                }
            }
        });
    }

    public final void addVcsFileStatusListener(VcsFileStatusListener listener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener, listener);
        }
    }

    public final void removeVcsFileStatusListener(VcsFileStatusListener listener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener, listener);
        }
    }

    protected final void fireVcsFileStatusChanged(VcsFileStatusEvent ev) {
        VcsFileStatusListener[] listeners;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            listeners = (VcsFileStatusListener[])this.listenerList.getListeners(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningFileSystem.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener);
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].vcsStatusChanged(ev);
            ++i;
        }
    }

    public abstract String[] getStates(DataObject var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StatusChangeUpdater
    implements Runnable {
        private List namesToUpdate = new ArrayList();

        public synchronized void addNameToUpdate(String name) {
            this.namesToUpdate.add(name);
        }

        public void run() {
            List names;
            StatusChangeUpdater statusChangeUpdater = this;
            synchronized (statusChangeUpdater) {
                names = this.namesToUpdate;
                this.namesToUpdate = new ArrayList();
            }
            Set fos = VersioningFileSystem.this.findExistingResources(names);
            if (fos.isEmpty()) {
                return;
            }
            VersioningFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VersioningFileSystem.this, fos, true, true));
        }
    }

    public class DefVersioningList
    implements AbstractFileSystem.List {
        private static final long serialVersionUID = 567851736120604546L;

        public String[] children(String str) {
            FileObject fo = VersioningFileSystem.this.fileSystem.findResource(str);
            FileObject[] childs = fo.getChildren();
            if (childs != null) {
                String[] toReturn = new String[childs.length];
                int i = 0;
                while (i < childs.length) {
                    toReturn[i] = childs[i].getNameExt();
                    ++i;
                }
                return toReturn;
            }
            return new String[0];
        }
    }

    public class VersioningFSChange
    implements AbstractFileSystem.Change {
        private static final long serialVersionUID = -4757075426649682071L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem;

        public void delete(String name) throws IOException {
            FileObject fo = VersioningFileSystem.this.fileSystem.findResource(name);
            if (fo == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FileCanNotDelete", (Object)name));
            }
            fo.delete(fo.lock());
        }

        public void createFolder(String path) throws IOException {
            String dir = VcsUtilities.getDirNamePart(path);
            String file = VcsUtilities.getFileNamePart(path);
            FileObject fo = VersioningFileSystem.this.fileSystem.findResource(dir);
            if (fo == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FolderCanNotCreate", (Object)path));
            }
            fo.createFolder(file);
        }

        public void createData(String path) throws IOException {
            String dir = VcsUtilities.getDirNamePart(path);
            String file = VcsUtilities.getFileNamePart(path);
            FileObject fo = VersioningFileSystem.this.fileSystem.findResource(dir);
            if (fo == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FileCanNotCreate", (Object)path));
            }
            fo.createData(file);
        }

        public void rename(String oldName, String newName) throws IOException {
            String newFileExt;
            int extIndex = newName.lastIndexOf(46);
            if (extIndex >= 0) {
                newName = newName.substring(0, extIndex);
            }
            String oldDir = VcsUtilities.getDirNamePart(oldName);
            String oldFile = VcsUtilities.getFileNamePart(oldName);
            String newFile = VcsUtilities.getFileNamePart(newName);
            extIndex = newFile.lastIndexOf(46);
            if (extIndex >= 0) {
                newFileExt = newFile.substring(extIndex + 1);
                newFile = newFile.substring(0, extIndex);
            } else {
                newFileExt = null;
            }
            FileObject fo = VersioningFileSystem.this.fileSystem.findResource(oldName);
            if (fo == null) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem = VersioningFSChange.class$("org.netbeans.modules.vcscore.versioning.VersioningFileSystem")) : class$org$netbeans$modules$vcscore$versioning$VersioningFileSystem), (String)"Exc_FileCanNotRename", (Object)oldName));
            }
            fo.rename(fo.lock(), newFile, newFileExt);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class VersioningAttrs
    implements AbstractFileSystem.Attr {
        private HashMap files = new HashMap();
        private AbstractFileSystem.Info info;
        private static final long serialVersionUID = 7177122547454760079L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader;

        public VersioningAttrs(AbstractFileSystem.Info info) {
            this.info = info;
        }

        public void deleteAttributes(String name) {
            this.files.remove(name);
        }

        public Enumeration attributes(String name) {
            HashMap attrs = (HashMap)this.files.get(name);
            if (attrs == null) {
                return new EmptyEnumeration();
            }
            return Collections.enumeration(attrs.keySet());
        }

        public void renameAttributes(String oldName, String newName) {
            HashMap attrs = (HashMap)this.files.get(oldName);
            if (attrs != null) {
                this.files.remove(oldName);
                this.files.put(newName, attrs);
            }
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            HashMap<String, Object> attrs = (HashMap<String, Object>)this.files.get(name);
            if (attrs == null) {
                attrs = new HashMap<String, Object>();
            }
            attrs.put(attrName, value);
            this.files.put(name, attrs);
        }

        public Object readAttribute(String name, String attrName) {
            if ("NetBeansAttrAssignedLoader".equals(attrName)) {
                if (this.info != null && this.info.folder(name)) {
                    return (class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader = VersioningAttrs.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningFolderDataLoader")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningFolderDataLoader).getName();
                }
                return (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader = VersioningAttrs.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataLoader")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataLoader).getName();
            }
            HashMap attrs = (HashMap)this.files.get(name);
            Object toReturn = null;
            toReturn = attrs == null ? null : attrs.get(attrName);
            return toReturn;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Versions
    extends Serializable {
        public RevisionList getRevisions(String var1, boolean var2);

        public InputStream inputStream(String var1, String var2) throws FileNotFoundException;
    }
}

