/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryEvent;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener;
import org.openide.util.Lookup;

public final class VersioningRepository
implements Serializable {
    private static VersioningRepository repository;
    private ArrayList verSystems;
    private ArrayList verSystemsCopy;
    private Hashtable names;
    private transient EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("systemName")) {
                String ov = (String)ev.getOldValue();
                String nv = (String)ev.getNewValue();
                VersioningFileSystem fs = (VersioningFileSystem)ev.getSource();
                1 var5_5 = this;
                synchronized (var5_5) {
                    VersioningRepository.this.names.remove(ov);
                    VersioningRepository.this.names.put(nv, fs);
                }
            }
        }
    };
    private static final long serialVersionUID = 8047724018983158285L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VersioningRepository;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener;

    private VersioningRepository() {
        this.verSystems = new ArrayList();
        this.names = new Hashtable();
    }

    public static synchronized VersioningRepository getRepository() {
        if (repository == null) {
            VersioningRepository.initRepository();
        }
        return repository;
    }

    private static synchronized void initRepository() {
        if (repository != null) {
            return;
        }
        Lookup l = Lookup.getDefault();
        repository = (VersioningRepository)l.lookup(class$org$netbeans$modules$vcscore$versioning$VersioningRepository == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepository = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepository")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepository);
        if (repository == null) {
            repository = new VersioningRepository();
        }
    }

    public final void addVersioningFileSystem(VersioningFileSystem vfs) {
        boolean fireIt;
        VersioningRepository versioningRepository = this;
        synchronized (versioningRepository) {
            String systemName = vfs.getSystemName();
            if (!this.names.containsKey(systemName)) {
                this.verSystems.add(vfs);
                this.verSystemsCopy = new ArrayList(this.verSystems);
                vfs.addPropertyChangeListener(this.propListener);
                this.names.put(systemName, vfs);
                fireIt = true;
                vfs.addNotify();
            } else {
                fireIt = false;
            }
        }
        if (fireIt) {
            this.fireVerSystem(vfs, true);
        }
    }

    public final void removeVersioningFileSystem(VersioningFileSystem vfs) {
        boolean fireIt;
        VersioningRepository versioningRepository = this;
        synchronized (versioningRepository) {
            String systemName = vfs.getSystemName();
            if (this.names.containsKey(systemName)) {
                ((AbstractCollection)this.verSystems).remove(vfs);
                this.verSystemsCopy = new ArrayList(this.verSystems);
                vfs.removePropertyChangeListener(this.propListener);
                this.names.remove(systemName);
                fireIt = true;
                vfs.removeNotify();
            } else {
                fireIt = false;
            }
        }
        if (fireIt) {
            this.fireVerSystem(vfs, false);
        }
    }

    public final List getVersioningFileSystems() {
        ArrayList vfsl = new ArrayList(this.verSystems);
        return vfsl;
    }

    public final synchronized VersioningFileSystem getSystem(String systemName) {
        return (VersioningFileSystem)this.names.get(systemName);
    }

    public void addRepositoryListener(VersioningRepositoryListener listener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener, listener);
        }
    }

    public void removeRepositoryListener(VersioningRepositoryListener listener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener, listener);
        }
    }

    private void fireVerSystem(VersioningFileSystem vfs, boolean added) {
        VersioningRepositoryListener[] listeners;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            listeners = (VersioningRepositoryListener[])this.listenerList.getListeners(class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener);
        }
        VersioningRepositoryEvent ev = new VersioningRepositoryEvent(this, vfs, added);
        if (added) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].versioningSystemAdded(ev);
                ++i;
            }
        } else {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].versioningSystemRemoved(ev);
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer str;
        VersioningRepository versioningRepository = this;
        synchronized (versioningRepository) {
            str = new StringBuffer("VersioningRepository: names = " + this.names + ", names.size() = " + this.names.size());
            Iterator it = this.names.keySet().iterator();
            while (it.hasNext()) {
                String systemName = (String)it.next();
                str.append("systemName = " + systemName + ", filesystem = " + this.names.get(systemName));
            }
        }
        return str.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

