/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.netbeans.modules.vcscore.versioning.RefreshRevisionsCookie;
import org.netbeans.modules.vcscore.versioning.RevisionChildren;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionChildren;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionList;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class VersioningDataNode
extends DataNode
implements RefreshRevisionsCookie {
    private static final String FOLDER_ICON_BASE = "/org/openide/resources/defaultFolder";
    public static final String SET_SORTING = "sorting";
    private PropL propListener;
    private static RequestProcessor versRequestProcessor = null;
    static final long serialVersionUID = 3389837583027384658L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode;
    static /* synthetic */ Class class$java$lang$String;

    public VersioningDataNode(VersioningDataObject data) {
        super((DataObject)data, (Children)new NumDotRevisionChildren(null));
        this.init();
    }

    private void init() {
        this.getCookieSet().add((Node.Cookie)this);
        this.initListeners();
        this.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"VersioningDataNode.Description"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    private void initListeners() {
        RevisionChildren children = (RevisionChildren)this.getChildren();
        ChildrenNotificationListener childrenNotificationListener = new ChildrenNotificationListener();
        children.addNotificationListener(childrenNotificationListener);
        this.propListener = new PropL();
        try {
            FileSystem fs = this.getDataObject().getPrimaryFile().getFileSystem();
            fs.addFileStatusListener(WeakListener.fileStatus((FileStatusListener)this.propListener, (Object)fs));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        this.getDataObject().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)this.getDataObject()));
    }

    public String getDisplayName() {
        String s;
        try {
            FileObject fo = this.getDataObject().getPrimaryFile();
            s = fo.getFileSystem().getStatus().annotateName(fo.getNameExt(), this.getDataObject().files());
        }
        catch (FileStateInvalidException exc) {
            s = super.getDisplayName();
        }
        return s;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ps = sheet.get("properties");
        ps.put((Node.Property)new PropertySupport.ReadOnly("status", class$java$lang$String == null ? (class$java$lang$String = VersioningDataNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"PROP_Status"), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"HINT_Status")){

            public Object getValue() {
                String value = ((VersioningDataObject)VersioningDataNode.this.getDataObject()).getStatus();
                return value == null ? "" : value;
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly("revision", class$java$lang$String == null ? (class$java$lang$String = VersioningDataNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"PROP_Revision"), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"HINT_Revision")){

            public Object getValue() {
                String value = ((VersioningDataObject)VersioningDataNode.this.getDataObject()).getRevision();
                return value == null ? "" : value;
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly("locker", class$java$lang$String == null ? (class$java$lang$String = VersioningDataNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"PROP_Locker"), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"HINT_Locker")){

            public Object getValue() {
                String value = ((VersioningDataObject)VersioningDataNode.this.getDataObject()).getLocker();
                return value == null ? "" : value;
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly("sticky", class$java$lang$String == null ? (class$java$lang$String = VersioningDataNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"PROP_Sticky"), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode = VersioningDataNode.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataNode), (String)"HINT_Sticky")){

            public Object getValue() {
                String value = ((VersioningDataObject)VersioningDataNode.this.getDataObject()).getSticky();
                return value == null ? "" : value;
            }
        });
        sheet.put(ps);
        return sheet;
    }

    public static RequestProcessor getVersioningRequestProcessor() {
        if (versRequestProcessor == null) {
            versRequestProcessor = new RequestProcessor("Versioning Explorer Request Processor");
        }
        return versRequestProcessor;
    }

    public void refreshRevisions() {
        VersioningDataNode.getVersioningRequestProcessor().post(new Runnable(){

            public void run() {
                VersioningDataObject vdo = (VersioningDataObject)VersioningDataNode.this.getDataObject();
                RevisionList rList = vdo.getRevisionList(true);
                if (rList == null) {
                    rList = new NumDotRevisionList();
                }
                rList.setFileObject(vdo.getPrimaryFile());
                String revision = vdo.getRevision();
                if (revision != null) {
                    Iterator it = rList.iterator();
                    while (it.hasNext()) {
                        RevisionItem item = (RevisionItem)it.next();
                        item.setCurrent(revision.equals(item.getRevisionVCS()));
                    }
                }
                RevisionChildren children = (RevisionChildren)VersioningDataNode.this.getChildren();
                children.setList(rList);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PropL
    implements FileStatusListener,
    PropertyChangeListener {
        private PropL() {
        }

        public void annotationChanged(FileStatusEvent ev) {
            if (ev.isNameChange()) {
                VersioningDataNode.super.fireDisplayNameChange(null, null);
            } else if (ev.isIconChange()) {
                VersioningDataNode.super.fireIconChange();
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("revision".equals(ev.getPropertyName())) {
                String revision = (String)ev.getNewValue();
                RevisionList list = ((RevisionChildren)VersioningDataNode.this.getChildren()).getList();
                if (list != null) {
                    RevisionList revisionList = list;
                    synchronized (revisionList) {
                        if (revision == null) {
                            Iterator it = list.iterator();
                            while (it.hasNext()) {
                                RevisionItem item = (RevisionItem)it.next();
                                item.setCurrent(false);
                            }
                        } else {
                            Iterator it = list.iterator();
                            while (it.hasNext()) {
                                RevisionItem item = (RevisionItem)it.next();
                                item.setCurrent(revision.equals(item.getRevision()));
                            }
                        }
                    }
                }
            }
        }
    }

    private class ChildrenNotificationListener
    implements RevisionChildren.NotificationListener {
        private ChildrenNotificationListener() {
        }

        public void notifyAdded() {
            VersioningDataNode.this.refreshRevisions();
        }

        public void notifyRemoved() {
        }
    }
}

