/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning.impl;

import java.util.EventListener;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusListener;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class VersioningDataObject
extends MultiDataObject {
    public static final String PROP_STATUS = "status";
    public static final String PROP_LOCKER = "locker";
    public static final String PROP_REVISION = "revision";
    public static final String PROP_STICKY = "sticky";
    public static final String PROP_ALL_STATES = "all";
    private String status = null;
    private String locker = null;
    private String revision = null;
    private String sticky = null;
    private EditorCookie editor;
    private VCSFileStatusListener vcsFileStatusListener;
    private static final long serialVersionUID = 5622788615406683488L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener;

    public VersioningDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.initListeners();
    }

    private void initListeners() {
        VersioningFileSystem vfs;
        try {
            vfs = (VersioningFileSystem)this.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException exc) {
            return;
        }
        this.vcsFileStatusListener = new VCSFileStatusListener();
        vfs.addVcsFileStatusListener((VcsFileStatusListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningDataObject.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener), (EventListener)this.vcsFileStatusListener, (Object)vfs));
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    protected Node createNodeDelegate() {
        VersioningDataNode node = new VersioningDataNode(this);
        return node;
    }

    public RevisionList getRevisionList(boolean refresh) {
        VersioningFileSystem vfs;
        try {
            vfs = (VersioningFileSystem)this.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException exc) {
            return null;
        }
        return vfs.getVersions().getRevisions(this.getPrimaryFile().getPackageNameExt('/', '.'), refresh);
    }

    private FileStatusProvider getFileStatusProvider() {
        VersioningFileSystem vfs;
        try {
            vfs = (VersioningFileSystem)this.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException exc) {
            return null;
        }
        return vfs.getFileStatusProvider();
    }

    public String getStatus() {
        if (this.status == null) {
            FileStatusProvider statusProvider = this.getFileStatusProvider();
            if (statusProvider == null) {
                return null;
            }
            this.status = statusProvider.getFileStatus(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.status;
    }

    public String getLocker() {
        if (this.locker == null) {
            FileStatusProvider statusProvider = this.getFileStatusProvider();
            if (statusProvider == null) {
                return null;
            }
            this.locker = statusProvider.getFileLocker(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.locker;
    }

    public String getRevision() {
        if (this.revision == null) {
            FileStatusProvider statusProvider = this.getFileStatusProvider();
            if (statusProvider == null) {
                return null;
            }
            this.revision = statusProvider.getFileRevision(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.revision;
    }

    public String getSticky() {
        if (this.sticky == null) {
            FileStatusProvider statusProvider = this.getFileStatusProvider();
            if (statusProvider == null) {
                return null;
            }
            this.sticky = statusProvider.getFileSticky(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.sticky;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VCSFileStatusListener
    implements VcsFileStatusListener {
        private VCSFileStatusListener() {
        }

        public void vcsStatusChanged(VcsFileStatusEvent event) {
            if (event.hasChanged(VersioningDataObject.this.getPrimaryFile())) {
                String oldState;
                FileStatusProvider statusProvider = VersioningDataObject.this.getFileStatusProvider();
                if (statusProvider == null) {
                    return;
                }
                String name = VersioningDataObject.this.getPrimaryFile().getPackageNameExt('/', '.');
                String newState = statusProvider.getFileStatus(name);
                if (VersioningDataObject.this.status == null && newState != null || VersioningDataObject.this.status != null && !VersioningDataObject.this.status.equals(newState)) {
                    oldState = VersioningDataObject.this.status;
                    VersioningDataObject.this.status = newState;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_STATUS, oldState, newState);
                }
                newState = statusProvider.getFileLocker(name);
                if (VersioningDataObject.this.locker == null && newState != null || VersioningDataObject.this.locker != null && !VersioningDataObject.this.locker.equals(newState)) {
                    oldState = VersioningDataObject.this.locker;
                    VersioningDataObject.this.locker = newState;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_LOCKER, oldState, newState);
                }
                newState = statusProvider.getFileRevision(name);
                if (VersioningDataObject.this.revision == null && newState != null || VersioningDataObject.this.revision != null && !VersioningDataObject.this.revision.equals(newState)) {
                    oldState = VersioningDataObject.this.revision;
                    VersioningDataObject.this.revision = newState;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_REVISION, oldState, newState);
                }
                newState = statusProvider.getFileSticky(name);
                if (VersioningDataObject.this.sticky == null && newState != null || VersioningDataObject.this.sticky != null && !VersioningDataObject.this.sticky.equals(newState)) {
                    oldState = VersioningDataObject.this.sticky;
                    VersioningDataObject.this.sticky = newState;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_STICKY, oldState, newState);
                }
            }
        }
    }
}

