/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryEvent;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener;
import org.netbeans.modules.vcscore.versioning.impl.RootFolderNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

final class VersioningDataSystem
extends AbstractNode
implements VersioningRepositoryListener {
    private static VersioningDataSystem def;
    private VersioningRepository repository;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction;

    private VersioningDataSystem(Children ch, VersioningRepository repository) {
        super(ch);
        this.repository = repository;
        this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem = VersioningDataSystem.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataSystem")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem), (String)"versioningSystemName"));
        this.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem = VersioningDataSystem.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataSystem")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem), (String)"VersioningDataSystem.Description"));
        this.setIconBase("org/netbeans/modules/vcscore/versioning/impl/versioningExplorer");
        this.initialize();
    }

    public static synchronized VersioningDataSystem getVersioningDataSystem() {
        if (def == null) {
            def = new VersioningDataSystem((Children)new DataChildren(), VersioningRepository.getRepository());
        }
        return def;
    }

    private void initialize() {
        this.repository.addRepositoryListener(this);
        List systems = this.repository.getVersioningFileSystems();
        Iterator it = systems.iterator();
        while (it.hasNext()) {
            VersioningFileSystem vs = (VersioningFileSystem)it.next();
            vs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DataChildren)this.getChildren()), (Object)vs));
        }
        this.refresh();
    }

    private static Node createRoot(VersioningFileSystem vs) {
        DataFolder df = DataFolder.findFolder((FileObject)vs.getRoot());
        return new RootFolderNode(df, df.createNodeChildren(DataFilter.ALL));
    }

    public void versioningSystemAdded(VersioningRepositoryEvent re) {
        re.getVersioningFileSystem().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DataChildren)this.getChildren()), (Object)re.getVersioningFileSystem()));
        this.refresh();
    }

    public void versioningSystemRemoved(VersioningRepositoryEvent re) {
        this.refresh();
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction = VersioningDataSystem.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction))};
    }

    private void refresh() {
        this.refresh(null);
    }

    private void refresh(VersioningFileSystem vs) {
        ((DataChildren)this.getChildren()).refresh(this.repository, vs);
    }

    public Node.Handle getHandle() {
        return new DataSystemHandler();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DataChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private DataChildren() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            VersioningDataSystem ds = (VersioningDataSystem)this.getNode();
            if (ds == null) {
                return;
            }
            if (ev.getPropertyName().equals("root")) {
                VersioningFileSystem vs = (VersioningFileSystem)ev.getSource();
                ds.refresh(vs);
                ds.refresh();
            }
        }

        protected Node[] createNodes(Object key) {
            Node n = VersioningDataSystem.createRoot((VersioningFileSystem)key);
            return new Node[]{n};
        }

        public void refresh(VersioningRepository repository, VersioningFileSystem vs) {
            List systems = repository.getVersioningFileSystems();
            systems.remove(vs);
            this.setKeys(systems);
        }
    }

    private static class DataSystemHandler
    implements Node.Handle {
        static final long serialVersionUID = -360330468336250300L;

        DataSystemHandler() {
        }

        public Node getNode() {
            return VersioningDataSystem.getVersioningDataSystem();
        }
    }
}

