/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.wizard.mountcvs;

import java.awt.Component;
import java.awt.Window;
import java.beans.IntrospectionException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.VcsConfigVariable;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.settings.GeneralVcsSettings;
import org.netbeans.modules.vcscore.wizard.mountcvs.CvsWizardData;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.nodes.BeanNode;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

public class CvsMountFS
extends AbstractFileSystem {
    private static final String FS_CMDLINE = "org.netbeans.modules.vcs.cmdline.CvsFileSystem";
    private static final String FS_CMDLINE_CUSTOM = "org.netbeans.modules.vcs.advanced.CommandLineVcsFileSystem";
    private static final String FS_JAVA = "org.netbeans.modules.cvsclient.NbJavaCvsFileSystem";
    private CvsWizardData data = null;
    static final long serialVersionUID = 1135495669383440118L;
    private static final String CONFIG_CVS_UNIX = "cvsUnix.xml";
    private static final String CONFIG_CVS_WIN = "cvsWin.xml";
    private static final String CONFIG_CVS_WIN98 = "cvsWin98.xml";
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public CvsMountFS() {
        this.list = new AbstractFileSystem.List(){

            public String[] children(String name) {
                return new String[0];
            }
        };
        this.info = new CvsMountInfo();
        this.change = new CvsMountChange();
        this.attr = new DefaultAttributes(this.info, this.change, this.list);
    }

    public void addNotify() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Repository.getDefault().removeFileSystem((FileSystem)CvsMountFS.this);
                if (CvsMountFS.this.data != null) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            BeanNode bn = new BeanNode((Object)((Object)2.access$100(this.this$1)));
                            Component c = bn.getCustomizer();
                            if (c instanceof Window) {
                                c.setVisible(true);
                            }
                        }
                        catch (IntrospectionException exc) {
                            ErrorManager.getDefault().notify((Throwable)exc);
                        }
                    }
                });
            }

            static /* synthetic */ CvsMountFS access$100(2 x0) {
                return x0.CvsMountFS.this;
            }
        });
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS = CvsMountFS.class$("org.netbeans.modules.vcscore.wizard.mountcvs.CvsMountFS")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS), (String)"LAB_CVSFileSystem");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setWizardData(final CvsWizardData data) {
        this.data = data;
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                CvsMountFS.mountClientFS(data);
            }
        });
    }

    public static Object setupClientFS(CvsWizardData data) {
        if (data != null) {
            Class<?> mountFSClass;
            try {
                mountFSClass = data.isBuildInCvs() ? Class.forName(FS_JAVA, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CvsMountFS.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)) : (data.isCustomizableCvs() ? Class.forName(FS_CMDLINE_CUSTOM, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CvsMountFS.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)) : Class.forName(FS_CMDLINE, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CvsMountFS.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)));
            }
            catch (ClassNotFoundException exc) {
                mountFSClass = null;
            }
            if (mountFSClass == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS = CvsMountFS.class$("org.netbeans.modules.vcscore.wizard.mountcvs.CvsMountFS")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$CvsMountFS), (String)"MSG_FS_Not_Available")));
                return null;
            }
            Object mountFS = CvsMountFS.createClientFS(mountFSClass);
            if (mountFS == null) {
                return null;
            }
            if (data.isBuildInCvs()) {
                CvsMountFS.setBuiltInFSParams(mountFS, mountFSClass, data);
            } else if (data.isCustomizableCvs()) {
                CvsMountFS.setCmdLineCustomFSParams(mountFS, mountFSClass, data);
            } else {
                CvsMountFS.setCmdLineFSParams(mountFS, mountFSClass, data);
            }
            return mountFS;
        }
        return null;
    }

    private static void mountClientFS(CvsWizardData data) {
        String[] mountPoints = data.getMountPoints();
        if (mountPoints == null || mountPoints.length == 0) {
            mountPoints = new String[]{data.getMountPoint()};
        }
        int i = 0;
        while (i < mountPoints.length) {
            data.setMountPointOnly(mountPoints[i]);
            Object mountFS = CvsMountFS.setupClientFS(data);
            if (mountFS != null) {
                Repository.getDefault().addFileSystem((FileSystem)mountFS);
            }
            ++i;
        }
    }

    private static Object createClientFS(Class mountFSClass) {
        Object mountFS;
        try {
            mountFS = mountFSClass.newInstance();
        }
        catch (InstantiationException instExc) {
            ErrorManager.getDefault().notify((Throwable)new Exception(){

                public String getLocalizedMessage() {
                    return instExc.getMessage();
                }
            });
            mountFS = null;
        }
        catch (IllegalAccessException iaExc) {
            ErrorManager.getDefault().notify((Throwable)new Exception(){

                public String getLocalizedMessage() {
                    return iaExc.getMessage();
                }
            });
            mountFS = null;
        }
        return mountFS;
    }

    private static void setBuiltInFSParams(Object mountFS, Class mountFSClass, CvsWizardData data) {
        GeneralVcsSettings settings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = CvsMountFS.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        if (data.getHome() != null) {
            settings.setHome(new File(data.getHome()));
        }
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setWorkingDir", class$java$io$File == null ? (class$java$io$File = CvsMountFS.class$("java.io.File")) : class$java$io$File, new File(data.getWorkingDir()));
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setRelMount", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getMountPoint());
        int type = data.getMethodType();
        if (type == 3) {
            CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsServerType", Integer.TYPE, new Integer(1));
        }
        if (type == 2) {
            CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsServerType", Integer.TYPE, new Integer(0));
        }
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsServerName", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getHostName());
        String port = data.getHostPort();
        if (port.length() > 0) {
            try {
                int portNo = Integer.parseInt(port);
                CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsPort", Integer.TYPE, new Integer(portNo));
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsUserName", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getUserName());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsRepository", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getCvsRepository());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setOffLine", Boolean.TYPE, data.isOffLine() ? Boolean.TRUE : Boolean.FALSE);
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setInitialCheckout", Boolean.TYPE, data.getPerformInitialCheckout() ? Boolean.TRUE : Boolean.FALSE);
        CvsMountFS.invokeMethod(mountFS, mountFSClass, "adjustSystemName");
    }

    private static void setCmdLineFSParams(Object mountFS, Class mountFSClass, CvsWizardData data) {
        String port;
        GeneralVcsSettings settings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = CvsMountFS.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        if (data.getHome() != null) {
            settings.setHome(new File(data.getHome()));
        }
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsModule", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getMountPoint());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setRootDirectory", class$java$io$File == null ? (class$java$io$File = CvsMountFS.class$("java.io.File")) : class$java$io$File, new File(data.getWorkingDir()));
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsServerType", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getMethod());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsServer", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getHostName());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsUserName", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getUserName());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsRoot", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getCvsRepository());
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setCvsExePath", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getCvsExecutable());
        if (data.getShellExecutalbe() != null) {
            CvsMountFS.setFSParam(mountFS, mountFSClass, "setCygwinPath", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, data.getShellExecutalbe());
        }
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setUseUnixShell", Boolean.TYPE, data.isWindows() ? Boolean.TRUE : Boolean.FALSE);
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setOffLine", Boolean.TYPE, data.isOffLine() ? Boolean.TRUE : Boolean.FALSE);
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setInitialCheckout", Boolean.TYPE, data.getPerformInitialCheckout() ? Boolean.TRUE : Boolean.FALSE);
        String cvs_rsh = data.getRsh();
        if (cvs_rsh != null && cvs_rsh.length() > 0) {
            ((VcsFileSystem)mountFS).setEnvironmentVar("CVS_RSH", cvs_rsh);
        }
        if ((port = data.getHostPort()).length() > 0) {
            ((VcsFileSystem)mountFS).setEnvironmentVar("CVS_CLIENT_PORT", port);
        }
    }

    private static void setCmdLineCustomFSParams(Object mountFS, Class mountFSClass, CvsWizardData data) {
        GeneralVcsSettings settings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = CvsMountFS.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        if (data.getHome() != null) {
            settings.setHome(new File(data.getHome()));
        }
        String configFileName = data.isWindows() ? CONFIG_CVS_WIN98 : (Utilities.isWindows() ? CONFIG_CVS_WIN : CONFIG_CVS_UNIX);
        CvsMountFS.setFSParam(mountFS, mountFSClass, "readConfiguration", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, configFileName);
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setConfigFileName", class$java$lang$String == null ? (class$java$lang$String = CvsMountFS.class$("java.lang.String")) : class$java$lang$String, configFileName);
        VcsFileSystem fileSystem = (VcsFileSystem)mountFS;
        try {
            fileSystem.setRootDirectory(new File(data.getWorkingDir()));
            fileSystem.setRelativeMountPoint(data.getMountPoint());
        }
        catch (PropertyVetoException vetoExc) {
            ErrorManager.getDefault().notify((Throwable)vetoExc);
        }
        catch (IOException ioExc) {
            ErrorManager.getDefault().notify((Throwable)ioExc);
        }
        Vector vars = fileSystem.getVariables();
        HashMap<String, VcsConfigVariable> varsByName = new HashMap<String, VcsConfigVariable>();
        int i = 0;
        int n = vars.size();
        while (i < n) {
            VcsConfigVariable var = (VcsConfigVariable)vars.get(i);
            varsByName.put(var.getName(), var);
            ++i;
        }
        CvsMountFS.setVar("SERVERTYPE", data.getMethod(), vars, varsByName);
        CvsMountFS.setVar("CVS_SERVER", data.getHostName(), vars, varsByName);
        CvsMountFS.setVar("CVS_USERNAME", data.getUserName(), vars, varsByName);
        CvsMountFS.setVar("CVS_REPOSITORY", data.getCvsRepository(), vars, varsByName);
        CvsMountFS.setVar("CVS_EXE", data.getCvsExecutable(), vars, varsByName);
        String port = data.getHostPort();
        if (port.length() > 0) {
            CvsMountFS.setVar("ENVIRONMENT_VAR_CVS_CLIENT_PORT", port, vars, varsByName);
        }
        if (data.getShellExecutalbe() != null) {
            CvsMountFS.setVar("SHELL", data.getShellExecutalbe(), vars, varsByName);
        }
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setOffLine", Boolean.TYPE, data.isOffLine() ? Boolean.TRUE : Boolean.FALSE);
        CvsMountFS.setFSParam(mountFS, mountFSClass, "setInitialCheckout", Boolean.TYPE, data.getPerformInitialCheckout() ? Boolean.TRUE : Boolean.FALSE);
        String cvs_rsh = data.getRsh();
        if (cvs_rsh != null && cvs_rsh.length() > 0) {
            fileSystem.setEnvironmentVar("CVS_RSH", cvs_rsh);
            CvsMountFS.setVar("ENVIRONMENT_VAR_CVS_RSH", cvs_rsh, vars, varsByName);
        }
        fileSystem.setVariables(vars);
    }

    private static void setVar(String name, String value, Vector vars, HashMap varsByName) {
        VcsConfigVariable var = (VcsConfigVariable)varsByName.get(name);
        if (var == null) {
            var = new VcsConfigVariable(name, null, value, false, false, false, null);
            vars.add(var);
            varsByName.put(name, var);
        } else {
            var.setValue(value);
        }
    }

    private static void invokeMethod(Object mountFS, Class mountFSClass, String methodName) {
        Method setter;
        try {
            setter = mountFSClass.getMethod(methodName, null);
        }
        catch (NoSuchMethodException nsmExc) {
            ErrorManager.getDefault().notify((Throwable)nsmExc);
            setter = null;
        }
        catch (SecurityException sExc) {
            ErrorManager.getDefault().notify((Throwable)sExc);
            setter = null;
        }
        if (setter != null) {
            try {
                setter.invoke(mountFS, null);
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
    }

    private static void setFSParam(Object mountFS, Class mountFSClass, String methodName, Class parameterType, Object value) {
        Method setter;
        try {
            setter = mountFSClass.getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException nsmExc) {
            ErrorManager.getDefault().notify((Throwable)nsmExc);
            setter = null;
        }
        catch (SecurityException sExc) {
            ErrorManager.getDefault().notify((Throwable)sExc);
            setter = null;
        }
        if (setter != null) {
            try {
                setter.invoke(mountFS, value);
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CvsMountChange
    implements AbstractFileSystem.Change {
        private static final long serialVersionUID = 2995922570369924991L;

        public void delete(String name) throws IOException {
        }

        public void createFolder(String name) throws IOException {
        }

        public void createData(String name) throws IOException {
        }

        public void rename(String oldName, String newName) throws IOException {
        }
    }

    public class CvsMountInfo
    implements AbstractFileSystem.Info {
        private static final long serialVersionUID = 1074538438080334531L;

        public Date lastModified(String name) {
            return null;
        }

        public boolean folder(String name) {
            return false;
        }

        public long size(String name) {
            return 0L;
        }

        public void markUnimportant(String name) {
        }

        public void lock(String name) throws IOException {
        }

        public String mimeType(String name) {
            return null;
        }

        public boolean readOnly(String name) {
            return false;
        }

        public void unlock(String name) {
        }

        public OutputStream outputStream(String name) throws IOException {
            throw new IOException();
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            throw new FileNotFoundException();
        }
    }
}

