/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.wizard.mountcvs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vcscore.settings.GeneralVcsSettings;
import org.netbeans.modules.vcscore.wizard.mountcvs.CvsWizardData;
import org.netbeans.modules.vcscore.wizard.mountcvs.GenericWizardPanel;
import org.netbeans.modules.vcscore.wizard.mountcvs.util.SimpleComboBoxEditor;
import org.netbeans.modules.vcscore.wizard.mountcvs.util.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class WDPanel
extends JPanel
implements GenericWizardPanel.WizardPanelUI,
DocumentListener {
    private LinkedList previousItems;
    private CvsWizardData data;
    private GenericWizardPanel.ChangeSupport changeSupport;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JTextArea descriptionTextArea;
    private JComboBox jComboBox1;
    private JLabel wdLabel;
    private JButton wdButton;
    private static final long serialVersionUID = 4155272251443011619L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel;

    public WDPanel(GenericWizardPanel.ChangeSupport changeSupport) {
        this.changeSupport = changeSupport;
        this.initComponents();
        GeneralVcsSettings settings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = WDPanel.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        this.previousItems = new LinkedList();
        Iterator it = settings.getWizardDirectoryCache().iterator();
        while (it.hasNext()) {
            String item = it.next().toString();
            this.previousItems.add(item);
        }
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.CMPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel)).getString("WDPanel.title"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        this.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.setPreferredSize(new Dimension(500, 350));
        SimpleComboBoxEditor editor = new SimpleComboBoxEditor();
        editor.addDocumentListener(this);
        this.jComboBox1.setEditor(editor);
        this.initAccessibility();
    }

    public void storeCvsWizardSettings(CvsWizardData data) {
        String item = (String)this.jComboBox1.getEditor().getItem();
        if (org.openide.util.Utilities.isWindows() && item.length() == 2 && Character.isLetter(item.charAt(0)) && ':' == item.charAt(1)) {
            item = item + "\\";
        }
        data.setWorkingDir(item);
        this.previousItems.addFirst(item);
        int i = 1;
        while (i < Math.min(4, this.previousItems.size())) {
            if (this.previousItems.get(i).equals(item)) {
                this.previousItems.remove(i);
            }
            ++i;
        }
        while (this.previousItems.size() > 4) {
            this.previousItems.removeLast();
        }
        data.setRootFile(WDPanel.getCvsRootFile(new File(item)));
    }

    public void readCvsWizardSettings(CvsWizardData data) {
        this.jComboBox1.removeAllItems();
        int i = 0;
        while (i < this.previousItems.size()) {
            this.jComboBox1.addItem(this.previousItems.get(i));
            ++i;
        }
        String wd = data.getWorkingDir();
        if (wd != null) {
            this.jComboBox1.setSelectedItem(wd);
        }
        this.data = data;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.wdLabel = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.wdButton = new JButton();
        this.jPanel2 = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.wdLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("WDPanel.wdLabel"));
        this.wdLabel.setLabelFor(this.jComboBox1);
        this.wdLabel.setNextFocusableComponent(this.wdButton);
        this.wdLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("WDPanel.wdLabel_Mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.wdLabel, gridBagConstraints);
        this.jComboBox1.setEditable(true);
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WDPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel1.add((Component)this.jComboBox1, gridBagConstraints);
        this.wdButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("WDPanel.wdBrowse_Mnemonic").charAt(0));
        this.wdButton.setText(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("WDPanel.wdBrowse"));
        this.wdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WDPanel.this.browseDir(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.wdButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.descriptionTextArea.setBackground(Color.lightGray);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("TIP_WorkingDirectoryPanel"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setDisabledTextColor(Color.black);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanel2.add((Component)this.descriptionTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.changeSupport.fireChange();
    }

    private void browseDir(ActionEvent evt) {
        JFileChooser fd = new JFileChooser();
        fd.setFileHidingEnabled(false);
        fd.setFileFilter(new javax.swing.filechooser.FileFilter(){
            static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel;

            public boolean accept(File file) {
                return file.exists() && file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = 3.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("TXT_Directory");
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        fd.setFileSelectionMode(1);
        File dir = Utilities.findDirectory((String)this.jComboBox1.getEditor().getItem());
        if (dir != null) {
            fd.setCurrentDirectory(dir);
        } else {
            try {
                File defDir = new File(System.getProperty("user.home"));
                if (org.openide.util.Utilities.isUnix()) {
                    dir = defDir;
                } else if (org.openide.util.Utilities.isWindows()) {
                    while ((defDir = defDir.getParentFile()) != null && defDir.getParentFile() != null) {
                    }
                    if (defDir != null) {
                        dir = defDir;
                    }
                }
            }
            catch (Exception ex) {
                dir = null;
            }
        }
        if (dir != null) {
            fd.setCurrentDirectory(dir);
        }
        if (fd.showOpenDialog(this) == 0) {
            String newWDName = fd.getSelectedFile().getAbsolutePath();
            this.jComboBox1.getEditor().setItem(newWDName);
            this.changeSupport.fireChange();
        }
    }

    public boolean isWizardPanelValid() {
        String wd__ = (String)this.jComboBox1.getEditor().getItem();
        if (wd__ == null || wd__.length() == 0) {
            return false;
        }
        File f = new File(wd__);
        return f.exists() && f.isDirectory();
    }

    public File getCvsRootFile() {
        return WDPanel.getCvsRootFile(new File((String)this.jComboBox1.getEditor().getItem()));
    }

    public static File getCvsRootFile(File root) {
        if (!root.isDirectory()) {
            return null;
        }
        File res = WDPanel.getCvsRootFileIn(root);
        if (res != null) {
            return res;
        }
        File[] entries = root.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                res = WDPanel.getCvsRootFileIn(entries[i]);
                if (res != null) {
                    return res;
                }
                ++i;
            }
        }
        return null;
    }

    private static File getCvsRootFileIn(File root) {
        File cvsRoot;
        File cvsDir = new File(root, "CVS");
        if (cvsDir.exists() && cvsDir.isDirectory() && (cvsRoot = new File(cvsDir, "Root")).exists() && cvsRoot.canRead()) {
            return cvsRoot;
        }
        return null;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changeSupport.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changeSupport.fireChange();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.changeSupport.fireChange();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("ACSD_WDPanel.title"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(this.descriptionTextArea.getText());
        this.wdButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("ACSD_WDPanel.wdBrowse"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

