/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.wizard.mountcvs.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.StringTokenizer;

public class CvsHelper {
    public static final String LOCAL = "local";
    public static final String SERVER = "server";
    public static final String PSERVER = "pserver";
    public static final String EXTERNAL = "ext";
    public static final int T_UNKNOWN = 0;
    public static final int T_LOCAL = 1;
    public static final int T_SERVER = 2;
    public static final int T_PSERVER = 3;
    public static final int T_EXTERNAL = 4;
    private String cvsRoot_;
    private String serverName_;
    private String serverPort_;
    private String userName_;
    private String repository_;
    private String method_;
    private boolean modified_;
    private PropertyChangeSupport changeSupport_ = new PropertyChangeSupport(this);

    public CvsHelper(String cvsRoot) {
        this.cvsRoot_ = cvsRoot;
        this.modified_ = false;
        this.method_ = "";
        this.repository_ = "";
        this.userName_ = "";
        this.serverPort_ = "";
        this.serverName_ = "";
        if (this.cvsRoot_ != null) {
            try {
                this.parseCvsRoot();
            }
            catch (IllegalArgumentException exc) {
                this.cvsRoot_ = "";
            }
        } else {
            this.cvsRoot_ = "";
        }
    }

    public CvsHelper() {
        this(null);
    }

    public String getCvsRoot() {
        if (this.modified_) {
            this.buildCvsRoot();
        }
        return this.cvsRoot_;
    }

    public boolean wasModified() {
        return this.modified_;
    }

    public String getMethod() {
        return this.method_;
    }

    public int getMethodType() {
        if (this.method_.equals(LOCAL)) {
            return 1;
        }
        if (this.method_.equals(SERVER)) {
            return 2;
        }
        if (this.method_.equals(PSERVER)) {
            return 3;
        }
        if (this.method_.equals(EXTERNAL)) {
            return 4;
        }
        return 0;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getServerPort() {
        return this.serverPort_;
    }

    public String getUserName() {
        return this.userName_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void setCvsRoot(String cvsRoot) {
        String oldCvsRoot = this.cvsRoot_;
        this.repository_ = "";
        this.method_ = "";
        this.serverName_ = "";
        this.userName_ = "";
        this.cvsRoot_ = cvsRoot;
        if (cvsRoot != null) {
            try {
                this.parseCvsRoot();
            }
            catch (IllegalArgumentException exc) {
                this.cvsRoot_ = "";
            }
        } else {
            this.cvsRoot_ = "";
        }
        this.modified_ = false;
        this.fireChange("cvsRoot", oldCvsRoot, this.cvsRoot_);
    }

    public void setMethod(String method) {
        String oldMethod = this.method_;
        this.method_ = method;
        this.modified_ = true;
        this.fireChange("method", oldMethod, this.method_);
    }

    public void setUserName(String userName) {
        String oldUserName = this.userName_;
        this.userName_ = userName;
        this.modified_ = true;
        this.fireChange("userName", oldUserName, this.userName_);
    }

    public void setServerName(String serverName) {
        String oldServerName = this.serverName_;
        this.serverName_ = serverName;
        this.modified_ = true;
        this.fireChange("serverName", oldServerName, this.serverName_);
    }

    public void setServerPort(String serverPort) {
        String oldServerPort = this.serverPort_;
        this.serverPort_ = serverPort;
        this.modified_ = true;
        this.fireChange("serverPort", oldServerPort, this.serverPort_);
    }

    public void setRepository(String repository) {
        String oldRepository = this.repository_;
        this.repository_ = repository;
        this.modified_ = true;
        this.fireChange("repository", oldRepository, this.repository_);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport_.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport_.removePropertyChangeListener(listener);
    }

    private void fireChange(String name, Object oldValue, Object newValue) {
        this.changeSupport_.firePropertyChange(name, oldValue, newValue);
    }

    private void buildCvsRoot() {
        String tmp = ":" + this.method_ + ":";
        if (!this.method_.equals(LOCAL)) {
            if (this.userName_.length() > 0) {
                tmp = tmp + this.userName_ + "@";
            }
            if (this.serverName_.length() > 0) {
                tmp = tmp + this.serverName_;
            }
            tmp = tmp + ":";
        }
        this.cvsRoot_ = tmp + this.serverPort_ + this.repository_;
    }

    /*
     * WARNING - void declaration
     */
    private void parseCvsRoot() throws IllegalArgumentException {
        StringTokenizer tk;
        this.cvsRoot_ = this.cvsRoot_.trim();
        if (this.cvsRoot_.charAt(0) != ':') {
            this.cvsRoot_ = ":local:" + this.cvsRoot_;
        }
        if ((tk = new StringTokenizer(this.cvsRoot_, ":", true)).countTokens() < 4) {
            this.cvsRoot_ = "";
            throw new IllegalArgumentException();
        }
        tk.nextToken();
        this.method_ = tk.nextToken();
        tk.nextToken();
        if (this.method_.equals(LOCAL)) {
            this.repository_ = this.restTokens(tk);
        } else {
            char c;
            if (tk.countTokens() < 2) {
                this.method_ = "";
                this.cvsRoot_ = "";
                throw new IllegalArgumentException();
            }
            String tmp = tk.nextToken();
            if (!tmp.equals(":")) {
                StringTokenizer tk2 = new StringTokenizer(tmp, "@");
                if (tk2.countTokens() == 2) {
                    this.userName_ = tk2.nextToken();
                    this.serverName_ = tk2.nextToken();
                    tk.nextToken();
                } else if (tk2.countTokens() == 1) {
                    this.userName_ = "";
                    this.serverName_ = tk2.nextToken();
                    tk.nextToken();
                } else {
                    this.method_ = "";
                    this.cvsRoot_ = "";
                    throw new IllegalArgumentException();
                }
            }
            this.repository_ = this.restTokens(tk);
            StringBuffer port = new StringBuffer();
            int i = 0;
            while (this.repository_.length() > i && Character.isDigit(c = this.repository_.charAt(i))) {
                void var4_5;
                port.append((char)var4_5);
                ++i;
            }
            if (port.length() > 0) {
                this.serverPort_ = port.toString();
                this.repository_ = this.repository_.substring(port.length());
            } else {
                this.serverPort_ = "";
            }
        }
    }

    private String restTokens(StringTokenizer tk) {
        String result = "";
        while (tk.hasMoreTokens()) {
            result = result + tk.nextToken();
        }
        return result;
    }
}

