/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.vcs.commands;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.filesystems.FileObject;

class CommandInvocationHandler
implements InvocationHandler,
Cloneable {
    private CommandSupport support;
    private EventListenerList listenerList = new EventListenerList();
    private Map properties = new Hashtable();
    private FileObject[] files = null;
    private boolean guiMode = true;
    private boolean expertMode = false;
    static /* synthetic */ Class class$java$util$EventListener;

    public CommandInvocationHandler(CommandSupport support) {
        this.support = support;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String propName;
        String name = method.getName();
        boolean get = false;
        boolean addListener = false;
        boolean removeListener = false;
        if (name.startsWith("set") && name.length() > "set".length()) {
            propName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            get = false;
        } else {
            if ("getApplicableFiles".equals(name)) {
                if (!(args[0] instanceof FileObject[])) throw new IllegalArgumentException("getApplicableFiles(" + args[0] + "): needs FileObject[] value.");
                return this.support.getApplicableFiles((FileObject[])args[0]);
            }
            if (name.startsWith("get") && name.length() > "get".length()) {
                propName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                get = true;
            } else if (name.startsWith("is") && name.length() > "is".length()) {
                propName = Character.toLowerCase(name.charAt(2)) + name.substring(3);
                get = true;
            } else if (name.startsWith("add") && name.endsWith("Listener") && args.length == 1 && args[0] instanceof EventListener) {
                addListener = true;
                propName = name.substring("add".length(), name.length() - "Listener".length());
            } else if (name.startsWith("remove") && name.endsWith("Listener") && args.length == 1 && args[0] instanceof EventListener) {
                removeListener = true;
                propName = name.substring("remove".length(), name.length() - "Listener".length());
            } else {
                if ("toString".equals(name)) {
                    return this.support.toString();
                }
                if ("equals".equals(name)) {
                    try {
                        return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return Boolean.FALSE;
                    }
                }
                if ("hashCode".equals(name)) {
                    return new Integer(this.hashCode());
                }
                if ("execute".equals(name)) {
                    CommandTask commandTask = this.support.createTheTask();
                    if (commandTask == null) {
                        return null;
                    }
                    commandTask.run();
                    return commandTask;
                }
                if (!"run".equals(name)) throw new NoSuchMethodError(name);
                if (!(this.support instanceof PrivilegedAction)) return this.support;
                return ((PrivilegedAction)((Object)this.support)).run();
            }
        }
        if (addListener) {
            this.listenerList.add(method.getParameterTypes()[0], (EventListener)args[0]);
            return null;
        }
        if (removeListener) {
            this.listenerList.remove(method.getParameterTypes()[0], (EventListener)args[0]);
            return null;
        }
        if (get) {
            void var9_13;
            if (args != null) {
                throw new IllegalArgumentException(args.toString());
            }
            if ("name".equals(propName)) {
                return this.support.getName();
            }
            if ("displayName".equals(propName)) {
                return this.support.getDisplayName();
            }
            if ("files".equals(propName)) {
                return this.files;
            }
            if ("gUIMode".equals(propName)) {
                return new Boolean(this.guiMode);
            }
            if ("expertMode".equals(propName)) {
                return new Boolean(this.expertMode);
            }
            if ("commandSupport".equals(propName)) {
                return this.support;
            }
            Object v = this.properties.get(propName);
            if (v != null) return var9_13;
            Object object = CommandInvocationHandler.getDefaultPropertyValue(method.getReturnType());
            return var9_13;
        }
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException(name + "(" + (args == null ? "null" : args.toString()) + ")");
        }
        if ("name".equals(propName)) {
            throw new NoSuchMethodError(name);
        }
        if ("displayName".equals(propName)) {
            throw new NoSuchMethodError(name);
        }
        if ("gUIMode".equals(propName)) {
            if (!(args[0] instanceof Boolean)) throw new IllegalArgumentException("setGUIMode(" + args[0] + "): needs boolean value.");
            this.guiMode = (Boolean)args[0];
            return null;
        } else if ("expertMode".equals(propName)) {
            if (!(args[0] instanceof Boolean)) throw new IllegalArgumentException("setGUIMode(" + args[0] + "): needs boolean value.");
            this.expertMode = (Boolean)args[0];
            return null;
        } else if ("files".equals(propName)) {
            if (!(args[0] instanceof FileObject[])) throw new IllegalArgumentException("setFiles(" + args[0] + "): needs FileObject[] value.");
            this.files = this.support.getApplicableFiles((FileObject[])args[0]);
            return null;
        } else if (args[0] == null) {
            this.properties.remove(propName);
            return null;
        } else {
            this.properties.put(propName, args[0]);
        }
        return null;
    }

    private static Object getDefaultPropertyValue(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(clazz)) {
            return new Byte(0);
        }
        if (Character.TYPE.equals(clazz)) {
            return new Character('\u0000');
        }
        if (Short.TYPE.equals(clazz)) {
            return new Short(0);
        }
        if (Integer.TYPE.equals(clazz)) {
            return new Integer(0);
        }
        if (Long.TYPE.equals(clazz)) {
            return new Long(0L);
        }
        if (Float.TYPE.equals(clazz)) {
            return new Float(0.0f);
        }
        if (Double.TYPE.equals(clazz)) {
            return new Double(0.0);
        }
        return null;
    }

    private Class findListenerClass(Object obj, String name) {
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        if (interfaces.length == 0) {
            return obj.getClass();
        }
        if (interfaces.length == 1) {
            return interfaces[0];
        }
        ArrayList eventListeners = new ArrayList();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].isAssignableFrom(class$java$util$EventListener == null ? CommandInvocationHandler.class$("java.util.EventListener") : class$java$util$EventListener)) {
                eventListeners.add(interfaces[i]);
            }
            ++i;
        }
        int size = eventListeners.size();
        if (size == 0) {
            return obj.getClass();
        }
        if (size == 1) {
            return (Class)eventListeners.get(0);
        }
        int i2 = 0;
        while (i2 < size) {
            Class interf = (Class)eventListeners.get(i2);
            if (interf.getName().indexOf(name) >= 0) {
                return interf;
            }
            ++i2;
        }
        return obj.getClass();
    }

    protected Object clone() {
        CommandInvocationHandler clon = new CommandInvocationHandler(this.support);
        clon.listenerList = new EventListenerList();
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            clon.listenerList.add((Class)listeners[i], (EventListener)listeners[i + 1]);
            i -= 2;
        }
        clon.properties = new Hashtable(this.properties);
        clon.files = this.files;
        clon.guiMode = this.guiMode;
        clon.expertMode = this.expertMode;
        return clon;
    }

    public EventListener[] getListeners(Class listenerType) {
        try {
            return this.listenerList.getListeners(listenerType);
        }
        catch (ClassCastException ccex) {
            System.err.println("Bad instance of listener: " + listenerType);
            ccex.printStackTrace(System.err);
            return new EventListener[0];
        }
    }

    FileObject[] getFiles() {
        return this.files;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

