/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.vcs.commands;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.spi.vcs.commands.CommandInvocationHandler;
import org.netbeans.spi.vcs.commands.CommandTaskSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public abstract class CommandSupport
implements Cloneable {
    private static final Class[] DEFAULT_IMPLEMENTED_CLASSES = new Class[]{class$org$netbeans$api$vcs$commands$Command == null ? (class$org$netbeans$api$vcs$commands$Command = CommandSupport.class$("org.netbeans.api.vcs.commands.Command")) : class$org$netbeans$api$vcs$commands$Command, class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CommandSupport.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction};
    private static final FileObject[] EMPTY_FILES = new FileObject[0];
    private Class commandClass;
    private Class[] commandClasses;
    private Command command;
    static /* synthetic */ Class class$org$netbeans$api$vcs$commands$Command;
    static /* synthetic */ Class class$java$security$PrivilegedAction;

    public CommandSupport(Class commandClass) {
        this.commandClass = commandClass;
    }

    public CommandSupport(Class[] commandClasses) {
        this.commandClasses = commandClasses;
    }

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract FileObject[] getApplicableFiles(FileObject[] var1);

    public abstract boolean hasExpertMode();

    public final Command createCommand() {
        try {
            Command cmd;
            CommandSupport clon = (CommandSupport)this.clone();
            CommandInvocationHandler ciHandler = new CommandInvocationHandler(clon);
            clon.command = cmd = this.createCommand(ciHandler);
            this.initializeCommand(cmd);
            return cmd;
        }
        catch (CloneNotSupportedException cnsex) {
            ErrorManager.getDefault().notify((Throwable)cnsex);
            return null;
        }
    }

    final Command createCommand(InvocationHandler handler) {
        Class[] implementedClasses;
        if (this.commandClasses != null) {
            List<Class> classes = Arrays.asList(DEFAULT_IMPLEMENTED_CLASSES);
            LinkedList<Class> newClasses = new LinkedList<Class>(Arrays.asList(this.commandClasses));
            newClasses.removeAll(classes);
            newClasses.addAll(0, classes);
            implementedClasses = newClasses.toArray(new Class[newClasses.size()]);
        } else {
            int i = 0;
            while (i < DEFAULT_IMPLEMENTED_CLASSES.length) {
                if (DEFAULT_IMPLEMENTED_CLASSES[i].equals(this.commandClass)) break;
                ++i;
            }
            if (i < DEFAULT_IMPLEMENTED_CLASSES.length) {
                implementedClasses = DEFAULT_IMPLEMENTED_CLASSES;
            } else {
                implementedClasses = new Class[DEFAULT_IMPLEMENTED_CLASSES.length + 1];
                System.arraycopy(DEFAULT_IMPLEMENTED_CLASSES, 0, implementedClasses, 0, DEFAULT_IMPLEMENTED_CLASSES.length);
                implementedClasses[CommandSupport.DEFAULT_IMPLEMENTED_CLASSES.length] = this.commandClass;
            }
        }
        Command command = (Command)Proxy.newProxyInstance(this.getClass().getClassLoader(), implementedClasses, handler);
        return command;
    }

    protected void initializeCommand(Command cmd) {
        cmd.setFiles(EMPTY_FILES);
    }

    protected final Command getCommand() {
        return this.command;
    }

    protected final Command getCommand(CommandTask task) throws IllegalArgumentException {
        if (!(task instanceof CommandTaskSupport)) {
            throw new IllegalArgumentException("Task is not instanceof CommandTaskSupport");
        }
        CommandTaskSupport taskSupport = (CommandTaskSupport)task;
        return taskSupport.getCommand();
    }

    protected boolean canExecute(CommandTask task) {
        return true;
    }

    protected abstract int execute(CommandTask var1);

    final CommandTask createTheTask() {
        Command cmd = this.getCommand();
        if (cmd == null) {
            return null;
        }
        Command taskCommand = null;
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(cmd);
            if (handler instanceof CommandInvocationHandler) {
                CommandInvocationHandler cHandler = (CommandInvocationHandler)((CommandInvocationHandler)handler).clone();
                taskCommand = this.createCommand(cHandler);
            }
        }
        catch (IllegalArgumentException iaex) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iaex, "It was not possible to clon the Command!"));
        }
        if (taskCommand == null) {
            taskCommand = cmd;
        }
        return this.createTask(taskCommand);
    }

    protected CommandTaskSupport createTask(Command taskCommand) {
        return new CommandTaskSupport(this, taskCommand);
    }

    protected void stop(CommandTask task) {
        this.killHard(task);
    }

    final void killHard(CommandTask task) {
        if (!(task instanceof CommandTaskSupport)) {
            throw new IllegalArgumentException(task.toString());
        }
        ((CommandTaskSupport)task).killMeHard();
    }

    protected final EventListener[] getListeners(Class listenerType, Command command) {
        if (command != null) {
            try {
                InvocationHandler handler = Proxy.getInvocationHandler(command);
                if (handler instanceof CommandInvocationHandler) {
                    return ((CommandInvocationHandler)handler).getListeners(listenerType);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract Object clone() throws CloneNotSupportedException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

