/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.httpserver.GrantAccessEvent;
import org.netbeans.modules.httpserver.GrantAccessListener;
import org.netbeans.modules.httpserver.GrantAccessPanel;
import org.netbeans.modules.httpserver.HttpServerModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.HttpServer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class HttpServerSettings
extends SystemOption
implements HttpServer.Impl,
PropertyChangeListener {
    private static final int MAX_START_RETRIES = 20;
    private static int currentRetries = 0;
    protected static EventListenerList listenerList = new EventListenerList();
    static boolean inited = false;
    private static Hashtable whoAsking = new Hashtable();
    public static final int SERVER_STARTUP_TIMEOUT = 3000;
    public static final String LOCALHOST = "local";
    public static final String ANYHOST = "any";
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST_PROPERTY = "hostProperty";
    public static final String PROP_REPOSITORY_BASEURL = "repositoryBaseURL";
    public static final String PROP_CLASSPATH_BASEURL = "classpathBaseURL";
    public static final String PROP_JAVADOC_BASEURL = "javadocBaseURL";
    static final String PROP_WRAPPER_BASEURL = "wrapperBaseURL";
    public static final String PROP_RUNNING = "running";
    private static final String PROP_HOST = "host";
    private static final String PROP_GRANTED_ADDRESSES = "grantedAddresses";
    private static final String PROP_SHOW_GRANT_ACCESS = "showGrantAccess";
    private static final int DEFAULT_PORT = 8082;
    private static String host = "local";
    private static String repositoryBaseURL = "/repository/";
    private static String classpathBaseURL = "/classpath/";
    private static String javadocBaseURL = "/javadoc/";
    private static String wrapperBaseURL = "/resource/";
    private static String grantedAddresses = "";
    static boolean running = false;
    private static boolean startStopMessages = true;
    private static Properties mappedServlets = new Properties();
    public static HttpServerSettings OPTIONS = null;
    private static int lastUsedName = 0;
    private static HashMap nameMap = new HashMap();
    private static Object httpLock;
    static final long serialVersionUID = 7387407495740535307L;
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$GrantAccessListener;

    static final Object httpLock() {
        if (httpLock == null) {
            httpLock = new Object();
        }
        return httpLock;
    }

    protected void initialize() {
        super.initialize();
        this.addPropertyChangeListener(this);
    }

    private boolean isGlobal() {
        return false;
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings)).getString("CTL_HTTP_settings");
    }

    public boolean isRunning() {
        if (this.isWriteExternal()) {
            if (inited) {
                return running;
            }
            return true;
        }
        if (inited) {
            return running;
        }
        this.setRunning(false);
        return running;
    }

    void runSuccess() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            currentRetries = 0;
            running = true;
            HttpServerSettings.httpLock().notifyAll();
        }
    }

    void runFailure(Throwable t) {
        running = false;
        if (t instanceof IncompatibleClassChangeError) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_HTTP_SERVER_incompatbleClasses"), 2));
        } else if (t instanceof BindException) {
            if (++currentRetries <= 20) {
                this.setPort(this.getPort() + 1);
                this.setRunning(true);
            } else {
                currentRetries = 0;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_HTTP_SERVER_START_FAIL"), 2));
                int p = this.getPort();
                if (p < 1024 && inited && Utilities.isUnix()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_onlyRootOnUnix"), 2));
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_HTTP_SERVER_START_FAIL_unknown"), 2));
        }
    }

    private void restartIfNecessary(boolean printMessages) {
        if (this.isReadExternal()) {
            return;
        }
        if (running) {
            if (!printMessages) {
                this.setStartStopMessages(false);
            }
            HttpServerModule.stopHTTPServer();
            HttpServerModule.initHTTPServer();
        }
    }

    private String getCanonicalRelativeURL(String url) {
        String newURL;
        if (url.length() == 0) {
            newURL = "/";
        } else {
            newURL = url.charAt(0) != '/' ? "/" + url : url;
            if (newURL.charAt(newURL.length() - 1) != '/') {
                newURL = newURL + "/";
            }
        }
        return newURL;
    }

    public void setRunning(boolean running) {
        if (this.isReadExternal()) {
            return;
        }
        inited = true;
        if (HttpServerSettings.running == running) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (running) {
                HttpServerModule.initHTTPServer();
            } else {
                HttpServerSettings.running = false;
                HttpServerModule.stopHTTPServer();
            }
        }
        this.firePropertyChange(PROP_RUNNING, !running ? Boolean.TRUE : Boolean.FALSE, running ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getRepositoryBaseURL() {
        return repositoryBaseURL;
    }

    public void setRepositoryBaseURL(String repositoryBaseURL) {
        String newURL = this.getCanonicalRelativeURL(repositoryBaseURL);
        if (HttpServerSettings.repositoryBaseURL.equals(newURL)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerSettings.repositoryBaseURL = newURL;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_REPOSITORY_BASEURL, null, HttpServerSettings.repositoryBaseURL);
    }

    public String getClasspathBaseURL() {
        return classpathBaseURL;
    }

    public void setClasspathBaseURL(String classpathBaseURL) {
        String newURL = this.getCanonicalRelativeURL(classpathBaseURL);
        if (HttpServerSettings.classpathBaseURL.equals(newURL)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerSettings.classpathBaseURL = newURL;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_CLASSPATH_BASEURL, null, HttpServerSettings.classpathBaseURL);
    }

    public String getJavadocBaseURL() {
        return javadocBaseURL;
    }

    public void setJavadocBaseURL(String javadocBaseURL) {
        String oldURL;
        String newURL = this.getCanonicalRelativeURL(javadocBaseURL);
        if (HttpServerSettings.javadocBaseURL.equals(newURL)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            oldURL = HttpServerSettings.javadocBaseURL;
            HttpServerSettings.javadocBaseURL = newURL;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_JAVADOC_BASEURL, oldURL, HttpServerSettings.javadocBaseURL);
    }

    public URL getJavadocURL(FileObject fo) throws MalformedURLException, UnknownHostException {
        try {
            this.setRunning(true);
            return new URL("http", this.getLocalHost(), this.getPort(), this.getJavadocBaseURL() + HttpServerSettings.mangle(fo.getFileSystem().getSystemName()) + "/" + fo.getPath());
        }
        catch (FileStateInvalidException ex) {
            throw new MalformedURLException();
        }
    }

    String getWrapperBaseURL() {
        return wrapperBaseURL;
    }

    void setWrapperBaseURL(String wrapperBaseURL) {
        String oldURL;
        String newURL = this.getCanonicalRelativeURL(wrapperBaseURL);
        if (HttpServerSettings.wrapperBaseURL.equals(newURL)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            oldURL = HttpServerSettings.wrapperBaseURL;
            HttpServerSettings.wrapperBaseURL = newURL;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_WRAPPER_BASEURL, oldURL, HttpServerSettings.wrapperBaseURL);
    }

    private String getGrantedAddresses() {
        return grantedAddresses;
    }

    public void setGrantedAddresses(String grantedAddresses) {
        HttpServerSettings.grantedAddresses = grantedAddresses;
        this.firePropertyChange(PROP_HOST_PROPERTY, null, HttpServerSettings.grantedAddresses);
    }

    public void setPort(int p) {
        if (p <= 0 || p > 65535) {
            throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"ERR_PortNumberOutOfRange", (Object)new Integer(p)));
        }
        Object old = this.getProperty(PROP_PORT);
        int port = old == null ? 8082 : (Integer)old;
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            old = this.putProperty(PROP_PORT, new Integer(p), false);
            if (old != null && p == (Integer)old) {
                return;
            }
            this.restartIfNecessary(true);
        }
        this.firePropertyChange(PROP_PORT, old, new Integer(p));
    }

    public int getPort() {
        Object prop = this.getProperty(PROP_PORT);
        return prop == null ? 8082 : (Integer)prop;
    }

    public void setHost(String h) {
        if (h.equals(ANYHOST) || h.equals(LOCALHOST)) {
            host = h;
        }
        this.firePropertyChange(PROP_HOST_PROPERTY, null, host);
    }

    private String getHost() {
        return host;
    }

    public void setStartStopMessages(boolean ssm) {
        startStopMessages = ssm;
    }

    public boolean isStartStopMessages() {
        return startStopMessages;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings);
    }

    void firePropertyChange0(String name, Object oldVal, Object newVal) {
        this.firePropertyChange(name, oldVal, newVal);
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public URL getRepositoryURL(FileObject fo) throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getRepositoryBaseURL() + fo.getPath());
    }

    public URL getRepositoryRoot() throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getRepositoryBaseURL());
    }

    public URL getResourceURL(String resourcePath) throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getClasspathBaseURL() + (resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath));
    }

    public URL getResourceRoot() throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getClasspathBaseURL());
    }

    public void addGrantAccessListener(GrantAccessListener l) {
        listenerList.add(class$org$netbeans$modules$httpserver$GrantAccessListener == null ? (class$org$netbeans$modules$httpserver$GrantAccessListener = HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener")) : class$org$netbeans$modules$httpserver$GrantAccessListener, l);
    }

    public void removeGrantAccessListener(GrantAccessListener l) {
        listenerList.remove(class$org$netbeans$modules$httpserver$GrantAccessListener == null ? (class$org$netbeans$modules$httpserver$GrantAccessListener = HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener")) : class$org$netbeans$modules$httpserver$GrantAccessListener, l);
    }

    protected boolean fireGrantAccessEvent(InetAddress clientAddress, String resource) {
        Object[] listeners = listenerList.getListenerList();
        GrantAccessEvent grantAccessEvent = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$org$netbeans$modules$httpserver$GrantAccessListener == null ? HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener") : class$org$netbeans$modules$httpserver$GrantAccessListener)) {
                if (grantAccessEvent == null) {
                    grantAccessEvent = new GrantAccessEvent(this, clientAddress, resource);
                }
                ((GrantAccessListener)listeners[i + 1]).grantAccess(grantAccessEvent);
            }
            i -= 2;
        }
        return grantAccessEvent == null ? false : grantAccessEvent.isGranted();
    }

    public boolean allowAccess(InetAddress addr) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean allowAccess(InetAddress addr, String requestPath) {
        if (this.accessAllowedNow(addr, requestPath)) {
            return true;
        }
        Thread askThread = null;
        Hashtable hashtable = whoAsking;
        synchronized (hashtable) {
            if (this.accessAllowedNow(addr, requestPath)) {
                return true;
            }
            askThread = (Thread)whoAsking.get(addr);
            if (askThread == null) {
                askThread = Thread.currentThread();
                whoAsking.put(addr, askThread);
            }
        }
        Class clazz = class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings;
        synchronized (clazz) {
            boolean bl;
            block14: {
                boolean bl2;
                block13: {
                    boolean bl3;
                    block12: {
                        if (askThread != Thread.currentThread()) {
                            return this.accessAllowedNow(addr, requestPath);
                        }
                        try {
                            if (!this.isShowGrantAccessDialog()) {
                                bl3 = false;
                                Object var13_9 = null;
                                whoAsking.remove(addr);
                                break block12;
                            }
                            String msg = NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_AddAddress", (Object)addr.getHostAddress());
                            GrantAccessPanel panel = new GrantAccessPanel(msg);
                            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"CTL_GrantAccessTitle"), true, 0, NotifyDescriptor.NO_OPTION, null);
                            descriptor.setMessageType(3);
                            Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
                            ((Component)d).setSize(580, 180);
                            d.show();
                            this.setShowGrantAccessDialog(panel.getShowDialog());
                            if (NotifyDescriptor.YES_OPTION.equals(descriptor.getValue())) {
                                this.appendAddressToGranted(addr.getHostAddress());
                                bl2 = true;
                                break block13;
                            }
                            bl = false;
                            break block14;
                        }
                        catch (Throwable throwable) {
                            Object var13_12 = null;
                            whoAsking.remove(addr);
                            throw throwable;
                        }
                    }
                    return bl3;
                }
                Object var13_10 = null;
                whoAsking.remove(addr);
                return bl2;
            }
            Object var13_11 = null;
            whoAsking.remove(addr);
            return bl;
        }
    }

    private boolean accessAllowedNow(InetAddress addr, String resource) {
        if (this.getHost().equals(ANYHOST)) {
            return true;
        }
        HashSet hs = this.getGrantedAddressesSet();
        if (hs.contains(addr.getHostAddress())) {
            return true;
        }
        return this.fireGrantAccessEvent(addr, resource);
    }

    private void appendAddressToGranted(String addr) {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String granted = this.getGrantedAddresses().trim();
            if (granted.length() > 0 && granted.charAt(granted.length() - 1) != ';' && granted.charAt(granted.length() - 1) != ',') {
                granted = granted + ',';
            }
            granted = granted + addr;
            this.setGrantedAddresses(granted);
        }
    }

    HashSet getGrantedAddressesSet() {
        HashSet<String> addr = new HashSet<String>();
        try {
            addr.add(InetAddress.getByName("localhost").getHostAddress());
            addr.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer(this.getGrantedAddresses(), ",;");
        while (st.hasMoreTokens()) {
            String ipa = st.nextToken();
            ipa = ipa.trim();
            try {
                addr.add(InetAddress.getByName(ipa).getHostAddress());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        return addr;
    }

    Properties getMappedServlets() {
        return mappedServlets;
    }

    static String mangle(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '.') {
                sb.append(name.charAt(i));
            } else {
                String code = Integer.toHexString(name.charAt(i)).toUpperCase();
                if (code.length() < 2) {
                    code = code.length() == 0 ? "00" : "0" + code;
                }
                sb.append("%").append(code.length() == 2 ? code : code.substring(code.length() - 2));
            }
            ++i;
        }
        return sb.toString();
    }

    static String demangle(String name) {
        StringBuffer sb = new StringBuffer();
        try {
            int i = 0;
            while (i < name.length()) {
                if (name.charAt(i) != '%') {
                    sb.append(name.charAt(i));
                } else {
                    sb.append((char)Integer.parseInt(name.substring(i + 1, i + 3), 16));
                    i += 2;
                }
                ++i;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return "";
        }
        return sb.toString();
    }

    public HostProperty getHostProperty() {
        return new HostProperty(grantedAddresses, host);
    }

    public void setHostProperty(HostProperty hostProperty) {
        if (ANYHOST.equals(hostProperty.getHost()) || LOCALHOST.equals(hostProperty.getHost())) {
            grantedAddresses = hostProperty.getGrantedAddresses();
            host = hostProperty.getHost();
            this.firePropertyChange(PROP_HOST_PROPERTY, null, hostProperty);
        }
    }

    public boolean isShowGrantAccessDialog() {
        Boolean b = (Boolean)this.getProperty(PROP_SHOW_GRANT_ACCESS);
        if (b != null) {
            return b;
        }
        return true;
    }

    public void setShowGrantAccessDialog(boolean show) {
        this.putProperty(PROP_SHOW_GRANT_ACCESS, show ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isReadExternal() || !this.equals(evt.getSource())) {
            return;
        }
        String prop = evt.getPropertyName();
        if (PROP_CLASSPATH_BASEURL.equals(prop) || PROP_JAVADOC_BASEURL.equals(prop) || PROP_REPOSITORY_BASEURL.equals(prop)) {
            boolean clash = this.getClasspathBaseURL().startsWith(this.getJavadocBaseURL());
            clash |= this.getClasspathBaseURL().startsWith(this.getRepositoryBaseURL());
            clash |= this.getJavadocBaseURL().startsWith(this.getClasspathBaseURL());
            clash |= this.getJavadocBaseURL().startsWith(this.getRepositoryBaseURL());
            clash |= this.getRepositoryBaseURL().startsWith(this.getClasspathBaseURL());
            if (clash |= this.getRepositoryBaseURL().startsWith(this.getJavadocBaseURL())) {
                RequestProcessor.getDefault().post(new Runnable(){
                    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = 1.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_MappingsConflict")));
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class HostProperty
    implements Serializable {
        private String grantedAddresses;
        private String host;
        private static final long serialVersionUID = 1927848926692414249L;

        HostProperty(String grantedAddresses, String host) {
            this.grantedAddresses = grantedAddresses;
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getGrantedAddresses() {
            return this.grantedAddresses;
        }

        public void setGrantedAddresses(String grantedAddresses) {
            this.grantedAddresses = grantedAddresses;
        }
    }
}

