/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.SharedClassObject;

public class HttpServerURLMapper
extends URLMapper {
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;

    public FileObject[] getFileObjects(URL url) {
        int index;
        String path = url.getPath();
        HttpServerSettings settings = (HttpServerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerURLMapper.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (boolean)true);
        String wrapper = settings.getWrapperBaseURL();
        if (path == null || !path.startsWith(wrapper)) {
            return null;
        }
        if ((path = path.substring(wrapper.length())).startsWith("/")) {
            path = path.substring(1);
        }
        if ((index = path.indexOf(47)) == -1) {
            return null;
        }
        String fsName = path.substring(0, index);
        FileSystem fs = HttpServerURLMapper.decodeFileSystemName(fsName);
        if (fs == null) {
            return null;
        }
        path = path.substring(index + 1);
        StringTokenizer slashTok = new StringTokenizer(path, "/", true);
        StringBuffer newPath = new StringBuffer();
        while (slashTok.hasMoreTokens()) {
            String tok = slashTok.nextToken();
            if (tok.startsWith("/")) {
                newPath.append(tok);
                continue;
            }
            newPath.append(URLDecoder.decode(tok));
        }
        FileObject fo = fs.findResource(newPath.toString());
        if (fo == null) {
            return null;
        }
        return new FileObject[]{fo};
    }

    public URL getURL(FileObject fileObject, int type) {
        if (type == 0) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            String encodedFs = HttpServerURLMapper.encodeFileSystemName(fileObject.getFileSystem());
            String orig = fileObject.getPath();
            StringTokenizer slashTok = new StringTokenizer(orig, "/", true);
            StringBuffer path = new StringBuffer();
            while (slashTok.hasMoreTokens()) {
                String tok = slashTok.nextToken();
                if (tok.startsWith("/")) {
                    path.append(tok);
                    continue;
                }
                path.append(URLEncoder.encode(tok));
            }
            if (fileObject.isFolder() && orig.length() > 0 && !path.toString().endsWith("/")) {
                path.append("/");
            }
            HttpServerSettings settings = (HttpServerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerURLMapper.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (boolean)true);
            settings.setRunning(true);
            URL newURL = new URL("http", HttpServerURLMapper.getLocalHost(type), settings.getPort(), settings.getWrapperBaseURL() + encodedFs + "/" + path.toString());
            return newURL;
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private static String encodeFileSystemName(FileSystem fs) {
        String fsname = fs.getSystemName();
        return URLEncoder.encode(fsname);
    }

    private static FileSystem decodeFileSystemName(String s) {
        String decoded = URLDecoder.decode(s);
        return Repository.getDefault().findFileSystem(decoded);
    }

    private static String getLocalHost(int type) {
        if (1 == type) {
            return "localhost";
        }
        if (2 == type) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                return "localhost";
            }
        }
        throw new IllegalArgumentException("Bad URL type: " + type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

