/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public abstract class NbBaseServlet
extends HttpServlet {
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$NbBaseServlet;
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public void init() throws ServletException {
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$NbBaseServlet == null ? (class$org$netbeans$modules$httpserver$NbBaseServlet = NbBaseServlet.class$("org.netbeans.modules.httpserver.NbBaseServlet")) : class$org$netbeans$modules$httpserver$NbBaseServlet)).getString("MSG_BaseServletDescr");
    }

    protected boolean checkAccess(HttpServletRequest request) throws IOException {
        HttpServerSettings settings = (HttpServerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = NbBaseServlet.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings));
        if (settings == null) {
            return false;
        }
        if (settings.getHostProperty().getHost().equals("any")) {
            return true;
        }
        HashSet hs = settings.getGrantedAddressesSet();
        if (hs.contains(request.getRemoteAddr().trim())) {
            return true;
        }
        String pathI = request.getPathInfo();
        if (pathI == null) {
            pathI = "";
        }
        try {
            String address = request.getRemoteAddr().trim();
            if (settings.allowAccess(InetAddress.getByName(address), pathI)) {
                return true;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        return false;
    }

    protected boolean handleClasspathRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathI = request.getPathInfo();
        if (pathI == null) {
            return false;
        }
        if (pathI.length() == 0) {
            return false;
        }
        if (pathI.charAt(0) == '/') {
            pathI = pathI.substring(1);
        }
        if (pathI.length() == 0) {
            return false;
        }
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbBaseServlet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        InputStream is = cl.getResourceAsStream(pathI);
        if (is == null) {
            return false;
        }
        try {
            String encoding = null;
            int ind = pathI.lastIndexOf(".");
            if (ind != -1) {
                String ext = pathI.substring(ind + 1);
                encoding = FileUtil.getMIMEType((String)ext);
            }
            if (encoding == null) {
                encoding = "content/unknown";
            }
            response.setContentType(encoding);
            ServletOutputStream os = response.getOutputStream();
            try {
                NbBaseServlet.copyStream(is, (OutputStream)os);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                os.close();
                throw throwable;
            }
            os.close();
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return true;
    }

    protected boolean handleRepositoryRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathI = request.getPathInfo();
        if (pathI == null) {
            return false;
        }
        FileObject fo = Repository.getDefault().findResource(pathI);
        if (fo == null && pathI.length() > 0 && pathI.charAt(pathI.length() - 1) != '/') {
            fo = Repository.getDefault().findResource(pathI + '/');
        }
        if (fo == null) {
            return false;
        }
        if (fo.isFolder()) {
            this.sendDirectory(request, response, fo);
        } else {
            this.sendFile(request, response, fo);
        }
        return true;
    }

    private void sendFile(HttpServletRequest request, HttpServletResponse response, FileObject file) throws IOException {
        String encoding = file.getMIMEType();
        response.setContentType(encoding);
        int len = (int)file.getSize();
        response.setContentLength(len);
        response.setDateHeader("Last-Modified", file.lastModified().getTime());
        InputStream in = file.getInputStream();
        try {
            ServletOutputStream os = response.getOutputStream();
            try {
                NbBaseServlet.copyStream(in, (OutputStream)os);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                os.close();
                throw throwable;
            }
            os.close();
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    private void sendDirectory(HttpServletRequest request, HttpServletResponse response, FileObject file) throws IOException {
        response.setContentType("text/html");
        String title = file.getPath();
        if (title.length() == 0) {
            title = NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$NbBaseServlet == null ? (class$org$netbeans$modules$httpserver$NbBaseServlet = NbBaseServlet.class$("org.netbeans.modules.httpserver.NbBaseServlet")) : class$org$netbeans$modules$httpserver$NbBaseServlet)).getString("LAB_REPOSITORY_ROOT");
        }
        PrintWriter out = response.getWriter();
        out.print("<HTML><HEAD><TITLE>");
        out.print(title);
        out.print("</TITLE></HEAD><BODY>\n<H1>");
        out.print(title);
        out.print("</H1>");
        FileObject parent = file.getParent();
        if (parent != null) {
            out.print("<A HREF=\"../\">" + NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$NbBaseServlet == null ? (class$org$netbeans$modules$httpserver$NbBaseServlet = NbBaseServlet.class$("org.netbeans.modules.httpserver.NbBaseServlet")) : class$org$netbeans$modules$httpserver$NbBaseServlet)).getString("CTL_PARENT_DIR") + "</A><BR><BR>\n");
        }
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        Iterator it = NbBaseServlet.sortEnumeration(NbBaseServlet.children(file.getPath()), new Comparator(){

            public int compare(Object o1, Object o2) {
                FileObject f1 = (FileObject)o1;
                FileObject f2 = (FileObject)o2;
                if (f1.isFolder() && !f2.isFolder()) {
                    return -1;
                }
                if (!f1.isFolder() && f2.isFolder()) {
                    return 1;
                }
                int res = String.CASE_INSENSITIVE_ORDER.compare(f1.getName(), f2.getName());
                if (res == 0) {
                    res = String.CASE_INSENSITIVE_ORDER.compare(f1.getExt(), f2.getExt());
                }
                return res;
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        HashMap<String, String> all = new HashMap<String, String>();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            String name = fo.getNameExt();
            if (all.get(name) != null) continue;
            all.put(name, name);
            StringBuffer sb = new StringBuffer("<A HREF=\"").append(name);
            if (fo.isFolder()) {
                sb.append("/\"><B>").append(name).append("</B></A><BR>");
            } else {
                sb.append("\">").append(name).append("</A><BR>");
            }
            out.print(sb.toString());
        }
        out.flush();
    }

    private static Iterator sortEnumeration(Enumeration en, Comparator c) {
        TreeSet ts = new TreeSet(c);
        while (en.hasMoreElements()) {
            ts.add(en.nextElement());
        }
        return ts.iterator();
    }

    private static Enumeration children(final String name) {
        Enumeration en = Repository.getDefault().getFileSystems();
        en = new AlterEnumeration(en){

            public Object alter(Object o) {
                FileSystem fs = (FileSystem)o;
                if (fs.isHidden()) {
                    return EmptyEnumeration.EMPTY;
                }
                FileObject fo = fs.findResource(name);
                if (fo == null || !fo.isFolder()) {
                    return EmptyEnumeration.EMPTY;
                }
                return fo.getChildren(false);
            }
        };
        return new SequenceEnumeration(en);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 8000;
        try {
            byte[] buffer = new byte[bufferSize];
            int len = bufferSize;
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.flush();
            throw throwable;
        }
        out.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

