/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.web.debug.DebugServletLine;
import org.netbeans.modules.web.debug.JspCompoundEvent;
import org.netbeans.modules.web.debug.JspEditorSupport;
import org.netbeans.modules.web.debug.LineMangler;
import org.openide.debugger.Debugger;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Lookup;

public class CurrentLineSupport {
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    protected static void installation() {
        ThreadsRoot root = (ThreadsRoot)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = CurrentLineSupport.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        root.addPropertyChangeListener((PropertyChangeListener)new ThreadsRootListener(root));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ThreadsRootListener
    implements PropertyChangeListener {
        private ThreadsRoot root;
        private Line oldServletLine;
        private Annotation oldAnnotation;

        private ThreadsRootListener(ThreadsRoot r) {
            this.root = r;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CallStackProducer producer;
            String name = propertyChangeEvent.getPropertyName();
            if (name == null) {
                return;
            }
            if (name.equals("currentLine")) {
                Object newValue = propertyChangeEvent.getNewValue();
                Object oldValue = propertyChangeEvent.getOldValue();
                if (newValue != null && oldValue == null) {
                    CoreBreakpoint jspBP;
                    Line newServletLine = (Line)newValue;
                    if (!(newServletLine instanceof DebugServletLine)) {
                        return;
                    }
                    Line newJspLine = LineMangler.getJspLine(newServletLine);
                    if (JspEditorSupport.getFocusedJspEditor()) {
                        ((DebugServletLine)newServletLine).changeToJspShowing(2);
                    }
                    if ((jspBP = (CoreBreakpoint)((Debugger)this.root).findBreakpoint(newJspLine)) != null) {
                        JspCompoundEvent jspEvent = (JspCompoundEvent)jspBP.getEvent();
                        jspEvent.detach();
                    }
                    DebuggerAnnotation.CurrentPC newAnnotation = new DebuggerAnnotation.CurrentPC();
                    newAnnotation.attachLine(newJspLine, newAnnotation.getAnnotationType());
                    this.oldServletLine = newServletLine;
                    this.oldAnnotation = newAnnotation;
                } else if (newValue == null && oldValue != null) {
                    if (this.oldServletLine != null) {
                        this.oldServletLineProcessing();
                    }
                } else if (newValue != null && oldValue != null) {
                    Line newServletLine = (Line)newValue;
                    if (!(newServletLine instanceof DebugServletLine)) {
                        return;
                    }
                    Line newJspLine = LineMangler.getJspLine(newServletLine);
                    if (JspEditorSupport.getFocusedJspEditor()) {
                        ((DebugServletLine)newServletLine).changeToJspShowing(2);
                    }
                    this.oldAnnotation.detach();
                    if (this.oldServletLine != null) {
                        this.oldServletLineProcessing();
                    }
                    DebuggerAnnotation.CurrentPC newAnnotation = new DebuggerAnnotation.CurrentPC();
                    newAnnotation.attachLine(newJspLine, newAnnotation.getAnnotationType());
                    this.oldServletLine = newServletLine;
                    this.oldAnnotation = newAnnotation;
                }
            } else if (name.equals("currentThread") && (producer = (CallStackProducer)this.root.getCurrentThread()) == null && this.oldServletLine != null) {
                this.oldServletLineProcessing();
            }
        }

        private void oldServletLineProcessing() {
            this.oldAnnotation.detach();
            Line oldJspLine = LineMangler.getJspLine(this.oldServletLine);
            CoreBreakpoint jspBP = (CoreBreakpoint)((Debugger)this.root).findBreakpoint(oldJspLine);
            if (jspBP != null) {
                JspCompoundEvent jspEvent = (JspCompoundEvent)jspBP.getEvent();
                jspEvent.annotate();
            }
            this.oldServletLine = null;
            this.oldAnnotation = null;
        }
    }
}

