/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.util.Find;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.netbeans.modules.web.core.jsploader.ServletLine;
import org.netbeans.modules.web.debug.DebugSettings;
import org.netbeans.modules.web.debug.JspEditorSupport;
import org.netbeans.modules.web.debug.LineMangler;
import org.netbeans.modules.web.debug.ToggleJspStepMode;
import org.openide.ErrorManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;

public class DebugServletLine
extends ServletLine {
    private ShowRunnable showRunnable;
    private transient boolean annotationInJSP = false;
    private transient boolean showInJSP = false;
    private static final long serialVersionUID = 5731692100828619935L;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$org$netbeans$modules$web$debug$DebugSettings;
    static /* synthetic */ Class class$org$openide$text$Annotation;
    static /* synthetic */ Class class$org$openide$text$Annotatable;

    public DebugServletLine(Line orig, ServletEditor editor) {
        super(orig, editor);
    }

    public void show(int kind, int column) {
        if (this.showRunnable != null) {
            this.showRunnable.setFinished();
        }
        this.showRunnable = new ShowRunnable(kind, column);
        if (this.showInJSP) {
            this.showInJSP = false;
            this.changeToJspShowing(kind);
        }
        RequestProcessor.getDefault().post((Runnable)this.showRunnable, 100);
    }

    public void show(int kind) {
        this.show(kind, 0);
    }

    public void changeToJspShowing(int kind) {
        if (this.showRunnable != null) {
            this.showRunnable.setJspShowing(kind);
        }
    }

    public boolean canBeMarkedCurrent(int action, Line previousLine) {
        try {
            Debugger debugger = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DebugServletLine.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            if (debugger.findBreakpoint((Line)this) != null) {
                return true;
            }
            if (DebugServletLine.findHiddenBreakpoint(debugger, (Line)this) != null) {
                return true;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        LineMangler mangler = LineMangler.getMangler((JspServletDataObject)this.getDataObject());
        if (ToggleJspStepMode.isJspStepMode() && mangler.getJavaLineType(this.getLineNumber() + 1).equals("MappedCharData")) {
            return false;
        }
        if (JspEditorSupport.getFocusedJspEditor()) {
            if (mangler.getJavaLineType(this.getLineNumber() + 1).equalsIgnoreCase("")) {
                return true;
            }
            return this.containJspLineThisLine(mangler);
        }
        return true;
    }

    protected void addAnnotation(Annotation anno) {
        if (this.isCompilerAnnotation(anno)) {
            Line jspLine = LineMangler.getJspLine((Line)this);
            DebugSettings ds = (DebugSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$web$debug$DebugSettings == null ? (class$org$netbeans$modules$web$debug$DebugSettings = DebugServletLine.class$("org.netbeans.modules.web.debug.DebugSettings")) : class$org$netbeans$modules$web$debug$DebugSettings), (boolean)true);
            if (ds.isShowErrorLineInJsp() && jspLine != null) {
                this.annotationInJSP = true;
                this.showInJSP = true;
                this.manipulateAnnotReflect(jspLine, anno, true);
            } else {
                this.annotationInJSP = false;
                this.showInJSP = false;
                super.addAnnotation(anno);
            }
        } else {
            this.showInJSP = false;
            super.addAnnotation(anno);
        }
    }

    protected void removeAnnotation(Annotation anno) {
        if (this.isCompilerAnnotation(anno)) {
            Line jspLine = LineMangler.getJspLine((Line)this);
            if (this.annotationInJSP && jspLine != null) {
                this.manipulateAnnotReflect(jspLine, anno, false);
            } else {
                super.removeAnnotation(anno);
            }
            this.annotationInJSP = false;
        } else {
            super.removeAnnotation(anno);
        }
    }

    private void manipulateAnnotReflect(Line l, Annotation anno, boolean add) {
        try {
            String methodName = add ? "addAnnotation" : "removeAnnotation";
            Method m = (class$org$openide$text$Annotatable == null ? (class$org$openide$text$Annotatable = DebugServletLine.class$("org.openide.text.Annotatable")) : class$org$openide$text$Annotatable).getDeclaredMethod(methodName, class$org$openide$text$Annotation == null ? (class$org$openide$text$Annotation = DebugServletLine.class$("org.openide.text.Annotation")) : class$org$openide$text$Annotation);
            ((AccessibleObject)m).setAccessible(true);
            m.invoke((Object)l, anno);
        }
        catch (NoSuchMethodException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private boolean isCompilerAnnotation(Annotation anno) {
        return "org-netbeans-core-compiler-error".equals(anno.getAnnotationType());
    }

    private boolean containJspLineThisLine(LineMangler mangler) {
        Line jspLine = LineMangler.getJspLine((Line)this);
        Line[] servletLines = LineMangler.getServletLines(jspLine);
        int i = 0;
        while (i < servletLines.length) {
            if (servletLines[i].equals((Object)this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Breakpoint findHiddenBreakpoint(Debugger debugger, Line line) {
        CoreBreakpoint[] b = Find.breakpoints((Debugger)debugger, (boolean)true, (boolean)true, (boolean)false, (boolean)true);
        int k = b.length;
        int i = 0;
        while (i < k) {
            if (b[i].isEnabled() && b[i].getLine() != null && b[i].getLine().equals(line)) {
                return b[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShowRunnable
    implements Runnable {
        private int kind;
        private int column = 0;
        private boolean finished = false;
        private boolean jspShowing = false;

        private ShowRunnable(int k, int c) {
            this.kind = k;
            this.column = c;
        }

        private ShowRunnable(int k) {
            this.kind = k;
        }

        public void run() {
            if (this.finished) {
                return;
            }
            if (this.jspShowing) {
                Line jspLine = LineMangler.getJspLine((Line)DebugServletLine.this);
                if (jspLine != null) {
                    jspLine.show(this.kind);
                }
            } else {
                DebugServletLine.this.orig.show(this.kind, this.column);
            }
        }

        protected void setFinished() {
            this.finished = true;
        }

        protected void setJspShowing(int kind) {
            this.jspShowing = true;
            this.kind = kind;
        }
    }

    public static class Set
    extends ServletLine.Set {
        public Set(Line.Set delegate, ServletEditor editor) {
            super(delegate, editor);
        }

        public List getLines() {
            if (this.linesCache == null) {
                List lines = this.delegate.getLines();
                this.linesCache = new ArrayList();
                int i = 0;
                while (i < lines.size()) {
                    this.linesCache.add(new DebugServletLine((Line)lines.get(i), this.editor));
                    ++i;
                }
            }
            return this.linesCache;
        }

        public Line getOriginal(int line) throws IndexOutOfBoundsException {
            return new DebugServletLine(this.delegate.getOriginal(line), this.editor);
        }

        public Line getCurrent(int line) throws IndexOutOfBoundsException {
            return new DebugServletLine(this.delegate.getCurrent(line), this.editor);
        }
    }
}

