/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.debugger.Controller;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.debug.JspCompoundEvent;
import org.netbeans.modules.web.html.HtmlDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;

class JspBreakpointPanel
extends JPanel
implements Controller {
    private final String DOT = ".";
    private JspCompoundEvent event;
    private String cls;
    static final long serialVersionUID = -8164649328980808272L;
    private JPanel jPanel1;
    private JLabel lblLineNumber;
    private JTextField tfLineNumber;
    private JTextField cboxClass;
    private JLabel lblClassName;
    static /* synthetic */ Class class$org$netbeans$modules$web$debug$JspBreakpointPanel;

    public JspBreakpointPanel(JspCompoundEvent e) {
        Line line;
        this.event = e;
        this.initComponents();
        this.putClientProperty("HelpID", "jsp_breakpoint");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("ACSD_LineBreakpointPanel"));
        this.cboxClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("ACSD_CTL_Class_name"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("ACSD_CTL_Line_number"));
        if (e != null && (line = Utils.getCurrentLine()) != null && line.getDataObject() instanceof JspDataObject) {
            e.setLine(line);
        }
        this.fillPackageAndClass();
        this.fillLineNumber();
    }

    private void initComponents() {
        this.lblClassName = new JLabel();
        this.lblLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.jPanel1 = new JPanel();
        this.cboxClass = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblClassName.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("CTL_Class_name"));
        this.lblClassName.setLabelFor(this.cboxClass);
        this.lblClassName.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("CTL_Class_name_mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblClassName, gridBagConstraints);
        this.lblLineNumber.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("CTL_Line_number"));
        this.lblLineNumber.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("CTL_Line_number_mnemonic").charAt(0));
        this.lblLineNumber.setLabelFor(this.tfLineNumber);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblLineNumber, gridBagConstraints);
        this.tfLineNumber.setColumns(7);
        this.tfLineNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JspBreakpointPanel.this.tfLineNumberActionPerformed(evt);
            }
        });
        this.tfLineNumber.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                JspBreakpointPanel.this.tfLineNumberFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                JspBreakpointPanel.this.tfLineNumberFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfLineNumber, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.cboxClass.setColumns(20);
        this.cboxClass.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                JspBreakpointPanel.this.setEventSource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cboxClass, gridBagConstraints);
    }

    private void setEventSource(FocusEvent evt) {
        String cls = this.cboxClass.getText();
        cls = cls.trim();
        if (this.event != null) {
            this.event.setSourceName(cls);
        }
        this.fillPackageAndClass();
    }

    private void tfLineNumberActionPerformed(ActionEvent evt) {
    }

    private void tfLineNumberFocusGained(FocusEvent evt) {
        if (!evt.isTemporary()) {
            ((JTextField)evt.getComponent()).selectAll();
        }
    }

    private void tfLineNumberFocusLost(FocusEvent evt) {
        if (!evt.isTemporary()) {
            if (this.tfLineNumber.getText().trim().length() > 0) {
                try {
                    int i = Integer.parseInt(this.tfLineNumber.getText());
                    if (i < 1) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("CTL_Bad_line_number"), 0));
                    } else if (this.event != null) {
                        this.event.setLineNumber(i);
                    }
                }
                catch (NumberFormatException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspBreakpointPanel == null ? (class$org$netbeans$modules$web$debug$JspBreakpointPanel = JspBreakpointPanel.class$("org.netbeans.modules.web.debug.JspBreakpointPanel")) : class$org$netbeans$modules$web$debug$JspBreakpointPanel)).getString("CTL_Bad_line_number"), 0));
                }
            }
            this.fillLineNumber();
        }
    }

    private void fillPackageAndClass() {
        if (!this.isAcceptableDataObject()) {
            return;
        }
        if (this.event.getSourceName() == null) {
            return;
        }
        String s = this.event.getSourceName().trim();
        if (s.length() < 1) {
            this.cls = "";
        } else {
            this.cls = s;
            this.cboxClass.setText(this.cls);
        }
    }

    private void fillLineNumber() {
        if (!this.isAcceptableDataObject()) {
            return;
        }
        if (this.event.getLineNumber() < 1) {
            this.tfLineNumber.setText("");
        } else {
            this.tfLineNumber.setText("" + this.event.getLineNumber());
        }
    }

    private boolean isAcceptableDataObject() {
        if (this.event == null) {
            return false;
        }
        Line l = this.event.getLine();
        if (l == null) {
            return false;
        }
        DataObject dobj = l.getDataObject();
        if (dobj == null) {
            return false;
        }
        return dobj instanceof JspDataObject || dobj instanceof HtmlDataObject;
    }

    public boolean ok() {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

