/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.debug.JspBreakpointAnnotation;
import org.netbeans.modules.web.debug.JspBreakpointPanel;
import org.netbeans.modules.web.debug.JspServletEvent;
import org.netbeans.modules.web.debug.LineMangler;
import org.netbeans.modules.web.debug.PinkJspBreakpointAnnotation;
import org.netbeans.modules.web.html.HtmlDataObject;
import org.openide.ErrorManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class JspCompoundEvent
extends LineBreakpointEvent
implements CoreBreakpoint.CompoundEvent,
CoreBreakpoint.AnnotatableEvent,
PropertyChangeListener {
    static final long serialVersionUID = 5611459342537392476L;
    public static final String PROP_SOURCE_NAME = "sourceName";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    private transient JspBreakpointAnnotation jspBreakpointAnnotation = new JspBreakpointAnnotation();
    private transient PinkJspBreakpointAnnotation pinkJspBreakpointAnnotation = new PinkJspBreakpointAnnotation();
    protected transient JspBreakpointUpdater updater;
    private boolean pink = false;
    private boolean newEvents = true;
    private List events = new ArrayList(4);
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$web$debug$JspCompoundEvent;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    public JspCompoundEvent() {
        this(false);
    }

    public JspCompoundEvent(boolean p) {
        this.pink = p;
        if (p) {
            this.newEvents = false;
        }
        this.init();
    }

    private void init() {
        this.jspBreakpointAnnotation = new JspBreakpointAnnotation();
        this.pinkJspBreakpointAnnotation = new PinkJspBreakpointAnnotation();
        this.updater = new JspBreakpointUpdater(this, this.getSourceName());
    }

    protected boolean isPink() {
        return this.pink;
    }

    protected void setNewEvents() {
        this.newEvents = true;
    }

    public boolean isDefault() {
        boolean val = JspCompoundEvent.isJsp();
        return val;
    }

    public static boolean isJsp() {
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JspCompoundEvent.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null) {
            return false;
        }
        if (nodes.length != 1) {
            return false;
        }
        Node n = nodes[0];
        DataObject dO = null;
        if (dO == null) {
            dO = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JspCompoundEvent.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (dO == null) {
            return false;
        }
        if (dO instanceof DataShadow) {
            dO = ((DataShadow)dO).getOriginal();
        }
        FileObject fo = dO.getPrimaryFile();
        return fo.getMIMEType().equals("text/x-jsp");
    }

    public CoreBreakpoint.Event[] getEvents() {
        if (this.line != null && (this.line.getDataObject() instanceof JspDataObject || this.line.getDataObject() instanceof HtmlDataObject)) {
            if (this.newEvents) {
                this.clearEvents();
                Line[] lines = LineMangler.getServletLines(this.line);
                int i = 0;
                while (i < lines.length) {
                    JspServletEvent event = new JspServletEvent(true);
                    event.setLine(lines[i]);
                    this.events.add(event);
                    ++i;
                }
                this.newEvents = false;
            }
            return this.events.toArray(new JspServletEvent[this.events.size()]);
        }
        return new CoreBreakpoint.Event[0];
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = JspCompoundEvent.class$("java.lang.String")) : class$java$lang$String), (String)PROP_SOURCE_NAME, (String)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("PROP_breakpoint_source_name"), (String)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("HINT_breakpoint_source_name"), (String)"getSourceName", (String)"setSourceName"), Utils.createProperty((Object)this, Integer.TYPE, (String)PROP_LINE_NUMBER, (String)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("PROP_breakpoint_line_number"), (String)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("HINT_breakpoint_line_number"), (String)"getLineNumber", (String)"setLineNumber")};
    }

    public JComponent getCustomizer() {
        this.setLine(Utils.getCurrentLine());
        return new JspBreakpointPanel(this);
    }

    protected void addEvent(Line servletLine) {
        JspServletEvent event = new JspServletEvent(true);
        event.setLine(servletLine);
        this.events.add(event);
    }

    protected void addEvent(JspServletEvent event) {
        this.events.add(event);
    }

    protected void removeEvent(Line servletLine) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            JspServletEvent event = (JspServletEvent)((Object)i.next());
            if (!event.getLine().equals(servletLine)) continue;
            this.events.remove((Object)event);
            this.deleteEmptyPinkBreakpoint();
            break;
        }
    }

    protected void removeEvent(JspServletEvent event) {
        if (this.events.remove((Object)event)) {
            this.deleteEmptyPinkBreakpoint();
        }
    }

    private void deleteEmptyPinkBreakpoint() {
        if (this.pink && this.events.isEmpty()) {
            Debugger debugger = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = JspCompoundEvent.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            if (null == debugger) {
                return;
            }
            Breakpoint b = debugger.findBreakpoint(this.line);
            b.remove();
        }
    }

    protected void clearEvents() {
        this.events = new ArrayList(4);
    }

    protected void refreshEvents() {
        this.firePropertyChange("event", null, this);
    }

    public String getTypeName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("CTL_JSP_DEBUGGER_NAME");
    }

    public String getCategoryDisplayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("CTL_JSP_DEBUGGER_NAME");
    }

    public Line[] getLines() {
        return new Line[]{this.line};
    }

    public String getTypeDisplayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("CTL_JSP_BREAKPOINT_NAME");
    }

    public boolean set() {
        return true;
    }

    public String getDisplayName() {
        if (this.pink) {
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("CTL_JSP_BREAKPOINT_DISPLAY_NAME_PINK"), this.line != null ? this.line.getDataObject().getPrimaryFile().getPath() : this.getSourceName(), this.line != null ? new Integer(this.line.getLineNumber() + 1) : new Integer(this.getLineNumber()));
        }
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspCompoundEvent == null ? (class$org$netbeans$modules$web$debug$JspCompoundEvent = JspCompoundEvent.class$("org.netbeans.modules.web.debug.JspCompoundEvent")) : class$org$netbeans$modules$web$debug$JspCompoundEvent)).getString("CTL_JSP_BREAKPOINT_DISPLAY_NAME"), this.line != null ? this.line.getDataObject().getPrimaryFile().getPath() : this.getSourceName(), this.line != null ? new Integer(this.line.getLineNumber() + 1) : new Integer(this.getLineNumber()));
    }

    public void remove() {
        this.detach();
        if (this.line != null) {
            DataObject jspDO = this.line.getDataObject();
            jspDO.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setSourceName(String cn) {
        if (cn != null) {
            cn = cn.trim();
        }
        if (cn == this.sourceName || cn != null && this.sourceName != null && this.sourceName.equals(cn)) {
            return;
        }
        String old = this.sourceName;
        this.sourceName = cn;
        int ln = this.getLineNumber();
        this.line = null;
        if (this.sourceName != null && this.sourceName.length() > 0 && ln > 0 && (this.line = JUtils.getLine((String)JspCompoundEvent.convert(this.sourceName), (int)ln)) == null) {
            this.lineNumber = ln;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_SOURCE_NAME, old, this.sourceName);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    private void sourceRenamed(String sn) {
        if (sn.equals(this.sourceName)) {
            return;
        }
        String oldSourceName = sn;
        this.sourceName = sn;
        this.firePropertyChange(PROP_SOURCE_NAME, oldSourceName, this.sourceName);
    }

    public void setLineNumber(int ln) {
        if (ln == this.lineNumber) {
            return;
        }
        int old = this.lineNumber;
        if (ln > 0) {
            if (this.sourceName != null && ln > 0) {
                this.line = JUtils.getLine((String)JspCompoundEvent.convert(this.sourceName), (int)ln);
            }
            this.lineNumber = ln;
        } else {
            this.line = null;
            this.lineNumber = -1;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(this.getLineNumber()));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    protected void sourceModified() {
        this.firePropertyChange(PROP_LINE_NUMBER, null, null);
    }

    public void setLine(Line l) {
        if (l != null) {
            Integer old = new Integer(this.getLineNumber());
            DataObject jspDO = l.getDataObject();
            jspDO.addPropertyChangeListener((PropertyChangeListener)this);
            this.setSourceName(l.getDataObject().getPrimaryFile().getPath());
            this.setLineNumber(l.getLineNumber() + 1);
            this.updater.setClassName(this.sourceName);
            this.line = l;
            this.firePropertyChange(PROP_LINE_NUMBER, old, this.line);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("PROP_SERVER_CHANGE")) {
            this.clearEvents();
            this.refreshEvents();
        } else if (e.getPropertyName().equals("CLEAN_COMPILE")) {
            this.clearEvents();
            this.refreshEvents();
        }
    }

    public Line getLine() {
        return this.line;
    }

    public boolean supportsMIMEType(String MIMEType) {
        return MIMEType.equals("text/x-jsp");
    }

    public boolean supportsDataObject(DataObject obj) {
        return obj instanceof JspDataObject;
    }

    public void detach() {
        this.pinkJspBreakpointAnnotation.detach();
        this.jspBreakpointAnnotation.detach();
    }

    public void annotate() {
        CoreBreakpoint br = this.getBreakpoint();
        if (br != null && br.isHidden()) {
            this.detach();
            return;
        }
        if (this.line != null) {
            if (this.pink) {
                this.pinkJspBreakpointAnnotation.attach((Annotatable)this.line);
            } else {
                this.jspBreakpointAnnotation.attach((Annotatable)this.line);
            }
        } else if (this.pink) {
            this.pinkJspBreakpointAnnotation.detach();
        } else {
            this.jspBreakpointAnnotation.detach();
        }
    }

    public static void jspCompoundEventInstallation() {
        List debuggers = Register.getDebuggerImpls();
        Iterator i = debuggers.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof JPDADebuggerImpl)) continue;
            JPDADebuggerImpl d = (JPDADebuggerImpl)o;
            d.registerEvent((CoreBreakpoint.Event)new JspCompoundEvent());
            return;
        }
        ErrorManager.getDefault().notify(4096, (Throwable)new Exception("no JPDADebuggerImpl"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private static String convert(String str) {
        String s = new String(str);
        int dotIndex = s.lastIndexOf(46);
        if (dotIndex != -1) {
            s = s.substring(0, dotIndex);
        }
        s = s.replace('/', '.');
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JspBreakpointUpdater
    extends BreakpointUpdater {
        public JspBreakpointUpdater(JspCompoundEvent breakpoint, String className) {
            super((CoreBreakpoint.Event)breakpoint, null, className);
        }

        protected synchronized void refreshFileObjectListener() {
            FileObject old = this.fileObject;
            Line line = ((JspCompoundEvent)this.breakpoint).getLine();
            if (line != null) {
                this.fileObject = line.getDataObject().getPrimaryFile();
                String fileName = JspCompoundEvent.convert(this.fileObject.getPath());
                if (this.className.indexOf(36) == -1) {
                    if (!fileName.equals(this.className)) {
                        this.fileObject = null;
                    }
                } else {
                    int fLen;
                    int cLen = this.className.length();
                    if (cLen < (fLen = fileName.length()) + 2 || this.className.charAt(fLen) != '$' || !this.className.startsWith(fileName)) {
                        this.fileObject = null;
                    }
                }
            } else {
                this.fileObject = null;
            }
            this.refreshFileObjectListener(old, this.fileObject);
        }

        protected void updateBreakpoint() {
            ((JspCompoundEvent)this.breakpoint).sourceRenamed(this.className);
        }

        public void fileChanged(FileEvent e) {
            super.fileChanged(e);
            ((JspCompoundEvent)this.breakpoint).sourceModified();
        }

        public void fileDeleted(FileEvent e) {
            JspCompoundEvent b = (JspCompoundEvent)this.breakpoint;
            if (b.getLine() != null) {
                b.setLine(null);
            }
            super.fileDeleted(e);
        }

        public void fileSystemAdded(RepositoryEvent e) {
            if (this.fileObject == null) {
                JspCompoundEvent b = (JspCompoundEvent)this.breakpoint;
                Line line = null;
                if (this.className != null) {
                    line = JUtils.getLine((String)JspCompoundEvent.convert(this.className), (int)b.getLineNumber());
                }
                if (line != null) {
                    b.setLine(line);
                    this.fileObject = line.getDataObject().getPrimaryFile();
                    this.refreshFileObjectListener(null, this.fileObject);
                    this.listenOnClass = this.onNestedClass;
                    if (this.listenOnClass) {
                        this.refreshClsElementListener();
                    }
                }
            }
        }

        public void fileSystemRemoved(RepositoryEvent e) {
            if (this.fileObject != null) {
                boolean removed;
                try {
                    removed = e.getFileSystem() == this.fileObject.getFileSystem();
                }
                catch (FileStateInvalidException ex) {
                    removed = true;
                }
                if (removed) {
                    JspCompoundEvent b = (JspCompoundEvent)this.breakpoint;
                    if (b.getLine() != null) {
                        b.setLine(null);
                    }
                    this.fileObject = null;
                    this.refreshFileObjectListener(this.fileObject, null);
                    if (this.listenOnClass) {
                        this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                        this.listenOnClass = false;
                    }
                }
            }
        }

        protected void fileSystemsChanged(List addedFS, List removedFS) {
            Repository rep = Repository.getDefault();
            Iterator i = addedFS.iterator();
            while (i.hasNext()) {
                this.fileSystemAdded(new RepositoryEvent(rep, (FileSystem)i.next(), true));
            }
            i = removedFS.iterator();
            while (i.hasNext()) {
                this.fileSystemRemoved(new RepositoryEvent(rep, (FileSystem)i.next(), false));
            }
        }
    }
}

