/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.web.core.jsploader.BaseJspEditorSupport;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.debug.JspEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.AbstractCompileAction;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JspEditorSupport
extends BaseJspEditorSupport {
    private static boolean focus = true;

    public JspEditorSupport(JspDataObject obj) {
        super(obj);
    }

    protected CloneableEditor createCloneableEditor() {
        return new JspEditor(this);
    }

    public static void setFocusedJspEditor(boolean b) {
        focus = b;
    }

    public static boolean getFocusedJspEditor() {
        return focus;
    }

    private static class CompileCookieEnumeration
    implements Enumeration {
        private Object cookie;

        public CompileCookieEnumeration(Object cookie) {
            this.cookie = cookie;
        }

        public boolean hasMoreElements() {
            return this.cookie != null;
        }

        public Object nextElement() {
            if (this.cookie != null) {
                Object cookie1 = this.cookie;
                this.cookie = null;
                return cookie1;
            }
            throw new NoSuchElementException();
        }
    }

    public static class JspEditor
    extends BaseJspEditorSupport.BaseJspEditor {
        public JspEditor() {
            this.initialize();
        }

        public JspEditor(BaseJspEditorSupport s) {
            super(s);
            this.initialize();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }

        private void initialize() {
            ((JComponent)((Object)this)).getActionMap().put("org.netbeans.modules.debugger.support.actions.ToggleBreakpointAction", new ToggleBreakpointAction());
        }

        protected void componentActivated() {
            JspEditorSupport.setFocusedJspEditor(true);
            super.componentActivated();
        }

        private final class ToggleBreakpointAction
        extends AbstractAction
        implements LookupListener {
            private final Lookup.Result debuggerR = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = ToggleBreakpointAction.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger));
            static /* synthetic */ Class class$org$openide$debugger$Debugger;

            public ToggleBreakpointAction() {
                this.debuggerR.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }

            public void actionPerformed(ActionEvent e) {
                ToggleBreakpointAction toggleBreakpointAction = this;
                synchronized (toggleBreakpointAction) {
                    Iterator it = this.debuggerR.allInstances().iterator();
                    if (it.hasNext()) {
                        Debugger debugger = (Debugger)it.next();
                        int row = NbDocument.findLineNumber((StyledDocument)JspEditor.super.cloneableEditorSupport().getDocument(), (int)JspEditor.super.getEditorPane().getCaret().getDot());
                        Line line = JspEditor.super.cloneableEditorSupport().getLineSet().getCurrent(row);
                        Breakpoint b = debugger.findBreakpoint(line);
                        if (b != null) {
                            b.remove();
                        } else {
                            debugger.createBreakpoint(line);
                            int debuggers = 0;
                            debuggers = ((CoreDebugger)debugger).getDebuggers().length;
                            if (debuggers > 0) {
                                Runnable r = new Runnable(this, line){
                                    static /* synthetic */ Class class$org$netbeans$modules$web$debug$JspEditorSupport;
                                    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
                                    private final /* synthetic */ Line val$line;
                                    private final /* synthetic */ ToggleBreakpointAction this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$line = val$line;
                                    }

                                    public void run() {
                                        boolean compilationOK = false;
                                        FfjJspCompileContext compContext = JspCompileUtil.getCurrentCompileContext((DataObject)this.val$line.getDataObject());
                                        FileObject jspFileObject = this.val$line.getDataObject().getPrimaryFile();
                                        WebStandardData.WebResource res = JspCompileUtil.getResourceData((FileObject)jspFileObject);
                                        WebStandardData.WebJsp jspData = (WebStandardData.WebJsp)res;
                                        FfjJspCompileContext.DevelopmentCompilation devc = null;
                                        if (compContext != null) {
                                            devc = compContext.getDevelopmentCompilation(jspData);
                                        }
                                        if (compContext == null || devc == null) {
                                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$JspEditorSupport == null ? (class$org$netbeans$modules$web$debug$JspEditorSupport = 1.class$("org.netbeans.modules.web.debug.JspEditorSupport")) : class$org$netbeans$modules$web$debug$JspEditorSupport)).getString("CTL_CompilationNotSupported"), 2));
                                            return;
                                        }
                                        boolean outdated = devc.isOutDated();
                                        if (outdated) {
                                            try {
                                                DataObject dobj = this.val$line.getDataObject();
                                                CompilerCookie.Compile cookie = (CompilerCookie.Compile)dobj.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = 1.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
                                                if (cookie != null) {
                                                    compilationOK = AbstractCompileAction.compile((Enumeration)new CompileCookieEnumeration(cookie), (String)this.val$line.getDataObject().getPrimaryFile().getName());
                                                }
                                            }
                                            catch (Exception e) {
                                                ErrorManager.getDefault().notify(1, (Throwable)e);
                                            }
                                        }
                                    }

                                    static /* synthetic */ Class class$(String x0) {
                                        try {
                                            return Class.forName(x0);
                                        }
                                        catch (ClassNotFoundException x1) {
                                            throw new NoClassDefFoundError(x1.getMessage());
                                        }
                                    }
                                };
                                RequestProcessor.getDefault().post(r, 50);
                            }
                        }
                    }
                }
            }

            public void resultChanged(LookupEvent e) {
                this.setEnabled(!this.debuggerR.allInstances().isEmpty());
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

