/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.netbeans.modules.web.debug.DebugServletLine;
import org.netbeans.modules.web.debug.JspEditorSupport;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.text.CloneableEditor;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.actions.SystemAction;

public class JspServletEditor
extends ServletEditor {
    public JspServletEditor(JspDataObject jspdo) {
        super(jspdo);
    }

    static String getFileName(Line line) {
        return line.getDataObject().getPrimaryFile().toString();
    }

    static String getDebugName(Line line) {
        return "{" + JspServletEditor.getFileName(line) + "-->" + line + "}";
    }

    public Line.Set getLineSet() {
        return new DebugServletLine.Set(super.getLineSet(), this);
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        super.loadFromStreamToKit(doc, stream, kit);
    }

    protected CloneableEditor createCloneableEditor() {
        return new ServletEditorComponentIE(this);
    }

    public static class ServletEditorComponentIE
    extends ServletEditor.ServletEditorComponent {
        static /* synthetic */ Class class$org$netbeans$modules$web$debug$ShowJsp;

        public ServletEditorComponentIE() {
            this.initialize();
        }

        public ServletEditorComponentIE(ServletEditor support) {
            super(support);
            this.initialize();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }

        private void initialize() {
            ((JComponent)((Object)this)).getActionMap().put("org.netbeans.modules.debugger.support.actions.ToggleBreakpointAction", new ToggleBreakpointAction());
        }

        private JspServletEditor getSupport() {
            return (JspServletEditor)this.cloneableEditorSupport();
        }

        protected void componentActivated() {
            JspEditorSupport.setFocusedJspEditor(false);
            super.componentActivated();
        }

        public SystemAction[] getSystemActions() {
            SystemAction[] sa = super.getSystemActions();
            SystemAction[] jspServletActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$web$debug$ShowJsp == null ? (class$org$netbeans$modules$web$debug$ShowJsp = ServletEditorComponentIE.class$("org.netbeans.modules.web.debug.ShowJsp")) : class$org$netbeans$modules$web$debug$ShowJsp))};
            return SystemAction.linkActions((SystemAction[])sa, (SystemAction[])jspServletActions);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private final class ToggleBreakpointAction
        extends AbstractAction
        implements LookupListener {
            private final Lookup.Result debuggerR = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = ToggleBreakpointAction.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger));
            static /* synthetic */ Class class$org$openide$debugger$Debugger;

            public ToggleBreakpointAction() {
                this.debuggerR.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }

            public void actionPerformed(ActionEvent e) {
                ToggleBreakpointAction toggleBreakpointAction = this;
                synchronized (toggleBreakpointAction) {
                    Iterator it = this.debuggerR.allInstances().iterator();
                    if (it.hasNext()) {
                        Debugger debugger = (Debugger)it.next();
                        int l = NbDocument.findLineNumber((StyledDocument)ServletEditorComponentIE.this.getSupport().getDocument(), (int)ServletEditorComponentIE.super.getPane().getCaret().getDot());
                        Line line = ServletEditorComponentIE.this.getSupport().getLineSet().getCurrent(l);
                        Breakpoint b = debugger.findBreakpoint(line);
                        if (b != null) {
                            b.remove();
                        } else {
                            debugger.createBreakpoint(line);
                        }
                    }
                }
            }

            public void resultChanged(LookupEvent e) {
                this.setEnabled(!this.debuggerR.allInstances().isEmpty());
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

