/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;
import org.netbeans.modules.web.core.jsploader.CompileData;
import org.netbeans.modules.web.core.jsploader.IncludedPagesSupport;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.netbeans.modules.web.html.HtmlDataObject;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebJspImpl;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;

public class LineMangler
implements Node.Cookie {
    private JspSourceMapper sourceMangler;
    private String className;
    private String mangledClassName;
    private DataObject myJspDataObject;
    JspServletDataObject myServletDataObject;
    private String packageName;
    private boolean enabled = true;
    private String rootDir;
    private Date initialServletDate = null;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;
    static /* synthetic */ Class class$org$netbeans$modules$web$debug$LineMangler;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    LineMangler(String className, String mangledClassName, String packageName, DataObject jspDataObject, JspServletDataObject servletDataObject) throws IOException {
        if (null == className) {
            throw new IllegalArgumentException("null == className");
        }
        if (null == mangledClassName) {
            throw new IllegalArgumentException("null == mangledClassName");
        }
        if (null == packageName) {
            throw new IllegalArgumentException("null == packageName");
        }
        if (null == jspDataObject) {
            throw new IllegalArgumentException("null = jspDataObject");
        }
        if (null == servletDataObject) {
            throw new IllegalArgumentException("null = servletDataObject");
        }
        this.className = className;
        this.packageName = packageName;
        this.mangledClassName = mangledClassName;
        this.myServletDataObject = servletDataObject;
        this.initialServletDate = this.myServletDataObject.getPrimaryFile().lastModified();
        this.setJspDataObject(jspDataObject);
        WebModuleImpl module = WebDataFactory.getFactory().findWebModule(jspDataObject.getPrimaryFile());
        WebJspImpl jspData = WebDataFactory.getFactory().getWebJsp(jspDataObject.getPrimaryFile().getPath(), (WebStandardData.WebModule)module);
        this.sourceMangler = JspCompileUtil.getCurrentCompileContext((DataObject)jspDataObject).createSourceMapper((WebStandardData.WebJsp)jspData);
        if (this.sourceMangler.isEmpty()) {
            this.sourceMangler.setPrimaryJspFileName(jspDataObject.getPrimaryFile().toString());
        }
        if (this.sourceMangler.size() == 0) {
            throw new IllegalArgumentException(" sourceMangler.size() == 0");
        }
    }

    JspSourceMapper getSourceMangler() {
        return this.sourceMangler;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMangledClassName() {
        return this.mangledClassName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean val) {
        this.enabled = val;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LineMangler)) {
            return false;
        }
        LineMangler other = (LineMangler)o;
        boolean result = (this.className == other.className || null != this.className && this.className.equals(other.className)) && (this.packageName == other.packageName || null != this.packageName && this.packageName.equals(other.packageName)) && (this.getJspDataObject() == other.getJspDataObject() || null != this.getJspDataObject() && this.getJspDataObject().equals(other.getJspDataObject()));
        return result;
    }

    private static Vector getFile(String name) throws IOException {
        String s;
        Vector<String> v = new Vector<String>();
        LineNumberReader lineReader = new LineNumberReader(new BufferedReader(new FileReader(name)));
        while (null != (s = lineReader.readLine())) {
            v.add(s);
        }
        return v;
    }

    public void print(String s) throws IOException {
        if (null == s) {
            return;
        }
        LineNumberReader lineReader = new LineNumberReader(new StringReader(s));
        while (null != (s = lineReader.readLine())) {
        }
    }

    public String toString() {
        return "----------LineMangler: enabled=" + this.isEnabled() + " sourceMangler=" + this.sourceMangler;
    }

    public int mangle(int line) {
        return this.sourceMangler.mangle(line, 1);
    }

    public int mangle(int line, int col) {
        return this.sourceMangler.mangle(line, col);
    }

    public int mangle(String jspFileName, int line, int col) {
        return this.sourceMangler.mangle(jspFileName, line, col);
    }

    public int unmangle(int line) {
        return this.sourceMangler.unmangle(line, 1);
    }

    public DataObject getJspDataObject(int javaLine) throws IOException {
        if (!this.sourceMangler.hasIncludeFiles()) {
            return this.myJspDataObject;
        }
        String jspFileName = this.sourceMangler.getJspFileName(javaLine, 1);
        FileObject fileObject = this.myJspDataObject.getPrimaryFile().getFileSystem().findResource(jspFileName);
        if (null == fileObject) {
            return null;
        }
        DataLoaderPool pool = (DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = LineMangler.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool);
        if (null == pool) {
            throw new Error("FATAL ERROR: LineMangler:: getJspDataObject(" + javaLine + "): null == dataloader");
        }
        DataObject myDataObject = pool.findDataObject(fileObject);
        if (null == myDataObject) {
            throw new Error("FATAL ERROR: LineMangler:: getJspDataObject(" + javaLine + "): null == myDataObject");
        }
        if (myDataObject instanceof HtmlDataObject) {
            return myDataObject;
        }
        if (!(myDataObject instanceof JspDataObject)) {
            return null;
        }
        return myDataObject;
    }

    public String getJavaLineType(int line) {
        return this.getJavaLineType(line, 1);
    }

    public String getJavaLineType(int line, int col) {
        return this.sourceMangler.getJavaLineType(line, col);
    }

    public boolean isJavaCodeInJspPage(int line) {
        return this.sourceMangler.isJavaCodeInJspPage(line, 1);
    }

    public boolean isJavaCodeInJspPage(int line, int col) {
        return this.sourceMangler.isJavaCodeInJspPage(line, col);
    }

    public int unmangle(String jspFileName, int line, int col) {
        return this.sourceMangler.unmangle(jspFileName, line, col);
    }

    public int unmangle(int line, int col) {
        return this.sourceMangler.unmangle(line, col);
    }

    public void setJspDataObject(DataObject d) {
        this.myJspDataObject = d;
    }

    public DataObject getJspDataObject() {
        return this.myJspDataObject;
    }

    public FileObject getJavaFileObject() throws IOException {
        if (null != this.myServletDataObject) {
            return this.myServletDataObject.getPrimaryFile();
        }
        FileObject f = this.getJspFileObject();
        FileObject dir = f.getParent();
        String javaFileName = this.mangledClassName.substring(this.packageName.length() + 1);
        FileObject javaFile = dir.getFileObject(javaFileName, "java");
        return javaFile;
    }

    public FileObject getJspFileObject() throws IOException {
        return this.getJspDataObject().getPrimaryFile();
    }

    public boolean isOutDated() throws IOException {
        return null == this.getJavaFileObject() || 0L == this.getJavaFileObject().getSize() || this.getJspFileObject().lastModified().after(this.getJavaFileObject().lastModified());
    }

    public static Vector getManglerList(DataObject dataObject) {
        Vector<LineMangler> manglerList = new Vector<LineMangler>(5);
        TreeSet<FileObject> mainPages = null;
        try {
            mainPages = IncludedPagesSupport.getIncludingPages((FileObject)dataObject.getPrimaryFile());
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            mainPages = new TreeSet<FileObject>();
        }
        mainPages.add(dataObject.getPrimaryFile());
        Iterator mainPageIterator = mainPages.iterator();
        while (mainPageIterator.hasNext()) {
            try {
                JspDataObject jspDO;
                JspServletDataObject servletDataObject;
                FileObject jspFO = (FileObject)mainPageIterator.next();
                DataObject dobj = DataObject.find((FileObject)jspFO);
                if (!(dobj instanceof JspDataObject) || (servletDataObject = (jspDO = (JspDataObject)dobj).getServletDataObject()) == null) continue;
                manglerList.add(LineMangler.getMangler(servletDataObject));
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return manglerList;
    }

    private boolean isNotUpToDate() {
        return !this.getServletDataObject().getPrimaryFile().lastModified().equals(this.initialServletDate);
    }

    public static LineMangler getMangler(JspServletDataObject servletDataObject) {
        LineMangler mangler = (LineMangler)servletDataObject.getCookie(class$org$netbeans$modules$web$debug$LineMangler == null ? (class$org$netbeans$modules$web$debug$LineMangler = LineMangler.class$("org.netbeans.modules.web.debug.LineMangler")) : class$org$netbeans$modules$web$debug$LineMangler);
        if (null == mangler || mangler.isNotUpToDate()) {
            JspDataObject jspDO;
            if (null != mangler) {
                servletDataObject.getCookieSet0().remove((Node.Cookie)mangler);
            }
            if ((jspDO = (JspDataObject)servletDataObject.getSourceJspPage()) == null) {
                return null;
            }
            if (!jspDO.isValid()) {
                return null;
            }
            String className = jspDO.getName();
            CompileData jspPlugin = jspDO.getPlugin();
            String servletFileName = jspPlugin.getCurrentServletClassName();
            if (servletFileName == null) {
                return null;
            }
            String mangledClassName = servletFileName.substring(0, servletFileName.length() - 5);
            FileObject fo = jspPlugin.getServletDirectory();
            String packageName = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getResourceName(fo, '.', false);
            try {
                mangler = new LineMangler(className, mangledClassName, packageName, (DataObject)jspDO, servletDataObject);
            }
            catch (IOException e) {
                mangler = null;
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
            servletDataObject.getCookieSet0().add((Node.Cookie)mangler);
        }
        return mangler;
    }

    public JspServletDataObject getServletDataObject() {
        return this.myServletDataObject;
    }

    private String adjustJspFileName(String jspFileName) throws IOException {
        return jspFileName;
    }

    public String[] getJspFileNames() throws IOException {
        Map jspFileNames = this.sourceMangler.getFileNames();
        String[] result = new String[jspFileNames.size()];
        int i = 0;
        Iterator iter = jspFileNames.values().iterator();
        while (iter.hasNext()) {
            String jspFileName = (String)iter.next();
            if (!this.sourceMangler.isProperJspFileName(jspFileName)) continue;
            jspFileName = this.adjustJspFileName(jspFileName);
            result[i++] = jspFileName;
        }
        return result;
    }

    public String[] getMapNames(String jspFileName) {
        Vector<String> v = new Vector<String>(3);
        Map fileNames = this.sourceMangler.getFileNames();
        Iterator iter = fileNames.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (name.indexOf(jspFileName) != 0) continue;
            v.add(name);
        }
        String[] s = new String[v.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public DataObject getJspDataObject(String jspFileName) throws IOException {
        DataObject jspDataObject = this.getJspDataObject();
        DataObject result = null;
        FileObject fileObject = jspDataObject.getPrimaryFile().getFileSystem().findResource(jspFileName);
        if (null != fileObject) {
            DataLoaderPool pool = (DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = LineMangler.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool);
            if (pool != null) {
                result = pool.findDataObject(fileObject);
            } else {
                ErrorManager.getDefault().notify((Throwable)new NullPointerException("There is no data loader pool (from lookup)!"));
            }
        }
        return result;
    }

    private Vector getSource(InputStream is) throws IOException {
        String s;
        Vector<String> v = new Vector<String>();
        LineNumberReader lineReader = new LineNumberReader(new BufferedReader(new InputStreamReader(is)));
        while (null != (s = lineReader.readLine())) {
            v.add(s);
        }
        return v;
    }

    private Vector getSource(FileObject fo) throws IOException {
        return this.getSource(fo.getInputStream());
    }

    public static Line getJspLine(Line servletLine) {
        Line.Set jspLineSet = null;
        Line jspOriginalLine = null;
        int jspUnmangledLineNumber = 0;
        try {
            LineMangler mangler = LineMangler.getMangler((JspServletDataObject)servletLine.getDataObject());
            if (mangler == null) {
                return null;
            }
            int servletLineNumber = servletLine.getLineNumber() + 1;
            jspUnmangledLineNumber = mangler.unmangle(servletLineNumber);
            DataObject jspDataObject = mangler.getJspDataObject(servletLineNumber);
            EditorCookie jspEditorCookie = (EditorCookie)jspDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = LineMangler.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            jspLineSet = jspEditorCookie.getLineSet();
            jspOriginalLine = jspLineSet.getOriginal(jspUnmangledLineNumber - 1);
            return jspOriginalLine;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            if (jspLineSet == null) {
                return null;
            }
            Line l = (Line)jspLineSet.getLines().get(jspLineSet.getLines().size() - 1);
            if (jspOriginalLine == null && jspUnmangledLineNumber > 0) {
                return l;
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            return null;
        }
        return null;
    }

    public static Line[] getServletLines(Line jspLine) {
        JspDataObject jspDataObject;
        Vector manglerList;
        if (jspLine == null) {
            return new Line[0];
        }
        ArrayList<Line> list = new ArrayList<Line>(10);
        DataObject dobj = jspLine.getDataObject();
        if (dobj instanceof JspDataObject && null != (manglerList = LineMangler.getManglerList((DataObject)(jspDataObject = (JspDataObject)dobj)))) {
            int i = 0;
            while (i < manglerList.size()) {
                try {
                    LineMangler mangler = (LineMangler)manglerList.elementAt(i);
                    int lineNumber = LineMangler.getJspReverseOriginal(jspLine.getLineNumber(), jspDataObject);
                    Line[] javaLines = LineMangler.getJavaLines(mangler, lineNumber, jspDataObject);
                    int ii = 0;
                    while (ii < javaLines.length) {
                        if (javaLines[ii] != null) {
                            list.add(javaLines[ii]);
                        }
                        ++ii;
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
                ++i;
            }
        }
        return list.toArray(new Line[list.size()]);
    }

    protected static Line[] getJavaLines(LineMangler mangler, int jspLine, JspDataObject jspDataObject) throws IOException {
        int javaLineNumber = 0;
        int jspLineNumber = 0;
        FileObject jspFileObject = jspDataObject.getPrimaryFile();
        FileObject javaFileObject = mangler.getJavaFileObject();
        DataLoaderPool pool = (DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = LineMangler.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool);
        Line[] result = null;
        if (pool != null) {
            DataObject dataobj = pool.findDataObject(javaFileObject);
            if (!(dataobj instanceof JspServletDataObject)) {
                ErrorManager.getDefault().notify(1, (Throwable)new ClassCastException("LineMangler.getJavaLines(): Not an instance of JspServletDataObject." + dataobj));
                return null;
            }
            JspServletDataObject javaDataObject = (JspServletDataObject)dataobj;
            JspDataObject mainJspPage = (JspDataObject)javaDataObject.getSourceJspPage();
            EditorCookie javaEditorCookie = mainJspPage.getServletEditor();
            Line.Set javaLineSet = javaEditorCookie.getLineSet();
            jspLineNumber = jspLine + 1;
            String[] jspMapNames = mangler.getMapNames(jspFileObject.toString());
            result = new Line[jspMapNames.length];
            int i = 0;
            while (i < jspMapNames.length) {
                javaLineNumber = mangler.mangle(jspMapNames[i], jspLineNumber, 1);
                result[i] = javaLineSet.getCurrent(javaLineNumber - 1);
                ++i;
            }
        } else {
            ErrorManager.getDefault().notify((Throwable)new NullPointerException("There is no data loader pool (from lookup)!"));
        }
        return result;
    }

    public static int getJspReverseOriginal(int num, JspDataObject dataObject) {
        StyledDocument doc;
        EditorCookie javaEditorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = LineMangler.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        try {
            doc = javaEditorCookie.openDocument();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return 1;
        }
        int numberOfLines = NbDocument.findLineRootElement((StyledDocument)doc).getElementCount();
        int originalLine = 0;
        int binDown = 0;
        int binUp = numberOfLines - 1;
        int currentPos = num;
        Line.Set lineSet = javaEditorCookie.getLineSet();
        do {
            if ((originalLine = lineSet.getOriginal(currentPos).getLineNumber()) < num) {
                binDown = currentPos;
                continue;
            }
            binUp = currentPos;
        } while (binDown != (currentPos = (binDown + binUp) / 2) && binUp != currentPos);
        int lowerOriginalLine = lineSet.getOriginal(binDown).getLineNumber();
        int upperOriginalLine = lineSet.getOriginal(binUp).getLineNumber();
        if (num <= lowerOriginalLine && num <= upperOriginalLine) {
            return binDown;
        }
        if (num >= lowerOriginalLine && num <= upperOriginalLine) {
            return binUp;
        }
        ErrorManager.getDefault().notify(4096, (Throwable)new Exception("cannot find correct line"));
        return 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

