/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.debug.LineMangler;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class ShowServlet
extends CookieAction {
    private JEditorPane myPane = null;
    private StyledDocument myDocument = null;
    private int javaLineNumber = 0;
    static /* synthetic */ Class class$org$netbeans$modules$web$debug$ShowServlet;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$JspDataObject;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$debug$ShowServlet == null ? (class$org$netbeans$modules$web$debug$ShowServlet = ShowServlet.class$("org.netbeans.modules.web.debug.ShowServlet")) : class$org$netbeans$modules$web$debug$ShowServlet)).getString("LBL_ShowServlet");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$web$debug$ShowServlet == null ? (class$org$netbeans$modules$web$debug$ShowServlet = ShowServlet.class$("org.netbeans.modules.web.debug.ShowServlet")) : class$org$netbeans$modules$web$debug$ShowServlet);
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{class$org$netbeans$modules$web$core$jsploader$JspDataObject == null ? (class$org$netbeans$modules$web$core$jsploader$JspDataObject = ShowServlet.class$("org.netbeans.modules.web.core.jsploader.JspDataObject")) : class$org$netbeans$modules$web$core$jsploader$JspDataObject};
    }

    protected boolean enable(Node[] activatedNodes) {
        if (super.enable(activatedNodes)) {
            try {
                JspDataObject jspDataObject = (JspDataObject)activatedNodes[0].getCookie(class$org$netbeans$modules$web$core$jsploader$JspDataObject == null ? (class$org$netbeans$modules$web$core$jsploader$JspDataObject = ShowServlet.class$("org.netbeans.modules.web.core.jsploader.JspDataObject")) : class$org$netbeans$modules$web$core$jsploader$JspDataObject);
                EditorCookie cook = (EditorCookie)jspDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = ShowServlet.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                JEditorPane[] panes = cook.getOpenedPanes();
                JEditorPane pane = panes[0];
                StyledDocument baseDoc = cook.getDocument();
                int dotPos = pane.getCaret().getDot();
                int lineNr = NbDocument.findLineNumber((StyledDocument)baseDoc, (int)dotPos);
                Line.Set lineSet = cook.getLineSet();
                Line jspLine = lineSet.getCurrent(lineNr);
                Line[] javaLines = LineMangler.getServletLines(jspLine);
                int ii = 0;
                while (ii < javaLines.length) {
                    if (javaLines[ii] != null) {
                        return true;
                    }
                    ++ii;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        try {
            JspDataObject jspDataObject = (JspDataObject)activatedNodes[0].getCookie(class$org$netbeans$modules$web$core$jsploader$JspDataObject == null ? (class$org$netbeans$modules$web$core$jsploader$JspDataObject = ShowServlet.class$("org.netbeans.modules.web.core.jsploader.JspDataObject")) : class$org$netbeans$modules$web$core$jsploader$JspDataObject);
            EditorCookie cook = (EditorCookie)jspDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = ShowServlet.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            JEditorPane[] panes = cook.getOpenedPanes();
            JEditorPane pane = panes[0];
            StyledDocument baseDoc = cook.getDocument();
            int dotPos = pane.getCaret().getDot();
            int lineNr = NbDocument.findLineNumber((StyledDocument)baseDoc, (int)dotPos);
            int jspLineNumber = LineMangler.getJspReverseOriginal(lineNr, jspDataObject);
            Vector manglerList = LineMangler.getManglerList((DataObject)jspDataObject);
            int i = 0;
            while (i < manglerList.size()) {
                LineMangler mangler = (LineMangler)manglerList.elementAt(i);
                Line[] javaLines = LineMangler.getJavaLines(mangler, jspLineNumber, jspDataObject);
                int ii = 0;
                while (ii < javaLines.length) {
                    this.showServlet(javaLines[ii], jspDataObject);
                    ++ii;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private void showServlet(final Line servletLine, final JspDataObject jspdo) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    EditorCookie.Observable obs = (EditorCookie.Observable)jspdo.getServletEditor();
                    JEditorPane[] panes = obs.getOpenedPanes();
                    ShowServlet.this.javaLineNumber = servletLine.getLineNumber() + 1;
                    if (panes != null) {
                        ShowServlet.this.myPane = panes[0];
                    }
                    ShowServlet.this.myDocument = obs.getDocument();
                    if (ShowServlet.this.myPane != null && ShowServlet.this.myDocument != null) {
                        ShowServlet.this.myPane.requestFocus();
                        ShowServlet.this.highlight();
                    } else {
                        obs.addPropertyChangeListener((PropertyChangeListener)new OpenedPanesListener(obs));
                        servletLine.show(2);
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        });
    }

    private void highlight() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Caret myCaret = ShowServlet.this.myPane.getCaret();
                    int offset = NbDocument.findLineOffset((StyledDocument)ShowServlet.this.myDocument, (int)(ShowServlet.this.javaLineNumber - 1));
                    int nextoffset = NbDocument.findLineOffset((StyledDocument)ShowServlet.this.myDocument, (int)ShowServlet.this.javaLineNumber);
                    myCaret.setDot(nextoffset);
                    myCaret.moveDot(offset);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OpenedPanesListener
    implements PropertyChangeListener {
        private EditorCookie.Observable edit = null;

        public OpenedPanesListener(EditorCookie.Observable ed) {
            this.edit = ed;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("openedPanes".equals(evt.getPropertyName())) {
                try {
                    JEditorPane[] panes = this.edit.getOpenedPanes();
                    if (panes == null) {
                        ShowServlet.this.myPane = null;
                        return;
                    }
                    int tryAmount = 0;
                    do {
                        ShowServlet.this.myDocument = this.edit.getDocument();
                        try {
                            Thread.sleep(tryAmount * 20);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    } while (ShowServlet.this.myDocument == null && ++tryAmount < 5);
                    ShowServlet.this.myPane = panes[0];
                    ShowServlet.this.myPane.requestFocus();
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                ShowServlet.this.highlight();
                this.edit.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

