/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.BeanEndGenerator;
import org.apache.jasper.compiler.BeanGenerator;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.DeclarationGenerator;
import org.apache.jasper.compiler.ExpressionGenerator;
import org.apache.jasper.compiler.ForwardGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.GetPropertyGenerator;
import org.apache.jasper.compiler.IncludeGenerator;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.PluginGenerator;
import org.apache.jasper.compiler.ScriptletGenerator;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SetPropertyGenerator;
import org.apache.jasper.compiler.TagBeginGenerator;
import org.apache.jasper.compiler.TagEndGenerator;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.compiler.UninterpretedTagBeginGenerator;
import org.apache.jasper.compiler.UninterpretedTagEndGenerator;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.jspparser.AnalyzerCompilerContext;
import org.netbeans.modules.web.jspparser.NullWriter;
import org.netbeans.modules.web.jspparser.WMDataCache;
import org.netbeans.modules.web.jspparser.XmlOutputter;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.xml.sax.Attributes;

public class AnalyzerParseEventListener
implements ParseEventListener {
    protected JspReader reader;
    protected ServletWriter dummyWriter;
    protected AnalyzerCompilerContext ctxt;
    ParserController parserCtl;
    String servletContentType = "text/html";
    String extendsClass = "";
    Vector interfaces = new Vector();
    Vector imports = new Vector();
    String error = "";
    boolean genSessionVariable = true;
    boolean singleThreaded = false;
    boolean autoFlush = true;
    Vector generators = new Vector();
    BeanRepository beanInfo;
    int bufferSize = 8192;
    boolean languageDir = false;
    boolean extendsDir = false;
    boolean sessionDir = false;
    boolean bufferDir = false;
    boolean threadsafeDir = false;
    boolean errorpageDir = false;
    boolean iserrorpageDir = false;
    boolean infoDir = false;
    boolean autoFlushDir = false;
    boolean contentTypeDir = false;
    TagLibraries libraries;
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;
    private XmlOutputter xo = new XmlOutputter();
    private ArrayList includedFileList;
    private ArrayList errorPageList;
    private ArrayList referencedPageList;
    private ArrayList tagLibraryDataList;
    private boolean doSave;
    private int errorReportingMode;
    private String[] includedFiles;
    private BeanDataImpl[] beans;
    private String[] errorPage;
    private String[] referencedPages;
    private TagLibraryDataImpl[] tagLibraryData;
    private boolean isErrorPage;
    static final String languageStr = "language";
    static final String extendsStr = "extends";
    static final String importStr = "import";
    static final String sessionStr = "session";
    static final String bufferStr = "buffer";
    static final String autoFlushStr = "autoFlush";
    static final String isThreadSafeStr = "isThreadSafe";
    static final String infoStr = "info";
    static final String errorPageStr = "errorPage";
    static final String isErrorPageStr = "isErrorPage";
    static final String contentTypeStr = "contentType";
    static final String pageEncodingStr = "pageEncoding";
    PageDirectiveHandlerInfo[] pdhis = new PageDirectiveHandlerInfo[]{new PageDirectiveHandlerInfo("language", new LanguageHandler()), new PageDirectiveHandlerInfo("extends", new ExtendsHandler()), new PageDirectiveHandlerInfo("import", new ImportsHandler()), new PageDirectiveHandlerInfo("session", new SessionHandler()), new PageDirectiveHandlerInfo("buffer", new BufferHandler()), new PageDirectiveHandlerInfo("autoFlush", new AutoFlushHandler()), new PageDirectiveHandlerInfo("isThreadSafe", new IsThreadSafeHandler()), new PageDirectiveHandlerInfo("info", new InfoHandler()), new PageDirectiveHandlerInfo("isErrorPage", new IsErrorPageHandler()), new PageDirectiveHandlerInfo("contentType", new ContentTypeHandler()), new PageDirectiveHandlerInfo("pageEncoding", new PageEncodingHandler()), new PageDirectiveHandlerInfo("errorPage", new ErrorPageHandler())};
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$FileDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$StaticInitializerPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$apache$jasper$compiler$BeanRepository;

    final void addGenerator(Generator gen) throws JasperException {
        gen.init(this.ctxt);
        this.generators.addElement(gen);
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setDefault(boolean isXml) {
    }

    public void setTemplateInfo(Mark start, Mark stop) {
    }

    AnalyzerParseEventListener(AnalyzerCompilerContext ctxt, boolean doSave, int errorReportingMode, ParserController parserCtl) {
        this.reader = ctxt.getReader();
        this.dummyWriter = new ServletWriter(new PrintWriter(new NullWriter()));
        this.ctxt = ctxt;
        this.parserCtl = parserCtl;
        this.beanInfo = new BeanRepository(ctxt.getClassLoader());
        this.libraries = new TagLibraries(ctxt.getClassLoader());
        this.doSave = doSave;
        this.errorReportingMode = errorReportingMode;
        this.includedFileList = new ArrayList();
        this.errorPageList = new ArrayList();
        this.referencedPageList = new ArrayList();
        this.tagLibraryDataList = new ArrayList();
    }

    public void beginPageProcessing() throws JasperException {
        int i = 0;
        while (i < Constants.STANDARD_IMPORTS.length) {
            this.imports.addElement(Constants.STANDARD_IMPORTS[i]);
            ++i;
        }
    }

    public void endPageProcessing() throws JasperException {
        this.generateHeader();
        this.generateAll(class$org$apache$jasper$compiler$ServiceMethodPhase == null ? (class$org$apache$jasper$compiler$ServiceMethodPhase = AnalyzerParseEventListener.class$("org.apache.jasper.compiler.ServiceMethodPhase")) : class$org$apache$jasper$compiler$ServiceMethodPhase);
        this.generateFooter();
        this.ctxt.setContentType(this.servletContentType);
        this.includedFiles = this.includedFileList.toArray(new String[this.includedFileList.size()]);
        this.beans = AnalyzerParseEventListener.createBeans(this.beanInfo);
        this.errorPage = this.errorPageList.toArray(new String[this.errorPageList.size()]);
        this.referencedPages = this.referencedPageList.toArray(new String[this.referencedPageList.size()]);
        this.tagLibraryData = this.tagLibraryDataList.toArray(new TagLibraryDataImpl[this.tagLibraryDataList.size()]);
        this.isErrorPage = this.ctxt.isErrorPage();
    }

    private Stack getTagHandlerStack() {
        if (this.tagHandlerStack == null) {
            this.tagHandlerStack = new Stack();
        }
        return this.tagHandlerStack;
    }

    private Hashtable getTagVarNumbers() {
        if (this.tagVarNumbers == null) {
            this.tagVarNumbers = new Hashtable();
        }
        return this.tagVarNumbers;
    }

    private void generateAll(Class phase) throws JasperException {
        int i = 0;
        while (i < this.generators.size()) {
            Generator gen = (Generator)this.generators.elementAt(i);
            if (phase.isInstance(gen)) {
                gen.generate(this.dummyWriter, phase);
            }
            ++i;
        }
    }

    private void generateHeader() throws JasperException {
        this.generateAll(class$org$apache$jasper$compiler$FileDeclarationPhase == null ? (class$org$apache$jasper$compiler$FileDeclarationPhase = AnalyzerParseEventListener.class$("org.apache.jasper.compiler.FileDeclarationPhase")) : class$org$apache$jasper$compiler$FileDeclarationPhase);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        this.generateAll(class$org$apache$jasper$compiler$ClassDeclarationPhase == null ? (class$org$apache$jasper$compiler$ClassDeclarationPhase = AnalyzerParseEventListener.class$("org.apache.jasper.compiler.ClassDeclarationPhase")) : class$org$apache$jasper$compiler$ClassDeclarationPhase);
        this.generateAll(class$org$apache$jasper$compiler$StaticInitializerPhase == null ? (class$org$apache$jasper$compiler$StaticInitializerPhase = AnalyzerParseEventListener.class$("org.apache.jasper.compiler.StaticInitializerPhase")) : class$org$apache$jasper$compiler$StaticInitializerPhase);
        this.generateAll(class$org$apache$jasper$compiler$InitMethodPhase == null ? (class$org$apache$jasper$compiler$InitMethodPhase = AnalyzerParseEventListener.class$("org.apache.jasper.compiler.InitMethodPhase")) : class$org$apache$jasper$compiler$InitMethodPhase);
    }

    private void generateFooter() throws JasperException {
    }

    public void handleComment(Mark start, Mark stop, char[] text) throws JasperException {
        Constants.message("jsp.message.htmlcomment", new Object[]{text}, 4);
    }

    public void handleDirective(String directive, Mark start, Mark stop, Attributes attrs) throws JasperException {
        Constants.message("jsp.message.handling_directive", new Object[]{directive, attrs}, 4);
        if (directive.equals("page")) {
            int attrsLength = attrs.getLength();
            int j = 0;
            while (j < attrsLength) {
                String attr = attrs.getQName(j);
                int i = 0;
                while (i < this.pdhis.length) {
                    PageDirectiveHandlerInfo pdhi = this.pdhis[i];
                    if (attr.equals(pdhi.attribute)) {
                        String value = attrs.getValue(j);
                        pdhi.handler.handlePageDirectiveAttribute(this, value, start, stop);
                    }
                    ++i;
                }
                ++j;
            }
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new CompileException(start, Constants.getString("jsp.error.page.bad_b_and_a_combo"));
        }
        if (directive.equals("taglib")) {
            String uri = attrs.getValue("uri");
            String prefix = attrs.getValue("prefix");
            this.processTaglibDirective(uri, prefix);
            this.xo.addRootNamespaces(prefix, uri);
        } else {
            if (directive.equals("include")) {
                String file = attrs.getValue("file");
                if (file == null) {
                    throw new CompileException(start, Constants.getString("jsp.error.include.missing.file"));
                }
                String absFile = this.ctxt.resolveRelativeUri(file);
                this.includedFileList.add(absFile);
                if (this.doSave) {
                    try {
                        DataObject dobj;
                        SaveCookie sc;
                        FileObject fo = this.ctxt.getResourceAsObject(file);
                        if (fo != null && (sc = (SaveCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = AnalyzerParseEventListener.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie)) != null) {
                            sc.save();
                        }
                    }
                    catch (DataObjectNotFoundException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    this.parserCtl.parse(file);
                }
                catch (FileNotFoundException ex) {
                    throw new CompileException(start, Constants.getString("jsp.error.file.not.found", new Object[]{file}));
                }
                catch (Exception ex) {
                    throw new CompileException(start, ex.getMessage());
                }
            }
            if (!directive.equals("include")) {
                this.xo.append("jsp:directive." + directive, attrs, true);
            }
        }
    }

    public void handleDeclaration(Mark start, Mark stop, Attributes attrs, char[] text) throws JasperException {
        this.addGenerator(new DeclarationGenerator(text));
        this.xo.append("jsp:declaration", attrs, text);
    }

    public void handleScriptlet(Mark start, Mark stop, Attributes attrs, char[] text) throws JasperException {
        this.addGenerator(new ScriptletGenerator(text));
        this.xo.append("jsp:scriptlet", attrs, text);
    }

    public void handleExpression(Mark start, Mark stop, Attributes attrs, char[] text) throws JasperException {
        this.addGenerator(new ExpressionGenerator(text));
        this.xo.append("jsp:expression", attrs, text);
    }

    public void handleBean(Mark start, Mark stop, Attributes attrs) throws JasperException {
        this.handleBean(start, stop, attrs, false);
    }

    public void handleBean(Mark start, Mark stop, Attributes attrs, boolean isXml) throws JasperException {
        this.addGenerator(new BeanGenerator(start, attrs, this.beanInfo, this.genSessionVariable, isXml));
        this.xo.append("jsp:useBean", attrs, false);
    }

    public void handleBeanEnd(Mark start, Mark stop, Attributes attrs) throws JasperException {
        this.addGenerator(new BeanEndGenerator());
        this.xo.append("jsp:useBean");
    }

    public void handleGetProperty(Mark start, Mark stop, Attributes attrs) throws JasperException {
        this.addGenerator(new GetPropertyGenerator(start, stop, attrs, this.beanInfo));
        this.xo.append("jsp:getProperty", attrs, true);
    }

    public void handleSetProperty(Mark start, Mark stop, Attributes attrs) throws JasperException {
        this.handleSetProperty(start, stop, attrs, false);
    }

    public void handleSetProperty(Mark start, Mark stop, Attributes attrs, boolean isXml) throws JasperException {
        this.addGenerator(new SetPropertyGenerator(start, stop, attrs, this.beanInfo, isXml));
        this.xo.append("jsp:setProperty", attrs, true);
    }

    public void handlePlugin(Mark start, Mark stop, Attributes attrs, Hashtable param, String fallback) throws JasperException {
        this.handlePlugin(start, stop, attrs, param, fallback, false);
    }

    public void handlePlugin(Mark start, Mark stop, Attributes attrs, Hashtable param, String fallback, boolean isXml) throws JasperException {
        this.addGenerator(new PluginGenerator(start, attrs, param, fallback, isXml));
    }

    public void handleForward(Mark start, Mark stop, Attributes attrs, Hashtable param) throws JasperException {
        this.handleForward(start, stop, attrs, param, false);
    }

    public void handleForward(Mark start, Mark stop, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        this.analyzerHandleIncludeForward(start, stop, attrs, param, isXml);
        this.addGenerator(new ForwardGenerator(start, attrs, param, isXml));
        this.xo.append("jsp:forward", attrs, false);
        this.xo.append("jsp:param", param);
        this.xo.append("jsp:forward");
    }

    public void handleInclude(Mark start, Mark stop, Attributes attrs, Hashtable param) throws JasperException {
        this.handleInclude(start, stop, attrs, param, false);
    }

    public void handleInclude(Mark start, Mark stop, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        this.analyzerHandleIncludeForward(start, stop, attrs, param, isXml);
        this.addGenerator(new IncludeGenerator(start, attrs, param, isXml));
        this.xo.append("jsp:include", attrs, false);
        this.xo.append("jsp:param", param);
        this.xo.append("jsp:include");
    }

    private void analyzerHandleIncludeForward(Mark start, Mark stop, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        String page = attrs.getValue("page");
        if (page == null) {
            throw new CompileException(start, Constants.getString("jsp.error.include.tag"));
        }
        boolean isExpression = JspUtil.isExpression(page, isXml);
        if (!isExpression) {
            page = this.ctxt.resolveRelativeUri(page);
            this.referencedPageList.add(page);
        } else {
            this.referencedPageList.add(page);
        }
    }

    public void handleCharData(Mark start, Mark stop, char[] chars) throws JasperException {
    }

    public void handleTagBegin(Mark start, Mark stop, Attributes attrs, String prefix, String shortTagName, TagLibraryInfo tli, TagInfo ti, boolean hasBody) throws JasperException {
        this.handleTagBegin(start, stop, attrs, prefix, shortTagName, tli, ti, hasBody, false);
    }

    public void handleTagBegin(Mark start, Mark stop, Attributes attrs, String prefix, String shortTagName, TagLibraryInfo tli, TagInfo ti, boolean hasBody, boolean isXml) throws JasperException {
        TagBeginGenerator tbg = new TagBeginGenerator(start, prefix, shortTagName, attrs, tli, ti, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers(), hasBody, isXml);
        this.addGenerator(tbg);
        this.xo.append(prefix + ":" + shortTagName, attrs, false);
    }

    public void handleTagEnd(Mark start, Mark stop, String prefix, String shortTagName, Attributes attrs, TagLibraryInfo tli, TagInfo ti, boolean hasBody) throws JasperException {
        TagEndGenerator teg = new TagEndGenerator(prefix, shortTagName, attrs, tli, ti, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers(), hasBody);
        this.addGenerator(teg);
        this.xo.append(prefix + ":" + shortTagName);
    }

    public TagLibraries getTagLibraries() {
        return this.libraries;
    }

    public void handleRootEnd() {
        this.xo.rootEnd();
    }

    public void handleRootBegin(Attributes attrs) throws JasperException {
        int attrsLength = attrs.getLength();
        int i = 0;
        while (i < attrsLength) {
            String prefix;
            String qName = attrs.getQName(i);
            if (qName.startsWith("xmlns:") && !(prefix = qName.substring(6)).equals("jsp")) {
                String uri = attrs.getValue(i);
                if (uri.startsWith("urn:jsptld:")) {
                    uri = uri.substring(11);
                }
                this.processTaglibDirective(uri, prefix);
            }
            ++i;
        }
        this.xo.addRootAttrs(attrs);
    }

    public void handleUninterpretedTagBegin(Mark start, Mark stop, String rawName, Attributes attrs) throws JasperException {
        UninterpretedTagBeginGenerator gen = new UninterpretedTagBeginGenerator(rawName, attrs);
        this.addGenerator(gen);
        this.xo.append(rawName, attrs, false);
    }

    public void handleUninterpretedTagEnd(Mark start, Mark stop, String rawName, char[] data) throws JasperException {
        if (data != null) {
            this.handleCharData(start, stop, data);
            this.xo.append(data);
        }
        UninterpretedTagEndGenerator gen = new UninterpretedTagEndGenerator(rawName);
        this.addGenerator(gen);
        this.xo.append(rawName);
    }

    public void handleJspCdata(Mark start, Mark stop, char[] data) throws JasperException {
        if (data != null) {
            this.handleCharData(start, stop, data);
            this.xo.append("jsp:text", null, data);
        }
    }

    public void validate() throws JasperException {
        StringBuffer errMessage = new StringBuffer();
        Enumeration enumeration = this.libraries.getTagLibInfos();
        boolean hasErrors = false;
        while (enumeration.hasMoreElements()) {
            TagLibraryInfo tli = (TagLibraryInfo)enumeration.nextElement();
            ValidationMessage[] errors = ((TagLibraryInfoImpl)tli).validate(this.xo.getPageData());
            if (errors == null || errors.length == 0) continue;
            hasErrors = true;
            errMessage.append("<h3>");
            errMessage.append(Constants.getString("jsp.error.taglibraryvalidator.invalidpage", new Object[]{tli.getShortName()}));
            errMessage.append("</h3>");
            int i = 0;
            while (i < errors.length) {
                String id = errors[i].getId();
                if (id != null) {
                    errMessage.append(errors[i].getId());
                    errMessage.append(": ");
                }
                errMessage.append(errors[i].getMessage());
                ++i;
            }
        }
        if (hasErrors) {
            throw new JasperException(errMessage.toString());
        }
    }

    private void processTaglibDirective(String uri, String prefix) throws JasperException {
        TagLibraryInfoImpl tl = null;
        String[] location = this.ctxt.getTldLocation(uri);
        if (location == null) {
            int uriType = TldLocationsCache.uriType(uri);
            if (uriType == 0) {
                throw new JasperException(Constants.getString("jsp.error.taglibDirective.absUriCannotBeResolved", new Object[]{uri}));
            }
            if (uriType == 2) {
                uri = this.ctxt.resolveRelativeUri(uri);
            }
            location = new String[2];
            location[0] = uri;
            if (uri.endsWith("jar")) {
                location[1] = "META-INF/taglib.tld";
            }
        }
        FileObject wm = this.ctxt.cd.getResourceAsObject("/");
        tl = WMDataCache.getDefault().getTagLibraryInfoImpl(wm, this.ctxt, prefix, uri, location);
        if (tl == null) {
            tl = new TagLibraryInfoImpl(this.ctxt, prefix, uri, location);
        }
        this.libraries.addTagLibrary(prefix, tl);
        this.tagLibraryDataList.add(new TagLibraryDataImpl(prefix, uri, location[0], location[1], tl));
    }

    public JspInfo getJspInfo() {
        return new JspInfo(){

            public String[] getIncludedFiles() {
                return AnalyzerParseEventListener.this.includedFiles;
            }

            public JspInfo.BeanData[] getBeans() {
                return AnalyzerParseEventListener.this.beans;
            }

            public String[] getErrorPage() {
                return AnalyzerParseEventListener.this.errorPage;
            }

            public String[] getReferencedPages() {
                return AnalyzerParseEventListener.this.referencedPages;
            }

            public JspInfo.TagLibraryData[] getTagLibraryData() {
                return AnalyzerParseEventListener.this.tagLibraryData;
            }

            public boolean isErrorPage() {
                return AnalyzerParseEventListener.this.isErrorPage;
            }
        };
    }

    private static BeanDataImpl[] createBeans(BeanRepository beans) {
        ArrayList beanList = new ArrayList();
        try {
            Field btField = (class$org$apache$jasper$compiler$BeanRepository == null ? (class$org$apache$jasper$compiler$BeanRepository = AnalyzerParseEventListener.class$("org.apache.jasper.compiler.BeanRepository")) : class$org$apache$jasper$compiler$BeanRepository).getDeclaredField("beanTypes");
            ((AccessibleObject)btField).setAccessible(true);
            Hashtable beanTypes = (Hashtable)btField.get(beans);
            AnalyzerParseEventListener.processBeanEnumeration(beanList, 4, beans.getApplicationBeans(), beanTypes);
            AnalyzerParseEventListener.processBeanEnumeration(beanList, 1, beans.getPageBeans(), beanTypes);
            AnalyzerParseEventListener.processBeanEnumeration(beanList, 2, beans.getRequestBeans(), beanTypes);
            AnalyzerParseEventListener.processBeanEnumeration(beanList, 3, beans.getSessionBeans(), beanTypes);
        }
        catch (NoSuchFieldException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return beanList.toArray(new BeanDataImpl[beanList.size()]);
    }

    private static void processBeanEnumeration(ArrayList beanList, int scopeInt, Enumeration beanNames, Hashtable beanTypes) {
        while (beanNames.hasMoreElements()) {
            String name = (String)beanNames.nextElement();
            beanList.add(new BeanDataImpl(name, scopeInt, (String)beanTypes.get(name)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TagLibraryDataImpl
    implements JspInfo.TagLibraryData {
        String prefix;
        String unresolvedURI;
        String resolvedURI;
        String resolvedURIWithinJar;
        TagLibraryInfo tagLib;

        public TagLibraryDataImpl(String prefix, String unresolvedURI, String resolvedURI, String resolvedURIWithinJar, TagLibraryInfo tagLib) {
            this.prefix = prefix;
            this.unresolvedURI = unresolvedURI;
            this.resolvedURI = resolvedURI;
            this.resolvedURIWithinJar = resolvedURIWithinJar;
            this.tagLib = tagLib;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUnresolvedURI() {
            return this.unresolvedURI;
        }

        public String getResolvedURI() {
            return this.resolvedURI;
        }

        public String getResolvedURIWithinJar() {
            return this.resolvedURIWithinJar;
        }

        public TagLibraryInfo getTagLibraryInfo() {
            return this.tagLib;
        }
    }

    static class BeanDataImpl
    implements JspInfo.BeanData {
        String id;
        int scope;
        String className;

        public BeanDataImpl(String id, int scope, String className) {
            this.id = id;
            this.scope = scope;
            this.className = className;
        }

        public String getId() {
            return this.id;
        }

        public int getScope() {
            return this.scope;
        }

        public String getClassName() {
            return this.className;
        }
    }

    static final class ExtendsHandler
    implements PageDirectiveHandler {
        ExtendsHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String extendsClzz, Mark start, Mark stop) throws JasperException {
            if (listener.extendsDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.extends"));
            }
            listener.extendsDir = true;
            if (extendsClzz != null) {
                listener.extendsClass = extendsClzz;
                if (extendsClzz.indexOf(".") == -1) {
                    listener.imports.addElement(extendsClzz);
                }
            }
        }
    }

    static final class ImportsHandler
    implements PageDirectiveHandler {
        ImportsHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String importPkgs, Mark start, Mark stop) throws JasperException {
            if (importPkgs != null) {
                StringTokenizer tokenizer = new StringTokenizer(importPkgs, ",");
                while (tokenizer.hasMoreTokens()) {
                    listener.imports.addElement(tokenizer.nextToken());
                }
            }
        }
    }

    static final class LanguageHandler
    implements PageDirectiveHandler {
        LanguageHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String language, Mark start, Mark stop) throws JasperException {
            if (listener.languageDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.language"));
            }
            listener.languageDir = true;
            if (language != null && !language.equalsIgnoreCase("java")) {
                throw new CompileException(start, Constants.getString("jsp.error.page.nomapping.language") + language);
            }
        }
    }

    static final class ErrorPageHandler
    implements PageDirectiveHandler {
        ErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String errorpage, Mark start, Mark stop) throws JasperException {
            if (listener.errorpageDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.errorpage"));
            }
            listener.errorpageDir = true;
            if (errorpage != null) {
                listener.error = errorpage;
            }
            if (errorpage != null) {
                String absolute = listener.ctxt.resolveRelativeUri(errorpage);
                listener.errorPageList.add(absolute);
            }
        }
    }

    static final class IsErrorPageHandler
    implements PageDirectiveHandler {
        IsErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String iserrorpage, Mark start, Mark stop) throws JasperException {
            if (listener.iserrorpageDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.iserrorpage"));
            }
            listener.iserrorpageDir = true;
            if (iserrorpage == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
            if (iserrorpage.equalsIgnoreCase("true")) {
                listener.ctxt.setErrorPage(true);
            } else if (iserrorpage.equalsIgnoreCase("false")) {
                listener.ctxt.setErrorPage(false);
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
        }
    }

    static final class InfoHandler
    implements PageDirectiveHandler {
        InfoHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String info, Mark start, Mark stop) throws JasperException {
            if (listener.infoDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.info"));
            }
            listener.infoDir = true;
            if (info == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.info"));
            }
        }
    }

    static final class IsThreadSafeHandler
    implements PageDirectiveHandler {
        IsThreadSafeHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String threadsafe, Mark start, Mark stop) throws JasperException {
            if (listener.threadsafeDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.threadsafe"));
            }
            listener.threadsafeDir = true;
            if (threadsafe == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
            if (threadsafe.equalsIgnoreCase("true")) {
                listener.singleThreaded = false;
            } else if (threadsafe.equalsIgnoreCase("false")) {
                listener.singleThreaded = true;
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
        }
    }

    static final class AutoFlushHandler
    implements PageDirectiveHandler {
        AutoFlushHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String autoflush, Mark start, Mark stop) throws JasperException {
            if (listener.autoFlushDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.autoflush"));
            }
            listener.autoFlushDir = true;
            if (autoflush == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
            if (autoflush.equalsIgnoreCase("true")) {
                listener.autoFlush = true;
            } else if (autoflush.equalsIgnoreCase("false")) {
                listener.autoFlush = false;
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
        }
    }

    static final class BufferHandler
    implements PageDirectiveHandler {
        BufferHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String buffer, Mark start, Mark stop) throws JasperException {
            if (listener.bufferDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.buffer"));
            }
            listener.bufferDir = true;
            if (buffer != null) {
                if (buffer.equalsIgnoreCase("none")) {
                    listener.bufferSize = 0;
                } else {
                    Integer i = null;
                    try {
                        int ind = buffer.indexOf("k");
                        String num = ind == -1 ? buffer : buffer.substring(0, ind);
                        i = new Integer(num);
                    }
                    catch (NumberFormatException n) {
                        throw new CompileException(start, Constants.getString("jsp.error.page.invalid.buffer"));
                    }
                    listener.bufferSize = i * 1024;
                }
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.buffer"));
            }
        }
    }

    static final class SessionHandler
    implements PageDirectiveHandler {
        SessionHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String session, Mark start, Mark stop) throws JasperException {
            if (listener.sessionDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.session"));
            }
            listener.sessionDir = true;
            if (session == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.session"));
            }
            if (session.equalsIgnoreCase("true")) {
                listener.genSessionVariable = true;
            } else if (session.equalsIgnoreCase("false")) {
                listener.genSessionVariable = false;
            } else {
                throw new CompileException(start, "Invalid value for session");
            }
        }
    }

    static final class PageEncodingHandler
    implements PageDirectiveHandler {
        PageEncodingHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String pageEncoding, Mark start, Mark stop) throws JasperException {
            if (pageEncoding == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.pageencoding"));
            }
        }
    }

    static final class ContentTypeHandler
    implements PageDirectiveHandler {
        ContentTypeHandler() {
        }

        public void handlePageDirectiveAttribute(AnalyzerParseEventListener listener, String contentType, Mark start, Mark stop) throws JasperException {
            if (listener.contentTypeDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.contenttypes"));
            }
            listener.contentTypeDir = true;
            if (contentType == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.contenttype"));
            }
            listener.servletContentType = contentType;
        }
    }

    static final class PageDirectiveHandlerInfo {
        String attribute;
        PageDirectiveHandler handler;

        PageDirectiveHandlerInfo(String attribute, PageDirectiveHandler handler) {
            this.attribute = attribute;
            this.handler = handler;
        }
    }

    static interface PageDirectiveHandler {
        public void handlePageDirectiveAttribute(AnalyzerParseEventListener var1, String var2, Mark var3, Mark var4) throws JasperException;
    }
}

