/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.util.TreeMap;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.modules.web.jspparser.AnalyzerParseEventListener;
import org.openide.ErrorManager;

public class TagLibDataImpl
extends TagLibParseSupport.TagLibData {
    private String prefix;
    private TagLibraryInfo tagLibraryInfo;
    private TreeMap tagMap = new TreeMap();

    public TagLibDataImpl(JspInfo.TagLibraryData info) {
        this.prefix = info.getPrefix();
        this.tagLibraryInfo = info instanceof AnalyzerParseEventListener.TagLibraryDataImpl ? ((AnalyzerParseEventListener.TagLibraryDataImpl)info).getTagLibraryInfo() : null;
        this.createTagMap();
    }

    private void createTagMap() {
        if (this.tagLibraryInfo != null) {
            TagInfo[] tagInfo = this.tagLibraryInfo.getTags();
            if (tagInfo == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException(this.tagLibraryInfo.getURI()));
                return;
            }
            int i = 0;
            while (i < tagInfo.length) {
                if (tagInfo[i] != null) {
                    String name = tagInfo[i].getTagName();
                    this.tagMap.put(name, new TagData(name, tagInfo[i].getBodyContent()));
                } else {
                    ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException(this.tagLibraryInfo.toString()));
                }
                ++i;
            }
        }
    }

    public boolean equalsColoringInformation(TagLibParseSupport.TagLibData other) {
        TagData[] otherTagData;
        if (!(other instanceof TagLibDataImpl)) {
            return false;
        }
        TagLibDataImpl otherImpl = (TagLibDataImpl)other;
        if (!this.prefix.equals(otherImpl.prefix)) {
            return false;
        }
        TagData[] myTagData = this.getTagData();
        if (myTagData.length != (otherTagData = otherImpl.getTagData()).length) {
            return false;
        }
        int i = 0;
        while (i < myTagData.length) {
            if (!myTagData[i].equalsColoringInformation(otherTagData[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TagData[] getTagData() {
        return this.tagMap.values().toArray(new TagData[this.tagMap.size()]);
    }

    public TagData getTagData(String tagName) {
        return (TagData)this.tagMap.get(tagName);
    }

    public Object getTagLibraryInfo() {
        return this.tagLibraryInfo;
    }

    public static class TagData {
        private String tagName;
        private String bodyContent;

        public TagData(String tagName, String bodyContent) {
            this.tagName = tagName;
            this.bodyContent = bodyContent;
        }

        boolean equalsColoringInformation(TagData other) {
            return this.tagName.equals(other.tagName) && this.bodyContent.equals(other.bodyContent);
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getBodyContent() {
            return this.bodyContent;
        }
    }
}

