/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.TldLocationsCache;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public class WMDataCache {
    private static WMDataCache instance;
    private static boolean debug;
    private WeakHashMap tldLocationsCaches = new WeakHashMap();
    private WeakHashMap tagLibraryInfoImplCaches = new WeakHashMap();
    static /* synthetic */ Class class$org$netbeans$modules$web$jspparser$WMDataCache;

    private WMDataCache() {
    }

    public static WMDataCache getDefault() {
        Class clazz = class$org$netbeans$modules$web$jspparser$WMDataCache == null ? (class$org$netbeans$modules$web$jspparser$WMDataCache = WMDataCache.class$("org.netbeans.modules.web.jspparser.WMDataCache")) : class$org$netbeans$modules$web$jspparser$WMDataCache;
        synchronized (clazz) {
            if (instance == null) {
                instance = new WMDataCache();
            }
            WMDataCache wMDataCache = instance;
            return wMDataCache;
        }
    }

    public synchronized TldLocationsCache getTldLocationsCache(FileObject wm, ServletContext sc) {
        TldLocationsCacheEntry en = (TldLocationsCacheEntry)this.tldLocationsCaches.get(wm);
        if (en == null) {
            if (debug) {
                System.out.println("[jp] creating NEW TldLocationsCacheEntry");
            }
            en = new TldLocationsCacheEntry();
            en.wm = wm;
            en.timestamp = this.getHihgestTimeStampForWM(wm);
            en.tlc = new TldLocationsCache(sc);
            this.tldLocationsCaches.put(wm, en);
        } else {
            long timestamp = this.getHihgestTimeStampForWM(wm);
            if (timestamp > en.timestamp) {
                if (debug) {
                    System.out.println("[jp] updating EXISTING TldLocationsCacheEntry");
                }
                en.timestamp = timestamp;
                en.tlc = new TldLocationsCache(sc);
            } else if (debug) {
                System.out.println("[jp] reusing EXISTING TldLocationsCacheEntry AS IS");
            }
        }
        return en.tlc;
    }

    public synchronized TagLibraryInfoImpl getTagLibraryInfoImpl(FileObject wm, JspCompilationContext ctxt, String prefix, String uriIn, String[] location) throws JasperException {
        try {
            TLIIKey key = new TLIIKey(wm, prefix, uriIn, location);
            TLIIEntry en = (TLIIEntry)this.tagLibraryInfoImplCaches.get(key);
            if (en == null) {
                if (debug) {
                    System.out.println("[jp] creating NEW TLIIEntry");
                }
                en = new TLIIEntry();
                en.key = key;
                FileObject taglib = this.getFileObjectForTLII(key);
                if (taglib == null) {
                    return null;
                }
                en.timestamp = taglib.lastModified().getTime();
                en.tlii = new TagLibraryInfoImpl(ctxt, prefix, uriIn, location);
                this.tagLibraryInfoImplCaches.put(key, en);
            } else {
                FileObject taglib = this.getFileObjectForTLII(key);
                if (taglib == null) {
                    this.tagLibraryInfoImplCaches.remove(key);
                    return null;
                }
                long timestamp = taglib.lastModified().getTime();
                if (timestamp > en.timestamp) {
                    if (debug) {
                        System.out.println("[jp] updating EXISTING TLIIEntry");
                    }
                    en.timestamp = timestamp;
                    en.tlii = new TagLibraryInfoImpl(ctxt, prefix, uriIn, location);
                } else if (debug) {
                    System.out.println("[jp] reusing EXISTING TLIIEntry AS IS");
                }
            }
            return en.tlii;
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return new TagLibraryInfoImpl(ctxt, prefix, uriIn, location);
        }
    }

    private long getHihgestTimeStampForWM(FileObject wm) {
        long highest = wm.lastModified().getTime();
        try {
            FileObject lib;
            FileObject webxml = JspCompileUtil.findRelativeResource((FileObject)wm, (String)"WEB-INF/web.xml");
            if (webxml != null) {
                highest = Math.max(webxml.lastModified().getTime(), highest);
            }
            if ((lib = JspCompileUtil.findRelativeResource((FileObject)wm, (String)"WEB-INF/lib")) != null) {
                highest = Math.max(lib.lastModified().getTime(), highest);
                FileObject[] libs = lib.getChildren();
                int i = 0;
                while (i < libs.length) {
                    highest = Math.max(libs[i].lastModified().getTime(), highest);
                    ++i;
                }
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return highest;
    }

    private FileObject getFileObjectForTLII(TLIIKey key) throws FileStateInvalidException {
        if (key.location == null || key.location[0] == null) {
            throw new IllegalArgumentException();
        }
        String fileLoc = key.location[0];
        if (fileLoc.startsWith("/")) {
            fileLoc = fileLoc.substring(1);
        }
        FileObject taglib = JspCompileUtil.findRelativeResource((FileObject)key.wm, (String)fileLoc);
        return taglib;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        debug = false;
    }

    private static class TLIIEntry {
        TLIIKey key;
        long timestamp;
        TagLibraryInfoImpl tlii;

        TLIIEntry() {
        }
    }

    private static class TLIIKey {
        FileObject wm;
        String prefix;
        String uriIn;
        String[] location;

        TLIIKey(FileObject wm, String prefix, String uriIn, String[] location) {
            this.wm = wm;
            this.prefix = prefix;
            this.uriIn = uriIn;
            this.location = location;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TLIIKey)) {
                return false;
            }
            TLIIKey key2 = (TLIIKey)o;
            if (!this.wm.equals(key2.wm)) {
                return false;
            }
            if (!this.prefix.equals(key2.prefix)) {
                return false;
            }
            if (!this.uriIn.equals(key2.uriIn)) {
                return false;
            }
            if (this.location == null || key2.location == null) {
                return false;
            }
            if (this.location[0] != null ? !this.location[0].equals(key2.location[0]) : key2.location[0] != null) {
                return false;
            }
            return !(this.location[1] != null ? !this.location[1].equals(key2.location[1]) : key2.location[1] != null);
        }

        public int hashCode() {
            return this.wm.hashCode() + this.prefix.hashCode() + this.uriIn.hashCode();
        }
    }

    private static class TldLocationsCacheEntry {
        FileObject wm;
        long timestamp;
        TldLocationsCache tlc;

        TldLocationsCacheEntry() {
        }
    }
}

