/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.Utilities;
import org.openide.ErrorManager;
import org.openide.text.Annotation;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;

public class NbEditorDocument
extends GuardedDocument
implements NbDocument.PositionBiasable,
NbDocument.WriteLockable,
NbDocument.Printable,
NbDocument.CustomEditor,
NbDocument.Annotatable {
    public static final String FORMATTER = "formatter";
    public static final String MIME_TYPE_PROP = "mimeType";
    public static final String INDENT_ENGINE = "indentEngine";
    private Formatter formatter;
    private HashMap annoMap;

    public NbEditorDocument(Class kitClass) {
        super(kitClass);
        this.addStyleToLayerMapping("NbBreakpointStyle", "NbBreakpointStyleLayer:10");
        this.addStyleToLayerMapping("NbErrorStyle", "NbErrorStyleLayer:20");
        this.addStyleToLayerMapping("NbCurrentStyle", "NbCurrentStyleLayer:30");
        this.setNormalStyleName("NbNormalStyle");
        this.annoMap = new HashMap(20);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        super.settingsChange(evt);
        Object o = this.getProperty(MIME_TYPE_PROP);
        if (!(o instanceof String)) {
            BaseKit kit = BaseKit.getKit(this.getKitClass());
            this.putProperty(MIME_TYPE_PROP, kit.getContentType());
        }
        this.putProperty(INDENT_ENGINE, new BaseDocument.PropertyEvaluator(){
            private Object cached;

            public Object getValue() {
                if (this.cached == null) {
                    this.cached = Settings.getValue(NbEditorDocument.this.getKitClass(), NbEditorDocument.INDENT_ENGINE);
                }
                return this.cached;
            }
        });
        this.formatter = null;
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        if (s != null) {
            Object val = s.getAttribute(NbDocument.GUARDED);
            if (val != null && val instanceof Boolean) {
                if (((Boolean)val).booleanValue()) {
                    super.setCharacterAttributes(offset, length, GuardedDocument.guardedSet, replace);
                } else {
                    super.setCharacterAttributes(offset, length, GuardedDocument.unguardedSet, replace);
                }
            } else {
                super.setCharacterAttributes(offset, length, s, replace);
            }
        }
    }

    public AttributedCharacterIterator[] createPrintIterators() {
        NbPrintContainer npc = new NbPrintContainer();
        this.print(npc);
        return npc.getIterators();
    }

    public Component createEditor(JEditorPane j) {
        return Utilities.getEditorUI(j).getExtComponent();
    }

    public Formatter getFormatter() {
        Formatter f = this.formatter;
        if (f == null) {
            f = this.formatter = (Formatter)Settings.getValue(this.getKitClass(), FORMATTER);
        }
        return f != null ? f : super.getFormatter();
    }

    public void addAnnotation(Position startPos, int length, Annotation annotation) {
        if (annotation.getAnnotationType() != null) {
            AnnotationDescDelegate a = new AnnotationDescDelegate(this, startPos, length, annotation);
            this.annoMap.put(annotation, a);
            this.getAnnotations().addAnnotation(a);
        }
    }

    public void removeAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        if (annotation.getAnnotationType() != null) {
            AnnotationDescDelegate a = (AnnotationDescDelegate)this.annoMap.get(annotation);
            try {
                a.detachListeners();
            }
            catch (NullPointerException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, 1, "Editor module received request to remove annotation which does not exist in the document. Cause of this error is either in OpenIDE module or in module which originated the annotation. Annotation class = " + annotation, null, null, null);
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return;
            }
            this.getAnnotations().removeAnnotation(a);
            this.annoMap.remove(annotation);
        }
    }

    class NbPrintContainer
    extends AttributedCharacters
    implements PrintContainer {
        ArrayList acl = new ArrayList();
        AttributedCharacters a = new AttributedCharacters();

        NbPrintContainer() {
        }

        public void add(char[] chars, Font font, Color foreColor, Color backColor) {
            this.a.append(chars, font, foreColor);
        }

        public void eol() {
            this.acl.add(this.a);
            this.a = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return true;
        }

        public AttributedCharacterIterator[] getIterators() {
            int cnt = this.acl.size();
            AttributedCharacterIterator[] acis = new AttributedCharacterIterator[cnt];
            int i = 0;
            while (i < cnt) {
                AttributedCharacters ac = (AttributedCharacters)this.acl.get(i);
                acis[i] = ac.iterator();
                ++i;
            }
            return acis;
        }
    }

    static class AnnotationDescDelegate
    extends AnnotationDesc {
        private Annotation delegate;
        private PropertyChangeListener l;
        private Position pos;
        private BaseDocument doc;

        AnnotationDescDelegate(BaseDocument doc, Position pos, int length, Annotation anno) {
            super(pos.getOffset(), length);
            this.pos = pos;
            this.delegate = anno;
            this.doc = doc;
            this.updateAnnotationType();
            this.l = new PropertyChangeListener(this){
                private final /* synthetic */ AnnotationDescDelegate this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "shortDescription") {
                        AnnotationDescDelegate.access$001(this.this$0, "shortDescription", null, null);
                    }
                    if (evt.getPropertyName() == "moveToFront") {
                        AnnotationDescDelegate.access$101(this.this$0, "moveToFront", null, null);
                    }
                    if (evt.getPropertyName() == "annotationType") {
                        this.this$0.updateAnnotationType();
                        AnnotationDescDelegate.access$201(this.this$0, "annotationType", null, null);
                    }
                }
            };
            this.delegate.addPropertyChangeListener(this.l);
        }

        public String getAnnotationType() {
            return this.delegate.getAnnotationType();
        }

        public String getShortDescription() {
            return this.delegate.getShortDescription();
        }

        void detachListeners() {
            this.delegate.removePropertyChangeListener(this.l);
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public int getLine() {
            try {
                return Utilities.getLineOffset(this.doc, this.pos.getOffset());
            }
            catch (BadLocationException e) {
                return 0;
            }
        }

        static /* synthetic */ void access$001(AnnotationDescDelegate x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ void access$101(AnnotationDescDelegate x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ void access$201(AnnotationDescDelegate x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }
    }
}

