/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Bookmarks;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.EditorModule;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.NbToolTip;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.actions.RedoAction;
import org.openide.actions.UndoAction;
import org.openide.awt.JPopupMenuPlus;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorKit
extends ExtKit {
    public static final String SYSTEM_ACTION_CLASS_NAME_PROPERTY = "systemActionClassName";
    public static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    static final long serialVersionUID = 4482122073483644089L;
    private static final Map contentTypeTable = new HashMap();
    public static final String generateGoToPopupAction = "generate-goto-popup";
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$openide$actions$ReplaceAction;
    static /* synthetic */ Class class$org$openide$actions$GotoAction;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public NbEditorKit() {
        EditorModule.init();
        AllOptionsFolder.getDefault().loadMIMEOption(this.getClass());
    }

    public Document createDefaultDocument() {
        return new NbEditorDocument(this.getClass());
    }

    protected EditorUI createEditorUI() {
        return new NbEditorUI();
    }

    protected Action[] createActions() {
        Action[] nbEditorActions = new Action[]{new NbBuildPopupMenuAction(), new NbStopMacroRecordingAction(), new NbUndoAction(), new NbRedoAction(), new NbToggleBookmarkAction(), new NbGotoNextBookmarkAction("bookmark-next", false), new NbBuildToolTipAction(), new NbToggleLineNumbersAction(), new ToggleToolbarAction(), new NbGenerateGoToPopupAction()};
        return TextAction.augmentList(super.createActions(), nbEditorActions);
    }

    protected void addSystemActionMapping(String editorActionName, Class systemActionClass) {
        Action a = this.getActionByName(editorActionName);
        if (a != null) {
            a.putValue(SYSTEM_ACTION_CLASS_NAME_PROPERTY, systemActionClass.getName());
        }
    }

    protected void updateActions() {
        this.addSystemActionMapping("cut-to-clipboard", class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = NbEditorKit.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction);
        this.addSystemActionMapping("copy-to-clipboard", class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = NbEditorKit.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction);
        this.addSystemActionMapping("paste-from-clipboard", class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = NbEditorKit.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        this.addSystemActionMapping("remove-selection", class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = NbEditorKit.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction);
        this.addSystemActionMapping("find", class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = NbEditorKit.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction);
        this.addSystemActionMapping("replace", class$org$openide$actions$ReplaceAction == null ? (class$org$openide$actions$ReplaceAction = NbEditorKit.class$("org.openide.actions.ReplaceAction")) : class$org$openide$actions$ReplaceAction);
        this.addSystemActionMapping("goto", class$org$openide$actions$GotoAction == null ? (class$org$openide$actions$GotoAction = NbEditorKit.class$("org.openide.actions.GotoAction")) : class$org$openide$actions$GotoAction);
    }

    public Class getFocusableComponentClass(JTextComponent c) {
        return class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbEditorKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent;
    }

    public String getContentType() {
        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            System.out.println("Warning: KitClass " + this.getClass().getName() + " doesn't override the method getContentType.");
        }
        return contentTypeTable.containsKey(this.getClass().getName()) ? (String)contentTypeTable.get(this.getClass().getName()) : "text/" + this.getClass().getName().replace('.', '_');
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        contentTypeTable.put("org.netbeans.modules.properties.syntax.PropertiesKit", "text/x-properties");
        contentTypeTable.put("org.netbeans.modules.web.core.syntax.JSPKit", "text/x-jsp");
        contentTypeTable.put("org.netbeans.modules.css.text.syntax.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.css.editor.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.DTDKit", "text/x-dtd");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.XMLKit", "text/xml");
        contentTypeTable.put("org.netbeans.modules.corba.idl.editor.coloring.IDLKit", "text/x-idl");
    }

    public static class NbBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                NbToolTip.buildToolTip(target);
            }
        }
    }

    public static class NbGenerateGoToPopupAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit;

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = NbGenerateGoToPopupAction.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit)).getString(NbEditorKit.generateGoToPopupAction);
        }

        public NbGenerateGoToPopupAction() {
            super(NbEditorKit.generateGoToPopupAction);
            String desc = this.getShortDescription();
            if (desc != null) {
                this.putValue("ShortDescription", desc);
            }
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class Bookmark
    implements Bookmarks.Bookmark {
        private Annotation anno;

        public Bookmark(Annotation anno) {
            this.anno = anno;
        }

        public int getLine() {
            return ((Line)this.anno.getAttachedAnnotatable()).getLineNumber();
        }

        public Annotation getAnno() {
            return this.anno;
        }

        public void remove() {
            this.anno.detach();
            this.anno = null;
        }
    }

    private static class BookmarkAnnotation
    extends Annotation {
        static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit;

        private BookmarkAnnotation() {
        }

        public String getAnnotationType() {
            return NbEditorKit.BOOKMARK_ANNOTATION_TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = BookmarkAnnotation.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit)).getString("Bookmark_Tooltip");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public class NbToggleLineNumbersAction
    extends ActionFactory.ToggleLineNumbersAction {
        private BaseOptions bo;
        private boolean lineNumbersVisible = false;

        public NbToggleLineNumbersAction() {
            this.bo = BaseOptions.getOptions(NbEditorKit.this.getClass());
        }

        protected boolean isLineNumbersVisible() {
            return this.bo != null ? this.bo.getLineNumberVisible() : this.lineNumbersVisible;
        }

        protected void toggleLineNumbers() {
            if (this.bo != null) {
                this.bo.setLineNumberVisible(!this.isLineNumbersVisible());
            } else {
                this.lineNumbersVisible = !this.lineNumbersVisible;
            }
        }
    }

    public static class NbGotoNextBookmarkAction
    extends ActionFactory.GotoNextBookmarkAction {
        static final long serialVersionUID = -6305740718286540539L;

        public NbGotoNextBookmarkAction() {
            super(null, false);
        }

        public NbGotoNextBookmarkAction(String nm, boolean select) {
            super(nm, select);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null) {
                return;
            }
            BaseDocument doc = (BaseDocument)target.getDocument();
            Caret caret = target.getCaret();
            if (Utilities.getEditorUI(target) == null || !Utilities.getEditorUI(target).isGlyphGutterVisible()) {
                target.getToolkit().beep();
                return;
            }
            int line = 0;
            try {
                line = Utilities.getLineOffset(doc, caret.getDot());
            }
            catch (BadLocationException e) {
                target.getToolkit().beep();
                return;
            }
            Bookmarks bookmarks = doc.getBookmarks();
            Bookmark bookmark = (Bookmark)bookmarks.getNextLineBookmark(line + 1);
            if (bookmark == null) {
                bookmark = (Bookmark)bookmarks.getNextLineBookmark(0);
            }
            if (bookmark == null) {
                return;
            }
            Annotation anno = bookmark.getAnno();
            anno.moveToFront();
            ((Line)anno.getAttachedAnnotatable()).show(2);
        }
    }

    public static class NbToggleBookmarkAction
    extends ActionFactory.ToggleBookmarkAction {
        static final long serialVersionUID = 8870696224845563318L;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null) {
                return;
            }
            BaseDocument doc = (BaseDocument)target.getDocument();
            Caret caret = target.getCaret();
            if (Utilities.getEditorUI(target) == null || !Utilities.getEditorUI(target).isGlyphGutterVisible()) {
                target.getToolkit().beep();
                return;
            }
            int line = 0;
            try {
                line = Utilities.getLineOffset(doc, caret.getDot());
            }
            catch (BadLocationException e) {
                target.getToolkit().beep();
                return;
            }
            Bookmarks bookmarks = doc.getBookmarks();
            Annotation anno = null;
            Bookmark bookmark = (Bookmark)bookmarks.getBookmark(line);
            if (bookmark != null) {
                anno = bookmark.getAnno();
            }
            if (anno == null) {
                anno = new BookmarkAnnotation();
                Line lineObj = NbEditorUtilities.getLine(doc, caret.getDot(), false);
                if (lineObj == null) {
                    target.getToolkit().beep();
                    return;
                }
                anno.attach((Annotatable)lineObj);
                bookmarks.putBookmark(new Bookmark(anno));
            } else {
                anno.detach();
                bookmarks.removeBookmark(bookmark);
            }
        }
    }

    public static class NbRedoAction
    extends ActionFactory.RedoAction {
        static /* synthetic */ Class class$org$openide$actions$RedoAction;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            RedoAction ra = (RedoAction)SystemAction.get((Class)(class$org$openide$actions$RedoAction == null ? (class$org$openide$actions$RedoAction = NbRedoAction.class$("org.openide.actions.RedoAction")) : class$org$openide$actions$RedoAction));
            if (ra != null && ra.isEnabled()) {
                ra.actionPerformed(evt);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class NbUndoAction
    extends ActionFactory.UndoAction {
        static /* synthetic */ Class class$org$openide$actions$UndoAction;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            UndoAction ua = (UndoAction)SystemAction.get((Class)(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = NbUndoAction.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction));
            if (ua != null && ua.isEnabled()) {
                ua.actionPerformed(evt);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public class NbStopMacroRecordingAction
    extends ActionFactory.StopMacroRecordingAction {
        private BaseOptions bo;

        private Map getKBMap() {
            List list = this.bo.getKeyBindingList();
            if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
                list.remove(0);
            }
            Map ret = OptionUtilities.makeKeyBindingsMap(list);
            return ret;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            this.bo = BaseOptions.getOptions(NbEditorKit.this.getClass());
            Map oldMacroMap = null;
            Map oldKBMap = null;
            if (this.bo != null) {
                oldMacroMap = this.bo.getMacroMap();
                oldKBMap = this.getKBMap();
            }
            super.actionPerformed(evt, target);
            if (this.bo != null) {
                this.bo.setMacroDiffMap(OptionUtilities.getMapDiff(oldMacroMap, this.bo.getMacroMap(), true));
                this.bo.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(oldKBMap, this.getKBMap(), true));
            }
        }
    }

    public class NbBuildPopupMenuAction
    extends ExtKit.BuildPopupMenuAction {
        static final long serialVersionUID = -8623762627678464181L;
        static /* synthetic */ Class class$org$openide$windows$TopComponent;
        static /* synthetic */ Class class$javax$swing$text$Keymap;
        static /* synthetic */ Class class$java$lang$ClassLoader;
        static /* synthetic */ Class class$org$openide$util$actions$SystemAction;

        protected JPopupMenu buildPopupMenu(JTextComponent target) {
            JPopupMenu popup = super.buildPopupMenu(target);
            if (popup instanceof JPopupMenuPlus) {
                return popup;
            }
            Component[] comps = popup.getComponents();
            popup.removeAll();
            JPopupMenuPlus popupPlus = new JPopupMenuPlus();
            int i = 0;
            while (i < comps.length) {
                popupPlus.add(comps[i]);
                ++i;
            }
            return popupPlus;
        }

        protected void addAction(JTextComponent target, JPopupMenu popupMenu, String actionName) {
            if (actionName != null) {
                if ((class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbBuildPopupMenuAction.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getName().equals(actionName)) {
                    TopComponent tc = NbEditorUtilities.getTopComponent(target);
                    if (tc != null) {
                        SystemAction[] actions = tc.getSystemActions();
                        int i = 0;
                        while (i < actions.length) {
                            Object action = actions[i];
                            if (action instanceof ContextAwareAction) {
                                action = ((ContextAwareAction)action).createContextAwareInstance(tc.getLookup());
                            }
                            if (action instanceof Presenter.Popup) {
                                KeyStroke[] keys;
                                Keymap km;
                                JMenuItem item = ((Presenter.Popup)action).getPopupPresenter();
                                if (item != null && !(item instanceof JMenu) && (km = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? NbBuildPopupMenuAction.class$("javax.swing.text.Keymap") : class$javax$swing$text$Keymap)) != null && (keys = km.getKeyStrokesForAction((Action)action)) != null && keys.length > 0) {
                                    item.setAccelerator(keys[0]);
                                }
                                if (item != null) {
                                    popupMenu.add(item);
                                }
                            } else if (action == null) {
                                popupMenu.addSeparator();
                            }
                            ++i;
                        }
                    }
                    return;
                }
                Class<?> saClass = null;
                try {
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbBuildPopupMenuAction.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                    saClass = Class.forName(actionName, false, loader);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (saClass != null && (class$org$openide$util$actions$SystemAction == null ? (class$org$openide$util$actions$SystemAction = NbBuildPopupMenuAction.class$("org.openide.util.actions.SystemAction")) : class$org$openide$util$actions$SystemAction).isAssignableFrom(saClass)) {
                    SystemAction sa = SystemAction.get(saClass);
                    if (sa instanceof Presenter.Popup) {
                        KeyStroke[] keys;
                        Keymap km;
                        JMenuItem item = ((Presenter.Popup)sa).getPopupPresenter();
                        if (item != null && !(item instanceof JMenu) && (km = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = NbBuildPopupMenuAction.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap)) != null && (keys = km.getKeyStrokesForAction((Action)sa)) != null && keys.length > 0) {
                            item.setAccelerator(keys[0]);
                        }
                        if (item != null) {
                            popupMenu.add(item);
                        }
                    }
                    return;
                }
            }
            super.addAction(target, popupMenu, actionName);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class ToggleToolbarAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction;

        public ToggleToolbarAction() {
            super("toggle-toolbar");
            this.putValue("helpID", (class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction == null ? (class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction = ToggleToolbarAction.class$("org.netbeans.modules.editor.NbEditorKit$ToggleToolbarAction")) : class$org$netbeans$modules$editor$NbEditorKit$ToggleToolbarAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            boolean toolbarVisible = AllOptionsFolder.getDefault().isToolbarVisible();
            AllOptionsFolder.getDefault().setToolbarVisible(!toolbarVisible);
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(LocaleSupport.getString("PROP_base_toolbarVisible"), AllOptionsFolder.getDefault().isToolbarVisible());
            item.addItemListener(new ItemListener(this){
                private final /* synthetic */ ToggleToolbarAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void itemStateChanged(ItemEvent e) {
                    this.this$0.actionPerformed(null, null);
                }
            });
            return item;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

