/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.NbToolbarSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorUI
extends ExtEditorUI {
    private FocusListener focusL;
    private SystemActionUpdater findActionUpdater = this.createSystemActionUpdater("find", true, false);
    private SystemActionUpdater replaceActionUpdater = this.createSystemActionUpdater("replace", true, false);
    private SystemActionUpdater gotoActionUpdater = this.createSystemActionUpdater("goto", true, false);
    private SystemActionUpdater removeSelectionActionUpdater;

    protected SystemActionUpdater createSystemActionUpdater(String editorActionName, boolean updatePerformer, boolean syncEnabling) {
        return new SystemActionUpdater(editorActionName, updatePerformer, syncEnabling);
    }

    public NbEditorUI() {
        this.focusL = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FileObject fo;
                DataObject dob;
                BaseDocument doc = NbEditorUI.this.getDocument();
                if (doc != null && (dob = NbEditorUtilities.getDataObject(doc)) != null && (fo = dob.getPrimaryFile()) != null) {
                    fo.refresh();
                }
            }
        };
    }

    protected void installUI(JTextComponent c) {
        super.installUI(c);
        c.addFocusListener(this.focusL);
    }

    protected void uninstallUI(JTextComponent c) {
        super.uninstallUI(c);
        c.removeFocusListener(this.focusL);
    }

    protected JComponent createExtComponent() {
        JComponent ec = super.createExtComponent();
        NbToolbarSupport.checkToolbar(ec, (JEditorPane)this.getComponent());
        return ec;
    }

    static class EnabledPropertySyncListener
    implements PropertyChangeListener {
        Action action;

        EnabledPropertySyncListener(Action actionToBeSynced) {
            this.action = actionToBeSynced;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                this.action.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }

    public final class SystemActionUpdater
    implements PropertyChangeListener,
    ActionPerformer {
        private String editorActionName;
        private boolean updatePerformer;
        private boolean syncEnabling;
        private Action editorAction;
        private Action systemAction;
        private PropertyChangeListener enabledPropertySyncL;

        SystemActionUpdater(String editorActionName, boolean updatePerformer, boolean syncEnabling) {
            this.editorActionName = editorActionName;
            this.updatePerformer = updatePerformer;
            this.syncEnabling = syncEnabling;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent component = NbEditorUI.this.getComponent();
                if (component != null) {
                    this.propertyChange(new PropertyChangeEvent(NbEditorUI.this, "component", null, component));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        public void editorActivated() {
            Action ea = this.getEditorAction();
            Action sa = this.getSystemAction();
            if (ea != null && sa != null) {
                if (this.updatePerformer && ea.isEnabled() && sa instanceof CallbackSystemAction) {
                    ((CallbackSystemAction)sa).setActionPerformer((ActionPerformer)this);
                }
                if (this.syncEnabling) {
                    if (this.enabledPropertySyncL == null) {
                        this.enabledPropertySyncL = new EnabledPropertySyncListener(sa);
                    }
                    ea.addPropertyChangeListener(this.enabledPropertySyncL);
                }
            }
        }

        public void editorDeactivated() {
            Action ea = this.getEditorAction();
            Action sa = this.getSystemAction();
            if (ea != null && sa != null && this.syncEnabling && this.enabledPropertySyncL != null) {
                ea.removePropertyChangeListener(this.enabledPropertySyncL);
            }
        }

        private void reset() {
            if (this.enabledPropertySyncL != null) {
                this.editorAction.removePropertyChangeListener(this.enabledPropertySyncL);
            }
            this.editorAction = null;
            this.systemAction = null;
            this.enabledPropertySyncL = null;
        }

        public void performAction(SystemAction action) {
            JTextComponent component = NbEditorUI.this.getComponent();
            Action ea = this.getEditorAction();
            if (component != null && ea != null) {
                ea.actionPerformed(new ActionEvent(component, 0, ""));
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("activated".equals(propName)) {
                TopComponent activated = (TopComponent)evt.getNewValue();
                if (activated instanceof CloneableEditor) {
                    this.editorActivated();
                } else {
                    this.editorDeactivated();
                }
            } else if ("component".equals(propName)) {
                JTextComponent component = (JTextComponent)evt.getNewValue();
                TopComponent.Registry regs = TopComponent.getRegistry();
                if (component != null) {
                    component.addPropertyChangeListener(this);
                    regs.addPropertyChangeListener((PropertyChangeListener)this);
                } else {
                    component = (JTextComponent)evt.getOldValue();
                    component.removePropertyChangeListener(this);
                    regs.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.reset();
            } else if ("editorKit".equals(propName)) {
                this.reset();
            }
        }

        private synchronized Action getEditorAction() {
            BaseKit kit;
            if (this.editorAction == null && (kit = Utilities.getKit(NbEditorUI.this.getComponent())) != null) {
                this.editorAction = kit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction() {
            String saClassName;
            Action ea;
            if (this.systemAction == null && (ea = this.getEditorAction()) != null && (saClassName = (String)ea.getValue("systemActionClassName")) != null) {
                Class<?> saClass;
                try {
                    saClass = Class.forName(saClassName);
                }
                catch (Throwable t) {
                    saClass = null;
                }
                if (saClass != null) {
                    this.systemAction = SystemAction.get(saClass);
                }
            }
            return this.systemAction;
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }
}

