/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class NbEditorUtilities {
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$netbeans$modules$editor$FormatterIndentEngine;

    public static DataObject getDataObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof DataObject) {
            return (DataObject)sdp;
        }
        return null;
    }

    public static int[] getIdentifierAndMethodBlock(BaseDocument doc, int offset) throws BadLocationException {
        int[] funBlk;
        int[] idBlk = Utilities.getIdentifierBlock(doc, offset);
        if (idBlk != null && (funBlk = ((ExtSyntaxSupport)doc.getSyntaxSupport()).getFunctionBlock(idBlk)) != null) {
            return new int[]{idBlk[0], idBlk[1], funBlk[1]};
        }
        return idBlk;
    }

    public static Line getLine(BaseDocument doc, int offset, boolean original) {
        Line.Set lineSet;
        LineCookie lc;
        DataObject dob = NbEditorUtilities.getDataObject(doc);
        if (dob != null && (lc = (LineCookie)dob.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = NbEditorUtilities.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie)) != null && (lineSet = lc.getLineSet()) != null) {
            try {
                int lineOffset = Utilities.getLineOffset(doc, offset);
                return original ? lineSet.getOriginal(lineOffset) : lineSet.getCurrent(lineOffset);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Line getLine(JTextComponent target, boolean original) {
        return NbEditorUtilities.getLine((BaseDocument)target.getDocument(), target.getCaret().getDot(), original);
    }

    public static TopComponent getTopComponent(JTextComponent target) {
        return (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbEditorUtilities.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, target);
    }

    public static void addJumpListEntry(DataObject dob) {
        final EditorCookie ec = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = NbEditorUtilities.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (ec != null) {
            final Timer timer = new Timer(500, null);
            timer.addActionListener(new ActionListener(){
                private int countDown = 10;

                public void actionPerformed(ActionEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            if (1.access$006(this.this$0) >= 0) {
                                JEditorPane[] panes = 1.access$100(this.this$0).getOpenedPanes();
                                if (panes != null && panes.length > 0) {
                                    JumpList.checkAddEntry(panes[0]);
                                    1.access$200(this.this$0).stop();
                                }
                            } else {
                                1.access$200(this.this$0).stop();
                            }
                        }
                    });
                }

                static /* synthetic */ int access$006(1 x0) {
                    return --x0.countDown;
                }

                static /* synthetic */ EditorCookie access$100(1 x0) {
                    return x0.ec;
                }

                static /* synthetic */ Timer access$200(1 x0) {
                    return x0.timer;
                }
            });
            timer.start();
        }
    }

    public static String[] mergeStringArrays(String[] a1, String[] a2) {
        String[] ret = new String[a1.length + a2.length];
        int i = 0;
        while (i < a1.length) {
            ret[i] = a1[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < a2.length) {
            ret[a1.length + i2] = a2[i2];
            ++i2;
        }
        return ret;
    }

    public static String getMimeType(Document doc) {
        return (String)doc.getProperty("mimeType");
    }

    public static void invalidArgument(String bundleKey) {
        IllegalArgumentException iae = new IllegalArgumentException("Invalid argument");
        Toolkit.getDefaultToolkit().beep();
        ErrorManager errMan = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = NbEditorUtilities.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errMan != null) {
            errMan.annotate((Throwable)iae, 256, iae.getMessage(), NbEditorUtilities.getString(bundleKey), null, null);
        }
        throw iae;
    }

    private static String getString(String key) {
        try {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$FormatterIndentEngine == null ? (class$org$netbeans$modules$editor$FormatterIndentEngine = NbEditorUtilities.class$("org.netbeans.modules.editor.FormatterIndentEngine")) : class$org$netbeans$modules$editor$FormatterIndentEngine)).getString(key);
        }
        catch (MissingResourceException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return key;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

