/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class NbToolTip
extends FileChangeAdapter {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.tooltip");
    private static final HashMap mime2tip = new HashMap();
    private String mimeType;
    private Annotation[] tipAnnotations;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbToolTip;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    static synchronized void buildToolTip(JTextComponent target) {
        String mimeType = NbEditorUtilities.getMimeType(target.getDocument());
        NbToolTip tip = NbToolTip.getTip(mimeType);
        tip.buildTip(target);
    }

    private NbToolTip(String mimeType) {
        this.mimeType = mimeType;
    }

    private static NbToolTip getTip(String mimeType) {
        NbToolTip tip = (NbToolTip)((Object)mime2tip.get(mimeType));
        if (tip == null) {
            tip = new NbToolTip(mimeType);
            mime2tip.put(mimeType, tip);
        }
        return tip;
    }

    private Annotation[] getTipAnnotations() {
        Annotation[] annos;
        Class clazz = class$org$netbeans$modules$editor$NbToolTip == null ? (class$org$netbeans$modules$editor$NbToolTip = NbToolTip.class$("org.netbeans.modules.editor.NbToolTip")) : class$org$netbeans$modules$editor$NbToolTip;
        synchronized (clazz) {
            annos = this.tipAnnotations;
        }
        if (annos == null) {
            if (debug) {
                System.err.println("Searching for tooltip annotations for mimeType=" + this.mimeType);
            }
            FileObject annoFolder = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + this.mimeType + "/ToolTips");
            if (debug) {
                System.err.println("tooltip annotation folder=" + annoFolder);
            }
            if (annoFolder != null) {
                ArrayList<Object> al = new ArrayList<Object>();
                Enumeration en = annoFolder.getChildren(false);
                while (en.hasMoreElements()) {
                    FileObject fo = (FileObject)en.nextElement();
                    if (debug) {
                        System.err.println("tooltip annotation fileobject=" + fo);
                    }
                    try {
                        DataObject dob = DataObject.find((FileObject)fo);
                        InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbToolTip.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                        if (debug) {
                            System.err.println("tooltip annotation instanceCookie=" + ic);
                        }
                        if (ic == null) continue;
                        Object a = ic.instanceCreate();
                        if (debug) {
                            System.err.println("tooltip annotation instance=" + a);
                        }
                        if (!(a instanceof Annotation)) continue;
                        if (debug) {
                            System.err.println("Found tooltip annotation=" + a + ", class " + a.getClass() + " for mimeType=" + this.mimeType);
                        }
                        al.add(a);
                    }
                    catch (DataObjectNotFoundException e) {
                    }
                    catch (IOException e) {
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                annos = al.toArray(new Annotation[al.size()]);
                Class clazz2 = class$org$netbeans$modules$editor$NbToolTip == null ? (class$org$netbeans$modules$editor$NbToolTip = NbToolTip.class$("org.netbeans.modules.editor.NbToolTip")) : class$org$netbeans$modules$editor$NbToolTip;
                synchronized (clazz2) {
                    this.tipAnnotations = annos;
                }
                annoFolder.addFileChangeListener((FileChangeListener)this);
            }
        }
        return annos;
    }

    private void buildTip(JTextComponent target) {
        int offset;
        BaseDocument doc;
        ToolTipSupport tts;
        ExtEditorUI ui;
        Annotation[] annos = this.getTipAnnotations();
        if (annos != null && (ui = ExtUtilities.getExtEditorUI(target)) != null && (tts = ui.getToolTipSupport()) != null && (doc = Utilities.getDocument(target)) != null && (offset = target.viewToModel(tts.getLastMouseEvent().getPoint())) >= 0) {
            try {
                Line.Part lp;
                Line l;
                Line.Set ls;
                EditorCookie ec;
                int line = Utilities.getLineOffset(doc, offset);
                int col = offset - Utilities.getRowStart(target, offset);
                DataObject dob = NbEditorUtilities.getDataObject(doc);
                if (dob != null && (ec = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = NbToolTip.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)) != null && (ls = ec.getLineSet()) != null && (l = ls.getCurrent(line)) != null && (lp = l.createPart(col, 0)) != null) {
                    new Request(annos, lp, tts).run();
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Request
    implements Runnable,
    PropertyChangeListener {
        private ToolTipSupport tts;
        private Annotation[] annos;

        Request(Annotation[] annos, Line.Part lp, ToolTipSupport tts) {
            this.annos = annos;
            this.tts = tts;
            tts.addPropertyChangeListener(this);
            int i = 0;
            while (i < annos.length) {
                annos[i].attach((Annotatable)lp);
                ++i;
            }
        }

        public void run() {
            int i = 0;
            while (i < this.annos.length) {
                String desc = this.annos[i].getShortDescription();
                if (desc != null) {
                    this.tts.setToolTipText(desc);
                }
                this.annos[i].addPropertyChangeListener((PropertyChangeListener)this);
                ++i;
            }
        }

        private void dismiss() {
            this.tts.removePropertyChangeListener(this);
            this.tts = null;
            int i = 0;
            while (i < this.annos.length) {
                this.annos[i].removePropertyChangeListener((PropertyChangeListener)this);
                this.annos[i].detach();
                ++i;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("shortDescription".equals(propName)) {
                if (evt.getNewValue() != null) {
                    String tipText = (String)evt.getNewValue();
                    Utilities.runInEventDispatchThread(new Runnable(this, tipText){
                        private final /* synthetic */ String val$tipText;
                        private final /* synthetic */ Request this$0;
                        {
                            this.this$0 = this$0;
                            this.val$tipText = val$tipText;
                        }

                        public void run() {
                            if (Request.access$000(this.this$0) != null) {
                                Request.access$000(this.this$0).setToolTipText(this.val$tipText);
                            }
                        }
                    });
                }
            } else if ("status".equals(propName) && (Integer)evt.getNewValue() == 0) {
                this.dismiss();
            }
        }

        static /* synthetic */ ToolTipSupport access$000(Request x0) {
            return x0.tts;
        }
    }
}

