/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.NbToolbarSupport;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.IndexedNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

final class NbToolbarConfigNode
extends IndexedNode {
    private static SystemAction[] folderActions;
    private List toolbarDataObjects;
    private DataFolder changeFolder;
    private static final String SEPARATOR_CLASS_NAME = "javax.swing.JToolBar$Separator";
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbToolbarConfigNode;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public static void showConfig(Class kitClass) {
        NodeOperation.getDefault().explore((Node)new NbToolbarConfigNode(kitClass));
    }

    NbToolbarConfigNode(Class kitClass) {
        DataFolder mimeFolder;
        String toolbarTypeName;
        if (kitClass == null) {
            toolbarTypeName = NbToolbarConfigNode.getLocalizedString("CTL_Toolbar_global");
            mimeFolder = null;
        } else {
            BaseOptions options = BaseOptions.getOptions(kitClass);
            if (options == null) {
                throw new IllegalStateException("No options available for kitClass=" + kitClass);
            }
            BaseKit kit = BaseKit.getKit(kitClass);
            if (kit == null) {
                throw new NullPointerException();
            }
            String mimeType = kit.getContentType();
            toolbarTypeName = options.getTypeName();
            if (toolbarTypeName == null) {
                toolbarTypeName = "<" + mimeType + ">";
            }
            mimeFolder = NbToolbarSupport.getToolbarFolder(mimeType, true);
        }
        String displayName = MessageFormat.format(NbToolbarConfigNode.getLocalizedString("CTL_Toolbar_name"), toolbarTypeName);
        super.setDisplayName(displayName);
        super.setShortDescription(NbToolbarConfigNode.getLocalizedString("CTL_Toolbar_hint"));
        super.setIconBase("org/netbeans/core/resources/toolbars");
        DataFolder baseFolder = NbToolbarSupport.getToolbarFolder("text/base", true);
        List toolbarDataObjects = NbToolbarSupport.getToolbarObjects(baseFolder, mimeFolder);
        Node[] nodes = new Node[toolbarDataObjects.size()];
        int i = nodes.length - 1;
        while (i >= 0) {
            nodes[i] = new ToolbarItemNode(((DataObject)toolbarDataObjects.get(i)).getNodeDelegate());
            --i;
        }
        this.getChildren().add(nodes);
        this.changeFolder = mimeFolder != null ? mimeFolder : baseFolder;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$editor$NbToolbarConfigNode == null ? (class$org$netbeans$modules$editor$NbToolbarConfigNode = NbToolbarConfigNode.class$("org.netbeans.modules.editor.NbToolbarConfigNode")) : class$org$netbeans$modules$editor$NbToolbarConfigNode);
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewType(){

            public String getName() {
                return NbToolbarConfigNode.getLocalizedString("PROP_addToolbarSeparator");
            }

            public void create() throws IOException {
                NbToolbarConfigNode.this.addToolbarSeparator();
            }
        }};
    }

    private void addToolbarSeparator() {
        DataObject dob;
        int maxId = 0;
        String lastDataObjectName = null;
        Iterator it = this.toolbarDataObjects.iterator();
        while (it.hasNext()) {
            dob = (DataObject)it.next();
            String dobName = dob.getName();
            InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbToolbarConfigNode.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (ic != null && SEPARATOR_CLASS_NAME.equals(ic.instanceName()) && dobName.startsWith("Separator") && dobName.endsWith(".instance")) {
                try {
                    int id = Integer.parseInt(dobName.substring("Separator".length(), dobName.length() - "Separator".length() - ".instance".length()));
                    maxId = Math.max(id, maxId);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (it.hasNext()) continue;
            lastDataObjectName = dob.getPrimaryFile().getNameExt();
        }
        try {
            dob = InstanceDataObject.create((DataFolder)this.changeFolder, (String)("Separator" + ++maxId + ".instance"), (String)SEPARATOR_CLASS_NAME);
            if (lastDataObjectName != null) {
                this.changeFolder.getPrimaryFile().setAttribute(lastDataObjectName + "/" + dob.getPrimaryFile().getNameExt(), (Object)Boolean.TRUE);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private void addEditorAction() {
        String eaName;
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbToolbarConfigNode.getLocalizedString("PROP_newToolbarEditorActionLabel"), NbToolbarConfigNode.getLocalizedString("PROP_newToolbarEditorActionDialog"));
        inputLine.setInputText(NbToolbarConfigNode.getLocalizedString("PROP_newToolbarEditorAction"));
        Object ok = DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (ok == NotifyDescriptor.OK_OPTION && (eaName = inputLine.getInputText()) != null && !"".equals(eaName)) {
            try {
                FileObject eaFO = this.changeFolder.getPrimaryFile().createData(eaName);
                if (this.toolbarDataObjects != null && this.toolbarDataObjects.size() > 0) {
                    this.changeFolder.getPrimaryFile().setAttribute(((DataObject)this.toolbarDataObjects.get(this.toolbarDataObjects.size() - 1)).getPrimaryFile().getNameExt() + "/" + eaFO.getNameExt(), (Object)Boolean.TRUE);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public SystemAction[] getActions() {
        if (folderActions == null) {
            folderActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = NbToolbarConfigNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = NbToolbarConfigNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = NbToolbarConfigNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = NbToolbarConfigNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = NbToolbarConfigNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return folderActions;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    private static String getLocalizedString(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$NbToolbarConfigNode == null ? (class$org$netbeans$modules$editor$NbToolbarConfigNode = NbToolbarConfigNode.class$("org.netbeans.modules.editor.NbToolbarConfigNode")) : class$org$netbeans$modules$editor$NbToolbarConfigNode), (String)key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ToolbarItemNode
    extends FilterNode {
        static SystemAction[] itemActions;
        static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
        static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

        ToolbarItemNode(Node filter) {
            super(filter, Children.LEAF);
        }

        public SystemAction[] getActions() {
            if (itemActions == null) {
                itemActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = ToolbarItemNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = ToolbarItemNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ToolbarItemNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ToolbarItemNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ToolbarItemNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ToolbarItemNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ToolbarItemNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
            return itemActions;
        }

        public boolean canRename() {
            return false;
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[0];
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

