/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class NbToolbarSupport {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.toolbar");
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.toolbar.sort");
    private static final String TOOLBARS_FOLDER_NAME = "Toolbars";
    private static final String DEFAULT_TOOLBAR_NAME = "Default";
    static final String BASE_MIME_TYPE = "text/base";
    private static final int TIMER_DELAY = 5000;
    private static final WeakHashMap kit2kitSup = new WeakHashMap();
    private static boolean lastToolbarsVisible;
    private static final Timer checkToolbarsTimer;
    private static int instanceCount;
    private static final Runnable returnFocusRunnable;
    private static final ActionListener sharedActionListener;
    private static final MouseListener sharedMouseListener;
    private static final SettingsChangeListener settingsListener;
    private static final PropertyChangeListener sharedPropertyChangeListener;
    private EditorKit kit;
    private JToolBar toolbarComponent;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$TopComponentContainer;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbToolbarSupport;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    static void checkToolbar(JComponent extComponent, JEditorPane pane) {
        pane.removePropertyChangeListener(sharedPropertyChangeListener);
        pane.addPropertyChangeListener(sharedPropertyChangeListener);
        NbToolbarSupport.refreshToolbar(extComponent, pane, NbToolbarSupport.isToolbarsVisible(), false);
    }

    private static void processAllToolbars(boolean toolbarsVisible, boolean refreshToolbarContent) {
        JEditorPane activatedPane = NbToolbarSupport.getEditorPane(NbToolbarSupport.getExtComponent(TopComponent.getRegistry().getActivated()));
        Iterator it = Registry.getComponentIterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            if (debug) {
                System.out.println("iteratorComponent=" + System.identityHashCode(c) + ", isShowing()=" + c.isShowing() + ", isActivatedPane=" + (c == activatedPane) + ", hasSelectedTopComponent=" + NbToolbarSupport.hasSelectedTopComponent(c));
            }
            if (!(c instanceof JEditorPane)) continue;
            boolean updateComponent = true;
            String debugInfo = "";
            if (!refreshToolbarContent && !toolbarsVisible) {
                updateComponent = !c.isShowing() && c != activatedPane && !NbToolbarSupport.hasSelectedTopComponent(c);
                debugInfo = "RECLAIM";
            } else if (!refreshToolbarContent && toolbarsVisible) {
                updateComponent = c.isShowing() || NbToolbarSupport.hasSelectedTopComponent(c);
                debugInfo = "SHOW";
            } else {
                updateComponent = true;
                String string = debugInfo = toolbarsVisible ? "SHOW" : "HIDE";
            }
            if (!updateComponent) continue;
            if (debug) {
                System.out.println("Attempt to " + debugInfo + " toolbar of c=" + System.identityHashCode(c));
            }
            NbToolbarSupport.refreshPaneToolbar((JEditorPane)c, toolbarsVisible, refreshToolbarContent);
        }
    }

    static DataFolder getToolbarFolder(String type, boolean forceCreate) {
        String toolbarFolderPath = "Editors/" + type + "/" + TOOLBARS_FOLDER_NAME + "/" + DEFAULT_TOOLBAR_NAME;
        DataFolder toolbarFolder = null;
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(toolbarFolderPath);
        if (f != null) {
            try {
                DataObject dob = DataObject.find((FileObject)f);
                toolbarFolder = (DataFolder)dob.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NbToolbarSupport.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            }
            catch (DataObjectNotFoundException e) {}
        } else if (forceCreate) {
            try {
                FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)toolbarFolderPath);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }
        return toolbarFolder;
    }

    private static JComponent getExtComponent(TopComponent tc) {
        Component c;
        if (tc != null && tc.getComponentCount() > 0 && (c = tc.getComponent(0)) instanceof JComponent) {
            JComponent jc = (JComponent)c;
            return NbToolbarSupport.getEditorPane(jc) != null ? jc : null;
        }
        return null;
    }

    private static JEditorPane getEditorPane(JComponent extComponent) {
        return extComponent != null ? (JEditorPane)extComponent.getClientProperty(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = NbToolbarSupport.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent) : null;
    }

    private static boolean hasSelectedTopComponent(Component c) {
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbToolbarSupport.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, c);
        if (tc == null) {
            return true;
        }
        TopComponentContainer tcc = (TopComponentContainer)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$windows$frames$TopComponentContainer == null ? (class$org$netbeans$core$windows$frames$TopComponentContainer = NbToolbarSupport.class$("org.netbeans.core.windows.frames.TopComponentContainer")) : class$org$netbeans$core$windows$frames$TopComponentContainer, (Component)tc);
        if (tcc == null) {
            return true;
        }
        List areas = tcc.getAreas();
        int i = areas.size() - 1;
        while (i >= 0) {
            TopComponentContainer.Area area = (TopComponentContainer.Area)areas.get(i);
            if (area.getSelectedTopComponent() == tc) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static void refreshPaneToolbar(JEditorPane pane, boolean toolbarVisible, boolean refreshToolbarContent) {
        EditorUI ui = Utilities.getEditorUI(pane);
        if (ui != null && ui.hasExtComponent()) {
            NbToolbarSupport.refreshToolbar(ui.getExtComponent(), pane, toolbarVisible, refreshToolbarContent);
        }
    }

    private static void refreshToolbar(JComponent extComponent, JEditorPane pane, boolean toolbarVisible, boolean refreshToolbarContent) {
        EditorKit kit = pane.getEditorKit();
        if (kit != null) {
            NbToolbarSupport sup = (NbToolbarSupport)pane.getClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport);
            DataFolder baseFolder = null;
            DataFolder mimeFolder = null;
            if (toolbarVisible) {
                baseFolder = NbToolbarSupport.getToolbarFolder(BASE_MIME_TYPE, false);
                mimeFolder = NbToolbarSupport.getToolbarFolder(NbToolbarSupport.getKitMimeType(kit), false);
                toolbarVisible &= baseFolder != null || mimeFolder != null;
            }
            if (toolbarVisible) {
                if (sup == null) {
                    KitSupport kitSup = NbToolbarSupport.getKitSupport(kit);
                    sup = kitSup.obtainUnused();
                    if (sup == null) {
                        sup = new NbToolbarSupport(kit);
                        sup.refreshToolbarComponent(baseFolder, mimeFolder);
                    }
                    sup.attachToolbarComponent(extComponent, pane);
                }
                if (refreshToolbarContent) {
                    sup.detachToolbarComponent(extComponent, pane);
                    sup.refreshToolbarComponent(baseFolder, mimeFolder);
                    sup.attachToolbarComponent(extComponent, pane);
                }
            } else if (sup != null) {
                sup.detachToolbarComponent(extComponent, pane);
                NbToolbarSupport.getKitSupport(sup.kit).release(sup);
            }
        }
    }

    private static boolean isToolbarsVisible() {
        return AllOptionsFolder.getDefault().isToolbarVisible();
    }

    private static KitSupport getKitSupport(EditorKit kit) {
        WeakHashMap weakHashMap = kit2kitSup;
        synchronized (weakHashMap) {
            KitSupport kitSup = (KitSupport)kit2kitSup.get(kit);
            if (kitSup == null) {
                kitSup = new KitSupport();
                kit2kitSup.put(kit, kitSup);
            }
            KitSupport kitSupport = kitSup;
            return kitSupport;
        }
    }

    private static int releaseExtraUnusedKitSupports() {
        WeakHashMap weakHashMap = kit2kitSup;
        synchronized (weakHashMap) {
            int cnt = 0;
            Iterator it = ((AbstractMap)kit2kitSup).values().iterator();
            while (it.hasNext()) {
                cnt += ((KitSupport)it.next()).releaseExtraUnused();
            }
            int n = cnt;
            return n;
        }
    }

    private static String getKitMimeType(EditorKit kit) {
        String mimeType = kit.getContentType();
        if (mimeType == null) {
            throw new NullPointerException();
        }
        return mimeType;
    }

    private static String getMnemonic(MultiKeyBinding binding) {
        StringBuffer sb = new StringBuffer();
        if (binding.keys != null) {
            int i = 0;
            while (i < binding.keys.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(NbToolbarSupport.getKeyMnemonic(binding.keys[i]));
                ++i;
            }
        } else {
            sb.append(NbToolbarSupport.getKeyMnemonic(binding.key));
        }
        return sb.toString();
    }

    private static String getKeyMnemonic(KeyStroke key) {
        int i;
        String sk = org.openide.util.Utilities.keyToString((KeyStroke)key);
        StringBuffer sb = new StringBuffer();
        int mods = key.getModifiers();
        if ((mods & 2) != 0) {
            sb.append("Ctrl+");
        }
        if ((mods & 8) != 0) {
            sb.append("Alt+");
        }
        if ((mods & 1) != 0) {
            sb.append("Shift+");
        }
        if ((mods & 4) != 0) {
            sb.append("Meta+");
        }
        if ((i = sk.indexOf(45)) != -1) {
            sk = sk.substring(i + 1);
        }
        sb.append(sk);
        return sb.toString();
    }

    NbToolbarSupport(EditorKit kit) {
        this.kit = kit;
        ++instanceCount;
    }

    private void refreshToolbarComponent(DataFolder baseFolder, DataFolder mimeFolder) {
        this.toolbarComponent = new JToolBar();
        this.toolbarComponent.setFloatable(false);
        this.toolbarComponent.setBorder(null);
        this.toolbarComponent.addMouseListener(sharedMouseListener);
        this.addPresenters(baseFolder, mimeFolder, this.toolbarComponent);
    }

    private void addPresenters(DataFolder baseFolder, DataFolder mimeFolder, JToolBar toolbar) {
        List gkbl;
        ArrayList keyBindingsList = new ArrayList();
        AllOptionsFolder aof = AllOptionsFolder.getDefault();
        if (aof != null && (gkbl = aof.getKeyBindingList()) != null) {
            keyBindingsList.addAll(gkbl);
        }
        if (this.kit instanceof BaseKit) {
            List kbl;
            BaseKit baseKit = (BaseKit)this.kit;
            BaseOptions options = BaseOptions.getOptions(this.kit.getClass());
            if (options != null && (kbl = options.getKeyBindingList()) != null) {
                keyBindingsList.addAll(kbl);
            }
            Iterator it = NbToolbarSupport.getToolbarObjects(baseFolder, mimeFolder).iterator();
            while (it.hasNext()) {
                DataObject dob = (DataObject)it.next();
                InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbToolbarSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic != null) {
                    try {
                        if ((class$javax$swing$JSeparator == null ? NbToolbarSupport.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(ic.instanceClass())) {
                            toolbar.addSeparator();
                            continue;
                        }
                        Object obj = ic.instanceCreate();
                        if (obj instanceof Presenter.Toolbar) {
                            Component tbp = ((Presenter.Toolbar)obj).getToolbarPresenter();
                            toolbar.add(tbp);
                            if (!(tbp instanceof JButton)) continue;
                            JButton jtbp = (JButton)tbp;
                            jtbp.setBorderPainted(false);
                            jtbp.addMouseListener(sharedMouseListener);
                            continue;
                        }
                        if (!(obj instanceof Component)) continue;
                        toolbar.add((Component)obj);
                        if (!(obj instanceof JButton)) continue;
                        JButton button = (JButton)obj;
                        button.setBorderPainted(false);
                        button.addMouseListener(sharedMouseListener);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    continue;
                }
                String actionName = dob.getName();
                Action a = baseKit.getActionByName(actionName);
                if (a == null) continue;
                Object icon = a.getValue("SmallIcon");
                if (icon == null) {
                    Image img;
                    String resourceId = (String)a.getValue("IconResource");
                    if (resourceId == null) {
                        resourceId = "org/netbeans/modules/editor/resources/default";
                    }
                    if ((img = org.openide.util.Utilities.loadImage((String)(resourceId + ".gif"))) != null) {
                        a.putValue("SmallIcon", new ImageIcon(img));
                    }
                }
                JButton button = toolbar.add(a);
                Iterator kbIt = keyBindingsList.iterator();
                while (kbIt.hasNext()) {
                    Object o = kbIt.next();
                    if (!(o instanceof MultiKeyBinding)) continue;
                    MultiKeyBinding binding = (MultiKeyBinding)o;
                    if (!actionName.equals(binding.actionName)) continue;
                    button.setToolTipText(button.getToolTipText() + " (" + NbToolbarSupport.getMnemonic(binding) + ")");
                    break;
                }
                button.setBorderPainted(false);
                button.addActionListener(sharedActionListener);
                button.addMouseListener(sharedMouseListener);
                button.setMargin(new Insets(2, 1, 0, 1));
            }
        }
    }

    static List getToolbarObjects(DataFolder baseFolder, DataFolder mimeFolder) {
        HashMap name2dob = new HashMap();
        ArrayList names = new ArrayList();
        ArrayList sortPairs = new ArrayList();
        if (mimeFolder != null) {
            NbToolbarSupport.addDataObjects(name2dob, names, mimeFolder.getChildren());
        }
        if (baseFolder != null) {
            NbToolbarSupport.addDataObjects(name2dob, names, baseFolder.getChildren());
        }
        if (mimeFolder != null) {
            NbToolbarSupport.addSortPairs(mimeFolder, sortPairs);
        }
        if (baseFolder != null) {
            NbToolbarSupport.addSortPairs(baseFolder, sortPairs);
        }
        SortSupport sortSupport = new SortSupport();
        Iterator it = sortPairs.iterator();
        while (it.hasNext()) {
            Object firstName = it.next();
            Object secondName = it.next();
            if (name2dob.containsKey(firstName) && name2dob.containsKey(secondName)) {
                sortSupport.addEdge(firstName, secondName);
                continue;
            }
            if (!debugSort) continue;
            System.out.println("Edge not added: " + firstName + " -> " + name2dob.containsKey(firstName) + ", " + secondName + " -> " + name2dob.containsKey(secondName));
        }
        if (debugSort) {
            System.out.println("Names: " + names + "\nsortSupport:" + sortSupport);
        }
        List standalones = sortSupport.eliminateMultipleStarts(names, true);
        if (debugSort) {
            System.out.println("Eliminated multiple starts: " + sortSupport + "\nStandalones: " + standalones);
        }
        List sortedNameList = sortSupport.createSortedList();
        if (debugSort) {
            System.out.println("Sorted Name List: " + sortedNameList);
        }
        sortedNameList.addAll(standalones);
        int sortedNameListSize = sortedNameList.size();
        ArrayList dobList = new ArrayList(sortedNameListSize);
        int i = 0;
        while (i < sortedNameListSize) {
            dobList.add(name2dob.get(sortedNameList.get(i)));
            ++i;
        }
        if (dobList.indexOf(null) != -1) {
            throw new IllegalStateException();
        }
        return dobList;
    }

    private static void addDataObjects(Map name2dob, List names, DataObject[] addDobs) {
        int addDobsLength = addDobs.length;
        ArrayList<String> addNamesList = new ArrayList<String>(addDobsLength);
        int i = 0;
        while (i < addDobsLength) {
            DataObject dob = addDobs[i];
            String dobName = dob.getPrimaryFile().getNameExt();
            if (names.indexOf(dobName) == -1 && addNamesList.indexOf(dobName) == -1) {
                name2dob.put(dobName, dob);
                addNamesList.add(dobName);
            }
            ++i;
        }
        names.addAll(0, addNamesList);
    }

    private static void addSortPairs(DataFolder toolbarFolder, List sortPairs) {
        FileObject primaryFile = toolbarFolder.getPrimaryFile();
        Enumeration e = primaryFile.getAttributes();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            int slashIndex = name.indexOf("/");
            if (slashIndex == -1 || !((value = primaryFile.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            sortPairs.add(name.substring(0, slashIndex));
            sortPairs.add(name.substring(slashIndex + 1));
        }
    }

    private void attachToolbarComponent(JComponent extComponent, JEditorPane pane) {
        if (pane.getClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport) != null) {
            throw new IllegalStateException();
        }
        pane.putClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport, this);
        extComponent.add((Component)this.toolbarComponent, "North");
    }

    private void detachToolbarComponent(JComponent extComponent, JEditorPane pane) {
        if (pane.getClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport) == null) {
            throw new IllegalStateException();
        }
        pane.putClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport, null);
        extComponent.remove(this.toolbarComponent);
    }

    static /* synthetic */ boolean access$800() {
        return lastToolbarsVisible;
    }

    static /* synthetic */ boolean access$802(boolean x0) {
        lastToolbarsVisible = x0;
        return lastToolbarsVisible;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        checkToolbarsTimer = new Timer(5000, null);
        returnFocusRunnable = new Runnable(){

            public void run() {
                JTextComponent c = BaseTextUI.getFocusedComponent();
                if (c != null) {
                    ((Component)c).requestFocus();
                }
            }
        };
        sharedActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object src = evt.getSource();
                if (src instanceof Timer) {
                    boolean toolbarsVisible;
                    if (debug) {
                        System.out.println("TIMER fired");
                    }
                    if (toolbarsVisible = NbToolbarSupport.isToolbarsVisible()) {
                        NbToolbarSupport.processAllToolbars(false, false);
                        int remains = NbToolbarSupport.releaseExtraUnusedKitSupports();
                        if (debug) {
                            System.out.println("Unused toolbar supports remaining=" + remains + ", instanceCount=" + instanceCount + "\nkitSupportRegistry: " + kit2kitSup);
                        }
                        if (remains > 0 && !checkToolbarsTimer.isRunning()) {
                            checkToolbarsTimer.restart();
                        }
                    }
                } else {
                    SwingUtilities.invokeLater(returnFocusRunnable);
                }
            }
        };
        sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                JButton button;
                if (evt.getSource() instanceof JButton && (button = (JButton)evt.getSource()).isEnabled()) {
                    button.setBorderPainted(true);
                }
            }

            public void mouseExited(MouseEvent evt) {
                if (evt.getSource() instanceof JButton) {
                    ((JButton)evt.getSource()).setBorderPainted(false);
                }
            }

            protected void showPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    JPopupMenu pm = new JPopupMenu();
                    JCheckBoxMenuItem item = new JCheckBoxMenuItem(LocaleSupport.getString("PROP_base_toolbarVisible"), NbToolbarSupport.isToolbarsVisible());
                    item.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent evt2) {
                            AllOptionsFolder.getDefault().setToolbarVisible(((JCheckBoxMenuItem)evt2.getSource()).isSelected());
                        }
                    });
                    pm.add(item);
                    pm.show((Component)evt.getSource(), evt.getX(), evt.getY());
                }
            }
        };
        settingsListener = new SettingsChangeListener(){

            public void settingsChange(SettingsChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        boolean toolbarsVisible = NbToolbarSupport.access$100();
                        if (NbToolbarSupport.access$800() != toolbarsVisible) {
                            NbToolbarSupport.access$802(toolbarsVisible);
                            NbToolbarSupport.access$200(NbToolbarSupport.access$800(), true);
                            if (!NbToolbarSupport.access$800()) {
                                NbToolbarSupport.access$500().clear();
                            }
                        }
                    }
                });
            }
        };
        sharedPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("editorKit".equals(propName)) {
                    Object src = evt.getSource();
                    if (src instanceof JEditorPane) {
                        JEditorPane pane = (JEditorPane)src;
                        NbToolbarSupport.refreshPaneToolbar(pane, false, false);
                        NbToolbarSupport.refreshPaneToolbar(pane, true, false);
                    }
                } else if ("activated".equals(propName)) {
                    JComponent extComponent;
                    TopComponent tc = (TopComponent)evt.getNewValue();
                    if (tc == null) {
                        TopComponent.getRegistry().getActivated();
                    }
                    if ((extComponent = NbToolbarSupport.getExtComponent(tc)) != null) {
                        if (debug) {
                            System.out.println("Attempt to SHOW toolbar for c=" + System.identityHashCode(NbToolbarSupport.getEditorPane(extComponent)));
                        }
                        NbToolbarSupport.refreshToolbar(extComponent, NbToolbarSupport.getEditorPane(extComponent), NbToolbarSupport.isToolbarsVisible(), false);
                        checkToolbarsTimer.restart();
                    }
                } else if ("currentWorkspace".equals(propName)) {
                    if (debug) {
                        System.out.println("WORKSPACE changed");
                    }
                    if (NbToolbarSupport.isToolbarsVisible()) {
                        NbToolbarSupport.processAllToolbars(true, false);
                    }
                }
            }
        };
        Settings.addSettingsChangeListener(settingsListener);
        settingsListener.settingsChange(null);
        TopComponent.getRegistry().addPropertyChangeListener(sharedPropertyChangeListener);
        WindowManager.getDefault().addPropertyChangeListener(sharedPropertyChangeListener);
        checkToolbarsTimer.addActionListener(sharedActionListener);
        checkToolbarsTimer.setRepeats(false);
    }

    private static final class SortSupport {
        private Map vert2edges = new HashMap();
        private Set edgesEnds = new HashSet();
        private Set mdfsVisited = new HashSet();
        private List mdfsFinished = new ArrayList();

        SortSupport() {
        }

        void addEdge(Object start, Object end) {
            if (start == null || end == null) {
                throw new IllegalStateException();
            }
            if (start.equals(end)) {
                return;
            }
            this.edgesEnds.add(end);
            ArrayList<Object> verts = (ArrayList<Object>)this.vert2edges.get(start);
            boolean addedNewList = false;
            if (verts == null) {
                verts = new ArrayList<Object>(2);
                this.vert2edges.put(start, verts);
                addedNewList = true;
            }
            if (verts.indexOf(end) == -1) {
                verts.add(end);
                if (debugSort) {
                    System.out.println("added edge " + start + " -> " + end);
                }
                if (this.mdfs(start)) {
                    verts.remove(verts.size() - 1);
                    if (addedNewList) {
                        this.vert2edges.remove(start);
                    }
                    if (debugSort) {
                        System.out.println("REMOVED edge " + start + " -> " + end);
                    }
                }
            }
        }

        List eliminateMultipleStarts(List vertList, boolean omitStandalones) {
            Object first = null;
            Object lastStart = null;
            ArrayList standalones = omitStandalones ? new ArrayList() : null;
            int vertListSize = vertList.size();
            int i = 0;
            while (i < vertListSize) {
                Object start = vertList.get(i);
                if (!this.edgesEnds.contains(start)) {
                    if (omitStandalones && !this.vert2edges.containsKey(start)) {
                        standalones.add(start);
                    } else if (first == null) {
                        first = start;
                        lastStart = start;
                    } else {
                        this.addEdge(lastStart, start);
                    }
                }
                ++i;
            }
            return standalones;
        }

        List createSortedList() {
            HashSet allVerts = new HashSet(this.vert2edges.keySet());
            allVerts.removeAll(this.edgesEnds);
            Iterator it = allVerts.iterator();
            if (!it.hasNext()) {
                throw new IllegalStateException("No first item");
            }
            Object first = it.next();
            if (it.hasNext()) {
                throw new IllegalStateException("More than one start item");
            }
            this.mdfs(first);
            Collections.reverse(this.mdfsFinished);
            return this.mdfsFinished;
        }

        private boolean mdfs(Object v) {
            this.mdfsVisited.clear();
            this.mdfsFinished.clear();
            return this.mdfsRec(v);
        }

        private boolean mdfsRec(Object v) {
            if (this.mdfsVisited.contains(v)) {
                return true;
            }
            this.mdfsVisited.add(v);
            List verts = (List)this.vert2edges.get(v);
            if (verts != null) {
                int vertsSize = verts.size();
                int i = 0;
                while (i < vertsSize) {
                    if (this.mdfsRec(verts.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            this.mdfsFinished.add(v);
            return false;
        }

        public String toString() {
            return "edgesEnds=" + this.edgesEnds + "\n\n vert2edges=" + this.vert2edges;
        }
    }

    private static class KitSupport {
        private List unused = new ArrayList();

        KitSupport() {
        }

        synchronized NbToolbarSupport obtainUnused() {
            int lastUnusedIndex = this.unused.size() - 1;
            if (lastUnusedIndex >= 0) {
                NbToolbarSupport sup = (NbToolbarSupport)this.unused.get(lastUnusedIndex);
                this.unused.remove(lastUnusedIndex);
                if (debug) {
                    System.out.println("KITSUPPORT: valid unused " + System.identityHashCode(sup));
                }
                return sup;
            }
            return null;
        }

        synchronized void release(NbToolbarSupport sup) {
            if (debug) {
                System.out.println("KITSUPPORT: release " + System.identityHashCode(sup));
            }
            this.unused.add(sup);
            if (!checkToolbarsTimer.isRunning()) {
                checkToolbarsTimer.restart();
            }
        }

        synchronized int releaseExtraUnused() {
            int unusedSize = this.unused.size();
            if (unusedSize <= 1) {
                return 0;
            }
            int newUnusedSize = unusedSize / 2;
            while (unusedSize > newUnusedSize) {
                this.unused.remove(--unusedSize);
            }
            return newUnusedSize;
        }

        public String toString() {
            return "unused=" + this.unused;
        }
    }
}

