/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.html.HTMLCompletion;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.LineWrapFormatter;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.html.NbReaderProvider;

public class HTMLKit
extends NbEditorKit {
    static final long serialVersionUID = -1381945567613910297L;
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String shiftInsertBreakAction = "shift-insert-break";
    private static boolean setupReadersInitialized = false;

    public HTMLKit() {
        if (!setupReadersInitialized) {
            NbReaderProvider.setupReaders();
            setupReadersInitialized = true;
        }
    }

    public String getContentType() {
        return HTML_MIME_TYPE;
    }

    public Syntax createSyntax(Document doc) {
        return new HTMLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new HTMLSyntaxSupport(doc);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new HTMLCompletion(extEditorUI);
    }

    public Formatter createFormatter() {
        return new LineWrapFormatter(this.getClass());
    }

    protected Action[] createActions() {
        Action[] HTMLActions = new Action[]{new HTMLShiftBreakAction()};
        return TextAction.augmentList(super.createActions(), HTMLActions);
    }

    public static class HTMLShiftBreakAction
    extends BaseAction {
        static final long serialVersionUID = 4004043376345356061L;

        public HTMLShiftBreakAction() {
            super(HTMLKit.shiftInsertBreakAction, 14);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Completion completion;
            if (target != null && (completion = ExtUtilities.getCompletion(target)) != null && completion.isPaneVisible() && !completion.substituteText(true)) {
                completion.refresh(false);
            }
        }
    }
}

