/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.Type;

public class JCExtension {
    public static boolean equals(JCClass cls1, ClassElement cls2) {
        return cls1.getFullName().equals(cls2.getName().getFullName());
    }

    public static boolean equals(JCType typ1, Type typ2) {
        int arrayDepth = 0;
        while (typ2.isArray()) {
            ++arrayDepth;
            typ2 = typ2.getElementType();
        }
        String fn = typ2.isPrimitive() ? typ2.getFullString() : typ2.getClassName().getFullName();
        return typ1.getArrayDepth() == arrayDepth && typ1.getClazz().getFullName().equals(fn);
    }

    public static boolean equals(JCField fld1, FieldElement fld2) {
        return fld1.getName().equals(fld2.getName().getFullName()) && JCExtension.equals(fld1.getType(), fld2.getType());
    }

    public static boolean equals(JCConstructor ctr1, ConstructorElement ctr2) {
        JCParameter[] parms1 = ctr1.getParameters();
        MethodParameter[] parms2 = ctr2.getParameters();
        if (parms2 == null || parms1.length != parms2.length) {
            return false;
        }
        int i = parms1.length - 1;
        while (i >= 0) {
            if (!JCExtension.equals(parms1[i].getType(), parms2[i].getType())) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean equals(JCMethod mtd1, MethodElement mtd2) {
        return mtd1.getName().equals(mtd2.getName().getFullName()) && JCExtension.equals((JCConstructor)mtd1, (ConstructorElement)mtd2);
    }

    public static FieldElement findFieldElement(JCField fld, ClassElement ce) {
        FieldElement[] fes = ce.getFields();
        if (fes != null) {
            int i = 0;
            while (i < fes.length) {
                if (JCExtension.equals(fld, fes[i])) {
                    return fes[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static ConstructorElement findConstructorElement(JCConstructor ctr, ClassElement ce) {
        ConstructorElement[] ces = ce.getConstructors();
        if (ces != null) {
            int i = 0;
            while (i < ces.length) {
                if (JCExtension.equals(ctr, ces[i])) {
                    return ces[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static MethodElement findMethodElement(JCMethod mtd, ClassElement ce) {
        MethodElement[] mes = ce.getMethods();
        if (mes != null) {
            int i = 0;
            while (i < mes.length) {
                if (JCExtension.equals(mtd, mes[i])) {
                    return mes[i];
                }
                ++i;
            }
        }
        return null;
    }

    static JCClass getIdentifierClass(Identifier i, Map lookupCache, boolean preferFinder) {
        JCFinder finder;
        SourceElement se;
        ClassElement ce;
        JCFinder finder2;
        String fn = i.getFullName();
        JCClass cls = (JCClass)lookupCache.get(fn);
        if (cls != null) {
            return cls;
        }
        if (preferFinder && (finder2 = JavaCompletion.getFinder()) != null && (cls = finder2.getExactClass(fn)) != null) {
            cls = JavaCompletion.getSimpleClass(cls);
            lookupCache.put(fn, cls);
            return cls;
        }
        int pkgLen = -1;
        try {
            ce = ClassElement.forName((String)fn);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            System.err.println("Error occurred during name resolving");
            t.printStackTrace();
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            return JavaCompletion.INVALID_CLASS;
        }
        if (ce != null && (se = ce.getSource()) != null) {
            Identifier pi = null;
            pi = se.getPackage();
            if (pi != null) {
                String pkgName = pi.getFullName();
                if (fn.startsWith(pkgName)) {
                    pkgLen = pkgName.length();
                }
            } else {
                pkgLen = 0;
            }
        }
        if (pkgLen < 0 && (finder = JavaCompletion.getFinder()) != null) {
            List clsList;
            if (!preferFinder) {
                cls = finder.getExactClass(fn);
            }
            if (cls == null && (clsList = finder.findClasses(null, fn, true)) != null && clsList.size() == 1) {
                cls = (JCClass)clsList.get(0);
            }
            if (cls != null) {
                cls = JavaCompletion.getSimpleClass(cls);
                lookupCache.put(fn, cls);
                return cls;
            }
        }
        if (pkgLen < 0) {
            pkgLen = Math.max(fn.lastIndexOf(46), 0);
            String pkgName = fn.substring(0, pkgLen);
            int lastDotInd = pkgName.lastIndexOf(46);
            if (lastDotInd == -1 && pkgName.length() > 0 && Character.isUpperCase(pkgName.charAt(0))) {
                pkgLen = 0;
            }
            if (lastDotInd < fn.length() - 1) {
                while (lastDotInd >= 0 && Character.isUpperCase(fn.charAt(lastDotInd + 1))) {
                    pkgName = pkgName.substring(0, lastDotInd);
                    pkgLen = lastDotInd;
                    lastDotInd = pkgName.lastIndexOf(46);
                }
            }
        }
        cls = JavaCompletion.getSimpleClass(fn, pkgLen);
        lookupCache.put(fn, cls);
        return cls;
    }

    static JCType getType(Type t, Map lookupCache, boolean preferFinder) {
        int arrayDepth = 0;
        while (t.isArray()) {
            ++arrayDepth;
            t = t.getElementType();
        }
        JCClass c = t.isPrimitive() ? JavaCompletion.getPrimitiveClass(t.getFullString()) : JCExtension.getIdentifierClass(t.getClassName(), lookupCache, preferFinder);
        return JavaCompletion.getType(c, arrayDepth);
    }

    private static boolean isDeprecated(Object obj) {
        MethodElement me;
        JavaDoc.Method jdMtd;
        JavaDocTag[] jdt = null;
        if (obj instanceof ClassElement) {
            ClassElement ce = (ClassElement)obj;
            JavaDoc.Class jdCls = ce.getJavaDoc();
            if (jdCls != null) {
                jdt = jdCls.getTags("@deprecated");
            }
        } else if (obj instanceof FieldElement) {
            FieldElement fe = (FieldElement)obj;
            JavaDoc.Field jdFld = fe.getJavaDoc();
            if (jdFld != null) {
                jdt = jdFld.getTags("@deprecated");
            }
        } else if (obj instanceof ConstructorElement) {
            ConstructorElement ce = (ConstructorElement)obj;
            JavaDoc.Method jdCon = ce.getJavaDoc();
            if (jdCon != null) {
                jdt = jdCon.getTags("@deprecated");
            }
        } else if (obj instanceof MethodElement && (jdMtd = (me = (MethodElement)obj).getJavaDoc()) != null) {
            jdt = jdMtd.getTags("@deprecated");
        }
        return jdt != null && jdt.length > 0;
    }

    static JCClass parseClassElement(ClassElement ce, int classLevel, int fieldLevel, int methodLevel, Map lookupCache, boolean preferFinder) {
        JCClass sc = JCExtension.getIdentifierClass(ce.getName(), lookupCache, preferFinder);
        if (sc.equals(JavaCompletion.INVALID_CLASS)) {
            return null;
        }
        return new NbJCClass(sc.getName(), sc.getPackageName(), ce.isInterface(), JCExtension.isDeprecated(ce), ce.getModifiers(), ce, classLevel, fieldLevel, methodLevel, lookupCache, preferFinder);
    }

    static class NbJCClass
    extends JavaCompletion.AbstractClass {
        public NbJCClass(String name, String packageName, boolean iface, int modifiers, ClassElement ce, int classLevel, int fieldLevel, int methodLevel, Map lookupCache, boolean preferFinder) {
            this(name, packageName, iface, false, modifiers, ce, classLevel, fieldLevel, methodLevel, lookupCache, preferFinder);
        }

        public NbJCClass(String name, String packageName, boolean iface, boolean deprecated, int modifiers, ClassElement ce, int classLevel, int fieldLevel, int methodLevel, Map lookupCache, boolean preferFinder) {
            super(name, packageName, iface, deprecated, modifiers);
            this.body = new JavaCompletion.AbstractClass.Body();
            ArrayList<Comparable> lst = new ArrayList<Comparable>();
            Identifier sc = ce.getSuperclass();
            this.body.superClass = sc != null ? JCExtension.getIdentifierClass(sc, lookupCache, preferFinder) : (iface ? JavaCompletion.INVALID_CLASS : JavaCompletion.OBJECT_CLASS);
            Identifier[] cei = ce.getInterfaces();
            this.body.interfaces = JavaCompletion.EMPTY_CLASSES;
            if (cei != null) {
                int i = 0;
                while (i < cei.length) {
                    if (cei[i] != null) {
                        lst.add(JCExtension.getIdentifierClass(cei[i], lookupCache, preferFinder));
                    }
                    ++i;
                }
                this.body.interfaces = new JCClass[lst.size()];
                lst.toArray(this.body.interfaces);
                lst.clear();
            }
            FieldElement[] cef = ce.getFields();
            this.body.fields = JavaCompletion.EMPTY_FIELDS;
            if (cef != null) {
                int i = 0;
                while (i < cef.length) {
                    if (cef[i] != null) {
                        int mods = cef[i].getModifiers();
                        if (iface) {
                            mods |= 1;
                        }
                        if (JCExtension.isDeprecated(cef[i])) {
                            mods |= 0x100000;
                        }
                        if (JavaCompletion.getLevel(mods) >= fieldLevel) {
                            lst.add(new JavaCompletion.BaseField(this, cef[i].getName().getName(), JCExtension.getType(cef[i].getType(), lookupCache, preferFinder), mods));
                        }
                    }
                    ++i;
                }
                this.body.fields = new JCField[lst.size()];
                lst.toArray(this.body.fields);
                lst.clear();
            }
            ConstructorElement[] cec = ce.getConstructors();
            this.body.constructors = JavaCompletion.EMPTY_CONSTRUCTORS;
            if (cec != null) {
                int i = 0;
                while (i < cec.length) {
                    if (cec[i] != null && JavaCompletion.getLevel(cec[i].getModifiers()) >= methodLevel) {
                        JCParameter[] parameters = JavaCompletion.EMPTY_PARAMETERS;
                        MethodParameter[] cep = cec[i].getParameters();
                        if (cep != null) {
                            parameters = new JCParameter[cep.length];
                            int j = 0;
                            while (j < cep.length) {
                                parameters[j] = new JavaCompletion.BaseParameter(cep[j].getName(), JCExtension.getType(cep[j].getType(), lookupCache, preferFinder));
                                ++j;
                            }
                        }
                        JCClass[] exceptions = JavaCompletion.EMPTY_CLASSES;
                        Identifier[] cee = cec[i].getExceptions();
                        exceptions = new JCClass[cee.length];
                        int j = 0;
                        while (j < cee.length) {
                            exceptions[j] = JCExtension.getIdentifierClass(cee[j], lookupCache, preferFinder);
                            ++j;
                        }
                        int mods = cec[i].getModifiers();
                        if (JCExtension.isDeprecated(cec[i])) {
                            mods |= 0x100000;
                        }
                        lst.add(new JavaCompletion.BaseConstructor(this, mods, parameters, exceptions));
                    }
                    ++i;
                }
                this.body.constructors = new JCConstructor[lst.size()];
                lst.toArray(this.body.constructors);
                lst.clear();
            }
            MethodElement[] cem = ce.getMethods();
            this.body.methods = JavaCompletion.EMPTY_METHODS;
            if (cem != null) {
                int i = 0;
                while (i < cem.length) {
                    if (cem[i] != null) {
                        int mods = cem[i].getModifiers();
                        if (iface) {
                            mods |= 1;
                        }
                        if (JCExtension.isDeprecated(cem[i])) {
                            mods |= 0x100000;
                        }
                        if (JavaCompletion.getLevel(mods) >= methodLevel) {
                            JCParameter[] parameters = JavaCompletion.EMPTY_PARAMETERS;
                            MethodParameter[] cep = cem[i].getParameters();
                            if (cep != null) {
                                parameters = new JCParameter[cep.length];
                                int j = 0;
                                while (j < cep.length) {
                                    parameters[j] = new JavaCompletion.BaseParameter(cep[j].getName(), JCExtension.getType(cep[j].getType(), lookupCache, preferFinder));
                                    ++j;
                                }
                            }
                            JCClass[] exceptions = JavaCompletion.EMPTY_CLASSES;
                            Identifier[] cee = cem[i].getExceptions();
                            exceptions = new JCClass[cee.length];
                            int j = 0;
                            while (j < cee.length) {
                                exceptions[j] = JCExtension.getIdentifierClass(cee[j], lookupCache, preferFinder);
                                ++j;
                            }
                            lst.add(new JavaCompletion.BaseMethod(this, cem[i].getName().getName(), mods, JCExtension.getType(cem[i].getReturn(), lookupCache, preferFinder), parameters, exceptions));
                        }
                    }
                    ++i;
                }
            }
            this.body.methods = new JCMethod[lst.size()];
            lst.toArray(this.body.methods);
            lst.clear();
        }

        protected void init() {
        }
    }
}

