/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.FileAccessor;
import org.netbeans.editor.ext.java.DAFileProvider;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.modules.editor.java.FileObjectAccessor;
import org.netbeans.modules.editor.java.JCStorageElement;
import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.JavaOptions;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class JCStorage
implements SettingsChangeListener,
PropertyChangeListener {
    private static final String DB_DIR = "ParserDB";
    private static final String STORAGE = "storage";
    private static final String STORAGE_EXT = "ser";
    public static final int STATUS_PARSED = 0;
    public static final int STATUS_PARSING = 1;
    public static final int STATUS_QUEUED = 2;
    public static final int STATUS_CANCELLED = 3;
    public static final String PROP_PROJECTS_CHANGED_START = "projects-changed-start";
    public static final String PROP_PROJECTS_CHANGED_END = "projects-changed-end";
    private PropertyChangeListener wL = WeakListener.propertyChange((PropertyChangeListener)this, null);
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.jcstorage");
    private static final boolean debugUpdater = Boolean.getBoolean("netbeans.debug.editor.updater");
    private static final String PROVIDER_FILE_EXT = "jcs";
    private static boolean inited;
    private static JCStorage storage;
    private FileObject dbFolder;
    private ArrayList elementList = new ArrayList();
    private final Object ELEMENT_LIST_LOCK = new Object();
    private HashSet updatingElements = new HashSet();
    private Map updatedFS = Collections.synchronizedMap(new HashMap());
    private JCFinder finder;
    private PropertyChangeSupport pcs;
    private Set parsingFSQueue = Collections.synchronizedSet(new HashSet());
    private Map paramFinders = new HashMap(5);
    private static final Object PARAM_FINDERS_LOCK;
    private Map params = new HashMap(5);
    private Timer timer;
    private ActionListener timerAction;
    private static final int TIMER_TRESHOLD = 4000;
    private boolean ignoreChanges = false;
    static /* synthetic */ Class class$org$netbeans$editor$ext$java$JavaCompletion;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JCStorage;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

    public static JCStorage getStorage() {
        Class clazz = class$org$netbeans$editor$ext$java$JavaCompletion == null ? (class$org$netbeans$editor$ext$java$JavaCompletion = JCStorage.class$("org.netbeans.editor.ext.java.JavaCompletion")) : class$org$netbeans$editor$ext$java$JavaCompletion;
        synchronized (clazz) {
            Class clazz2 = class$org$netbeans$modules$editor$java$JCStorage == null ? (class$org$netbeans$modules$editor$java$JCStorage = JCStorage.class$("org.netbeans.modules.editor.java.JCStorage")) : class$org$netbeans$modules$editor$java$JCStorage;
            synchronized (clazz2) {
                if (storage == null) {
                    JCStorage.init(Repository.getDefault().getDefaultFileSystem().getRoot());
                }
                JCStorage jCStorage = storage;
                return jCStorage;
            }
        }
    }

    private static void init(FileObject rootFolder) {
        long time = 0L;
        if (debug) {
            System.err.println("JCStorage initing\t" + Thread.currentThread());
            time = System.currentTimeMillis();
        }
        storage = new JCStorage(rootFolder);
        if (debug) {
            System.err.println("JCStorage inited in=" + (System.currentTimeMillis() - time) + "ms");
        }
    }

    JCStorage(FileObject rootFolder) {
        Settings.addSettingsChangeListener(this);
        this.checkDBFolder(rootFolder);
        if (this.dbFolder != null) {
            if (debug) {
                String fsName;
                try {
                    fsName = this.dbFolder.getFileSystem().toString();
                }
                catch (FileStateInvalidException e) {
                    fsName = "<Invalid filesystem>";
                }
                System.err.println("JCStorage.init(): scanning dbFolder='" + this.dbFolder + "' of filesystem='" + fsName + "'");
            }
            this.timerAction = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JCStorage.this.timer.stop();
                    JCStorage.this.refresh();
                }
            };
            this.timer = new Timer(0, this.timerAction);
            this.timer.setRepeats(false);
            this.initElements();
            this.initProviders();
            this.refresh();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (JCStorage.this.getStorageFile(false) == null) {
                        JCStorage.this.checkImportedFS();
                    }
                    JCStorage.this.parseUnfinishedElements();
                }
            }, 1000);
        }
    }

    private void checkDBFolder(FileObject rootFolder) {
        if (rootFolder != null) {
            this.dbFolder = rootFolder.getFileObject(DB_DIR);
        }
    }

    private void parseFSFromQueue() {
        Iterator it;
        if (!this.parsingFSQueue.isEmpty() && (it = this.parsingFSQueue.iterator()).hasNext()) {
            Object obj = it.next();
            this.parseFSOnBackground((FileSystem)obj);
            this.parsingFSQueue.remove(obj);
        }
    }

    private boolean isJDKSourceFS(FileSystem fs) {
        return fs.findResource("java/lang/String.java") != null || fs.findResource("src/java/lang/String.java") != null;
    }

    public void parseFSOnBackground(final FileSystem fs) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            return;
        }
        if (fs == null) {
            return;
        }
        FileObject fo = fs.getRoot();
        FileSystemCapability fsCap = fs.getCapability();
        if (fsCap == null || !fsCap.capableOf(FileSystemCapability.COMPILE)) {
            return;
        }
        if (fo == null || fs.isHidden()) {
            return;
        }
        if (this.isJDKSourceFS(fs)) {
            return;
        }
        JCStorageElement element = this.findFileSystemElement(fs.getSystemName());
        if (element != null && element.getUpdated()) {
            if (debugUpdater) {
                System.err.println("parser DB is already updated:" + fs.getSystemName());
            }
            return;
        }
        if (element != null && this.updatingElements.contains(element)) {
            if (debugUpdater) {
                System.err.println("parser DB is already updated:" + fs.getSystemName());
            }
            return;
        }
        if (!(BaseOptions.getOptions(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit) instanceof JavaOptions)) {
            return;
        }
        JavaOptions jo = (JavaOptions)BaseOptions.getOptions(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit);
        String updation = jo.getUpdatePDAfterMounting();
        if ("pd_never".equals(updation)) {
            return;
        }
        if ("pd_always".equals(updation)) {
            fs.getCapability().addPropertyChangeListener(this.wL);
            if (this.updatedFS.size() > 0) {
                this.parsingFSQueue.add(fs);
                String fsName = fs.getSystemName();
                JCStorageElement elem = this.getElement(fs);
                if (elem == null) {
                    elem = this.addElement(JCUpdater.constructPrefixName(fsName), fsName, 2, 2, 2, true);
                    this.saveElements();
                }
            } else {
                try {
                    DataObject dataObj = DataObject.find((FileObject)fo);
                    Node[] node = new Node[]{dataObj.getNodeDelegate()};
                    if (this.getElement(fs) == null) {
                        String fsName = fs.getSystemName();
                        this.addElement(JCUpdater.constructPrefixName(fsName), fsName, 2, 2, 2, true);
                        this.saveElements();
                    }
                    final JCUpdater update = new JCUpdater(node, false, false);
                    this.updatedFS.put(fs, update);
                    update.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent e) {
                            if (e == null) {
                                return;
                            }
                            if ("parsing_finished".equals(e.getPropertyName()) && update != null) {
                                update.removePropertyChangeListener(this);
                                JCStorage.this.updatedFS.remove(fs);
                                JCStorage.this.parsingFSQueue.remove(fs);
                                fs.getCapability().removePropertyChangeListener(JCStorage.this.wL);
                                String evtNewValue = (String)e.getNewValue();
                                if (JCStorage.this.ignoreChanges) {
                                    return;
                                }
                                if ("finished-interrupted".equals(evtNewValue)) {
                                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format(JCStorage.this.getBundleString("JC_parsing_cancelled_status_displayer"), fs.getDisplayName()));
                                    JCStorageElement elem = JCStorage.this.getElement(fs);
                                    if (elem != null) {
                                        JCStorage.this.deleteFile(elem, false);
                                        JCStorage.this.removeElement(elem.getName(), false);
                                        JCStorage.this.saveElements();
                                        try {
                                            Thread.sleep(10000L);
                                        }
                                        catch (InterruptedException ie) {
                                            // empty catch block
                                        }
                                        JCStorage.this.refresh();
                                    }
                                } else if ("finished-cancelled".equals(evtNewValue)) {
                                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format(JCStorage.this.getBundleString("JC_parsing_cancelled_status_displayer"), fs.getDisplayName()));
                                    JCStorageElement elem = JCStorage.this.getElement(fs);
                                    if (elem != null) {
                                        elem.setCancelled(true);
                                        JCStorage.this.saveElements();
                                    }
                                    JCStorage.this.firePropertyChange(null, null, null);
                                } else {
                                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format("finished-stopped".equals(evtNewValue) ? JCStorage.this.getBundleString("JC_parsing_cancelled_status_displayer") : JCStorage.this.getBundleString("JC_parsing_finished_status_displayer"), fs.getDisplayName()));
                                    JCStorage.this.firePropertyChange(null, null, null);
                                }
                                JCStorage.this.parseFSFromQueue();
                            }
                        }
                    });
                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format(this.getBundleString("JC_creating_parserDB_status_displayer"), fs.getDisplayName()));
                    update.start();
                }
                catch (DataObjectNotFoundException notFound) {
                    // empty catch block
                }
            }
        }
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JCStorage == null ? (class$org$netbeans$modules$editor$java$JCStorage = JCStorage.class$("org.netbeans.modules.editor.java.JCStorage")) : class$org$netbeans$modules$editor$java$JCStorage), (String)s);
    }

    public void removeParsedFS(FileSystem fs) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            return;
        }
        if (fs == null || fs.isHidden()) {
            return;
        }
        this.parsingFSQueue.remove(fs);
        if (this.updatedFS.containsKey(fs)) {
            JCUpdater updater;
            if (debugUpdater) {
                System.err.println("removing parsed FS:" + fs.getSystemName());
            }
            if ((updater = (JCUpdater)this.updatedFS.get(fs)) != null && updater.isAlive()) {
                updater.interruptTask();
            }
        } else {
            JCStorageElement elem;
            FileSystemCapability fsCap = fs.getCapability();
            if (fsCap != null) {
                fsCap.removePropertyChangeListener(this.wL);
            }
            if ((elem = this.getElement(fs)) != null && elem.getName() != null) {
                this.deleteFile(elem, false);
                this.removeElement(elem.getName(), false);
                this.refreshLater();
                this.saveElements();
            }
        }
    }

    private void parseUnfinishedElements() {
        JCStorageElement[] elems = this.getElements();
        int i = 0;
        while (i < elems.length) {
            if (!elems[i].getUpdated() && !elems[i].getCancelled()) {
                if (debugUpdater) {
                    System.err.println("Unfinished parser DB element found:" + elems[i].getFileSystemName());
                }
                if (elems[i].getFileSystemName() != null) {
                    FileSystem filesys = Repository.getDefault().findFileSystem(elems[i].getFileSystemName());
                    if (filesys != null) {
                        this.parseFSOnBackground(filesys);
                    } else if (debugUpdater) {
                        System.err.println("FS is not mounted, unfinished element will not be reparsed:" + elems[i].getFileSystemName());
                    }
                }
            }
            ++i;
        }
    }

    public int getFSStatus(FileSystem fs) {
        if (this.updatedFS.containsKey(fs)) {
            return 1;
        }
        if (this.parsingFSQueue.contains(fs)) {
            return 2;
        }
        JCStorageElement elem = this.getElement(fs);
        if (elem != null && elem.getCancelled()) {
            return 3;
        }
        return 0;
    }

    public void stopFSParsing(FileSystem fs) {
        if (fs == null) {
            return;
        }
        this.parsingFSQueue.remove(fs);
        JCStorageElement elem = this.getElement(fs);
        if (elem != null) {
            elem.setCancelled(true);
            this.saveElements();
        }
        if (this.updatedFS.containsKey(fs)) {
            JCUpdater updater;
            if (debugUpdater) {
                System.err.println("Stopping parsed FS:" + fs.getSystemName());
            }
            if ((updater = (JCUpdater)this.updatedFS.get(fs)) != null && updater.isAlive()) {
                updater.stopTask();
            }
        } else {
            FileSystemCapability fsCap = fs.getCapability();
            if (fsCap != null) {
                fsCap.removePropertyChangeListener(this.wL);
            }
        }
        this.firePropertyChange(null, null, null);
    }

    FileObject getParserDBFile(String fileNamePrefix, String fileExt) {
        FileObject ret = null;
        if (this.dbFolder != null) {
            return this.dbFolder.getFileObject(fileNamePrefix, fileExt);
        }
        return ret;
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPCS().firePropertyChange(propertyName, oldValue, newValue);
    }

    static boolean isInitialized() {
        return storage != null;
    }

    private File getStorageFile(boolean createStorageFile) {
        File storage = null;
        if (this.dbFolder == null) {
            return null;
        }
        FileObject storageFO = this.dbFolder.getFileObject(STORAGE, STORAGE_EXT);
        try {
            if (createStorageFile && storageFO == null) {
                storageFO = this.dbFolder.createData(STORAGE, STORAGE_EXT);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (storageFO != null) {
            storage = FileUtil.toFile((FileObject)storageFO);
        }
        return storage;
    }

    private void checkImportedFS() {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            return;
        }
        Enumeration filesystems = Repository.getDefault().getFileSystems();
        while (filesystems.hasMoreElements()) {
            this.parseFSOnBackground((FileSystem)filesystems.nextElement());
        }
    }

    private void initElements() {
        try {
            ArrayList list = null;
            File storage = this.getStorageFile(false);
            if (storage != null && storage.exists()) {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(storage));
                list = (ArrayList)is.readObject();
                is.close();
            }
            Object object = this.ELEMENT_LIST_LOCK;
            synchronized (object) {
                this.elementList = list != null ? list : new ArrayList();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveElements() {
        block6: {
            if (this.ignoreChanges) {
                return;
            }
            try {
                File storage = this.getStorageFile(true);
                if (storage == null) break block6;
                ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(storage));
                Object object = this.ELEMENT_LIST_LOCK;
                synchronized (object) {
                    os.writeObject(this.elementList);
                }
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public JCStorageElement[] getElements() {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            JCStorageElement[] jcse = new JCStorageElement[this.elementList.size()];
            this.elementList.toArray(jcse);
            JCStorageElement[] jCStorageElementArray = jcse;
            return jCStorageElementArray;
        }
    }

    public JCStorageElement getElement(String name) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int i = this.elementList.indexOf(new JCStorageElement(name));
            if (i >= 0) {
                JCStorageElement jCStorageElement = (JCStorageElement)this.elementList.get(i);
                return jCStorageElement;
            }
            JCStorageElement jCStorageElement = null;
            return jCStorageElement;
        }
    }

    private JCStorageElement getElement(FileSystem fs) {
        if (fs == null) {
            return null;
        }
        JCStorageElement[] jce = this.getElements();
        int i = 0;
        while (i < jce.length) {
            if (fs.getSystemName().equals(jce[i].getFileSystemName())) {
                return jce[i];
            }
            ++i;
        }
        return null;
    }

    private void initProviders() {
        if (this.dbFolder != null) {
            Enumeration en = this.dbFolder.getData(false);
            while (en.hasMoreElements()) {
                JCStorageElement e;
                FileObject fo = (FileObject)en.nextElement();
                if (debug) {
                    System.err.println("JCStorage.initProviders(): fileObject='" + fo + "'");
                }
                if (!PROVIDER_FILE_EXT.equals(fo.getExt()) || !fo.existsExt("jcb")) continue;
                String name = fo.getName();
                FileObject bodyFO = this.dbFolder.getFileObject(name, "jcb");
                DAFileProvider provider = new DAFileProvider(new FileObjectAccessor(fo), new FileObjectAccessor(bodyFO));
                if (debug) {
                    System.err.println("JCStorage.initProviders():   body file exists: " + bodyFO);
                }
                if ((e = this.getElement(name)) != null) {
                    e.setProvider(provider);
                    continue;
                }
                e = new JCStorageElement(name);
                e.setProvider(provider);
                this.addElement(e);
            }
        }
    }

    public void deleteFile(JCStorageElement elem) {
        this.deleteFile(elem, true);
    }

    private void deleteFile(JCStorageElement elem, boolean removeElement) {
        if (elem == null || elem.getName() == null) {
            return;
        }
        String fsName = elem.getFileSystemName();
        if (fsName != null) {
            FileSystem filesys = Repository.getDefault().findFileSystem(elem.getFileSystemName());
            JCUpdater updater = (JCUpdater)this.updatedFS.get(filesys);
            if (updater != null && updater.isAlive()) {
                updater.interruptTask();
                return;
            }
            this.parsingFSQueue.remove(filesys);
        }
        try {
            DataObject body;
            DataObject skel;
            FileObject skelFO = this.getParserDBFile(elem.getName(), PROVIDER_FILE_EXT);
            FileObject bodyFO = this.getParserDBFile(elem.getName(), "jcb");
            if (skelFO != null && (skel = DataObject.find((FileObject)skelFO)) != null) {
                try {
                    skel.delete();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
            if (bodyFO != null && (body = DataObject.find((FileObject)bodyFO)) != null) {
                try {
                    body.delete();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
            if (removeElement) {
                this.removeElement(elem.getName());
            }
        }
        catch (DataObjectNotFoundException donfe) {
            // empty catch block
        }
    }

    void removeElement(String name) {
        this.removeElement(name, true);
    }

    private void removeElement(String name, boolean refresh) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int cnt = this.elementList.size();
            int i = 0;
            while (i < cnt) {
                if (name.equals(((JCStorageElement)this.elementList.get(i)).getName())) {
                    this.elementList.remove(i);
                    --cnt;
                }
                ++i;
            }
        }
        this.saveElements();
        this.firePropertyChange(null, null, null);
        if (refresh) {
            this.refresh();
        }
    }

    public JCStorageElement findFileSystemElement(String fsName) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            Iterator i = ((AbstractList)this.elementList).iterator();
            while (i.hasNext()) {
                JCStorageElement e = (JCStorageElement)i.next();
                if (!fsName.equals(e.getFileSystemName())) continue;
                JCStorageElement jCStorageElement = e;
                return jCStorageElement;
            }
            JCStorageElement jCStorageElement = null;
            return jCStorageElement;
        }
    }

    void removeFileSystemElement(String fsName) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int cnt = this.elementList.size();
            int i = 0;
            while (i < cnt) {
                if (fsName.equals(((JCStorageElement)this.elementList.get(i)).getFileSystemName())) {
                    this.elementList.remove(i);
                    --cnt;
                }
                ++i;
            }
        }
    }

    private void addElement(JCStorageElement e) {
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            int i = this.elementList.indexOf(e);
            if (i >= 0) {
                this.elementList.set(i, e);
            } else {
                this.elementList.add(e);
                this.firePropertyChange(null, null, null);
            }
        }
    }

    public JCStorageElement addElement(String name, String fsName, int classLevel, int fieldLevel, int methodLevel) {
        return this.addElement(name, fsName, classLevel, fieldLevel, methodLevel, true);
    }

    public JCStorageElement addElement(String name, String fsName, int classLevel, int fieldLevel, int methodLevel, boolean autoUpdate) {
        JCStorageElement e = new JCStorageElement(name, fsName, classLevel, fieldLevel, methodLevel, autoUpdate);
        this.removeFileSystemElement(fsName);
        this.addElement(e);
        this.saveElements();
        return e;
    }

    public void checkProvider(JCStorageElement e) {
        if (e.getProvider() == null && this.dbFolder != null) {
            String name = e.getName();
            String ext = PROVIDER_FILE_EXT;
            FileObject skelFO = this.dbFolder.getFileObject(name, ext);
            try {
                if (skelFO == null) {
                    skelFO = this.dbFolder.createData(name, ext);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (skelFO != null) {
                ext = "jcb";
                FileObject bodyFO = this.dbFolder.getFileObject(name, ext);
                try {
                    if (bodyFO == null) {
                        bodyFO = this.dbFolder.createData(name, ext);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (bodyFO != null) {
                    DAFileProvider cp = new DAFileProvider(new FileObjectAccessor(skelFO), new FileObjectAccessor(bodyFO));
                    cp.reset();
                    e.setProvider(cp);
                }
            }
        }
    }

    public JCFinder getFinder(boolean caseSensitive, boolean naturalSort, boolean showDeprecatedMembers) {
        JCFinder finderParam = null;
        if (caseSensitive == this.getCaseSensitive() && naturalSort == this.getNaturalSort() && showDeprecatedMembers == this.getShowDeprecated()) {
            return JavaCompletion.getFinder();
        }
        Object object = PARAM_FINDERS_LOCK;
        synchronized (object) {
            SoftReference softRef = (SoftReference)this.paramFinders.get(null);
            if (softRef != null) {
                finderParam = (JCFinder)softRef.get();
            }
            FinderParams prms = (FinderParams)this.params.get(null);
            if (finderParam == null || prms == null || caseSensitive != prms.isCaseSensitive() || naturalSort != prms.isNaturalSort() || showDeprecatedMembers != prms.isShowDeprecatedMembers()) {
                finderParam = new JCBaseFinder();
                ((JCBaseFinder)this.finder).setCaseSensitive(caseSensitive);
                ((JCBaseFinder)this.finder).setNaturalSort(naturalSort);
                ((JCBaseFinder)this.finder).setShowDeprecated(showDeprecatedMembers);
                this.params.put(null, new FinderParams(caseSensitive, naturalSort, showDeprecatedMembers));
                this.paramFinders.put(null, new SoftReference<JCFinder>(finderParam));
            }
        }
        JCStorage jCStorage = this;
        synchronized (jCStorage) {
            Object object2 = this.ELEMENT_LIST_LOCK;
            synchronized (object2) {
                Iterator i = ((AbstractList)this.elementList).iterator();
                while (i.hasNext()) {
                    JCStorageElement e = (JCStorageElement)i.next();
                    if (e.getProvider() == null || this.updatingElements.contains(e)) continue;
                    finderParam.append(e.getProvider());
                }
            }
        }
        return finderParam;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        FileSystemCapability fscap = (FileSystemCapability)evt.getSource();
        if (!fscap.capableOf(FileSystemCapability.COMPILE)) {
            ArrayList updatingFS = new ArrayList(this.updatedFS.keySet());
            updatingFS.addAll(this.parsingFSQueue);
            int i = 0;
            while (i < updatingFS.size()) {
                FileSystemCapability updFSCap;
                FileSystem updFS = (FileSystem)updatingFS.get(i);
                if (updFS != null && (updFSCap = updFS.getCapability()) != null && !updFSCap.capableOf(FileSystemCapability.COMPILE)) {
                    this.removeParsedFS(updFS);
                }
                ++i;
            }
        }
    }

    private void refreshLater() {
        this.timer.stop();
        this.timer.setInitialDelay(4000);
        this.timer.setDelay(4000);
        this.timer.start();
    }

    public void refresh() {
        if (this.ignoreChanges) {
            return;
        }
        this.finder = new JCBaseFinder();
        ((JCBaseFinder)this.finder).setCaseSensitive(this.getCaseSensitive());
        ((JCBaseFinder)this.finder).setNaturalSort(this.getNaturalSort());
        ((JCBaseFinder)this.finder).setShowDeprecated(this.getShowDeprecated());
        JavaCompletion.setFinder(this.finder);
        JCFinder finderParam = null;
        Object object = PARAM_FINDERS_LOCK;
        synchronized (object) {
            SoftReference softRef = (SoftReference)this.paramFinders.get(null);
            if (softRef != null) {
                finderParam = (JCFinder)softRef.get();
            }
        }
        JCStorage jCStorage = this;
        synchronized (jCStorage) {
            Object object2 = this.ELEMENT_LIST_LOCK;
            synchronized (object2) {
                Iterator i = ((AbstractList)this.elementList).iterator();
                while (i.hasNext()) {
                    JCStorageElement e = (JCStorageElement)i.next();
                    if (e.getProvider() == null || this.updatingElements.contains(e)) continue;
                    this.finder.append(e.getProvider());
                    if (finderParam == null) continue;
                    finderParam.append(e.getProvider());
                }
            }
        }
    }

    public synchronized void addProcessedElement(JCStorageElement elem) {
        this.updatingElements.add(elem);
    }

    public synchronized void removeProcessedElement(JCStorageElement elem) {
        this.updatingElements.remove(elem);
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.err.println("arg1=base-source-dir arg2=target-file-prefix arg3=class-level arg4=field-level arg5=method-level\nStorage level: 0=all, 1=not private 2=public and protected, 3=public only\nExample of args: e:\\java\\jdk12\\src e:\\NB\\system\\ParserDB\\jdk12 2 2 2");
            return;
        }
        int classLevel = Integer.parseInt(args[2]);
        int fieldLevel = Integer.parseInt(args[3]);
        int methodLevel = Integer.parseInt(args[4]);
        System.out.println("Inspecting classes ...");
        List classNameList = JCUtilities.getClassNameList(args[0]);
        List classList = JCUtilities.getClassList(classNameList, true, classLevel, fieldLevel, methodLevel);
        File skels = new File(args[1] + "." + PROVIDER_FILE_EXT);
        File bodies = new File(args[1] + "." + "jcb");
        final int[] cnt = new int[1];
        DAFileProvider fp = new DAFileProvider(new FileAccessor(skels), new FileAccessor(bodies));
        fp.reset();
        JavaCompletion.ListProvider classes = new JavaCompletion.ListProvider(classList){

            public boolean notifyAppend(JCClass c, boolean appendFinished) {
                if (appendFinished) {
                    System.out.println("Building " + c.getFullName() + " ...");
                    cnt[0] = cnt[0] + 1;
                }
                return true;
            }
        };
        long tm = System.currentTimeMillis();
        fp.append(classes);
        System.out.println(cnt[0] + " classes rebuilt in " + (System.currentTimeMillis() - tm) + "ms.");
        System.out.println("Files created:\nSkeleton file: " + skels.getAbsolutePath() + ", length=" + skels.length() + "\nBody file: " + bodies.getAbsolutePath() + ", length=" + bodies.length());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object object = this.ELEMENT_LIST_LOCK;
        synchronized (object) {
            Iterator i = ((AbstractList)this.elementList).iterator();
            while (i.hasNext()) {
                sb.append(((JCStorageElement)i.next()).toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private boolean getCaseSensitive() {
        return (Boolean)SettingsUtil.getValue(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit, "completion-case-sensitive", ExtSettingsDefaults.defaultCompletionCaseSensitive);
    }

    private boolean getNaturalSort() {
        return (Boolean)SettingsUtil.getValue(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit, "completion-natural-sort", ExtSettingsDefaults.defaultCompletionNaturalSort);
    }

    private boolean getShowDeprecated() {
        return (Boolean)SettingsUtil.getValue(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JCStorage.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit, "show-deprecated-members", ExtSettingsDefaults.defaultShowDeprecatedMembers);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (this.finder == null || !(this.finder instanceof JCBaseFinder)) {
            return;
        }
        ((JCBaseFinder)this.finder).setCaseSensitive(this.getCaseSensitive());
        ((JCBaseFinder)this.finder).setNaturalSort(this.getNaturalSort());
        ((JCBaseFinder)this.finder).setShowDeprecated(this.getShowDeprecated());
    }

    public void ignoreChanges(boolean ignore, boolean save) {
        if (ignore) {
            if (save) {
                this.firePropertyChange(PROP_PROJECTS_CHANGED_START, null, null);
                this.parsingFSQueue.clear();
                this.saveElements();
                Object object = this.ELEMENT_LIST_LOCK;
                synchronized (object) {
                    this.elementList.clear();
                }
                ArrayList updatingFS = new ArrayList(this.updatedFS.values());
                int i = 0;
                while (i < updatingFS.size()) {
                    JCUpdater updater = (JCUpdater)updatingFS.get(i);
                    if (updater != null && updater.isAlive()) {
                        updater.interruptTask();
                    }
                    ++i;
                }
            }
        } else {
            this.firePropertyChange(PROP_PROJECTS_CHANGED_END, null, null);
            JavaCompletion.setFinder(new JCBaseFinder());
            this.initElements();
            if (this.getStorageFile(false) == null) {
                this.checkImportedFS();
            }
            this.initProviders();
            this.refreshLater();
            this.parseUnfinishedElements();
            this.firePropertyChange(null, null, null);
        }
        this.ignoreChanges = ignore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PARAM_FINDERS_LOCK = new Object();
    }

    private static class FinderParams {
        boolean caseSensitive;
        boolean naturalSort;
        boolean showDeprecatedMembers;

        public FinderParams(boolean caseSensitive, boolean naturalSort, boolean showDeprecatedMembers) {
            this.caseSensitive = caseSensitive;
            this.naturalSort = naturalSort;
            this.showDeprecatedMembers = showDeprecatedMembers;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public boolean isNaturalSort() {
            return this.naturalSort;
        }

        public boolean isShowDeprecatedMembers() {
            return this.showDeprecatedMembers;
        }
    }
}

