/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.io.Serializable;
import org.netbeans.editor.ext.java.JCClassProvider;

public class JCStorageElement
implements Serializable {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.updater");
    String name;
    String fileSystemName;
    private int classLevel;
    private int fieldLevel;
    private int methodLevel;
    private boolean autoUpdate;
    private boolean updated;
    private boolean cancelled;
    private transient JCClassProvider provider;
    public static final int CURRENT_VERSION = 2;
    private int version = 1;
    static final long serialVersionUID = -8525995534921942711L;

    public JCStorageElement() {
    }

    public JCStorageElement(String name) {
        this.name = name;
    }

    public JCStorageElement(String name, String fileSystemName, int classLevel, int fieldLevel, int methodLevel) {
        this(name, fileSystemName, classLevel, fieldLevel, methodLevel, true);
    }

    public JCStorageElement(String name, String fileSystemName, int classLevel, int fieldLevel, int methodLevel, boolean autoUpdate) {
        this.name = name;
        this.fileSystemName = fileSystemName;
        this.classLevel = classLevel;
        this.fieldLevel = fieldLevel;
        this.methodLevel = methodLevel;
        this.autoUpdate = autoUpdate;
        this.version = 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    public int getClassLevel() {
        return this.classLevel;
    }

    public void setClassLevel(int classLevel) {
        this.classLevel = classLevel;
    }

    public int getFieldLevel() {
        return this.fieldLevel;
    }

    public void setFieldLevel(int fieldLevel) {
        this.fieldLevel = fieldLevel;
    }

    public int getMethodLevel() {
        return this.methodLevel;
    }

    public void setMethodLevel(int methodLevel) {
        this.methodLevel = methodLevel;
    }

    public JCClassProvider getProvider() {
        return this.provider;
    }

    public void setProvider(JCClassProvider provider) {
        this.provider = provider;
    }

    public void setAutoUpdate(boolean auto) {
        this.autoUpdate = auto;
    }

    public boolean getAutoUpdate() {
        this.checkVersion();
        return this.autoUpdate;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
        this.setCancelled(false);
    }

    public boolean getUpdated() {
        this.checkVersion();
        return this.updated;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion() {
        this.version = this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JCStorageElement) {
            return this.name.equals(((JCStorageElement)o).name);
        }
        if (o instanceof String) {
            return this.name.equals((String)o);
        }
        return false;
    }

    private void checkVersion() {
        if (this.version >= 2) {
            return;
        }
        if (this.version <= 1) {
            this.version = 2;
            if (this.fileSystemName != null) {
                if (debug) {
                    System.err.println("old version of parser DB element => autoUpd = true, updated = true:" + this.getFileSystemName());
                }
                this.autoUpdate = true;
            }
            this.updated = true;
        }
    }

    public String toString() {
        return "name='" + this.name + "', fileSystemName='" + this.fileSystemName + "', classLevel=" + this.classLevel + ", fieldLevel=" + this.fieldLevel + ", methodLevel=" + this.methodLevel + ", provider=" + this.provider;
    }
}

