/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.editor.ext.java.DAFileProvider;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCClassProvider2;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JCProgressPanel;
import org.netbeans.modules.editor.java.JCProviderPanel;
import org.netbeans.modules.editor.java.JCStorage;
import org.netbeans.modules.editor.java.JCStorageElement;
import org.netbeans.modules.editor.java.JCUpdater;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.NbBundle;
import org.openide.util.enum.QueueEnumeration;

public class JCUpdater
extends Thread
implements PropertyChangeListener {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.updater");
    private static final String BUNDLE_TITLE = "JC_title";
    private static final String BUNDLE_INSPECTING = "JC_inspecting";
    private static final String BUNDLE_BUILDING_CLASS = "JC_building_class";
    private static final String BUNDLE_INIT_PARSER = "JC_init_parser";
    private static final String BUNDLE_UPDATING_DB = "JC_updating_db";
    private static final String BUNDLE_UPDATING_MEMORY = "JC_updating_memory";
    private static final String BUNDLE_ENTRIES = "JC_entries";
    private static final String BUNDLE_CLASSES_FOUND = "JC_classes_found";
    private static final String BUNDLE_CLASSES_DONE = "JC_classes_done";
    private static final String BUNDLE_CLASSES_DONE_OF = "JC_classes_done_of";
    public static final String PROP_MOUNT_FS = "mount_fs";
    public static final String PROP_PARSING_INTERRUPTED = "parsing_interrupted";
    public static final String PROP_PARSING_FINISHED = "parsing_finished";
    Node[] activatedNodes;
    public static final String FINISHED_NORMAL = "finished-normal";
    public static final String FINISHED_INTERRUPTED = "finished-interrupted";
    public static final String FINISHED_STOPPED = "finished-stopped";
    public static final String FINISHED_CANCELLED = "finished-cancelled";
    private boolean interruptTask = false;
    private String finishedStatus = "finished-normal";
    static ArrayList processedNodes = new ArrayList();
    Map lookupCache;
    int doneCnt;
    private PropertyChangeSupport pcs;
    private boolean displayMount = false;
    private boolean mountFilesystem = false;
    private boolean displayProviderPanel = true;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JCUpdater;

    public JCUpdater() {
        this.setName("ParserDB Updater");
    }

    public JCUpdater(Node[] activatedNodes) {
        this(activatedNodes, false, true);
    }

    public JCUpdater(Node[] activatedNodes, boolean displayMount) {
        this(activatedNodes, displayMount, true);
    }

    public JCUpdater(Node[] activatedNodes, boolean displayMount, boolean displayProviderPanel) {
        this.activatedNodes = activatedNodes;
        this.displayMount = displayMount;
        this.displayProviderPanel = displayProviderPanel;
        this.setName("ParserDB Updater");
        JCStorage.getStorage().addPropertyChangeListener(this);
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPCS().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "projects-changed-start".equals(evt.getPropertyName())) {
            this.stopTask();
        }
    }

    public void interruptTask() {
        this.interruptTask = true;
        this.finishedStatus = FINISHED_INTERRUPTED;
    }

    void stopTask() {
        this.interruptTask = true;
        this.finishedStatus = FINISHED_STOPPED;
    }

    public void run() {
        if (!this.displayProviderPanel) {
            this.setPriority(1);
        }
        ProgressPanel progress = new ProgressPanel();
        try {
            this.lookupCache = new HashMap(89);
            Node[] nodes = (Node[])this.activatedNodes.clone();
            this.activatedNodes = null;
            int i = 0;
            while (i < nodes.length) {
                Node n = nodes[i];
                if (this.getFS(n) == null || !processedNodes.contains(n)) {
                    if (this.displayProviderPanel) {
                        progress.setDialogVisible(true);
                        progress.invokeSetBuilding(this.getBundleString(BUNDLE_INSPECTING));
                        progress.invokeSetCurrentClass("");
                        progress.invokeSetDoneString("");
                    }
                    this.doneCnt = 0;
                    if (!this.processNode(n, progress)) {
                        if (progress == null || !this.displayProviderPanel) break;
                        this.finishedStatus = FINISHED_CANCELLED;
                        JCStorage.getStorage().stopFSParsing(this.getFS(n));
                        break;
                    }
                    nodes[i] = null;
                }
                ++i;
            }
            this.lookupCache.clear();
            this.lookupCache = null;
            progress.setDialogVisible(false);
            progress.destroy();
            progress = null;
        }
        catch (Throwable t) {
            System.err.println("Exception occurred during Code Completion Database rebuilding");
            t.printStackTrace();
            progress.setDialogVisible(false);
            progress.destroy();
            progress = null;
        }
        this.firePropertyChange(PROP_MOUNT_FS, null, this.mountFilesystem ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange(PROP_PARSING_INTERRUPTED, null, FINISHED_INTERRUPTED.equals(this.finishedStatus) ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange(PROP_PARSING_FINISHED, null, this.finishedStatus);
    }

    private FileSystem getFS(Node nod) {
        DataFolder df = (DataFolder)nod.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = JCUpdater.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        try {
            if (df != null) {
                FileObject fo = df.getPrimaryFile();
                return fo.getFileSystem();
            }
            SourceCookie sc = (SourceCookie)nod.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JCUpdater.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
            if (sc != null) {
                return ((DataObject)nod.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JCUpdater.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)).getPrimaryFile().getFileSystem();
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean processNode(Node n, ProgressPanel progress) {
        block18: {
            boolean e222;
            block17: {
                boolean e222;
                block16: {
                    boolean e222;
                    block15: {
                        QueueEnumeration qe = new QueueEnumeration();
                        int cnt = 0;
                        boolean root = false;
                        String fsName = null;
                        DataFolder df = (DataFolder)n.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = JCUpdater.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                        if (this.getFS(n) != null && processedNodes.contains(this.getFS(n))) {
                            if (!debug) return true;
                            System.err.println("FS is already updating:" + this.getFS(n).getSystemName());
                            return true;
                        }
                        try {
                            JCStorageElement element;
                            block14: {
                                if (this.getFS(n) != null) {
                                    processedNodes.add(this.getFS(n));
                                }
                                try {
                                    if (df != null) {
                                        if (!this.inspectFolder(df, qe, progress)) {
                                            boolean bl = false;
                                            Object var10_14 = null;
                                            if (this.getFS(n) == null) return bl;
                                            ((AbstractCollection)processedNodes).remove(this.getFS(n));
                                            return bl;
                                        }
                                        cnt = this.doneCnt;
                                        this.doneCnt = 0;
                                        FileObject fo = df.getPrimaryFile();
                                        fsName = fo.getFileSystem().getSystemName();
                                        root = fo.isRoot();
                                        break block14;
                                    }
                                    SourceCookie sc = (SourceCookie)n.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JCUpdater.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                                    if (sc != null) {
                                        cnt = 1;
                                        qe.put((Object)sc);
                                        fsName = ((DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JCUpdater.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)).getPrimaryFile().getFileSystem().getSystemName();
                                    }
                                }
                                catch (FileStateInvalidException e222) {
                                    // empty catch block
                                }
                            }
                            if (cnt > 0 && fsName != null) {
                                if (progress != null) {
                                    if (this.displayProviderPanel) {
                                        e222 = progress.cancelled ? false : this.updateProvider(qe, cnt, fsName, root, progress);
                                        break block15;
                                    }
                                    e222 = this.updateProviderOnBackground(qe, cnt, fsName, root);
                                    break block16;
                                }
                                e222 = this.updateProviderOnBackground(qe, cnt, fsName, root);
                                break block17;
                            }
                            if (cnt != 0 || fsName == null) break block18;
                            if (debug) {
                                System.err.println("FS doesn't contain source files:" + fsName);
                            }
                            if ((element = JCStorage.getStorage().findFileSystemElement(fsName)) != null) {
                                element.setUpdated(true);
                                JCStorage.getStorage().saveElements();
                            }
                            break block18;
                        }
                        catch (Throwable throwable) {
                            Object var10_19 = null;
                            if (this.getFS(n) == null) throw throwable;
                            ((AbstractCollection)processedNodes).remove(this.getFS(n));
                            throw throwable;
                        }
                    }
                    Object var10_15 = null;
                    if (this.getFS(n) == null) return e222;
                    ((AbstractCollection)processedNodes).remove(this.getFS(n));
                    return e222;
                }
                Object var10_16 = null;
                if (this.getFS(n) == null) return e222;
                ((AbstractCollection)processedNodes).remove(this.getFS(n));
                return e222;
            }
            Object var10_17 = null;
            if (this.getFS(n) == null) return e222;
            ((AbstractCollection)processedNodes).remove(this.getFS(n));
            return e222;
        }
        Object var10_18 = null;
        if (this.getFS(n) == null) return true;
        ((AbstractCollection)processedNodes).remove(this.getFS(n));
        return true;
    }

    boolean inspectFolder(DataFolder df, QueueEnumeration qe, ProgressPanel progress) {
        if (this.interruptTask) {
            return false;
        }
        DataObject[] children = df.getChildren();
        children = (DataObject[])children.clone();
        boolean validFolder = false;
        boolean wrongMountPointFound = false;
        int i = 0;
        while (i < children.length) {
            SourceCookie sc;
            if (progress != null && progress.cancelled) {
                return false;
            }
            DataObject dob = children[i];
            if (dob instanceof DataFolder) {
                if (progress != null) {
                    progress.invokeSetCurrentClass(Integer.toString(this.doneCnt) + " " + this.getBundleString(BUNDLE_CLASSES_FOUND));
                }
                if (!this.inspectFolder((DataFolder)dob, qe, progress)) {
                    return false;
                }
            } else if (!validFolder && !wrongMountPointFound && (sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? JCUpdater.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie)) != null) {
                validFolder = true;
                if (!this.isValidMountPoint(sc, df)) {
                    String pkgFullName = sc.getSource().getPackage() == null ? "" : sc.getSource().getPackage().getFullName();
                    String className = dob.getName();
                    String message = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JCUpdater == null ? JCUpdater.class$("org.netbeans.modules.editor.java.JCUpdater") : class$org$netbeans$modules$editor$java$JCUpdater)).getString("ERR_Wrong_mounting_point"), className, pkgFullName, df.getPrimaryFile().getPackageName('.'));
                    if (this.displayProviderPanel) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)message, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    } else if (debug) {
                        System.err.println(message);
                    }
                    wrongMountPointFound = true;
                }
            }
            children[i] = null;
            ++i;
        }
        if (validFolder && !wrongMountPointFound) {
            qe.put((Object)df);
            ++this.doneCnt;
        }
        return true;
    }

    private boolean isValidMountPoint(SourceCookie sc, DataFolder df) {
        if (sc.getSource() != null) {
            String pkgFullName;
            String string = pkgFullName = sc.getSource().getPackage() == null ? "" : sc.getSource().getPackage().getFullName();
            if (df.getPrimaryFile().getPackageName('.').equals(pkgFullName)) {
                return true;
            }
        }
        return false;
    }

    public static synchronized boolean removeClass(FileObject fo, String oldName) {
        if (fo == null) {
            return false;
        }
        try {
            String newClassName;
            String fsName = fo.getFileSystem().getSystemName();
            JCStorage storage = JCStorage.getStorage();
            if (storage == null) {
                return false;
            }
            JCStorageElement element = storage.findFileSystemElement(fsName);
            if (element == null) {
                return false;
            }
            if (!element.getAutoUpdate()) {
                return false;
            }
            String string = newClassName = oldName == null ? fo.getPackageName('.') : oldName;
            if (element.getProvider() instanceof JCClassProvider2) {
                ((JCClassProvider2)element.getProvider()).remove(new JavaCompletion.SingleProvider(JavaCompletion.createSimpleClass(newClassName)));
            }
            if (JavaCompletion.getFinder() instanceof JCClassProvider2) {
                ((JCClassProvider2)((Object)JavaCompletion.getFinder())).remove(new JavaCompletion.SingleProvider(JavaCompletion.createSimpleClass(newClassName)));
            }
            return true;
        }
        catch (FileStateInvalidException e) {
            return false;
        }
    }

    private boolean appendSource(SourceCookie sc, JCStorageElement element, ProgressPanel progress, Map cache) {
        if (this.interruptTask) {
            return false;
        }
        int classLevel = element.getClassLevel();
        int fieldLevel = element.getFieldLevel();
        int methodLevel = element.getMethodLevel();
        SourceElement se = sc.getSource();
        ClassElement[] ce = se.getAllClasses();
        try {
            if (ce != null) {
                int i = 0;
                while (i < ce.length) {
                    JCClass classToAppend;
                    if (JavaCompletion.getLevel(ce[i].getModifiers()) >= classLevel && (classToAppend = JCExtension.parseClassElement(ce[i], classLevel, fieldLevel, methodLevel, cache, false)) != null) {
                        if (element.getProvider() != null) {
                            if (this.interruptTask) {
                                return false;
                            }
                            element.getProvider().append(new JavaCompletion.SingleProvider(classToAppend));
                            JavaCompletion.getFinder().append(new JavaCompletion.SingleProvider(classToAppend));
                        }
                        classToAppend = null;
                        if (progress != null && progress.cancelled) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (OutOfMemoryError oome) {
            return false;
        }
        return true;
    }

    public static String constructPrefixName(String fsName) {
        StringBuffer sb = new StringBuffer(fsName);
        int lastReplacement = -2;
        int i = 0;
        while (i < sb.length()) {
            switch (sb.charAt(i)) {
                case ' ': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '\\': {
                    if (lastReplacement == i - 1) {
                        sb.delete(i, i + 1);
                        --i;
                        break;
                    }
                    sb.replace(i, i + 1, "_");
                    lastReplacement = i;
                }
            }
            ++i;
        }
        if (sb.length() > 1 && sb.charAt(0) == '_') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '_') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateProvider(QueueEnumeration qe, int classCnt, String fsName, boolean isRoot, ProgressPanel progress) {
        JCStorageElement element;
        block21: {
            boolean bl;
            JCStorage storage = JCStorage.getStorage();
            element = storage.findFileSystemElement(fsName);
            if (this.displayProviderPanel && (isRoot || element == null)) {
                boolean overwrite;
                progress.setDialogVisible(false);
                JCProviderPanel pp = new JCProviderPanel(this.displayMount);
                if (element != null) {
                    pp.setNamePrefix(element.getName());
                    pp.setClassLevel(element.getClassLevel());
                    pp.setFieldLevel(element.getFieldLevel());
                    pp.setMethodLevel(element.getMethodLevel());
                    pp.setAutoUpdate(element.getAutoUpdate());
                } else {
                    pp.setNamePrefix(JCUpdater.constructPrefixName(fsName));
                    pp.selectNamePrefix();
                    pp.setAutoUpdate(true);
                }
                do {
                    overwrite = true;
                    DialogDescriptor dd = new DialogDescriptor((Object)pp, this.getBundleString(BUNDLE_TITLE) + ' ' + fsName);
                    final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                    if (!SwingUtilities.isEventDispatchThread()) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    d.pack();
                                    ((Component)d).setVisible(true);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        d.pack();
                        ((Component)d).setVisible(true);
                    }
                    Object o = dd.getValue();
                    if (o == NotifyDescriptor.OK_OPTION) {
                        DAFileProvider dafp;
                        if (element != null && (dafp = (DAFileProvider)element.getProvider()) != null) {
                            dafp.invalidate();
                        }
                        JCStorageElement[] jcse = storage.getElements();
                        int m = 0;
                        while (m < jcse.length) {
                            if (pp.getNamePrefix().equals(jcse[m].getName()) && !fsName.equals(jcse[m].getFileSystemName())) {
                                NotifyDescriptor.Confirmation NDConfirm = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JCUpdater == null ? JCUpdater.class$("org.netbeans.modules.editor.java.JCUpdater") : class$org$netbeans$modules$editor$java$JCUpdater)).getString("ask_overwrite"), pp.getNamePrefix()), 0, 2);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)NDConfirm);
                                overwrite = NDConfirm.getValue() == NotifyDescriptor.YES_OPTION;
                            }
                            ++m;
                        }
                        if (!overwrite) continue;
                        boolean au = this.displayMount ? pp.getAutoUpdate() && pp.getMountFilesystem() : pp.getAutoUpdate();
                        element = storage.addElement(pp.getNamePrefix(), fsName, pp.getClassLevel(), pp.getFieldLevel(), pp.getMethodLevel(), au);
                        this.mountFilesystem = pp.getMountFilesystem();
                        continue;
                    }
                    ((Component)d).setVisible(false);
                    d.dispose();
                    return false;
                } while (!overwrite);
                progress.setDialogVisible(true);
            }
            int classLevel = element.getClassLevel();
            int fieldLevel = element.getFieldLevel();
            int methodLevel = element.getMethodLevel();
            storage.checkProvider(element);
            try {
                if (isRoot) {
                    JCStorage.getStorage().addProcessedElement(element);
                }
                String doneString = " " + this.getBundleString(BUNDLE_CLASSES_DONE);
                String ofString = " " + this.getBundleString(BUNDLE_CLASSES_DONE_OF) + " ";
                progress.invokeSetBuilding(this.getBundleString(BUNDLE_BUILDING_CLASS));
                progress.invokeSetDoneString(this.getBundleString(BUNDLE_INIT_PARSER));
                boolean ok = true;
                this.doneCnt = 0;
                block6: while (ok && qe.hasMoreElements()) {
                    SourceCookie sc;
                    Object ob = qe.nextElement();
                    if (ob instanceof DataFolder) {
                        DataFolder dfo = (DataFolder)ob;
                        DataObject[] children = dfo.getChildren();
                        progress.invokeSetCurrentClass(dfo.getPrimaryFile().getPackageName('.'));
                        ++this.doneCnt;
                        progress.invokeSetDoneString(this.doneCnt + ofString + classCnt + doneString);
                        int j = 0;
                        while (j < children.length) {
                            SourceCookie sc2;
                            if (progress != null && progress.cancelled) {
                                boolean bl2 = false;
                                Object var21_29 = null;
                                if (!isRoot) return bl2;
                                JCStorage.getStorage().removeProcessedElement(element);
                                JCStorage.getStorage().refresh();
                                return bl2;
                            }
                            DataObject dob = children[j];
                            if (!(dob instanceof DataFolder) && (sc2 = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? JCUpdater.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie)) != null && !this.appendSource(sc2, element, progress, this.lookupCache)) {
                                ok = false;
                                continue block6;
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (!(ob instanceof SourceCookie) || this.appendSource(sc = (SourceCookie)ob, element, progress, this.lookupCache)) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    element.setUpdated(true);
                    storage.saveElements();
                    break block21;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Object var21_32 = null;
                if (!isRoot) throw throwable;
                JCStorage.getStorage().removeProcessedElement(element);
                JCStorage.getStorage().refresh();
                throw throwable;
            }
            Object var21_30 = null;
            if (!isRoot) return bl;
            JCStorage.getStorage().removeProcessedElement(element);
            JCStorage.getStorage().refresh();
            return bl;
        }
        Object var21_31 = null;
        if (!isRoot) return true;
        JCStorage.getStorage().removeProcessedElement(element);
        JCStorage.getStorage().refresh();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateProviderOnBackground(QueueEnumeration qe, int classCnt, String fsName, boolean isRoot) {
        boolean bl;
        JCClassProvider prov;
        HashMap lookupCacheBkg = new HashMap(89);
        JCStorage storage = JCStorage.getStorage();
        if (storage == null) {
            return false;
        }
        JCStorageElement element = storage.findFileSystemElement(fsName);
        boolean elementNewlyCreated = false;
        if (element == null) {
            if (this.displayProviderPanel || !isRoot) return false;
            elementNewlyCreated = true;
            element = storage.addElement(JCUpdater.constructPrefixName(fsName), fsName, 2, 2, 2, true);
        } else if (isRoot && (prov = element.getProvider()) != null && prov instanceof DAFileProvider) {
            ((DAFileProvider)prov).invalidate();
        }
        if (isRoot && debug) {
            System.err.println("Updating parserDB on background:" + fsName);
        }
        int classLevel = element.getClassLevel();
        int fieldLevel = element.getFieldLevel();
        int methodLevel = element.getMethodLevel();
        boolean autoUpdate = element.getAutoUpdate();
        if (!autoUpdate && this.displayProviderPanel) {
            return false;
        }
        if (isRoot && !elementNewlyCreated) {
            element = storage.addElement(element.getName(), fsName, classLevel, fieldLevel, methodLevel, autoUpdate);
        }
        storage.checkProvider(element);
        try {
            if (isRoot) {
                JCStorage.getStorage().addProcessedElement(element);
            }
            String doneString = " " + this.getBundleString(BUNDLE_CLASSES_DONE);
            String ofString = " " + this.getBundleString(BUNDLE_CLASSES_DONE_OF) + " ";
            boolean ok = true;
            this.doneCnt = 0;
            block2: while (ok && qe.hasMoreElements()) {
                SourceCookie sc;
                Object ob = qe.nextElement();
                if (ob instanceof DataFolder) {
                    DataObject[] children = ((DataFolder)ob).getChildren();
                    ++this.doneCnt;
                    int j = 0;
                    while (j < children.length) {
                        SourceCookie sc2;
                        DataObject dob = children[j];
                        if (!(dob instanceof DataFolder) && (sc2 = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? JCUpdater.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie)) != null && !this.appendSource(sc2, element, null, lookupCacheBkg)) {
                            ok = false;
                            continue block2;
                        }
                        ++j;
                    }
                    continue;
                }
                if (!(ob instanceof SourceCookie) || this.appendSource(sc = (SourceCookie)ob, element, null, lookupCacheBkg)) continue;
                ok = false;
                break;
            }
            if (!ok) {
                boolean bl2 = false;
                Object var22_24 = null;
                if (isRoot && debug) {
                    System.err.println("refreshed parser DB element:" + element.getFileSystemName());
                }
                if (isRoot) {
                    JCStorage.getStorage().removeProcessedElement(element);
                    JCStorage.getStorage().refresh();
                }
                lookupCacheBkg.clear();
                return bl2;
            }
            element.setUpdated(true);
            storage.saveElements();
            if (isRoot && debug) {
                System.err.println("parser DB has been updated:" + fsName);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Object var22_26 = null;
            if (isRoot && debug) {
                System.err.println("refreshed parser DB element:" + element.getFileSystemName());
            }
            if (isRoot) {
                JCStorage.getStorage().removeProcessedElement(element);
                JCStorage.getStorage().refresh();
            }
            lookupCacheBkg.clear();
            lookupCacheBkg = null;
            throw throwable;
        }
        Object var22_25 = null;
        if (isRoot && debug) {
            System.err.println("refreshed parser DB element:" + element.getFileSystemName());
        }
        if (isRoot) {
            JCStorage.getStorage().removeProcessedElement(element);
            JCStorage.getStorage().refresh();
        }
        lookupCacheBkg.clear();
        return bl;
    }

    String getBundleString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JCUpdater == null ? (class$org$netbeans$modules$editor$java$JCUpdater = JCUpdater.class$("org.netbeans.modules.editor.java.JCUpdater")) : class$org$netbeans$modules$editor$java$JCUpdater), (String)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProgressPanel
    extends JCProgressPanel
    implements ActionListener {
        private DialogDescriptor descriptor;
        private Dialog dialog;
        private boolean cancelled;
        static final long serialVersionUID = 6306529202240892814L;

        ProgressPanel() {
        }

        private synchronized DialogDescriptor getDescriptor() {
            if (this.descriptor == null) {
                this.descriptor = this.createDescriptor();
            }
            return this.descriptor;
        }

        private DialogDescriptor createDescriptor() {
            return new DialogDescriptor((Object)this, JCUpdater.this.getBundleString("JC_progress_title"), false, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, null, (ActionListener)this);
        }

        public void actionPerformed(ActionEvent evt) {
        }

        private void cancelPressed() {
            this.cancelled = true;
            this.setDialogVisible(false);
        }

        private void setDialogVisible(boolean visible) {
            SwingUtilities.invokeLater(new Runnable(this, visible){
                private final /* synthetic */ boolean val$visible;
                private final /* synthetic */ ProgressPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$visible = val$visible;
                }

                public void run() {
                    if (this.val$visible && ProgressPanel.access$300(this.this$1) == null) {
                        DialogDescriptor localDescriptor = ProgressPanel.access$400(this.this$1);
                        ProgressPanel.access$302(this.this$1, DialogDisplayer.getDefault().createDialog(localDescriptor));
                        ((Component)ProgressPanel.access$300(this.this$1)).setSize(300, 200);
                        localDescriptor.setButtonListener(new ActionListener(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void actionPerformed(ActionEvent evt) {
                                if (evt.getSource() == NotifyDescriptor.CANCEL_OPTION) {
                                    ProgressPanel.access$600(2.access$500(this.this$2));
                                }
                            }
                        });
                    }
                    if (ProgressPanel.access$300(this.this$1) != null) {
                        ((Component)ProgressPanel.access$300(this.this$1)).setVisible(this.val$visible);
                    }
                }

                static /* synthetic */ ProgressPanel access$500(2 x0) {
                    return x0.this$1;
                }
            });
        }

        private void destroy() {
            if (this.dialog != null) {
                ((Component)this.dialog).setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
            }
            ProgressPanel progressPanel = this;
            synchronized (progressPanel) {
                this.descriptor = null;
            }
        }

        static /* synthetic */ Dialog access$300(ProgressPanel x0) {
            return x0.dialog;
        }

        static /* synthetic */ DialogDescriptor access$400(ProgressPanel x0) {
            return x0.getDescriptor();
        }

        static /* synthetic */ Dialog access$302(ProgressPanel x0, Dialog x1) {
            x0.dialog = x1;
            return x0.dialog;
        }

        static /* synthetic */ void access$600(ProgressPanel x0) {
            x0.cancelPressed();
        }
    }
}

