/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCStorage;
import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.NbCompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJavaCompletion;
import org.netbeans.modules.editor.java.NbJavaFastImport;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SourceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.Watch;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;
import org.openide.windows.TopComponent;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fastImportAction = "fast-import";
    public static final String javaDocShowAction = "javadoc-show-action";
    static final long serialVersionUID = -5445829962533684922L;
    private static DORegistryListener rl;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public JavaKit() {
        this.prepareJCCInit();
        if (rl == null) {
            rl = new DORegistryListener();
            DataObject.getRegistry().addChangeListener(WeakListener.change((ChangeListener)rl, (Object)DataObject.getRegistry()));
        }
    }

    private void prepareJCCInit() {
        CompletionInitializer ci = new CompletionInitializer();
        JavaCompletion.setFinderInitializer(ci);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)ci);
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument(this.getClass());
        doc.putProperty("write-line-separator", "\n");
        return doc;
    }

    public Syntax createSyntax(Document doc) {
        return new JavaSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new NbJavaSyntaxSupport(doc);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new NbJavaCompletion(extEditorUI);
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return new NbCompletionJavaDoc(extEditorUI);
    }

    public Formatter createFormatter() {
        return new JavaFormatter(this.getClass());
    }

    protected void initDocument(BaseDocument doc) {
        doc.addLayer(new JavaDrawLayerFactory.JavaLayer(), 1010);
        doc.addDocumentListener(new JavaDrawLayerFactory.LParenWatcher());
    }

    public Class getFocusableComponentClass(JTextComponent c) {
        return class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = JavaKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent;
    }

    protected Action[] createActions() {
        Action[] javaActions = new Action[]{new JavaDefaultKeyTypedAction(), new JavaGotoHelpAction(), new JavaGotoSourceAction(), new JavaGotoDeclarationAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new FastImportAction(), new JavaDocShowAction(), new JavaGenerateGoToPopupAction()};
        return TextAction.augmentList(super.createActions(), javaActions);
    }

    static JCClass findResultInnerClass(JCClass topClass, String innerClsName) {
        if (topClass == null || innerClsName == null) {
            return null;
        }
        ClassElement ce = ClassElement.forName((String)topClass.getFullName());
        if (ce == null) {
            return null;
        }
        ClassElement[] innerClasses = ce.getClasses();
        if (innerClsName != null) {
            int i = 0;
            while (i < innerClasses.length) {
                JCClass innerCls;
                if (innerClsName.equals(innerClasses[i].getName().getName()) && (innerCls = JavaCompletion.getFinder().getExactClass(innerClasses[i].getName().getFullName())) != null) {
                    return innerCls;
                }
                ++i;
            }
        }
        return null;
    }

    private static int findEndOfMethod(JTextComponent textComp, int startPos) {
        try {
            int level = 0;
            BaseDocument doc = (BaseDocument)textComp.getDocument();
            int i = startPos;
            while (i < textComp.getDocument().getLength()) {
                char ch = doc.getChars(i, 1)[0];
                if (ch == ';') {
                    return -1;
                }
                if (ch == '(') {
                    ++level;
                }
                if (ch == ')') {
                    if (level == 0) {
                        return i + 1;
                    }
                    --level;
                }
                ++i;
            }
            return -1;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    private static Object findImportedItem(NbJavaSyntaxSupport nbJavaSup, CompletionQuery.Result result) {
        nbJavaSup.refreshJavaImport();
        String sourcePkg = nbJavaSup.getPackage();
        int x = 0;
        while (x < result.getData().size()) {
            Object itemObj = result.getData().get(x);
            if (itemObj instanceof JCClass) {
                JCClass cls = (JCClass)itemObj;
                String itemPkg = cls.getPackageName();
                if (nbJavaSup.isImported(cls) || sourcePkg.equals(itemPkg)) {
                    return result.getData().get(x);
                }
            }
            ++x;
        }
        return null;
    }

    private static Object findResultInnerItem(NbJavaSyntaxSupport nbJavaSup, CompletionQuery.Result result) {
        ClassElement ce;
        JCClass topClass = nbJavaSup.getTopClass();
        if (topClass != null && (ce = ClassElement.forName((String)topClass.getFullName())) != null) {
            ClassElement[] innerClasses = ce.getClasses();
            Object resultName = null;
            int i = 0;
            while (i < result.getData().size()) {
                JCField fld;
                int j;
                JCClass innerClass;
                JCClass clz;
                if (result.getData().get(i) instanceof JCClass) {
                    return JavaKit.findResultInnerClass(topClass, ((JCClass)result.getData().get(i)).getName());
                }
                if (result.getData().get(i) instanceof JCMethod) {
                    JCMethod mtd = (JCMethod)result.getData().get(i);
                    clz = mtd.getClazz();
                    if (clz != null && (innerClass = JavaKit.findResultInnerClass(topClass, clz.getName())) != null) {
                        JCMethod[] methods = innerClass.getMethods();
                        j = 0;
                        while (j < methods.length) {
                            if (methods[j].equals(mtd)) {
                                return methods[j];
                            }
                            ++j;
                        }
                    }
                } else if (result.getData().get(i) instanceof JCConstructor) {
                    JCConstructor constructor = (JCConstructor)result.getData().get(i);
                    clz = constructor.getClazz();
                    if (clz != null && (innerClass = JavaKit.findResultInnerClass(topClass, clz.getName())) != null) {
                        JCConstructor[] constructors = innerClass.getConstructors();
                        j = 0;
                        while (j < constructors.length) {
                            if (constructors[j].equals(constructor)) {
                                return constructors[j];
                            }
                            ++j;
                        }
                    }
                } else if (result.getData().get(i) instanceof JCField && (clz = (fld = (JCField)result.getData().get(i)).getClazz()) != null && (innerClass = JavaKit.findResultInnerClass(topClass, clz.getName())) != null) {
                    JCField[] fields = innerClass.getFields();
                    j = 0;
                    while (j < fields.length) {
                        if (fields[j].equals(fld)) {
                            return fields[j];
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DORegistryListener
    implements ChangeListener {
        private Vector unsavedSources = new Vector(5);
        static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

        public void stateChanged(ChangeEvent e) {
            DataObject[] dataObj = DataObject.getRegistry().getModified();
            Vector<DataObject> newSources = new Vector<DataObject>(5);
            int i = 0;
            while (i < dataObj.length) {
                SourceCookie sc = (SourceCookie)dataObj[i].getCookie(class$org$openide$cookies$SourceCookie == null ? DORegistryListener.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                if (sc != null) {
                    if (!this.unsavedSources.contains(dataObj[i])) {
                        this.unsavedSources.add(dataObj[i]);
                    }
                    newSources.add(dataObj[i]);
                }
                ++i;
            }
            this.addSavedSourcesToParserDB(this.getSavedSources(newSources));
        }

        private void addSavedSourcesToParserDB(DataObject[] savedSources) {
            if (savedSources.length <= 0) {
                return;
            }
            JCUpdater update = new JCUpdater();
            RequestProcessor.postRequest((Runnable)new Runnable(this, update, savedSources){
                static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
                private final /* synthetic */ JCUpdater val$update;
                private final /* synthetic */ DataObject[] val$savedSources;
                private final /* synthetic */ DORegistryListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$update = val$update;
                    this.val$savedSources = val$savedSources;
                }

                private void updateParserDB(SourceElement se, DataObject savedSource) {
                    Node node;
                    if (se.getStatus() != 3) {
                        return;
                    }
                    if (savedSource.isValid() && (node = savedSource.getNodeDelegate()) != null) {
                        RequestProcessor.postRequest((Runnable)new Runnable(this, node){
                            private final /* synthetic */ Node val$node;
                            private final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$node = val$node;
                            }

                            public void run() {
                                3.access$400(this.this$2).processNode(this.val$node, null);
                            }
                        });
                    }
                }

                public void run() {
                    int k = 0;
                    while (k < this.val$savedSources.length) {
                        if (this.val$savedSources[k].isValid()) {
                            SourceCookie sc = (SourceCookie)this.val$savedSources[k].getCookie(class$org$openide$cookies$SourceCookie == null ? 3.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                            SourceElement se = sc.getSource();
                            DataObject savedSource = this.val$savedSources[k];
                            Task parsingTask = se.prepare();
                            if (parsingTask.isFinished()) {
                                this.updateParserDB(se, savedSource);
                            } else {
                                parsingTask.addTaskListener(new TaskListener(this, se, savedSource){
                                    private final /* synthetic */ SourceElement val$se;
                                    private final /* synthetic */ DataObject val$savedSource;
                                    private final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = this$2;
                                        this.val$se = val$se;
                                        this.val$savedSource = val$savedSource;
                                    }

                                    public void taskFinished(Task t) {
                                        t.removeTaskListener((TaskListener)this);
                                        3.access$500(this.this$2, this.val$se, this.val$savedSource);
                                    }
                                });
                            }
                        }
                        ++k;
                    }
                }

                static /* synthetic */ JCUpdater access$400(3 x0) {
                    return x0.val$update;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }

                static /* synthetic */ void access$500(3 x0, SourceElement x1, DataObject x2) {
                    x0.updateParserDB(x1, x2);
                }
            }, (int)0, (int)1);
        }

        private DataObject[] getSavedSources(Vector newSources) {
            Vector ret = new Vector(5);
            int j = 0;
            while (j < this.unsavedSources.size()) {
                if (!newSources.contains(this.unsavedSources.get(j))) {
                    ret.add(this.unsavedSources.get(j));
                }
                ++j;
            }
            int k = 0;
            while (k < ret.size()) {
                this.unsavedSources.remove(ret.get(k));
                ++k;
            }
            DataObject[] savedSources = new DataObject[ret.size()];
            ret.toArray(savedSources);
            return savedSources;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class FastImportAction
    extends BaseAction {
        public FastImportAction() {
            super(JavaKit.fastImportAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                new NbJavaFastImport(target).setDialogVisible(true);
            }
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                StringBuffer sb = new StringBuffer("System.out.println(\"");
                String title = (String)doc.getProperty("title");
                if (title != null) {
                    sb.append(title);
                    sb.append(':');
                }
                try {
                    sb.append(Utilities.getLineOffset(doc, target.getCaret().getDot()) + 1);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                sb.append(' ');
                BaseKit kit = Utilities.getKit(target);
                if (kit == null) {
                    return;
                }
                Action a = kit.getActionByName("insert-content");
                if (a != null) {
                    Utilities.performAction(a, new ActionEvent(target, 1001, sb.toString()), target);
                }
            }
        }
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaGotoHelpAction() {
            super("goto-help", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoHelpAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction).getName());
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("java-desc-goto-help"));
        }

        public URL[] getJavaDocURLs(JTextComponent target) {
            Completion completion = ExtUtilities.getCompletion(target);
            SyntaxSupport sup = Utilities.getSyntaxSupport(target);
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    Object item = completion.getSelectedValue();
                    if (item != null) {
                        return nbJavaSup.getJavaDocURLs(item);
                    }
                } else {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    try {
                        int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock(doc, dotPos);
                        if (idFunBlk == null) {
                            idFunBlk = new int[]{dotPos, dotPos};
                        }
                        int ind = idFunBlk.length - 1;
                        while (ind >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(target, idFunBlk[ind], nbJavaSup);
                            if (result != null && result.getData().size() > 0) {
                                if (result.getData().size() > 1) {
                                    Object innerClassItem = JavaKit.findResultInnerItem(nbJavaSup, result);
                                    if (innerClassItem != null) {
                                        return nbJavaSup.getJavaDocURLs(innerClassItem);
                                    }
                                    Object importedItem = JavaKit.findImportedItem(nbJavaSup, result);
                                    if (importedItem != null) {
                                        return nbJavaSup.getJavaDocURLs(importedItem);
                                    }
                                }
                                return nbJavaSup.getJavaDocURLs(result.getData().get(0));
                            }
                            --ind;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                URL[] urls = this.getJavaDocURLs(target);
                if (urls != null && urls.length > 0) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urls[0]);
                } else {
                    Utilities.setStatusText(target, NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("cannot_find_javadoc"));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("show_javadoc");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class JavaDocShowAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaDocShowAction() {
            super(JavaKit.javaDocShowAction);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction = JavaDocShowAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaDocShowAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Object obj = this.getMember(target);
                CompletionJavaDoc javadoc = ExtUtilities.getCompletionJavaDoc(target);
                if (javadoc != null) {
                    javadoc.setContent(obj);
                    javadoc.addToHistory(obj);
                }
            }
        }

        public Object getMember(JTextComponent target) {
            Object item = null;
            Completion completion = ExtUtilities.getCompletion(target);
            SyntaxSupport sup = Utilities.getSyntaxSupport(target);
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaDocShowAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    item = completion.getSelectedValue();
                    if (item != null) {
                        return item;
                    }
                } else {
                    try {
                        int dotPos = target.getCaret().getDot();
                        BaseDocument doc = (BaseDocument)target.getDocument();
                        int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock(doc, dotPos);
                        if (idFunBlk == null || dotPos > 0 && doc.getChars(dotPos - 1, 1)[0] == '(' && dotPos == idFunBlk[0]) {
                            idFunBlk = new int[]{dotPos, dotPos};
                        }
                        int ind = idFunBlk.length - 1;
                        while (ind >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(target, idFunBlk[ind], sup);
                            if (result != null && result.getData().size() > 0) {
                                CompletionQuery.Result resultx;
                                int endOfMethod;
                                Object itm = result.getData().get(0);
                                if ((itm instanceof JCConstructor || itm instanceof JCMethod) && result.getData().size() > 1 && (endOfMethod = JavaKit.findEndOfMethod(target, idFunBlk[ind])) > -1 && (resultx = completion.getQuery().query(target, endOfMethod, sup)) != null && resultx.getData().size() > 0) {
                                    return resultx.getData().get(0);
                                }
                                Object innerClassItem = JavaKit.findResultInnerItem(nbJavaSup, result);
                                if (innerClassItem != null) {
                                    return innerClassItem;
                                }
                                Object importedItem = JavaKit.findImportedItem(nbJavaSup, result);
                                return importedItem != null ? importedItem : result.getData().get(0);
                            }
                            --ind;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DelayedMenu
    extends JMenu {
        RequestProcessor.Task task;

        public DelayedMenu(String s) {
            super(s);
        }

        public JPopupMenu getPopupMenu() {
            if (this.task != null && !this.task.isFinished()) {
                this.task.waitFinished();
            }
            return super.getPopupMenu();
        }

        public void addTask(RequestProcessor.Task task) {
            this.task = task;
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            KeyStroke[] keys;
            Keymap km = target.getKeymap();
            if (km != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                item.setAccelerator(keys[0]);
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit(target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null) {
                    String itemText = this.getItemText(target, actionName, a);
                    if (itemText != null) {
                        item = new JMenuItem(itemText);
                        item.addActionListener(a);
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(a.isEnabled());
                        Object helpID = a.getValue("helpID");
                        if (helpID != null && helpID instanceof String) {
                            item.putClientProperty("HelpID", helpID);
                        }
                    } else if ("goto-source".equals(actionName)) {
                        item = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGenerateGoToPopupAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(false);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            } else {
                menu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            DelayedMenu jm = new DelayedMenu(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGenerateGoToPopupAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("generate-goto-popup"));
            RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)new Runnable(this, target, jm){
                private final /* synthetic */ JTextComponent val$target;
                private final /* synthetic */ DelayedMenu val$jm;
                private final /* synthetic */ JavaGenerateGoToPopupAction this$0;
                {
                    this.this$0 = this$0;
                    this.val$target = val$target;
                    this.val$jm = val$jm;
                }

                public void run() {
                    this.this$0.addAction(this.val$target, this.val$jm, "goto-source");
                    this.this$0.addAction(this.val$target, this.val$jm, "goto-declaration");
                }
            });
            jm.addTask(task);
            return jm;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class JavaGotoSourceAction
    extends BaseAction {
        private static final Object STORAGE_INIT = new Object();
        private static boolean storageInitialized = false;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

        public JavaGotoSourceAction() {
            super("goto-source", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoSourceAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction).getName());
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/gotosource");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            String msg;
            if (target != null && (msg = this.openSource(target, false)) != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            }
        }

        public String openSource(JTextComponent target, boolean simulate) {
            Object item = null;
            String itemDesc = null;
            Completion completion = ExtUtilities.getCompletion(target);
            SyntaxSupport sup = Utilities.getSyntaxSupport(target);
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    item = completion.getSelectedValue();
                    if (item != null) {
                        itemDesc = nbJavaSup.openSource(item, false, simulate);
                    }
                } else {
                    try {
                        int dotPos = target.getCaret().getDot();
                        BaseDocument doc = (BaseDocument)target.getDocument();
                        int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock(doc, dotPos);
                        if (idFunBlk == null || dotPos > 0 && doc.getChars(dotPos - 1, 1)[0] == '(' && dotPos == idFunBlk[0]) {
                            idFunBlk = new int[]{dotPos, dotPos};
                        }
                        int ind = idFunBlk.length - 1;
                        while (ind >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(target, idFunBlk[ind], nbJavaSup);
                            if (result != null && result.getData().size() > 0) {
                                CompletionQuery.Result resultx;
                                int endOfMethod;
                                Object itm = result.getData().get(0);
                                if ((itm instanceof JCConstructor || itm instanceof JCMethod) && result.getData().size() > 1 && (endOfMethod = JavaKit.findEndOfMethod(target, idFunBlk[ind])) > -1 && (resultx = completion.getQuery().query(target, endOfMethod, nbJavaSup)) != null && resultx.getData().size() > 0) {
                                    itemDesc = nbJavaSup.openSource(resultx.getData().get(0), false, simulate);
                                    break;
                                }
                                nbJavaSup.refreshJavaImport();
                                Object innerClassItem = JavaKit.findResultInnerItem(nbJavaSup, result);
                                if (innerClassItem != null) {
                                    itemDesc = nbJavaSup.openSource(innerClassItem, false, simulate);
                                    break;
                                }
                                Object importedItem = JavaKit.findImportedItem(nbJavaSup, result);
                                itemDesc = importedItem != null ? nbJavaSup.openSource(importedItem, false, simulate) : nbJavaSup.openSource(result.getData().get(0), false, simulate);
                            }
                            --ind;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            String msg = null;
            if (itemDesc != null) {
                boolean isPkg = item instanceof JCPackage;
                msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(simulate ? (isPkg ? "goto_source_explore_package" : "goto_source_open_source") : (isPkg ? "goto_source_package_not_found" : "goto_source_source_not_found"));
                msg = MessageFormat.format(msg, itemDesc);
            }
            return msg;
        }

        public String getPopupMenuText(JTextComponent target) {
            String ret = null;
            if (JCStorage.isInitialized()) {
                return this.openSource(target, true);
            }
            Object object = STORAGE_INIT;
            synchronized (object) {
                final JTextComponent textComp = target;
                ret = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted");
                if (!storageInitialized) {
                    storageInitialized = true;
                    RequestProcessor.postRequest((Runnable)new Runnable(){

                        public void run() {
                            String string = this.openSource(textComp, true);
                        }
                    }, (int)200);
                }
                String string = ret;
                return string;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class JavaGotoDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction = JavaGotoDeclarationAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block15: {
                if (target != null) {
                    Completion completion = ExtUtilities.getCompletion(target);
                    SyntaxSupport sup = Utilities.getSyntaxSupport(target);
                    NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoDeclarationAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
                    if (completion != null) {
                        if (completion.isPaneVisible()) {
                            Object item = completion.getSelectedValue();
                            if (item != null) {
                                nbJavaSup.openSource(item, true, false);
                            }
                        } else {
                            boolean found = false;
                            int dotPos = target.getCaret().getDot();
                            BaseDocument doc = (BaseDocument)target.getDocument();
                            try {
                                int pos;
                                int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock(doc, dotPos);
                                if (idFunBlk != null && idFunBlk.length == 2 && ((pos = Utilities.getFirstNonWhiteBwd(doc, idFunBlk[0])) < 0 || doc.getChars(pos, 1)[0] != '.')) {
                                    found = this.gotoDeclaration(target);
                                }
                                if (found) break block15;
                                if (idFunBlk == null) {
                                    idFunBlk = new int[]{dotPos, dotPos};
                                }
                                int ind = idFunBlk.length - 1;
                                while (ind >= 1) {
                                    CompletionQuery.Result result = completion.getQuery().query(target, idFunBlk[ind], nbJavaSup);
                                    if (result != null && result.getData().size() > 0) {
                                        CompletionQuery.Result resultx;
                                        int endOfMethod;
                                        Object itm = result.getData().get(0);
                                        if ((itm instanceof JCConstructor || itm instanceof JCMethod) && result.getData().size() > 1 && (endOfMethod = JavaKit.findEndOfMethod(target, idFunBlk[ind])) > -1 && (resultx = completion.getQuery().query(target, endOfMethod, nbJavaSup)) != null && resultx.getData().size() > 0) {
                                            nbJavaSup.openSource(resultx.getData().get(0), true, false);
                                        } else {
                                            Object innerClassItem = JavaKit.findResultInnerItem(nbJavaSup, result);
                                            if (innerClassItem != null) {
                                                nbJavaSup.openSource(innerClassItem, true, false);
                                            } else {
                                                nbJavaSup.openSource(result.getData().get(0), true, false);
                                            }
                                        }
                                        break;
                                    }
                                    --ind;
                                }
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class ToggleBreakpointAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction;

        public ToggleBreakpointAction() {
            super(JavaKit.toggleBreakpointAction);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction = ToggleBreakpointAction.class$("org.netbeans.modules.editor.java.JavaKit$ToggleBreakpointAction")) : class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                int dotPos;
                NbJavaSyntaxSupport sup = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(target);
                Breakpoint b = sup.getBreakpoint(dotPos = target.getCaret().getDot());
                if (b == null) {
                    sup.createBreakpoint(dotPos);
                } else {
                    b.remove();
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class JavaBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        static final long serialVersionUID = -2009277037915948909L;

        protected String buildText(JTextComponent target) {
            Watch watch;
            String word;
            int state;
            String text = null;
            NbJavaSyntaxSupport sup = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(target);
            Debugger debugger = sup.getDebugger();
            if (debugger != null && ((state = debugger.getState()) == 3 || state == 4) && (word = ExtUtilities.getExtEditorUI(target).getToolTipSupport().getIdentifierUnderCursor()) != null && (watch = debugger.createWatch(word, true)) != null) {
                String asText = watch.getAsText();
                if (asText != null && !asText.trim().equals(word.trim())) {
                    text = word + '=' + asText;
                }
                watch.remove();
            }
            return text;
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
    }

    private static class CompletionInitializer
    implements JavaCompletion.JCFinderInitializer,
    PropertyChangeListener,
    Runnable {
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

        private CompletionInitializer() {
        }

        public void initJCFinder() {
            JCStorage.getStorage();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("activatedNodes".equals(evt.getPropertyName())) {
                Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
                if (nodes == null || nodes.length == 0) {
                    return;
                }
                EditorCookie ec = (EditorCookie)nodes[0].getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = CompletionInitializer.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (ec == null) {
                    return;
                }
                JEditorPane[] panes = ec.getOpenedPanes();
                if (panes == null || panes.length == 0 || !panes[0].hasFocus()) {
                    return;
                }
                EditorKit kit = panes[0].getEditorKit();
                if (!(kit instanceof JavaKit)) {
                    return;
                }
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                RequestProcessor.postRequest((Runnable)this);
            }
        }

        public void run() {
            JCStorage.getStorage();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

