/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodElement;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NbCompletionJavaDoc
extends CompletionJavaDoc {
    ParsingThread task = null;
    Map lookupCache = new HashMap(89);
    private static final String CONTENT_NOT_FOUND = NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$NbCompletionJavaDoc == null ? (class$org$netbeans$modules$editor$java$NbCompletionJavaDoc = NbCompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbCompletionJavaDoc")) : class$org$netbeans$modules$editor$java$NbCompletionJavaDoc), (String)"javadoc_content_not_found");
    private static boolean javaSourcesMounted;
    private static boolean inited;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbCompletionJavaDoc;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

    public NbCompletionJavaDoc(ExtEditorUI extEditorUI) {
        super(extEditorUI);
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Enumeration e = Repository.getDefault().getFileSystems();
                while (e.hasMoreElements()) {
                    FileSystem fs = (FileSystem)e.nextElement();
                    if (fs.findResource("java/lang/String.java") == null) continue;
                    javaSourcesMounted = true;
                    break;
                }
                inited = true;
            }
        });
    }

    private CompletionJavaDoc.JavaDocTagItem[] getJavaDocTags(JavaDocTag[] jdt) {
        CompletionJavaDoc.JavaDocTagItem[] ret = new CompletionJavaDoc.JavaDocTagItem[jdt.length];
        int i = 0;
        while (i < jdt.length) {
            ret[i] = new JavaDocTagItemImpl(jdt[i].name(), jdt[i].text());
            ++i;
        }
        return ret;
    }

    private void mountSources() {
        if (!inited) {
            return;
        }
        if (javaSourcesMounted) {
            return;
        }
        javaSourcesMounted = true;
        try {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.indexOf("1.4") != -1) {
                String fileSeparator = System.getProperty("file.separator");
                String javaRuntimeRoot = System.getProperty("java.home") + fileSeparator;
                String javaRoot = javaRuntimeRoot + ".." + fileSeparator;
                File srcFile = new File(javaRoot + "src.zip");
                if (!srcFile.exists() && !(srcFile = new File(javaRoot + "src.jar")).exists()) {
                    return;
                }
                FileSystemCapability.Bean cap = new FileSystemCapability.Bean();
                cap.setCompile(false);
                cap.setDebug(false);
                cap.setExecute(false);
                cap.setDoc(false);
                JarFileSystem mountedFS = new JarFileSystem((FileSystemCapability)cap);
                mountedFS.setJarFile(srcFile);
                mountedFS.setHidden(true);
                if (Repository.getDefault().findFileSystem(mountedFS.getSystemName()) == null) {
                    Repository.getDefault().addFileSystem((FileSystem)mountedFS);
                }
            }
        }
        catch (IOException ioe) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private ClassElement getClassElement(String clsFullName) {
        ClassElement ce = null;
        if (clsFullName == null) {
            return null;
        }
        try {
            ce = ClassElement.forName((String)clsFullName);
            if (ce == null && !javaSourcesMounted) {
                this.mountSources();
                ce = ClassElement.forName((String)clsFullName);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            System.err.println("Error occurred during name resolving");
            t.printStackTrace();
        }
        return ce;
    }

    private ParsingThread setInRequestProcessorThread(Object content) {
        ParsingThread pt = new ParsingThread(content);
        RequestProcessor.postRequest((Runnable)pt);
        return pt;
    }

    public void cancelPerformingThread() {
        super.cancelPerformingThread();
        if (this.task != null) {
            this.task.stopTask();
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (this.task != null) {
            this.task.stopTask();
        }
        this.task = this.setInRequestProcessorThread(this.currentContent);
    }

    public void goToSource() {
        SyntaxSupport sup = Utilities.getSyntaxSupport(this.extEditorUI.getComponent());
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = NbCompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
        nbJavaSup.openSource(this.currentContent, false, false);
    }

    public void openInExternalBrowser() {
        SyntaxSupport sup = Utilities.getSyntaxSupport(this.extEditorUI.getComponent());
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = NbCompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
        URL[] urls = nbJavaSup.getJavaDocURLs(this.currentContent);
        if (urls != null && urls.length > 0) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(urls[0]);
        }
    }

    protected String findProperClass(String name, JCClass cls) {
        List classes;
        if (cls == null || name == null) {
            return null;
        }
        String ret = null;
        if (cls.getPackageName() != null && cls.getPackageName().length() > 0) {
            if (this.getClassElement(cls.getPackageName() + "." + name) != null) {
                return cls.getPackageName() + "." + name;
            }
        } else if (this.getClassElement(name) != null) {
            return name;
        }
        if ((classes = JavaCompletion.getFinder().findClasses(null, name, true)).size() > 0 && this.getClassElement(ret = ((JCClass)classes.get(0)).getFullName()) == null) {
            ret = null;
        }
        return ret;
    }

    protected boolean isNotFullyQualifiedInnerClass(String inner, JCClass cls) {
        if (inner.indexOf(".") != inner.lastIndexOf(".")) {
            return false;
        }
        String pkgName = cls.getPackageName();
        return this.getClassElement(pkgName.length() > 0 ? pkgName + "." + inner : inner) != null;
    }

    private List parseMethodTypes(String parameters) {
        ArrayList<String> ret = new ArrayList<String>();
        if (parameters == null) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(parameters, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            param.trim();
            if (param.startsWith(" ")) {
                param = param.substring(1);
            }
            if (param.endsWith(" ")) {
                param = param.substring(0, param.length() - 1);
            }
            if (param.indexOf(".") < 0) {
                ClassElement ce;
                String testParam = "java.lang." + param;
                if (testParam.indexOf("[") > 0) {
                    testParam = testParam.substring(0, testParam.indexOf("["));
                }
                if ((ce = this.getClassElement(testParam)) != null) {
                    param = "java.lang." + param;
                }
            }
            ret.add(param);
        }
        return ret;
    }

    public boolean isExternalJavaDocMounted() {
        SyntaxSupport sup = Utilities.getSyntaxSupport(this.extEditorUI.getComponent());
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = NbCompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
        URL[] urls = nbJavaSup.getJavaDocURLs(this.currentContent);
        return urls != null && urls.length >= 1;
    }

    public Object parseLink(String link, JCClass cls) {
        ClassElement linkClsElem2;
        String refCls;
        link = link.trim();
        JCFinder finder = JavaCompletion.getFinder();
        if (link.indexOf("#") > -1) {
            MethodElement me;
            String memberLink;
            JCClass linkClass;
            ClassElement linkClsElem2;
            if (link.startsWith("#")) {
                if (cls == null) {
                    return null;
                }
                linkClsElem2 = this.getClassElement(cls.getFullName());
                if (linkClsElem2 == null) {
                    return null;
                }
                linkClass = finder.getExactClass(cls.getFullName());
                if (linkClass == null) {
                    linkClass = JCExtension.parseClassElement(linkClsElem2, 0, 0, 0, this.lookupCache, false);
                }
                if (linkClass == null) {
                    return null;
                }
            } else {
                String refCls2 = link.substring(0, link.indexOf("#"));
                if (refCls2.indexOf(".") < 0 && cls != null) {
                    String curPkgCls;
                    String string = curPkgCls = cls.getPackageName().length() > 0 ? cls.getPackageName() + "." + refCls2 : refCls2;
                    if (this.getClassElement(curPkgCls) == null) {
                        List outCls = finder.findClasses(null, refCls2, true);
                        if (outCls.size() > 0) {
                            refCls2 = ((JCClass)outCls.get(0)).getFullName();
                        }
                    } else {
                        refCls2 = curPkgCls;
                    }
                }
                if ((linkClsElem2 = this.getClassElement(refCls2)) == null) {
                    return null;
                }
                linkClass = finder.getExactClass(linkClsElem2.getName().getFullName());
                if (linkClass == null) {
                    linkClass = JCExtension.parseClassElement(linkClsElem2, 0, 0, 0, this.lookupCache, false);
                }
                if (linkClass == null) {
                    return null;
                }
            }
            if (link.indexOf("(") > 0) {
                memberLink = link.substring(link.indexOf("#") + 1);
                String memberFullName = memberLink.indexOf(" ") > 0 ? memberLink.substring(0, memberLink.indexOf(" ")) : memberLink;
                String memberName = memberLink.substring(0, memberLink.indexOf("("));
                String memberParams = null;
                if (link.indexOf(")") > 0) {
                    memberParams = link.substring(link.indexOf("(") + 1, link.indexOf(")"));
                }
                List params = this.parseMethodTypes(memberParams);
                Type[] types = new Type[params.size()];
                try {
                    int i = 0;
                    while (i < types.length) {
                        types[i] = Type.parse((String)((String)params.get(i)));
                        ++i;
                    }
                }
                catch (IllegalArgumentException iae) {
                    types = new Type[]{};
                }
                MethodElement me2 = linkClsElem2.getMethod(Identifier.create((String)memberName), types);
                if (me2 != null) {
                    JCMethod[] mtds = linkClass.getMethods();
                    int i = 0;
                    while (i < mtds.length) {
                        if (JCExtension.equals(mtds[i], me2)) {
                            return mtds[i];
                        }
                        ++i;
                    }
                }
                return null;
            }
            memberLink = link.substring(link.indexOf("#") + 1);
            String memberName = memberLink.indexOf(" ") > 0 ? memberLink.substring(0, memberLink.indexOf(" ")) : memberLink;
            FieldElement fieldElement = linkClsElem2.getField(Identifier.create((String)memberName));
            if (fieldElement != null) {
                JCField[] flds = linkClass.getFields();
                int i = 0;
                while (i < flds.length) {
                    if (JCExtension.equals(flds[i], fieldElement)) {
                        return flds[i];
                    }
                    ++i;
                }
                return null;
            }
            ClassElement processedCE = linkClsElem2;
            do {
                me = processedCE.getMethod(Identifier.create((String)memberName), new Type[0]);
                Identifier superCls = processedCE.getSuperclass();
                ClassElement classElement = processedCE = superCls == null ? null : ClassElement.forName((String)superCls.getFullName());
            } while (processedCE != null && me == null);
            if (me == null) {
                Identifier superCls;
                processedCE = linkClsElem2;
                do {
                    MethodElement[] mes = processedCE.getMethods();
                    int i = 0;
                    while (i < mes.length) {
                        JCClass linkClassLoop;
                        if (Identifier.create((String)memberName).equals((Object)mes[i].getName()) && (linkClassLoop = finder.getExactClass(processedCE.getName().getFullName())) != null) {
                            JCMethod[] mtds = linkClassLoop.getMethods();
                            int j = 0;
                            while (j < mtds.length) {
                                if (JCExtension.equals(mtds[j], mes[i])) {
                                    return mtds[j];
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                } while ((processedCE = (superCls = processedCE.getSuperclass()) == null ? null : ClassElement.forName((String)superCls.getFullName())) != null);
            } else {
                do {
                    JCMethod[] mtds = linkClass.getMethods();
                    int i = 0;
                    while (i < mtds.length) {
                        if (JCExtension.equals(mtds[i], me)) {
                            return mtds[i];
                        }
                        ++i;
                    }
                } while ((linkClass = linkClass.getSuperclass()) != null);
            }
            return null;
        }
        String string = refCls = link.indexOf(" ") > 0 ? link.substring(0, link.indexOf(" ")) : link;
        if (refCls.indexOf(".") > 0) {
            linkClsElem2 = this.getClassElement(refCls);
            if (linkClsElem2 == null && cls != null) {
                refCls = this.findProperClass(refCls, cls);
            }
        } else if (cls != null) {
            refCls = this.findProperClass(refCls, cls);
        }
        if ((linkClsElem2 = this.getClassElement(refCls)) == null) {
            return null;
        }
        JCClass linkClass = finder.getExactClass(linkClsElem2.getName().getFullName());
        if (linkClass == null) {
            linkClass = JCExtension.parseClassElement(linkClsElem2, 0, 0, 0, this.lookupCache, false);
        }
        return linkClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        inited = false;
    }

    class JavaDocTagItemImpl
    implements CompletionJavaDoc.JavaDocTagItem {
        String name;
        String text;

        public JavaDocTagItemImpl(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JavaDocTagItemImpl p = (JavaDocTagItemImpl)o;
            return this.name.compareTo(p.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JavaDocTagItemImpl) {
                return this.name.equals(((JavaDocTagItemImpl)o).getName());
            }
            if (o instanceof String) {
                return this.name.equals((String)o);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ParsingThread
    implements Runnable {
        Object content;
        boolean running = true;

        public ParsingThread(Object content) {
            this.content = content;
        }

        void stopTask() {
            this.running = false;
        }

        private String getBoldName(String description, String name) {
            if (description.indexOf(name) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(description.substring(0, description.indexOf(name)));
                sb.append("<b>" + name + "</b>");
                sb.append(description.substring(description.indexOf(name) + name.length()));
                return sb.toString().replace('$', '.');
            }
            return description;
        }

        private void showJavaDoc(String preparedText) {
            if (this.running) {
                NbCompletionJavaDoc.this.getJavaDocView().setContent(preparedText);
                if (this.running) {
                    NbCompletionJavaDoc.this.setJavaDocVisible(true);
                }
            }
        }

        private void setMethod(MethodElement me, JCMethod jcMethod) {
            if (me == null || jcMethod == null) {
                if (jcMethod == null) {
                    this.showJavaDoc(CONTENT_NOT_FOUND);
                } else {
                    String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcMethod.getClazz(), this.getBoldName(jcMethod.toString(), jcMethod.getName()), CONTENT_NOT_FOUND, null);
                    this.showJavaDoc(preparedText);
                }
                return;
            }
            JavaDoc.Method jdMethod = me.getJavaDoc();
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcMethod.getClazz(), this.getBoldName(jcMethod.toString(), jcMethod.getName()), jdMethod == null || jdMethod.getText().length() == 0 && jdMethod.getTags().length == 0 ? CONTENT_NOT_FOUND : jdMethod.getText(), jdMethod == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdMethod.getTags()));
            this.showJavaDoc(preparedText);
        }

        private void setClass(ClassElement ce, JCClass cls) {
            if (ce == null) {
                String preparedText = cls != null ? NbCompletionJavaDoc.this.prepareJavaDocContent(cls, "", CONTENT_NOT_FOUND, null) : CONTENT_NOT_FOUND;
                this.showJavaDoc(preparedText);
                return;
            }
            JavaDoc.Class jdClass = ce.getJavaDoc();
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(cls, "", jdClass == null || jdClass.getText().length() == 0 && jdClass.getTags().length == 0 ? CONTENT_NOT_FOUND : jdClass.getText(), jdClass == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdClass.getTags()));
            this.showJavaDoc(preparedText);
        }

        private void setField(FieldElement fe, JCField jcField) {
            if (fe == null || jcField == null) {
                if (jcField == null) {
                    this.showJavaDoc(CONTENT_NOT_FOUND);
                } else {
                    String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcField.getClazz(), this.getBoldName(jcField.toString(), jcField.getName()), CONTENT_NOT_FOUND, null);
                    this.showJavaDoc(preparedText);
                }
                return;
            }
            JavaDoc.Field jdField = fe.getJavaDoc();
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcField.getClazz(), this.getBoldName(jcField.toString(), jcField.getName()), jdField == null || jdField.getText().length() == 0 && jdField.getTags().length == 0 ? CONTENT_NOT_FOUND : jdField.getText(), jdField == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdField.getTags()));
            this.showJavaDoc(preparedText);
        }

        private void setConstructor(ConstructorElement conElem, JCConstructor jcConstuctor) {
            if (conElem == null || jcConstuctor == null) {
                if (jcConstuctor == null) {
                    this.showJavaDoc(CONTENT_NOT_FOUND);
                } else {
                    String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcConstuctor.getClazz(), this.getBoldName(jcConstuctor.toString(), jcConstuctor.getClazz().getName()), CONTENT_NOT_FOUND, null);
                    this.showJavaDoc(preparedText);
                }
                return;
            }
            JavaDoc.Method jdMethod = conElem.getJavaDoc();
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcConstuctor.getClazz(), this.getBoldName(jcConstuctor.toString(), jcConstuctor.getClazz().getName()), jdMethod == null || jdMethod.getText().length() == 0 && jdMethod.getTags().length == 0 ? CONTENT_NOT_FOUND : jdMethod.getText(), jdMethod == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdMethod.getTags()));
            this.showJavaDoc(preparedText);
        }

        public void run() {
            if (!javaSourcesMounted) {
                NbCompletionJavaDoc.this.mountSources();
            }
            if (this.content instanceof JCClass) {
                this.setClass(NbCompletionJavaDoc.this.getClassElement(((JCClass)this.content).getFullName()), (JCClass)this.content);
            } else if (this.content instanceof JCField) {
                JCField fld = (JCField)this.content;
                ClassElement ce = NbCompletionJavaDoc.this.getClassElement(fld.getClazz().getFullName());
                if (ce == null) {
                    this.showJavaDoc(CONTENT_NOT_FOUND);
                    return;
                }
                this.setField(ce.getField(Identifier.create((String)((JCField)this.content).getName())), fld);
            } else if (this.content instanceof JCMethod) {
                JCMethod mtd = (JCMethod)this.content;
                ClassElement ce = NbCompletionJavaDoc.this.getClassElement(mtd.getClazz().getFullName());
                if (ce == null) {
                    this.showJavaDoc(CONTENT_NOT_FOUND);
                    return;
                }
                JCParameter[] jcp = mtd.getParameters();
                try {
                    Type[] types = new Type[jcp.length];
                    int i = 0;
                    while (i < jcp.length) {
                        String array = "";
                        int j = 0;
                        while (j < jcp[i].getType().getArrayDepth()) {
                            array = array + "[]";
                            ++j;
                        }
                        types[i] = Type.parse((String)(jcp[i].getType().getClazz().getFullName() + array));
                        ++i;
                    }
                    this.setMethod(ce.getMethod(Identifier.create((String)((JCMethod)this.content).getName()), types), mtd);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                }
            } else if (this.content instanceof JCConstructor) {
                JCConstructor con = (JCConstructor)this.content;
                ClassElement ce = NbCompletionJavaDoc.this.getClassElement(con.getClazz().getFullName());
                if (ce == null) {
                    this.showJavaDoc(CONTENT_NOT_FOUND);
                    return;
                }
                JCParameter[] jcp = con.getParameters();
                try {
                    Type[] types = new Type[jcp.length];
                    int i = 0;
                    while (i < jcp.length) {
                        String array = "";
                        int j = 0;
                        while (j < jcp[i].getType().getArrayDepth()) {
                            array = array + "[]";
                            ++j;
                        }
                        types[i] = Type.parse((String)(jcp[i].getType().getClazz().getFullName() + array));
                        ++i;
                    }
                    this.setConstructor(ce.getConstructor(types), con);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                }
            } else {
                this.showJavaDoc(CONTENT_NOT_FOUND);
            }
        }
    }
}

