/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SourceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class NbJavaSyntaxSupport
extends JavaSyntaxSupport {
    private static final String PACKAGE_SUMMARY = "package-summary";
    private HashMap jcLookupCache = new HashMap(307);
    protected boolean jcValid;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    public NbJavaSyntaxSupport(BaseDocument doc) {
        super(doc);
    }

    protected void documentModified(DocumentEvent evt) {
        super.documentModified(evt);
        this.jcValid = false;
    }

    protected int getMethodStartPosition(int pos) {
        DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
        if (dob != null) {
            try {
                Element swingElem;
                org.openide.src.Element elem;
                SourceCookie.Editor sce = (SourceCookie.Editor)dob.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
                if (sce != null && (elem = sce.findElement(pos)) != null && (swingElem = sce.sourceToText(elem)) != null) {
                    return swingElem.getStartOffset();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return 0;
    }

    private boolean isMounted(String pkgName, String className) {
        Enumeration en = Repository.getDefault().getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.find(pkgName, className, "class");
            if (fo == null) {
                fo = fs.find(pkgName, className, "java");
            }
            if (fo == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnknownImport(String className) {
        boolean ret = super.isUnknownImport(className);
        if (ret) {
            return ret;
        }
        List unknownImports = this.getUnknownImports();
        int i = 0;
        while (i < unknownImports.size()) {
            String imp = (String)unknownImports.get(i);
            if (imp.endsWith("*") && imp.length() > 2) {
                imp = imp.substring(0, imp.length() - 2);
                JCClass exactCls = JavaCompletion.getFinder().getExactClass(imp + "." + className);
                if (this.isMounted(imp, className) && exactCls == null) {
                    return true;
                }
            }
            ++i;
        }
        return ret;
    }

    public int findGlobalDeclarationPosition(String varName, int varPos) {
        org.openide.src.Element e = this.getElementAtPos(varPos);
        if (e instanceof MemberElement) {
            MemberElement me = (MemberElement)e;
            while (me != null) {
                ClassElement ce;
                FieldElement[] fields;
                if (me instanceof ClassElement && (fields = (ce = (ClassElement)me).getFields()) != null) {
                    int i = 0;
                    while (i < fields.length) {
                        Element elem;
                        SourceCookie.Editor sce;
                        DataObject dob;
                        if (fields[i].getName().getFullName().equals(varName) && (dob = NbEditorUtilities.getDataObject(this.getDocument())) != null && (sce = (SourceCookie.Editor)dob.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie$Editor") : class$org$openide$cookies$SourceCookie$Editor)) != null && (elem = sce.sourceToText((org.openide.src.Element)fields[i])) != null) {
                            return elem.getStartOffset();
                        }
                        ++i;
                    }
                }
                me = me.getDeclaringClass();
            }
        }
        return -1;
    }

    private org.openide.src.Element getElementAtPos(int pos) {
        SourceCookie.Editor sce;
        DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
        if (dob != null && (sce = (SourceCookie.Editor)dob.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor)) != null) {
            return sce.findElement(pos);
        }
        return null;
    }

    private ClassElement getClassElement(int pos) {
        ClassElement ce = null;
        org.openide.src.Element elem = this.getElementAtPos(pos);
        if (elem instanceof ClassElement) {
            ce = (ClassElement)elem;
        } else if (elem instanceof MemberElement) {
            ce = ((MemberElement)elem).getDeclaringClass();
        } else if (elem instanceof InitializerElement) {
            ce = ((InitializerElement)elem).getDeclaringClass();
        }
        return ce;
    }

    public JCClass getTopClass() {
        DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
        if (dob != null) {
            String topClassName = dob.getPrimaryFile().getPackageName('.');
            return JavaCompletion.getFinder().getExactClass(topClassName);
        }
        return null;
    }

    public JCClass getClassFromName(String className, boolean searchByName) {
        JCClass innerCls = JavaKit.findResultInnerClass(this.getTopClass(), className);
        return innerCls != null ? innerCls : super.getClassFromName(className, searchByName);
    }

    public String getPackage() {
        Identifier pkg;
        SourceElement se;
        SourceCookie sc;
        DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
        if (dob != null && (sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null && (se = sc.getSource()) != null && (pkg = se.getPackage()) != null) {
            return pkg.getFullName();
        }
        return "";
    }

    public JCClass getClass(int pos) {
        ClassElement ce = this.getClassElement(pos);
        if (ce != null) {
            return JavaCompletion.getFinder().getExactClass(ce.getName().getFullName());
        }
        return null;
    }

    public boolean isStaticBlock(int pos) {
        org.openide.src.Element elem = this.getElementAtPos(pos);
        if (elem instanceof MethodElement) {
            return (((MethodElement)elem).getModifiers() & 8) != 0;
        }
        if (elem instanceof FieldElement) {
            return (((FieldElement)elem).getModifiers() & 8) != 0;
        }
        return elem instanceof InitializerElement;
    }

    private ClassElement[] getAllClassElements() {
        SourceElement se;
        SourceCookie sc;
        DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
        if (dob != null && (sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null && (se = sc.getSource()) != null) {
            return se.getAllClasses();
        }
        return null;
    }

    public boolean isPrepared() {
        SourceElement se;
        SourceCookie sc;
        DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
        return dob == null || (sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) == null || (se = sc.getSource()) == null || se.getStatus() != 0 && se.getStatus() != 1;
    }

    private void performRefresh() {
        JCFinder finder = JavaCompletion.getFinder();
        ClassElement[] ces = this.getAllClassElements();
        if (ces != null) {
            int i = 0;
            while (i < ces.length) {
                JCClass classToAppend = JCExtension.parseClassElement(ces[i], 0, 0, 0, this.jcLookupCache, true);
                if (classToAppend != null) {
                    finder.append(new JavaCompletion.SingleProvider(classToAppend));
                    this.refreshParents(classToAppend);
                }
                ++i;
            }
        }
        this.jcValid = true;
    }

    public void refreshClassInfo() {
        if (!this.jcValid) {
            DataObject dob = NbEditorUtilities.getDataObject(this.getDocument());
            if (dob == null) {
                return;
            }
            SourceCookie sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
            if (sc == null) {
                return;
            }
            SourceElement se = sc.getSource();
            Task parsingTask = se.prepare();
            if (parsingTask.isFinished()) {
                this.performRefresh();
            } else {
                parsingTask.addTaskListener(new TaskListener(){

                    public void taskFinished(Task t) {
                        t.removeTaskListener((TaskListener)this);
                        NbJavaSyntaxSupport.this.performRefresh();
                    }
                });
            }
        }
    }

    private void refreshParents(JCClass cls) {
        JCFinder finder = JavaCompletion.getFinder();
        ArrayList<JCClass> clsList = new ArrayList<JCClass>();
        clsList.add(cls);
        while ((cls = cls.getSuperclass()) != null && !cls.equals(JavaCompletion.INVALID_CLASS) && clsList.indexOf(cls) < 0) {
            JCClass fc = finder.getExactClass(cls.getFullName());
            if (fc == null) {
                ClassElement ce = ClassElement.forName((String)cls.getFullName());
                if (ce != null) {
                    fc = JCExtension.parseClassElement(ce, 0, 0, 0, this.jcLookupCache, true);
                }
                if (fc == null) break;
                finder.append(new JavaCompletion.SingleProvider(fc));
            }
            cls = fc;
            clsList.add(cls);
        }
    }

    protected Map buildGlobalVariableMap(int pos) {
        this.refreshClassInfo();
        JCFinder finder = JavaCompletion.getFinder();
        JCClass cls = this.getClass(pos);
        if (cls != null) {
            HashMap<String, JCType> varMap = new HashMap<String, JCType>();
            List fldList = finder.findFields(cls, "", false, false, true);
            int i = fldList.size() - 1;
            while (i >= 0) {
                JCField fld = (JCField)fldList.get(i);
                varMap.put(fld.getName(), fld.getType());
                --i;
            }
            return varMap;
        }
        return null;
    }

    private ClassElement recurseClasses(ClassElement[] classes, String name) {
        int i = 0;
        while (i < classes.length) {
            ClassElement ce = classes[i];
            if (ce.getName().getFullName().replace('$', '.').equals(name)) {
                return ce;
            }
            ClassElement inner = this.recurseClasses(ce.getClasses(), name);
            if (inner != null) {
                return inner;
            }
            ++i;
        }
        return null;
    }

    private DataObject getDataObject(FileObject fo) {
        DataObject dob = null;
        if (fo != null) {
            try {
                dob = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dob;
    }

    private DataObject getDataObject(Repository rep, JCClass cls) {
        FileObject fo;
        DataObject dob = null;
        String clsName = cls.getName();
        int dotInd = clsName.indexOf(46, 0);
        if (dotInd >= 0) {
            clsName = clsName.substring(0, dotInd);
        }
        if ((fo = rep.find(cls.getPackageName(), clsName, "java")) != null) {
            dob = this.getDataObject(fo);
        }
        return dob;
    }

    private SourceElement getSourceElement(DataObject classDOB) {
        SourceCookie sc;
        SourceElement se = null;
        if (classDOB != null && (sc = (SourceCookie)classDOB.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null) {
            se = sc.getSource();
        }
        return se;
    }

    private ClassElement getClassElement(DataObject classDOB, JCClass cls) {
        SourceElement se = this.getSourceElement(classDOB);
        ClassElement ce = null;
        if (se != null) {
            ce = this.recurseClasses(se.getClasses(), cls.getFullName());
        }
        return ce;
    }

    private void openAtElement(final DataObject classDOB, final org.openide.src.Element e) {
        new Thread(){
            static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

            public void run() {
                OpenCookie oc;
                OpenCookie openCookie = e != null ? (OpenCookie)e.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = 2.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie) : (oc = (OpenCookie)classDOB.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = 2.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie));
                if (oc != null) {
                    oc.open();
                    return;
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }.start();
    }

    private String getSourceName(JCClass cls, boolean shortName) {
        String name = cls.getName();
        int icInd = name.indexOf(46);
        if (icInd >= 0) {
            name = name.substring(0, icInd);
        }
        return shortName ? name : cls.getPackageName() + '.' + name;
    }

    public String openSource(Object item, boolean findDeclaration, boolean simulate) {
        JCConstructor ctr;
        JCClass cls;
        Repository rep = Repository.getDefault();
        DataObject dob = null;
        ClassElement elem = null;
        String ret = null;
        boolean found = false;
        if (item instanceof JCPackage) {
            if (!findDeclaration) {
                String pkgName = ((JCPackage)item).getName();
                if (pkgName == null || pkgName.length() <= 0) {
                    return null;
                }
                FileObject fo = rep.find(pkgName, null, null);
                if (fo != null && (dob = this.getDataObject(fo)) != null) {
                    Node node = dob.getNodeDelegate();
                    if (node != null) {
                        found = true;
                        if (!simulate) {
                            NodeOperation.getDefault().explore(node);
                        }
                    }
                    dob = null;
                }
                if (simulate || !found) {
                    ret = pkgName;
                }
            }
        } else if (item instanceof JCClass) {
            JCClass cls2 = (JCClass)item;
            if (!JavaCompletion.isPrimitiveClass(cls2)) {
                dob = this.getDataObject(rep, cls2);
                if (dob == null) {
                    dob = this.openViaClass(cls2);
                }
                if (dob != null) {
                    found = true;
                    elem = this.getClassElement(dob, cls2);
                }
                if (simulate || !found) {
                    ret = this.getSourceName(cls2, simulate);
                }
            }
        } else if (item instanceof JCField) {
            JCClass cls3;
            JCField fld = (JCField)item;
            JCClass jCClass = cls3 = findDeclaration ? fld.getClazz() : fld.getType().getClazz();
            if (!JavaCompletion.isPrimitiveClass(cls3)) {
                dob = this.getDataObject(rep, cls3);
                if (dob == null) {
                    dob = this.openViaClass(cls3);
                }
                if (dob != null) {
                    found = true;
                    ClassElement ce = this.getClassElement(dob, cls3);
                    if (ce != null) {
                        elem = JCExtension.findFieldElement(fld, ce);
                    }
                }
                if (simulate || !found) {
                    ret = this.getSourceName(cls3, simulate);
                }
            }
        } else if (item instanceof JCMethod) {
            JCMethod mtd = (JCMethod)item;
            JCClass cls4 = mtd.getClazz();
            if (!JavaCompletion.isPrimitiveClass(cls4)) {
                dob = this.getDataObject(rep, cls4);
                if (dob == null) {
                    dob = this.openViaClass(cls4);
                }
                if (dob != null) {
                    found = true;
                    ClassElement ce = this.getClassElement(dob, cls4);
                    if (ce != null) {
                        elem = JCExtension.findMethodElement(mtd, ce);
                    }
                }
                if (simulate || !found) {
                    ret = this.getSourceName(cls4, simulate);
                }
            }
        } else if (item instanceof JCConstructor && !JavaCompletion.isPrimitiveClass(cls = (ctr = (JCConstructor)item).getClazz())) {
            dob = this.getDataObject(rep, cls);
            if (dob == null) {
                dob = this.openViaClass(cls);
            }
            if (dob != null) {
                found = true;
                ClassElement ce = this.getClassElement(dob, cls);
                if (ce != null) {
                    elem = JCExtension.findConstructorElement(ctr, ce);
                }
            }
            if (simulate || !found) {
                ret = this.getSourceName(cls, simulate);
            }
        }
        if (dob != null && !simulate) {
            this.openAtElement(dob, (org.openide.src.Element)elem);
            NbEditorUtilities.addJumpListEntry(dob);
        }
        return ret;
    }

    private DataObject openViaClass(JCClass cls) {
        DataObject dobj;
        FileObject foClass = Repository.getDefault().find(cls.getPackageName(), cls.getName(), "class");
        if (foClass == null) {
            return null;
        }
        try {
            dobj = DataObject.find((FileObject)foClass.getParent());
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dobj == null) {
            return null;
        }
        DataFolder packageFolder = (DataFolder)dobj.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NbJavaSyntaxSupport.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (packageFolder == null) {
            return null;
        }
        DataObject[] children = packageFolder.getChildren();
        int i = 0;
        while (i < children.length) {
            SourceCookie sc;
            DataObject dob = children[i];
            if (!(dob instanceof DataFolder) && (sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie)) != null) {
                SourceElement se = sc.getSource();
                ClassElement[] ce = se.getClasses();
                String topClassName = dob.getPrimaryFile().getPackageName('.');
                int j = 0;
                while (j < ce.length) {
                    FileObject fo;
                    String innerTopClass = ce[j].getName().getFullName();
                    if (!topClassName.equals(innerTopClass) && innerTopClass.equals(foClass.getPackageName('.')) && (fo = Repository.getDefault().findResource(topClassName.replace('.', '/') + ".java")) != null) {
                        try {
                            return DataObject.find((FileObject)fo);
                        }
                        catch (DataObjectNotFoundException dnfe) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private FileSystem[] getDocFileSystems() {
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        Enumeration en = Repository.getDefault().getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (!fs.getCapability().capableOf(FileSystemCapability.DOC)) continue;
            fsList.add(fs);
        }
        FileSystem[] ret = new FileSystem[fsList.size()];
        fsList.toArray(ret);
        return ret;
    }

    private FileObject[] getDocFileObjects(String pkg, String name) {
        FileSystem[] fss = this.getDocFileSystems();
        ArrayList<FileObject> foList = new ArrayList<FileObject>();
        String apiPkg = "api." + pkg;
        int i = 0;
        while (i < fss.length) {
            FileObject fo = fss[i].find(pkg, name, "html");
            if (fo == null) {
                fo = fss[i].find(apiPkg, name, "html");
            }
            if (fo != null) {
                foList.add(fo);
            }
            ++i;
        }
        FileObject[] ret = new FileObject[foList.size()];
        foList.toArray(ret);
        return ret;
    }

    public URL[] getJavaDocURLs(Object obj) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (obj instanceof JCPackage) {
            JCPackage pkg = (JCPackage)obj;
            FileObject[] fos = this.getDocFileObjects(pkg.getName(), PACKAGE_SUMMARY);
            int i = 0;
            while (i < fos.length) {
                try {
                    urlList.add(fos[i].getURL());
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                ++i;
            }
        } else if (obj instanceof JCClass) {
            JCClass cls = (JCClass)obj;
            FileObject[] fos = this.getDocFileObjects(cls.getPackageName(), cls.getName());
            int i = 0;
            while (i < fos.length) {
                try {
                    urlList.add(fos[i].getURL());
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                ++i;
            }
        } else if (obj instanceof JCConstructor) {
            JCConstructor ctr = (JCConstructor)obj;
            JCClass cls = ctr.getClazz();
            FileObject[] fos = this.getDocFileObjects(cls.getPackageName(), cls.getName());
            int i = 0;
            while (i < fos.length) {
                try {
                    URL url = fos[i].getURL();
                    StringBuffer sb = new StringBuffer("#");
                    sb.append(obj instanceof JCMethod ? ((JCMethod)ctr).getName() : cls.getName());
                    sb.append('(');
                    JCParameter[] parms = ctr.getParameters();
                    int cntM1 = parms.length - 1;
                    int j = 0;
                    while (j <= cntM1) {
                        sb.append(parms[j].getType().format(true));
                        if (j < cntM1) {
                            sb.append(", ");
                        }
                        ++j;
                    }
                    sb.append(')');
                    try {
                        urlList.add(new URL(url.toString() + sb));
                    }
                    catch (MalformedURLException e) {}
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                ++i;
            }
        } else if (obj instanceof JCField) {
            JCField fld = (JCField)obj;
            JCClass cls = fld.getClazz();
            FileObject[] fos = this.getDocFileObjects(cls.getPackageName(), cls.getName());
            int i = 0;
            while (i < fos.length) {
                try {
                    URL url = fos[i].getURL();
                    try {
                        urlList.add(new URL(url.toString() + '#' + fld.getName()));
                    }
                    catch (MalformedURLException e) {}
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        URL[] ret = new URL[urlList.size()];
        urlList.toArray(ret);
        return ret;
    }

    public Debugger getDebugger() {
        Debugger deb = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = NbJavaSyntaxSupport.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        return deb;
    }

    public Breakpoint getBreakpoint(int pos) {
        Debugger debugger = this.getDebugger();
        Line line = NbEditorUtilities.getLine(this.getDocument(), pos, false);
        if (debugger != null && line != null) {
            return debugger.findBreakpoint(line);
        }
        return null;
    }

    public Breakpoint createBreakpoint(int pos) {
        Debugger debugger = this.getDebugger();
        Line line = NbEditorUtilities.getLine(this.getDocument(), pos, false);
        if (debugger != null && line != null) {
            return debugger.createBreakpoint(line);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

