/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.java.JCStorage;
import org.netbeans.modules.editor.java.JCStorageElement;
import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.editor.java.PDCustomizerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class PDCustomizer {
    private final PDCustomizerDialog pdDialog;
    private static PDCustomizer customizer;
    public JButton closeOption;
    private String[] columnNames = new String[]{this.getBundleString("PDCD_PREFIX"), this.getBundleString("PDCD_FILESYSTEM"), this.getBundleString("PDCD_AUTOUPDATE"), this.getBundleString("PDCD_STATUS")};
    private static final String HELP_ID = "editing.completion.manager";
    private static final Comparator ELEMENTS_COMPARATOR;
    private CustomizerTableModel model;
    private JCStorageElement[] elements;
    private PropertyChangeListener storageListener;
    private Dialog dialog;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$PDCustomizer;

    private PDCustomizer() {
        this.closeOption = new JButton(this.getBundleString("PDCD_CLOSE"));
        this.closeOption.setMnemonic(this.getBundleString("PDCD_CLOSE").charAt(0));
        this.closeOption.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_PDCD_CLOSE"));
        this.model = new CustomizerTableModel();
        this.pdDialog = new PDCustomizerDialog((Frame)new JFrame(), true);
        this.pdDialog.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    PDCustomizer.this.pdDialog.enableDeleteButton(true);
                    if (lsm.getMaxSelectionIndex() > lsm.getMinSelectionIndex()) {
                        PDCustomizer.this.pdDialog.enableUpdateButton(false);
                        return;
                    }
                    int selectedRow = lsm.getMinSelectionIndex();
                    Object o = PDCustomizer.this.model.getValueAt(selectedRow, 1);
                    boolean fsAvailable = o != null && o instanceof String && PDCustomizer.this.getMountedFS((String)o) != null;
                    PDCustomizer.this.pdDialog.enableUpdateButton(fsAvailable);
                    int elemStatus = JCStorage.getStorage().getFSStatus(PDCustomizer.this.getMountedFS((String)o));
                    boolean isParsing = elemStatus == 2 || elemStatus == 1;
                    PDCustomizer.this.pdDialog.enableStopButton(isParsing);
                }
            }
        });
        this.pdDialog.getTable().setModel(this.model);
        this.pdDialog.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel colModel = PDCustomizer.this.pdDialog.getTable().getColumnModel();
                int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
                if (columnModelIndex != 0) {
                    return;
                }
                ((ElementsComparator)ELEMENTS_COMPARATOR).changeSortOrder();
                PDCustomizer.this.refresh();
            }
        });
        this.storageListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PDCustomizer.this.refresh();
            }
        };
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$PDCustomizer == null ? (class$org$netbeans$modules$editor$java$PDCustomizer = PDCustomizer.class$("org.netbeans.modules.editor.java.PDCustomizer")) : class$org$netbeans$modules$editor$java$PDCustomizer), (String)s);
    }

    Dialog getCustomizer() {
        if (this.dialog == null) {
            this.attachListener();
            DialogDescriptor dd = new DialogDescriptor((Object)this.pdDialog.getContentPane(), this.getBundleString("PDCD_PDCUSTOMIZER"), false, new Object[]{this.closeOption}, (Object)this.closeOption, 0, new HelpCtx(HELP_ID), null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dd);
        }
        this.refresh();
        return this.dialog;
    }

    FileSystem getMountedFS(String fsName) {
        if (fsName == null) {
            return null;
        }
        Enumeration e = Repository.getDefault().getFileSystems();
        while (e.hasMoreElements()) {
            FileSystem fs;
            Object obj = e.nextElement();
            if (!(obj instanceof FileSystem) || !fsName.equals((fs = (FileSystem)obj).getSystemName())) continue;
            return fs;
        }
        return null;
    }

    public void refresh() {
        final Object[][] data = this.getData();
        if (SwingUtilities.isEventDispatchThread()) {
            this.setData(data);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PDCustomizer.this.setData(data);
                }
            });
        }
    }

    private String getStatusString(int status) {
        String ret = "";
        switch (status) {
            case 1: {
                ret = this.getBundleString("PDCD_STATUS_PARSING");
                break;
            }
            case 2: {
                ret = this.getBundleString("PDCD_STATUS_QUEUED");
                break;
            }
            case 3: {
                ret = this.getBundleString("PDCD_STATUS_CANCELLED");
            }
        }
        return ret;
    }

    private JCStorageElement[] sort(JCStorageElement[] elems) {
        Arrays.sort(elems, ELEMENTS_COMPARATOR);
        return elems;
    }

    public Object[][] getData() {
        this.elements = this.sort(JCStorage.getStorage().getElements());
        Object[][] data = new Object[this.elements.length][4];
        int i = 0;
        while (i < this.elements.length) {
            String status = "";
            FileSystem mountedFS = this.getMountedFS(this.elements[i].getFileSystemName());
            if (mountedFS != null) {
                status = this.getStatusString(JCStorage.getStorage().getFSStatus(mountedFS));
            }
            data[i] = new Object[]{this.elements[i].getName(), this.elements[i].getFileSystemName(), this.elements[i].getAutoUpdate() && mountedFS != null ? Boolean.TRUE : Boolean.FALSE, status};
            ++i;
        }
        return data;
    }

    public void setData(Object[][] newData) {
        this.model.setDataVector(newData, this.columnNames);
        this.pdDialog.getTable().getColumnModel().getColumn(0).setPreferredWidth(130);
        this.pdDialog.getTable().getColumnModel().getColumn(1).setPreferredWidth(130);
        this.pdDialog.getTable().getColumnModel().getColumn(2).setPreferredWidth(25);
        this.pdDialog.getTable().getColumnModel().getColumn(3).setPreferredWidth(25);
        this.pdDialog.enableUpdateButton(false);
        this.pdDialog.enableDeleteButton(false);
        this.pdDialog.enableStopButton(false);
    }

    public static synchronized PDCustomizer getDefault() {
        if (customizer == null) {
            customizer = new PDCustomizer();
        }
        return customizer;
    }

    private DataObject getSelectedFSDO() {
        DataObject ret = null;
        int selectedRow = this.pdDialog.getTable().getSelectedRow();
        Object o = this.model.getValueAt(selectedRow, 1);
        if (o != null && o instanceof String) {
            String fsName = (String)o;
            FileSystem fs = this.getMountedFS(fsName);
            if (fs == null) {
                return null;
            }
            FileObject fo = fs.getRoot();
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    if (dobj != null && dobj.isValid()) {
                        return dobj;
                    }
                }
                catch (DataObjectNotFoundException donf) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public void delete(String prefixName, boolean notify) {
        if (prefixName == null) {
            return;
        }
        JCStorageElement elem = JCStorage.getStorage().getElement(prefixName);
        if (notify && elem != null) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)MessageFormat.format(this.getBundleString("PDC_DeleteQuestion"), elem.getName()), this.getBundleString("PDC_DeleteDialogTitle"), 0, 3, null, NotifyDescriptor.YES_OPTION);
            DialogDisplayer.getDefault().notify(nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        JCStorage.getStorage().deleteFile(elem);
    }

    protected void delete() {
        int[] selectedRow = this.pdDialog.getTable().getSelectedRows();
        String[] deletedDBs = new String[selectedRow.length];
        int i = 0;
        while (i < selectedRow.length) {
            deletedDBs[i] = null;
            Object o = this.model.getValueAt(selectedRow[i], 0);
            if (o != null && o instanceof String) {
                deletedDBs[i] = (String)o;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < deletedDBs.length) {
            if (deletedDBs[i2] != null) {
                this.delete(deletedDBs[i2], true);
            }
            ++i2;
        }
    }

    protected void add() {
        block14: {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
                }

                public String getDescription() {
                    return PDCustomizer.this.getBundleString("PDC_JarArchivesMask");
                }
            });
            chooser.setDialogTitle(this.getBundleString("PDC_ChooserTitle"));
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), this.getBundleString("PDC_SelectButton")) == 0) {
                File file = chooser.getSelectedFile();
                try {
                    boolean alreadyMounted;
                    LocalFileSystem mountedFS = null;
                    if (file.isDirectory()) {
                        mountedFS = new LocalFileSystem();
                        mountedFS.setRootDirectory(file);
                    } else if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                        mountedFS = new JarFileSystem();
                        ((JarFileSystem)mountedFS).setJarFile(file);
                    }
                    if (mountedFS == null) {
                        return;
                    }
                    mountedFS.setHidden(true);
                    if (Repository.getDefault().findFileSystem(mountedFS.getSystemName()) == null) {
                        Repository.getDefault().addFileSystem((FileSystem)mountedFS);
                        alreadyMounted = false;
                    } else {
                        alreadyMounted = true;
                    }
                    LocalFileSystem fileSystem = mountedFS;
                    FileObject fo = mountedFS.getRoot();
                    if (fo == null) break block14;
                    try {
                        DataObject dobj = DataObject.find((FileObject)fo);
                        if (dobj != null && dobj.isValid() && dobj != null) {
                            JCUpdater update = new JCUpdater(new Node[]{dobj.getNodeDelegate()}, true);
                            if (!alreadyMounted) {
                                update.addPropertyChangeListener(new PropertyChangeListener((FileSystem)fileSystem, update){
                                    private final /* synthetic */ FileSystem val$fileSystem;
                                    private final /* synthetic */ JCUpdater val$update;
                                    {
                                        this.val$fileSystem = val$fileSystem;
                                        this.val$update = val$update;
                                    }

                                    public void propertyChange(PropertyChangeEvent e) {
                                        if (e == null) {
                                            return;
                                        }
                                        if ("mount_fs".equals(e.getPropertyName())) {
                                            boolean mount;
                                            boolean bl = mount = e.getNewValue() != null && e.getNewValue() instanceof Boolean ? (Boolean)e.getNewValue() : false;
                                            if (!mount) {
                                                Repository.getDefault().removeFileSystem(this.val$fileSystem);
                                                JCStorageElement elem = JCStorage.getStorage().findFileSystemElement(this.val$fileSystem.getSystemName());
                                                if (elem != null) {
                                                    elem.setAutoUpdate(false);
                                                    PDCustomizer.this.refresh();
                                                }
                                            } else {
                                                this.val$fileSystem.setHidden(false);
                                            }
                                            if (this.val$update != null) {
                                                this.val$update.setPriority(1);
                                                this.val$update.removePropertyChangeListener(this);
                                            }
                                        }
                                    }
                                });
                            }
                            update.start();
                        }
                    }
                    catch (DataObjectNotFoundException donf) {}
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace();
                }
            }
        }
    }

    protected void update() {
        DataObject dobj = this.getSelectedFSDO();
        if (dobj != null) {
            JCUpdater update = new JCUpdater(new Node[]{dobj.getNodeDelegate()});
            update.setPriority(1);
            update.start();
        }
    }

    protected void stop() {
        int[] selectedRow = this.pdDialog.getTable().getSelectedRows();
        String[] stoppedElements = new String[selectedRow.length];
        int i = 0;
        while (i < selectedRow.length) {
            stoppedElements[i] = null;
            Object o = this.model.getValueAt(selectedRow[i], 1);
            if (o != null && o instanceof String) {
                stoppedElements[i] = (String)o;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < stoppedElements.length) {
            if (stoppedElements[i2] != null) {
                FileSystem mountedFS = this.getMountedFS(stoppedElements[i2]);
                int status = JCStorage.getStorage().getFSStatus(mountedFS);
                if (status == 1 || status == 2) {
                    JCStorage.getStorage().stopFSParsing(mountedFS);
                }
            }
            ++i2;
        }
    }

    public void openDialog() {
        if (this.dialog == null) {
            this.attachListener();
            DialogDescriptor dd = new DialogDescriptor((Object)this.pdDialog.getContentPane(), this.getBundleString("PDCD_PDCUSTOMIZER"), false, new Object[]{this.closeOption}, (Object)this.closeOption, 0, new HelpCtx(HELP_ID), null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dd);
        }
        this.refresh();
        this.dialog.show();
    }

    void attachListener() {
        JCStorage.getStorage().addPropertyChangeListener(this.storageListener);
    }

    void detachListener() {
        JCStorage.getStorage().addPropertyChangeListener(this.storageListener);
    }

    public CustomizerTableModel getCustomizerTableModel() {
        return this.model;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ELEMENTS_COMPARATOR = new ElementsComparator();
    }

    private static final class ElementsComparator
    implements Comparator {
        private boolean ascending = true;

        private ElementsComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof JCStorageElement && o2 instanceof JCStorageElement) {
                String objOneName = ((JCStorageElement)o1).getName();
                String objTwoName = ((JCStorageElement)o2).getName();
                if (objOneName != null && objTwoName != null) {
                    return this.ascending ? objOneName.compareTo(objTwoName) : -objOneName.compareTo(objTwoName);
                }
            }
            return 0;
        }

        public void changeSortOrder() {
            this.ascending = !this.ascending;
        }
    }

    private class CustomizerTableModel
    extends DefaultTableModel
    implements TableModelListener {
        boolean[] canEdit = new boolean[]{false, false, true, false};
        static /* synthetic */ Class class$java$lang$Boolean;

        public CustomizerTableModel() {
            this.addTableModelListener(this);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object o = PDCustomizer.this.model.getValueAt(rowIndex, 1);
            boolean fsAvailable = o != null && o instanceof String && PDCustomizer.this.getMountedFS((String)o) != null;
            return this.canEdit[columnIndex] && fsAvailable;
        }

        public Class getColumnClass(int i) {
            if (i == 2) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = CustomizerTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return super.getColumnClass(i);
        }

        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int column = e.getColumn();
            if (column != 2) {
                return;
            }
            Object data = PDCustomizer.this.model.getValueAt(row, column);
            if (data instanceof Boolean) {
                PDCustomizer.this.elements[row].setAutoUpdate((Boolean)data);
                JCStorage.getStorage().saveElements();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

