/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.FileAccessor;
import org.netbeans.editor.ext.java.DAFileProvider;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFileProvider;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JCUpdater;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.Lookup;

public class StandaloneJCDBCreator {
    private static JCFileProvider fp;
    private static Map cacheMap;
    private static List sourcePaths;
    private static List dbFileName;
    private static int classLevel;
    private static int fieldLevel;
    private static int methodLevel;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private static void appendSource(SourceCookie sc, Map cache) {
        SourceElement se = sc.getSource();
        ClassElement[] ce = se.getAllClasses();
        if (ce == null) {
            return;
        }
        int i = 0;
        while (i < ce.length) {
            JCClass classToAppend;
            if (JavaCompletion.getLevel(ce[i].getModifiers()) >= classLevel && (classToAppend = JCExtension.parseClassElement(ce[i], classLevel, fieldLevel, methodLevel, cache, false)) != null) {
                fp.append(new JavaCompletion.SingleProvider(classToAppend));
                classToAppend = null;
            }
            ++i;
        }
    }

    private static void parseFolder(DataFolder df) {
        DataObject[] children = df.getChildren();
        children = (DataObject[])children.clone();
        int i = 0;
        while (i < children.length) {
            DataObject dob = children[i];
            if (dob instanceof DataFolder) {
                StandaloneJCDBCreator.parseFolder((DataFolder)dob);
            } else {
                SourceCookie sc = (SourceCookie)dob.getCookie(class$org$openide$cookies$SourceCookie == null ? StandaloneJCDBCreator.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                if (sc != null) {
                    StandaloneJCDBCreator.appendSource(sc, cacheMap);
                }
            }
            children[i] = null;
            ++i;
        }
    }

    private static void createDB(DataObject dob, String fileName) {
        if (!(dob instanceof DataFolder)) {
            System.out.println();
            return;
        }
        File skels = new File(fileName + "." + "jcs");
        File bodies = new File(fileName + "." + "jcb");
        System.out.println("Creating DB files: " + skels + " " + bodies);
        fp = new DAFileProvider(new FileAccessor(skels), new FileAccessor(bodies));
        fp.reset();
        JavaCompletion.setFinderInitializer(new JavaCompletion.JCFinderInitializer(){

            public void initJCFinder() {
            }
        });
        System.out.println("Parsing...");
        StandaloneJCDBCreator.parseFolder((DataFolder)dob);
    }

    private static void parseArguments(String[] args) {
        String param;
        sourcePaths = new ArrayList();
        dbFileName = new ArrayList();
        String sp = args[0];
        String names = args[1];
        int numOfPaths = 0;
        int numOfNames = 0;
        StringTokenizer st = new StringTokenizer(sp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            param = st.nextToken();
            if (param.length() <= 0) continue;
            sourcePaths.add(param);
            ++numOfPaths;
        }
        st = new StringTokenizer(names, File.pathSeparator);
        while (st.hasMoreTokens() && numOfNames < numOfPaths) {
            param = st.nextToken();
            if (param.length() <= 0) continue;
            dbFileName.add(param);
            ++numOfNames;
        }
        int i = numOfNames;
        while (i < numOfPaths) {
            String generatedName = JCUpdater.constructPrefixName((String)sourcePaths.get(i));
            System.out.println("Generated name: " + generatedName);
            dbFileName.add(generatedName);
            ++i;
        }
        classLevel = Integer.parseInt(args[2]);
        fieldLevel = Integer.parseInt(args[3]);
        methodLevel = Integer.parseInt(args[4]);
    }

    private static FileSystem createFileSystem(File f) {
        LocalFileSystem ret = null;
        try {
            if (f.isDirectory()) {
                ret = new LocalFileSystem();
                ret.setRootDirectory(f);
            } else if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
                ret = new JarFileSystem();
                ((JarFileSystem)ret).setJarFile(f);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (PropertyVetoException pve) {
            pve.printStackTrace();
        }
        return ret;
    }

    private static void argsMessage() {
        System.out.println("arg1=base-source-dirs separated by ; or :\narg2=target-file-prefix-names separated by ; or :\narg3=class-level\narg4=field-level\narg5=method-level\nStorage level: 0=all, 1=not private 2=public and protected, 3=public only\nExample of args: e:\\java\\jdk140\\src;e:\\nb\\openide.jar e:\\databases\\jdk140;e:\\databases\\netbeans\\openide 2 2 2");
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            StandaloneJCDBCreator.argsMessage();
            throw new IllegalArgumentException();
        }
        Lookup.getDefault().lookup(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = StandaloneJCDBCreator.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo);
        StandaloneJCDBCreator.parseArguments(args);
        int i = 0;
        while (i < sourcePaths.size()) {
            File f = new File((String)sourcePaths.get(i));
            if (!(f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip"))) {
                throw new IllegalArgumentException(f.getAbsolutePath());
            }
            System.out.println("Processing: " + f);
            FileSystem fs = StandaloneJCDBCreator.createFileSystem(f);
            if (fs == null) {
                throw new IllegalArgumentException(f.getAbsolutePath());
            }
            fs.setHidden(true);
            if (Repository.getDefault().findFileSystem(fs.getSystemName()) == null) {
                Repository.getDefault().addFileSystem(fs);
            }
            FileObject fo = fs.getRoot();
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (dobj.isValid()) {
                    StandaloneJCDBCreator.createDB(dobj, (String)dbFileName.get(i));
                    System.out.println("Created " + dbFileName.get(i));
                }
            }
            catch (DataObjectNotFoundException donf) {
                donf.printStackTrace();
            }
            if (Repository.getDefault().findFileSystem(fs.getSystemName()) != null) {
                Repository.getDefault().removeFileSystem(fs);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        cacheMap = new HashMap();
    }
}

