/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AbbrevsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "abbrevs";
    public static final String TAG_ABBREV = "abbrev";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_REMOVE = "remove";
    public static final String ATTR_XML_SPACE = "xml:space";
    public static final String VALUE_XML_SPACE = "preserve";
    static final String FILENAME = "abbreviations";

    public AbbrevsMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    protected synchronized void loadSettings(boolean propagate) {
        Document doc = this.dom;
        Element rootElement = doc.getDocumentElement();
        if (!TAG_ROOT.equals(rootElement.getTagName())) {
            return;
        }
        HashMap mapa = new HashMap((Map)Settings.getValue(this.base.getKitClass(), "abbrev-map"));
        this.properties.clear();
        NodeList abbr = rootElement.getElementsByTagName(TAG_ABBREV);
        int i = 0;
        while (i < abbr.getLength()) {
            Node node = abbr.item(i);
            Element FCElement = (Element)node;
            if (FCElement != null) {
                Node subNode;
                NodeList textList;
                String key = FCElement.getAttribute(ATTR_KEY);
                String delete = FCElement.getAttribute(ATTR_REMOVE);
                String expanded = "";
                if (!Boolean.valueOf(delete).booleanValue() && (textList = FCElement.getChildNodes()).getLength() > 0 && (subNode = textList.item(0)) instanceof Text) {
                    Text textNode = (Text)subNode;
                    expanded = textNode.getData();
                }
                this.properties.put(key, expanded);
            }
            ++i;
        }
        if (this.properties.size() > 0) {
            mapa.putAll(this.properties);
            Iterator i2 = this.properties.keySet().iterator();
            while (i2.hasNext()) {
                String key = (String)i2.next();
                if (((String)this.properties.get(key)).length() != 0) continue;
                mapa.remove(key);
            }
            if (propagate) {
                this.base.setAbbrevMap(mapa, false);
            }
        }
        if (propagate) {
            this.setLoaded(true);
        }
    }

    protected synchronized void updateSettings(Map changedProp) {
        this.properties.putAll(changedProp);
        Document doc = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
        Element rootElem = doc.getDocumentElement();
        ArrayList<String> removed = new ArrayList<String>();
        HashMap defaultAbbrevs = this.base.getDefaultAbbrevMap();
        if (defaultAbbrevs == null) {
            defaultAbbrevs = new HashMap();
        }
        Iterator i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String defValue;
            String key = (String)i.next();
            if (!(this.properties.get(key) instanceof String)) continue;
            String action = (String)this.properties.get(key);
            if (action.length() == 0) {
                if (!defaultAbbrevs.containsKey(key)) {
                    removed.add(key);
                    continue;
                }
            } else if (defaultAbbrevs.containsKey(key) && (defValue = (String)defaultAbbrevs.get(key)).equals(action)) {
                removed.add(key);
                continue;
            }
            Element abbrevElem = doc.createElement(TAG_ABBREV);
            abbrevElem.setAttribute(ATTR_KEY, key);
            if (action.length() == 0) {
                abbrevElem.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
            } else {
                abbrevElem.setAttribute(ATTR_XML_SPACE, VALUE_XML_SPACE);
                abbrevElem.appendChild(doc.createTextNode(action));
            }
            rootElem.appendChild(abbrevElem);
        }
        int i2 = 0;
        while (i2 < removed.size()) {
            this.properties.remove(removed.get(i2));
            ++i2;
        }
        doc.getDocumentElement().normalize();
        this.saveSettings(doc);
    }
}

