/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.editor.AnnotationType;
import org.netbeans.modules.editor.options.AnnotationTypeActionsFolder;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class AnnotationTypeProcessor
implements XMLDataObject.Processor,
InstanceCookie {
    static final String DTD_PUBLIC_ID = "-//NetBeans//DTD annotation type 1.0//EN";
    static final String DTD_SYSTEM_ID = "http://www.netbeans.org/dtds/annotation-type-1_0.dtd";
    static final String TAG_TYPE = "type";
    static final String ATTR_TYPE_NAME = "name";
    static final String ATTR_TYPE_LOCALIZING_BUNDLE = "localizing_bundle";
    static final String ATTR_TYPE_DESCRIPTION_KEY = "description_key";
    static final String ATTR_TYPE_VISIBLE = "visible";
    static final String ATTR_TYPE_GLYPH = "glyph";
    static final String ATTR_TYPE_HIGHLIGHT = "highlight";
    static final String ATTR_TYPE_FOREGROUND = "foreground";
    static final String ATTR_TYPE_WAVEUNDERLINE = "waveunderline";
    static final String ATTR_TYPE_TYPE = "type";
    static final String ATTR_TYPE_CONTENTTYPE = "contenttype";
    static final String ATTR_TYPE_ACTIONS = "actions";
    static final String ATTR_ACTION_NAME = "name";
    static final String TAG_COMBINATION = "combination";
    static final String ATTR_COMBINATION_TIPTEXT_KEY = "tiptext_key";
    static final String ATTR_COMBINATION_ORDER = "order";
    static final String ATTR_COMBINATION_MIN_OPTIONALS = "min_optionals";
    static final String TAG_COMBINE = "combine";
    static final String ATTR_COMBINE_ANNOTATIONTYPE = "annotationtype";
    static final String ATTR_COMBINE_ABSORBALL = "absorb_all";
    static final String ATTR_COMBINE_OPTIONAL = "optional";
    static final String ATTR_COMBINE_MIN = "min";
    private XMLDataObject xmlDataObject;
    private AnnotationType annotationType;
    static /* synthetic */ Class class$org$netbeans$editor$AnnotationType;

    public void attachTo(XMLDataObject xmlDO) {
        this.xmlDataObject = xmlDO;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.annotationType != null) {
            return this.annotationType;
        }
        this.parse();
        return this.annotationType;
    }

    public Class instanceClass() {
        return class$org$netbeans$editor$AnnotationType == null ? (class$org$netbeans$editor$AnnotationType = AnnotationTypeProcessor.class$("org.netbeans.editor.AnnotationType")) : class$org$netbeans$editor$AnnotationType;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    private synchronized AnnotationType parse() {
        if (this.annotationType == null) {
            AnnotationType at = new AnnotationType();
            Handler h = new Handler(at);
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                Parser xp = factory.newSAXParser().getParser();
                xp.setEntityResolver(h);
                xp.setDocumentHandler(h);
                xp.setErrorHandler(h);
                xp.parse(new InputSource(this.xmlDataObject.getPrimaryFile().getInputStream()));
                at.putProp("file", this.xmlDataObject.getPrimaryFile());
                this.annotationType = at;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.annotationType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Handler
    extends HandlerBase {
        private AnnotationType at;
        private int depth = 0;
        private ResourceBundle bundle;
        private List combinations;

        Handler(AnnotationType at) {
            this.at = at;
        }

        private void rethrow(Exception e) throws SAXException {
            SAXException saxe = new SAXException(e);
            ErrorManager.getDefault().copyAnnotation((Throwable)saxe, (Throwable)e);
            throw saxe;
        }

        public void startElement(String name, AttributeList amap) throws SAXException {
            switch (this.depth++) {
                case 0: {
                    if (!"type".equals(name)) {
                        throw new SAXException("malformed AnnotationType xml file");
                    }
                    this.at.setName(amap.getValue("name"));
                    if (amap.getValue("type") == null) {
                        this.at.setWholeLine(true);
                    } else {
                        this.at.setWholeLine("line".equals(amap.getValue("type")));
                    }
                    if (amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_VISIBLE) == null) {
                        this.at.setVisible(true);
                    } else {
                        this.at.setVisible(amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_VISIBLE));
                    }
                    if (this.at.isVisible()) {
                        String localizer = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_LOCALIZING_BUNDLE);
                        String key = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_DESCRIPTION_KEY);
                        this.at.putProp("bundle", localizer);
                        this.at.putProp("desciptionKey", key);
                    }
                    try {
                        String color = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_HIGHLIGHT);
                        if (color != null) {
                            this.at.setHighlight(Color.decode(color));
                            this.at.setUseHighlightColor(true);
                        } else {
                            this.at.setUseHighlightColor(false);
                        }
                        color = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_FOREGROUND);
                        if (color != null) {
                            this.at.setForegroundColor(Color.decode(color));
                            this.at.setInheritForegroundColor(false);
                        } else {
                            this.at.setInheritForegroundColor(true);
                        }
                        color = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_WAVEUNDERLINE);
                        if (color != null) {
                            this.at.setWaveUnderlineColor(Color.decode(color));
                            this.at.setUseWaveUnderlineColor(true);
                        } else {
                            this.at.setUseWaveUnderlineColor(false);
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.rethrow(ex);
                    }
                    try {
                        String uri = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_GLYPH);
                        if (uri != null) {
                            this.at.setGlyph(new URL(uri));
                        }
                    }
                    catch (MalformedURLException ex) {
                        this.rethrow(ex);
                    }
                    String actions = amap.getValue(AnnotationTypeProcessor.ATTR_TYPE_ACTIONS);
                    if (actions == null) break;
                    AnnotationTypeActionsFolder.readActions(this.at, actions);
                    this.at.putProp("actionsFolder", actions);
                    break;
                }
                case 1: {
                    String min;
                    String order;
                    if (!AnnotationTypeProcessor.TAG_COMBINATION.equals(name)) {
                        throw new SAXException("malformed AnnotationType xml file");
                    }
                    this.combinations = new ArrayList();
                    String key = amap.getValue(AnnotationTypeProcessor.ATTR_COMBINATION_TIPTEXT_KEY);
                    if (key != null) {
                        this.at.putProp("tooltipTextKey", key);
                    }
                    if ((order = amap.getValue(AnnotationTypeProcessor.ATTR_COMBINATION_ORDER)) != null) {
                        this.at.setCombinationOrder(order);
                    }
                    if ((min = amap.getValue(AnnotationTypeProcessor.ATTR_COMBINATION_MIN_OPTIONALS)) == null) break;
                    this.at.setMinimumOptionals(min);
                    break;
                }
                case 2: {
                    this.combinations.add(new AnnotationType.CombinationMember(amap.getValue(AnnotationTypeProcessor.ATTR_COMBINE_ANNOTATIONTYPE), amap.getValue(AnnotationTypeProcessor.ATTR_COMBINE_ABSORBALL) == null ? false : "true".equals(amap.getValue(AnnotationTypeProcessor.ATTR_COMBINE_ABSORBALL)), amap.getValue(AnnotationTypeProcessor.ATTR_COMBINE_OPTIONAL) == null ? false : "true".equals(amap.getValue(AnnotationTypeProcessor.ATTR_COMBINE_OPTIONAL)), amap.getValue(AnnotationTypeProcessor.ATTR_COMBINE_MIN)));
                    break;
                }
                default: {
                    throw new SAXException("malformed AnnotationType xml file");
                }
            }
        }

        public void endElement(String name) throws SAXException {
            if (--this.depth == 1) {
                AnnotationType.CombinationMember[] combs = new AnnotationType.CombinationMember[this.combinations.size()];
                this.combinations.toArray(combs);
                this.at.setCombinations(combs);
            }
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (AnnotationTypeProcessor.DTD_PUBLIC_ID.equals(pid)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(sid);
        }
    }
}

