/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnotationTypesFolder
extends FolderInstance {
    private static final String FOLDER = "Editors/AnnotationTypes";
    private static AnnotationTypesFolder folder;
    private Map annotationTypes;
    private FileObject fo;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    private AnnotationTypesFolder(FileObject fo, DataFolder fld) {
        super(fld);
        this.recreate();
        this.instanceFinished();
        this.fo = fo;
        fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fe) {
                Iterator it = AnnotationTypes.getTypes().getAnnotationTypeNames();
                while (it.hasNext()) {
                    AnnotationType type = AnnotationTypes.getTypes().getType((String)it.next());
                    if (type == null || !((FileObject)type.getProp("file")).equals(fe.getFile())) continue;
                    AnnotationTypes.getTypes().removeType(type.getName());
                    break;
                }
            }
        });
    }

    public static synchronized AnnotationTypesFolder getAnnotationTypesFolder() {
        if (folder != null) {
            return folder;
        }
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER);
        if (f == null) {
            return null;
        }
        try {
            DataObject d = DataObject.find((FileObject)f);
            DataFolder df = (DataFolder)d.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = AnnotationTypesFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (df != null) {
                folder = new AnnotationTypesFolder(f, df);
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        return folder;
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        this.annotationTypes = new HashMap(cookies.length * 4 / 3);
        int i = 0;
        while (i < cookies.length) {
            Object o = cookies[i].instanceCreate();
            if (o instanceof AnnotationType) {
                AnnotationType type = (AnnotationType)o;
                this.annotationTypes.put(type.getName(), type);
            }
            ++i;
        }
        AnnotationTypes.getTypes().setTypes(this.annotationTypes);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveAnnotationType(AnnotationType type) {
        FileObject fo = (FileObject)type.getProp("file");
        Document doc = XMLUtil.createDocument((String)"type", null, (String)"-//NetBeans//DTD annotation type 1.0//EN", (String)"http://www.netbeans.org/dtds/annotation-type-1_0.dtd");
        Element typeElem = doc.getDocumentElement();
        typeElem.setAttribute("name", type.getName());
        if (type.getProp("bundle") != null) {
            typeElem.setAttribute("localizing_bundle", (String)type.getProp("bundle"));
        }
        if (type.getProp("desciptionKey") != null) {
            typeElem.setAttribute("description_key", (String)type.getProp("desciptionKey"));
        }
        typeElem.setAttribute("visible", type.isVisible() ? "true" : "false");
        typeElem.setAttribute("type", type.isWholeLine() ? "line" : "linepart");
        if (type.getProp("glyph") != null) {
            typeElem.setAttribute("glyph", type.getGlyph().toExternalForm());
        }
        if (type.getProp("highlight") != null && type.isUseHighlightColor()) {
            typeElem.setAttribute("highlight", "0x" + Integer.toHexString(type.getHighlight().getRGB() & 0xFFFFFF));
        }
        if (type.getProp("waveunderline") != null && type.isUseWaveUnderlineColor()) {
            typeElem.setAttribute("waveunderline", "0x" + Integer.toHexString(type.getWaveUnderlineColor().getRGB() & 0xFFFFFF));
        }
        if (type.getProp("foreground") != null && !type.isInheritForegroundColor()) {
            typeElem.setAttribute("foreground", "0x" + Integer.toHexString(type.getForegroundColor().getRGB() & 0xFFFFFF));
        }
        if (type.getProp("actionsFolder") != null) {
            typeElem.setAttribute("actions", (String)type.getProp("actionsFolder"));
        }
        if (type.getCombinations() != null) {
            Element combsElem = doc.createElement("combination");
            combsElem.setAttribute("tiptext_key", (String)type.getProp("tooltipTextKey"));
            if (type.getProp("combinationOrder") != null) {
                combsElem.setAttribute("order", "" + type.getCombinationOrder());
            }
            if (type.getProp("combinationMinimumOptionals") != null) {
                combsElem.setAttribute("min_optionals", "" + type.getMinimumOptionals());
            }
            typeElem.appendChild(combsElem);
            AnnotationType.CombinationMember[] combs = type.getCombinations();
            int i = 0;
            while (i < combs.length) {
                Element combElem = doc.createElement("combine");
                combElem.setAttribute("annotationtype", combs[i].getName());
                combElem.setAttribute("absorb_all", combs[i].isAbsorbAll() ? "true" : "false");
                combElem.setAttribute("optional", combs[i].isOptional() ? "true" : "false");
                if (combs[i].getMinimumCount() > 0) {
                    combElem.setAttribute("min", "" + combs[i].getMinimumCount());
                }
                combsElem.appendChild(combElem);
                ++i;
            }
        }
        doc.getDocumentElement().normalize();
        try {
            FileLock lock = fo.lock();
            try {
                try {
                    XMLUtil.write((Document)doc, (OutputStream)fo.getOutputStream(lock), null);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    Object var10_12 = null;
                    lock.releaseLock();
                    return;
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

