/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.modules.editor.options.AnnotationTypeOptions;
import org.netbeans.modules.editor.options.AnnotationTypesFolder;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class AnnotationTypesNode
extends AbstractNode {
    private static final String HELP_ID = "editing.configuring.annotations";
    private static final String ICON_BASE = "org/netbeans/modules/editor/resources/annotationtypes";
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$AnnotationTypesNode;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public AnnotationTypesNode() {
        super((Children)new AnnotationTypesSubnodes());
        this.setName("annotationtypes");
        this.setDisplayName(this.getBundleString("ATN_AnnotationTypesNode_Name"));
        this.setShortDescription(this.getBundleString("ATN_AnnotationTypesNode_Description"));
        this.setIconBase(ICON_BASE);
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$options$AnnotationTypesNode == null ? (class$org$netbeans$modules$editor$options$AnnotationTypesNode = AnnotationTypesNode.class$("org.netbeans.modules.editor.options.AnnotationTypesNode")) : class$org$netbeans$modules$editor$options$AnnotationTypesNode), (String)s);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = AnnotationTypesNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ps = sheet.get("properties");
        if (ps == null) {
            ps = Sheet.createPropertiesSet();
        }
        ps.put((Node.Property)this.createProperty("backgroundDrawing", Boolean.TYPE));
        ps.put((Node.Property)this.createProperty("backgroundGlyphAlpha", Integer.TYPE));
        ps.put((Node.Property)this.createProperty("combineGlyphs", Boolean.TYPE));
        ps.put((Node.Property)this.createProperty("glyphsOverLineNumbers", Boolean.TYPE));
        ps.put((Node.Property)this.createProperty("showGlyphGutter", Boolean.TYPE));
        sheet.put(ps);
        return sheet;
    }

    private PropertySupport createProperty(final String name, Class clazz) {
        return new PropertySupport.ReadWrite(name, clazz, this.getBundleString("PROP_" + name), this.getBundleString("HINT_" + name)){

            public Object getValue() {
                return AnnotationTypesNode.this.getProperty(name);
            }

            public void setValue(Object value) {
                AnnotationTypesNode.this.setProperty(name, value);
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        };
    }

    private void setProperty(String property, Object value) {
        if (property.equals("backgroundDrawing")) {
            AnnotationTypes.getTypes().setBackgroundDrawing((Boolean)value);
        }
        if (property.equals("backgroundGlyphAlpha")) {
            AnnotationTypes.getTypes().setBackgroundGlyphAlpha((Integer)value);
        }
        if (property.equals("combineGlyphs")) {
            AnnotationTypes.getTypes().setCombineGlyphs((Boolean)value);
        }
        if (property.equals("glyphsOverLineNumbers")) {
            AnnotationTypes.getTypes().setGlyphsOverLineNumbers((Boolean)value);
        }
        if (property.equals("showGlyphGutter")) {
            AnnotationTypes.getTypes().setShowGlyphGutter((Boolean)value);
        }
    }

    private Object getProperty(String property) {
        if (property.equals("backgroundDrawing")) {
            return AnnotationTypes.getTypes().isBackgroundDrawing();
        }
        if (property.equals("backgroundGlyphAlpha")) {
            return AnnotationTypes.getTypes().getBackgroundGlyphAlpha();
        }
        if (property.equals("combineGlyphs")) {
            return AnnotationTypes.getTypes().isCombineGlyphs();
        }
        if (property.equals("glyphsOverLineNumbers")) {
            return AnnotationTypes.getTypes().isGlyphsOverLineNumbers();
        }
        if (property.equals("showGlyphGutter")) {
            return AnnotationTypes.getTypes().isShowGlyphGutter();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AnnotationTypesSubnodes
    extends Children.Array {
        private PropertyChangeListener listener = new PropertyChangeListener(this){
            private final /* synthetic */ AnnotationTypesSubnodes this$0;
            {
                this.this$0 = this$0;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "annotationTypes") {
                    AnnotationTypesSubnodes.access$203(this.this$0, this.this$0.initCollection());
                    AnnotationTypesSubnodes.access$301(this.this$0);
                }
            }
        };

        public AnnotationTypesSubnodes() {
            AnnotationTypes.getTypes().addPropertyChangeListener(this.listener);
        }

        protected Collection initCollection() {
            AnnotationTypesFolder folder = AnnotationTypesFolder.getAnnotationTypesFolder();
            Iterator types = AnnotationTypes.getTypes().getAnnotationTypeNames();
            LinkedList<AnnotationTypesSubnode> list = new LinkedList<AnnotationTypesSubnode>();
            while (types.hasNext()) {
                String name = (String)types.next();
                AnnotationType type = AnnotationTypes.getTypes().getType(name);
                if (type == null || !type.isVisible()) continue;
                try {
                    list.add(new AnnotationTypesSubnode(type));
                }
                catch (IntrospectionException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            return list;
        }

        static /* synthetic */ Collection access$203(AnnotationTypesSubnodes x0, Collection x1) {
            x0.nodes = x1;
            return x0.nodes;
        }

        static /* synthetic */ void access$301(AnnotationTypesSubnodes x0) {
            super.refresh();
        }

        private static final class AnnotationTypesSubnode
        extends BeanNode {
            static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;

            public AnnotationTypesSubnode(AnnotationType type) throws IntrospectionException {
                super((Object)new AnnotationTypeOptions(type));
                this.setName(type.getDescription());
                String icon = type.getGlyph().getFile();
                icon = icon.substring(0, icon.lastIndexOf(46));
                this.setIconBase(icon);
            }

            public boolean canDestroy() {
                return false;
            }

            public HelpCtx getHelpCtx() {
                return new HelpCtx(AnnotationTypesNode.HELP_ID);
            }

            public SystemAction[] getActions() {
                SystemAction customizeBean;
                SystemAction[] as = super.getActions();
                List<SystemAction> actions = Arrays.asList(as);
                if (actions.contains(customizeBean = SystemAction.get((Class)(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = AnnotationTypesSubnode.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction)))) {
                    actions = new ArrayList<SystemAction>(actions);
                    actions.remove(customizeBean);
                    return actions.toArray(new SystemAction[0]);
                }
                return as;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

