/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.MultiPropertyFolder;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.netbeans.modules.editor.options.UpgradeOptions;
import org.openide.ServiceType;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class BaseOptions
extends OptionSupport {
    protected static final int LATEST_OPTIONS_VERSION = 21;
    protected static final String OPTIONS_VERSION_PROP = "optionsVersion";
    public static final String ABBREV_MAP_PROP = "abbrevMap";
    public static final String BASE = "base";
    public static final String CARET_BLINK_RATE_PROP = "caretBlinkRate";
    public static final String CARET_COLOR_INSERT_MODE_PROP = "caretColorInsertMode";
    public static final String CARET_COLOR_OVERWRITE_MODE_PROP = "caretColorOverwriteMode";
    public static final String CARET_ITALIC_INSERT_MODE_PROP = "caretItalicInsertMode";
    public static final String CARET_ITALIC_OVERWRITE_MODE_PROP = "caretItalicOverwriteMode";
    public static final String CARET_TYPE_INSERT_MODE_PROP = "caretTypeInsertMode";
    public static final String CARET_TYPE_OVERWRITE_MODE_PROP = "caretTypeOverwriteMode";
    public static final String COLORING_MAP_PROP = "coloringMap";
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String FIND_HIGHLIGHT_SEARCH_PROP = "findHighlightSearch";
    public static final String FIND_HISTORY_PROP = "findHistory";
    public static final String FIND_HISTORY_SIZE_PROP = "findHistorySize";
    public static final String FIND_INC_SEARCH_DELAY_PROP = "findIncSearchDelay";
    public static final String FIND_INC_SEARCH_PROP = "findIncSearch";
    public static final String FIND_MATCH_CASE_PROP = "findMatchCase";
    public static final String FIND_REG_EXP_PROP = "findRegExp";
    public static final String FIND_SMART_CASE_PROP = "findSmartCase";
    public static final String FIND_WHOLE_WORDS_PROP = "findWholeWords";
    public static final String FIND_WRAP_SEARCH_PROP = "findWrapSearch";
    public static final String FONT_SIZE_PROP = "fontSize";
    public static final String HIGHLIGHT_CARET_ROW_PROP = "highlightCaretRow";
    public static final String HIGHLIGHT_MATCHING_BRACKET_PROP = "highlightMatchingBracket";
    public static final String INDENT_ENGINE_PROP = "indentEngine";
    public static final String KEY_BINDING_LIST_PROP = "keyBindingList";
    public static final String LINE_HEIGHT_CORRECTION_PROP = "lineHeightCorrection";
    public static final String LINE_NUMBER_MARGIN_PROP = "lineNumberMargin";
    public static final String LINE_NUMBER_MARGIN_PROP_2 = "lineNumberMargin2";
    public static final String LINE_NUMBER_VISIBLE_PROP = "lineNumberVisible";
    public static final String MACRO_MAP_PROP = "macroMap";
    public static final String MARGIN_PROP = "margin";
    public static final String SCROLL_FIND_INSETS_PROP = "scrollFindInsets";
    public static final String SCROLL_JUMP_INSETS_PROP = "scrollJumpInsets";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    public static final String STATUS_BAR_CARET_DELAY_PROP = "statusBarCaretDelay";
    public static final String STATUS_BAR_VISIBLE_PROP = "statusBarVisible";
    public static final String TAB_SIZE_PROP = "tabSize";
    public static final String TEXT_LIMIT_LINE_COLOR_PROP = "textLimitLineColor";
    public static final String TEXT_LIMIT_LINE_VISIBLE_PROP = "textLimitLineVisible";
    public static final String TEXT_LIMIT_WIDTH_PROP = "textLimitWidth";
    public static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    public static final String TEXT_ANTIALIASING_PROP = "textAntialiasing";
    static final String[] BASE_PROP_NAMES = new String[]{"abbrevMap", "caretBlinkRate", "caretColorInsertMode", "caretColorOverwriteMode", "caretItalicInsertMode", "caretItalicOverwriteMode", "caretTypeInsertMode", "caretTypeOverwriteMode", "coloringMap", "expandTabs", "fontSize", "highlightCaretRow", "highlightMatchingBracket", "indentEngine", "keyBindingList", "lineHeightCorrection", "lineNumberMargin2", "lineNumberVisible", "macroMap", "margin", "scrollFindInsets", "scrollJumpInsets", "spacesPerTab", "statusBarCaretDelay", "statusBarVisible", "tabSize", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "optionsVersion"};
    static final long serialVersionUID = -5469192431366914841L;
    private static final String HELP_ID = "editing.global";
    private static final String NO_INDENT_ENGINE = "NO_INDENT_ENGINE";
    private static final boolean debugFormat = Boolean.getBoolean("netbeans.debug.editor.format");
    private static final Map textAntialiasingHintsMap = new HashMap();
    private transient Settings.Initializer coloringMapInitializer;
    private transient int optionsVersion;
    private transient IndentEngine readExternalIndentEngine;
    private transient boolean inReadExternal;
    private transient MIMEOptionNode mimeNode;
    private transient Map defaultAbbrevsMap;
    private transient Map defaultMacrosMap;
    private transient Map defaultKeyBindingsMap;
    private transient MIMEOptionFolder settingsFolder;
    private static final HashMap kitClass2Options;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$MacrosMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$SimpleIndentEngine;

    public BaseOptions() {
        this(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit, BASE);
        this.optionsVersion = 21;
    }

    public BaseOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
        kitClass2Options.put(kitClass, this);
    }

    public static BaseOptions getOptions(Class kitClass) {
        BaseOptions option = (BaseOptions)((Object)kitClass2Options.get(kitClass));
        if (option == null) {
            AllOptionsFolder.getDefault().loadMIMEOption(kitClass, false);
            option = (BaseOptions)((Object)kitClass2Options.get(kitClass));
        }
        return option;
    }

    private void attachSettingsFileListener(FileObject folderFO) {
        String contentType = BaseKit.getKit(this.getKitClass()).getContentType();
        if (contentType == null) {
            return;
        }
        FileObject optionFO = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + contentType + "/" + "Settings.settings");
        if (optionFO != null && FileUtil.toFile((FileObject)optionFO) != null) {
            try {
                FileUtil.toFile((FileObject)optionFO).delete();
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        folderFO.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            private void delete(FileObject fo) {
                File settingsFile;
                if (fo.getNameExt().equals("Settings.settings") && (settingsFile = FileUtil.toFile((FileObject)fo)) != null) {
                    settingsFile.delete();
                }
            }

            public void fileDataCreated(FileEvent fe) {
                if (fe == null) {
                    return;
                }
                this.delete(fe.getFile());
            }

            public void fileChanged(FileEvent fe) {
                if (fe == null) {
                    return;
                }
                this.delete(fe.getFile());
            }
        });
    }

    protected MIMEOptionFolder getMIMEFolder() {
        BaseKit kit = BaseKit.getKit(this.getKitClass());
        String name = kit.getContentType();
        if (name == null) {
            return null;
        }
        BaseOptions baseOptions = this;
        synchronized (baseOptions) {
            FileObject fo;
            if (this.settingsFolder != null) {
                MIMEOptionFolder mIMEOptionFolder = this.settingsFolder;
                return mIMEOptionFolder;
            }
            FileObject f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + name);
            if (f == null && (fo = Repository.getDefault().getDefaultFileSystem().findResource("Editors")) != null) {
                try {
                    StringTokenizer stok = new StringTokenizer(name, "/");
                    while (stok.hasMoreElements()) {
                        String newFolder = stok.nextToken();
                        fo = fo.getFileObject(newFolder) == null ? fo.createFolder(newFolder) : fo.getFileObject(newFolder);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + name);
            }
            if (f != null) {
                try {
                    DataObject d = DataObject.find((FileObject)f);
                    DataFolder df = (DataFolder)d.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = BaseOptions.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                    if (df != null) {
                        this.attachSettingsFileListener(f);
                        MIMEOptionFolder mIMEOptionFolder = this.settingsFolder = new MIMEOptionFolder(df, this);
                        return mIMEOptionFolder;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            MIMEOptionFolder mIMEOptionFolder = null;
            return mIMEOptionFolder;
        }
    }

    public synchronized MIMEOptionNode getMimeNode() {
        if (this.mimeNode == null) {
            this.createMIMENode(this.getTypeName());
        }
        return this.mimeNode;
    }

    private void createMIMENode(String typeName) {
        if (typeName.equals(BASE)) {
            return;
        }
        try {
            this.mimeNode = new MIMEOptionNode(this);
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }

    protected void updateSettingsMap(Class kitClass, Map settingsMap) {
        super.updateSettingsMap(kitClass, settingsMap);
        if (kitClass == this.getKitClass()) {
            settingsMap.put(INDENT_ENGINE_PROP, new Settings.Evaluator(){

                public Object getValue(Class kitClass2, String settingName) {
                    return BaseOptions.this.getIndentEngine();
                }
            });
            settingsMap.put("formatter", new Settings.Evaluator(){

                public Object getValue(Class kitClass2, String settingName) {
                    IndentEngine eng = BaseOptions.this.getIndentEngine();
                    return eng != null ? (eng instanceof FormatterIndentEngine ? ((FormatterIndentEngine)eng).getFormatter() : new IndentEngineFormatter(BaseOptions.this.getKitClass(), eng)) : null;
                }
            });
            if (kitClass == (class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)) {
                settingsMap.put("rendering-hints", new Settings.Evaluator(){

                    public Object getValue(Class kitClass2, String settingName) {
                        return BaseOptions.this.isTextAntialiasing() ? textAntialiasingHintsMap : Collections.EMPTY_MAP;
                    }
                });
            }
            if (this.coloringMapInitializer != null) {
                this.coloringMapInitializer.updateSettingsMap(kitClass, settingsMap);
            }
        }
        if (kitClass == (class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit) && this.coloringMapInitializer != null) {
            this.coloringMapInitializer.updateSettingsMap(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit, settingsMap);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public int getTabSize() {
        return this.getSettingInteger("tab-size");
    }

    public void setTabSize(int tabSize) {
        if (tabSize < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("tab-size", tabSize, TAB_SIZE_PROP);
    }

    public void setExpandTabs(boolean expandTabs) {
        this.setSettingBoolean("expand-tabs", expandTabs, EXPAND_TABS_PROP);
    }

    public void setSpacesPerTab(int i) {
        if (i > 0) {
            this.setSettingInteger("spaces-per-tab", i, SPACES_PER_TAB_PROP);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Map getDefaultAbbrevMap() {
        this.loadDefaultAbbreviations();
        return this.defaultAbbrevsMap;
    }

    private void loadDefaultAbbreviations() {
        if (this.defaultAbbrevsMap != null) {
            return;
        }
        MIMEOptionFolder mimeFolder = this.getMIMEFolder();
        if (mimeFolder == null) {
            return;
        }
        MIMEOptionFolder mof = mimeFolder.getFolder("Defaults");
        if (mof == null) {
            return;
        }
        MIMEOptionFile file = mof.getFile(class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.AbbrevsMIMEProcessor")) : class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor, false);
        if (file != null && !file.isLoaded()) {
            file.loadSettings(false);
            this.defaultAbbrevsMap = new HashMap(file.getAllProperties());
        }
    }

    public Map getAbbrevMap() {
        this.loadDefaultAbbreviations();
        this.loadSettings(class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.AbbrevsMIMEProcessor")) : class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor);
        return new HashMap((Map)super.getSettingValue("abbrev-map"));
    }

    public void setAbbrevMap(Map map, boolean saveToXML) {
        Map diffMap = null;
        if (saveToXML) {
            this.loadDefaultAbbreviations();
            diffMap = OptionUtilities.getMapDiff(this.getAbbrevMap(), map, true);
            if (diffMap.size() > 0) {
                this.updateSettings(class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.AbbrevsMIMEProcessor")) : class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor, diffMap);
            }
        }
        super.setSettingValue("abbrev-map", map, ABBREV_MAP_PROP);
    }

    public void setAbbrevMap(Map map) {
        this.setAbbrevMap(map, true);
    }

    public String getCaretTypeInsertMode() {
        return (String)this.getSettingValue("caret-type-insert-mode");
    }

    public void setCaretTypeInsertMode(String type) {
        this.setSettingValue("caret-type-insert-mode", type, CARET_TYPE_INSERT_MODE_PROP);
    }

    public String getCaretTypeOverwriteMode() {
        return (String)this.getSettingValue("caret-type-overwrite-mode");
    }

    public void setCaretTypeOverwriteMode(String type) {
        this.setSettingValue("caret-type-overwrite-mode", type, CARET_TYPE_OVERWRITE_MODE_PROP);
    }

    public boolean getCaretItalicInsertMode() {
        return this.getSettingBoolean("caret-italic-insert-mode");
    }

    public void setCaretItalicInsertMode(boolean b) {
        this.setSettingBoolean("caret-italic-insert-mode", b, CARET_ITALIC_INSERT_MODE_PROP);
    }

    public boolean getCaretItalicOverwriteMode() {
        return this.getSettingBoolean("caret-italic-overwrite-mode");
    }

    public void setCaretItalicOverwriteMode(boolean b) {
        this.setSettingBoolean("caret-italic-overwrite-mode", b, CARET_ITALIC_OVERWRITE_MODE_PROP);
    }

    public Color getCaretColorInsertMode() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        return (Color)super.getSettingValue("caret-color-insert-mode");
    }

    public void setCaretColorInsertMode(Color color) {
        this.setCaretColorInsertMode(color, true);
    }

    public void setCaretColorInsertMode(Color color, boolean saveToXML) {
        if (saveToXML && !this.getCaretColorInsertMode().equals(color) && color != null) {
            HashMap<String, Color> map = new HashMap<String, Color>();
            map.put("caret-color-insert-mode", color);
            if (map != null) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, map);
            }
        }
        super.setSettingValue("caret-color-insert-mode", color, CARET_COLOR_INSERT_MODE_PROP);
    }

    public Color getCaretColorOverwriteMode() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        return (Color)super.getSettingValue("caret-color-overwrite-mode");
    }

    public void setCaretColorOverwriteMode(Color color) {
        this.setCaretColorOverwriteMode(color, true);
    }

    public void setCaretColorOverwriteMode(Color color, boolean saveToXML) {
        if (saveToXML && !this.getCaretColorOverwriteMode().equals(color) && color != null) {
            HashMap<String, Color> map = new HashMap<String, Color>();
            map.put("caret-color-overwrite-mode", color);
            if (map != null) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, map);
            }
        }
        super.setSettingValue("caret-color-overwrite-mode", color, CARET_COLOR_OVERWRITE_MODE_PROP);
    }

    public int getCaretBlinkRate() {
        return this.getSettingInteger("caret-blink-rate");
    }

    public void setCaretBlinkRate(int rate) {
        if (rate < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("caret-blink-rate", rate, CARET_BLINK_RATE_PROP);
    }

    public boolean getLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setLineNumberVisible(boolean b) {
        this.setSettingBoolean("line-number-visible", b, LINE_NUMBER_VISIBLE_PROP);
    }

    public Insets getScrollJumpInsets() {
        return (Insets)this.getSettingValue("scroll-jump-insets");
    }

    public void setScrollJumpInsets(Insets i) {
        this.setSettingValue("scroll-jump-insets", i, SCROLL_JUMP_INSETS_PROP);
    }

    public Insets getScrollFindInsets() {
        return (Insets)this.getSettingValue("scroll-find-insets");
    }

    public void setScrollFindInsets(Insets i) {
        this.setSettingValue("scroll-find-insets", i, SCROLL_FIND_INSETS_PROP);
    }

    public Map getDefaultKeyBindingsMap() {
        this.loadDefaultKeyBindings();
        return this.defaultKeyBindingsMap;
    }

    private void loadDefaultKeyBindings() {
        MIMEOptionFolder mof;
        MIMEOptionFolder mimeFolder;
        if (this.defaultKeyBindingsMap != null) {
            return;
        }
        if (BASE.equals(this.getTypeName())) {
            mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            mof = mimeFolder.getFolder("Defaults");
        } else {
            AllOptionsFolder.getDefault().loadDefaultKeyBindings();
            mimeFolder = this.getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            mof = mimeFolder.getFolder("Defaults");
        }
        if (mof == null) {
            return;
        }
        MIMEOptionFile file = mof.getFile(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor, false);
        if (file != null && !file.isLoaded()) {
            file.loadSettings(false);
            this.defaultKeyBindingsMap = new HashMap(file.getAllProperties());
        }
    }

    private List getKBList() {
        this.loadDefaultKeyBindings();
        this.loadSettings(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor);
        Class kitClass = this.getKitClass();
        Settings.KitAndValue[] kav = this.getSettingValueHierarchy("key-bindings");
        List<MultiKeyBinding> kbList = null;
        int i = 0;
        while (i < kav.length) {
            if (kav[i].kitClass == kitClass) {
                kbList = (List)kav[i].value;
            }
            ++i;
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        int cnt = kbList.size();
        int i2 = 0;
        while (i2 < cnt) {
            Object o = kbList.get(i2);
            if (!(o instanceof MultiKeyBinding) && o != null) {
                JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
                kbList.set(i2, new MultiKeyBinding(b.key, b.actionName));
            }
            ++i2;
        }
        return new ArrayList(kbList);
    }

    public List getKeyBindingList() {
        ArrayList<String> kb2 = new ArrayList<String>(this.getKBList());
        kb2.add(0, this.getKitClass().getName());
        return kb2;
    }

    public void setKeyBindingList(List list) {
        this.setKeyBindingList(list, true);
    }

    public void setKeyBindingsDiffMap(Map diffMap) {
        if (diffMap != null && diffMap.size() > 0) {
            this.updateSettings(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor, diffMap);
        }
    }

    public void setKeyBindingList(List list, boolean saveToXML) {
        if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
            list.remove(0);
        }
        Map diffMap = null;
        if (saveToXML) {
            this.loadDefaultKeyBindings();
            List kbMap = this.getKeyBindingList();
            if (kbMap.size() > 0 && (kbMap.get(0) instanceof Class || kbMap.get(0) instanceof String)) {
                kbMap.remove(0);
            }
            if ((diffMap = OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(kbMap), OptionUtilities.makeKeyBindingsMap(list), true)).size() > 0) {
                this.updateSettings(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor, diffMap);
            }
        }
        super.setSettingValue("key-bindings", list, KEY_BINDING_LIST_PROP);
    }

    public Map getColoringMap() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        HashMap<Object, String> cm = new HashMap<Object, String>(SettingsUtil.getColoringMap(this.getKitClass(), false, true));
        cm.put(null, this.getKitClass().getName());
        return cm;
    }

    public void setColoringMap(Map coloringMap) {
        this.setColoringMap(coloringMap, true);
    }

    public void setColoringMap(Map coloringMap, boolean saveToXML) {
        Map diffMap = null;
        if (coloringMap != null) {
            if (this.inReadExternal) {
                coloringMap = UpgradeOptions.patchColorings(this.getKitClass(), coloringMap);
            }
            if (saveToXML && (diffMap = OptionUtilities.getMapDiff(this.getColoringMap(), coloringMap, false)).size() > 0) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, diffMap);
            }
            coloringMap.remove(null);
            SettingsUtil.setColoringMap(this.getKitClass(), coloringMap, false);
            this.coloringMapInitializer = SettingsUtil.getColoringMapInitializer(this.getKitClass(), coloringMap, false, this.getTypeName() + "-coloring-map-initializer");
            this.firePropertyChange(COLORING_MAP_PROP, null, null);
        }
    }

    public int getFontSize() {
        Coloring dc = SettingsUtil.getColoring(this.getKitClass(), "default", false);
        return dc != null ? dc.getFont().getSize() : SettingsDefaults.defaultFont.getSize();
    }

    public void setFontSize(int size) {
        if (size < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        int oldSize = this.getFontSize();
        Map cm = SettingsUtil.getColoringMap(this.getKitClass(), false, true);
        if (cm != null) {
            Iterator it = cm.entrySet().iterator();
            while (it.hasNext()) {
                Coloring c;
                Font font;
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                if (!(value instanceof Coloring) || (font = (c = (Coloring)value).getFont()) == null || font.getSize() == size) continue;
                font = font.deriveFont((float)size);
                Coloring newColoring = new Coloring(font, c.getFontMode(), c.getForeColor(), c.getBackColor());
                entry.setValue(newColoring);
            }
            this.setColoringMap(cm);
            this.firePropertyChange(FONT_SIZE_PROP, null, null);
        }
    }

    public float getLineHeightCorrection() {
        return ((Float)this.getSettingValue("line-height-correction")).floatValue();
    }

    public void setLineHeightCorrection(float f) {
        if (f <= 0.0f) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingValue("line-height-correction", new Float(f), LINE_HEIGHT_CORRECTION_PROP);
    }

    public Map getDefaultMacrosMap() {
        this.loadDefaultMacros();
        return this.defaultMacrosMap;
    }

    private void loadDefaultMacros() {
        if (this.defaultMacrosMap != null) {
            return;
        }
        MIMEOptionFolder mimeFolder = this.getMIMEFolder();
        if (mimeFolder == null) {
            return;
        }
        MIMEOptionFolder mof = mimeFolder.getFolder("Defaults");
        if (mof == null) {
            return;
        }
        MIMEOptionFile file = mof.getFile(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor, false);
        if (file != null && !file.isLoaded()) {
            file.loadSettings(false);
            this.defaultMacrosMap = new HashMap(file.getAllProperties());
        }
    }

    private void processMacroKeyBindings(Map diff, List oldKB) {
        ArrayList<MultiKeyBinding> deletedKB = new ArrayList<MultiKeyBinding>();
        ArrayList<MultiKeyBinding> addedKB = new ArrayList<MultiKeyBinding>();
        List newKB = this.getKBList();
        Iterator i = diff.keySet().iterator();
        block0: while (i.hasNext()) {
            MultiKeyBinding mkb;
            int j;
            String key = (String)i.next();
            if (!(diff.get(key) instanceof String)) continue;
            String action = (String)diff.get(key);
            String kbActionName = new String("macro-" + key);
            if (action.length() != 0) {
                j = 0;
                while (j < oldKB.size()) {
                    if (oldKB.get(j) instanceof MultiKeyBinding) {
                        mkb = (MultiKeyBinding)oldKB.get(j);
                        if (kbActionName.equals(mkb.actionName)) {
                            addedKB.add(mkb);
                            continue block0;
                        }
                    }
                    ++j;
                }
                continue;
            }
            j = 0;
            while (j < newKB.size()) {
                if (newKB.get(j) instanceof MultiKeyBinding) {
                    mkb = (MultiKeyBinding)newKB.get(j);
                    if (kbActionName.equals(mkb.actionName)) {
                        deletedKB.add(mkb);
                        continue block0;
                    }
                }
                ++j;
            }
        }
        if (deletedKB.size() > 0 || addedKB.size() > 0) {
            newKB.removeAll(deletedKB);
            newKB.addAll(addedKB);
            this.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(this.getKBList()), OptionUtilities.makeKeyBindingsMap(newKB), true));
            Settings.setValue(this.getKitClass(), "key-bindings", newKB);
        }
    }

    public Map getMacroMap() {
        this.loadDefaultMacros();
        this.loadSettings(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor);
        HashMap<Object, List> ret = new HashMap<Object, List>((Map)super.getSettingValue("macro-map"));
        ret.put(null, this.getKBList());
        return ret;
    }

    public void setMacroDiffMap(Map diffMap) {
        if (diffMap != null && diffMap.size() > 0) {
            this.updateSettings(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor, diffMap);
        }
    }

    public void setMacroMap(Map map, boolean saveToXML) {
        Map diffMap = null;
        ArrayList kb = new ArrayList();
        if (map.containsKey(null)) {
            kb.addAll((List)map.get(null));
            map.remove(null);
        }
        if (saveToXML) {
            this.loadDefaultMacros();
            diffMap = OptionUtilities.getMapDiff(this.getMacroMap(), map, true);
            if (diffMap.containsKey(null)) {
                diffMap.remove(null);
            }
            if (diffMap.size() > 0) {
                this.processMacroKeyBindings(diffMap, kb);
                this.updateSettings(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor, diffMap);
            }
        }
        super.setSettingValue("macro-map", map);
    }

    public void setMacroMap(Map map) {
        this.setMacroMap(map, true);
    }

    public Insets getMargin() {
        return (Insets)this.getSettingValue(MARGIN_PROP);
    }

    public void setMargin(Insets i) {
        this.setSettingValue(MARGIN_PROP, i, MARGIN_PROP);
    }

    public Insets getLineNumberMargin() {
        return (Insets)this.getSettingValue("line-number-margin");
    }

    public void setLineNumberMargin(Insets i) {
        this.setSettingValue("line-number-margin", i, LINE_NUMBER_MARGIN_PROP);
    }

    public Dimension getLineNumberMargin2() {
        Insets ins = (Insets)this.getSettingValue("line-number-margin");
        return new Dimension(ins.left, ins.right);
    }

    public void setLineNumberMargin2(Dimension d) {
        this.setLineNumberMargin(new Insets(0, d.width, 0, d.height));
    }

    public boolean getStatusBarVisible() {
        return this.getSettingBoolean("status-bar-visible");
    }

    public void setStatusBarVisible(boolean v) {
        this.setSettingBoolean("status-bar-visible", v, STATUS_BAR_VISIBLE_PROP);
    }

    public int getStatusBarCaretDelay() {
        return this.getSettingInteger("status-bar-caret-delay");
    }

    public void setStatusBarCaretDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("status-bar-caret-delay", delay, STATUS_BAR_CARET_DELAY_PROP);
    }

    public boolean getFindHighlightSearch() {
        return this.getSettingBoolean("find-highlight-search");
    }

    public void setFindHighlightSearch(boolean b) {
        this.setSettingBoolean("find-highlight-search", b, FIND_HIGHLIGHT_SEARCH_PROP);
    }

    public boolean getFindIncSearch() {
        return this.getSettingBoolean("find-inc-search");
    }

    public void setFindIncSearch(boolean b) {
        this.setSettingBoolean("find-inc-search", b, FIND_INC_SEARCH_PROP);
    }

    public int getFindIncSearchDelay() {
        return this.getSettingInteger("find-inc-search-delay");
    }

    public void setFindIncSearchDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("find-inc-search-delay", delay, FIND_INC_SEARCH_DELAY_PROP);
    }

    public boolean getFindWrapSearch() {
        return this.getSettingBoolean("find-wrap-search");
    }

    public void setFindWrapSearch(boolean b) {
        this.setSettingBoolean("find-wrap-search", b, FIND_WRAP_SEARCH_PROP);
    }

    public boolean getFindSmartCase() {
        return this.getSettingBoolean("find-smart-case");
    }

    public void setFindSmartCase(boolean b) {
        this.setSettingBoolean("find-smart-case", b, FIND_SMART_CASE_PROP);
    }

    public Map getFindHistory() {
        return new HashMap((Map)this.getSettingValue("find-history"));
    }

    public void setFindHistory(Map m) {
        this.setSettingValue("find-history", m, FIND_HISTORY_PROP);
    }

    public int getFindHistorySize() {
        return this.getSettingInteger("find-history-size");
    }

    public void setFindHistorySize(int size) {
        this.setSettingInteger("find-history-size", size, FIND_HISTORY_SIZE_PROP);
    }

    public Color getTextLimitLineColor() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        return (Color)super.getSettingValue("text-limit-line-color");
    }

    public void setTextLimitLineColor(Color color) {
        this.setTextLimitLineColor(color, true);
    }

    public void setTextLimitLineColor(Color color, boolean saveToXML) {
        if (saveToXML && !this.getTextLimitLineColor().equals(color) && color != null) {
            HashMap<String, Color> map = new HashMap<String, Color>();
            map.put("text-limit-line-color", color);
            if (map != null) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, map);
            }
        }
        super.setSettingValue("text-limit-line-color", color, TEXT_LIMIT_LINE_COLOR_PROP);
    }

    public int getTextLimitWidth() {
        return this.getSettingInteger("text-limit-width");
    }

    public void setTextLimitWidth(int width) {
        if (width <= 0) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingInteger("text-limit-width", width, TEXT_LIMIT_WIDTH_PROP);
    }

    public boolean getTextLimitLineVisible() {
        return this.getSettingBoolean("text-limit-line-visible");
    }

    public void setTextLimitLineVisible(boolean visible) {
        this.setSettingBoolean("text-limit-line-visible", visible, TEXT_LIMIT_LINE_VISIBLE_PROP);
    }

    public boolean getHighlightMatchingBracket() {
        return this.getSettingBoolean("highlight-match-brace");
    }

    public void setHighlightMatchingBracket(boolean highlight) {
        this.setSettingBoolean("highlight-match-brace", highlight, HIGHLIGHT_MATCHING_BRACKET_PROP);
    }

    public boolean getHighlightCaretRow() {
        return this.getSettingBoolean("highlight-caret-row");
    }

    public void setHighlightCaretRow(boolean highlight) {
        this.setSettingBoolean("highlight-caret-row", highlight, HIGHLIGHT_CARET_ROW_PROP);
    }

    public boolean isToolbarVisible() {
        return this.getSettingBoolean(TOOLBAR_VISIBLE_PROP);
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.setSettingBoolean(TOOLBAR_VISIBLE_PROP, toolbarVisible, TOOLBAR_VISIBLE_PROP);
    }

    public boolean isTextAntialiasing() {
        Boolean val = (Boolean)this.getSettingValue(TEXT_ANTIALIASING_PROP);
        if (val != null) {
            return val;
        }
        return Utilities.getOperatingSystem() == 2048;
    }

    public void setTextAntialiasing(boolean textAntialiasing) {
        this.setSettingBoolean(TEXT_ANTIALIASING_PROP, textAntialiasing, TEXT_ANTIALIASING_PROP);
        Settings.touchValue(this.getKitClass(), "rendering-hints");
    }

    public void initPopupMenuItems() {
        MultiPropertyFolder mpf;
        MIMEOptionFolder mimeFolder;
        if (!BASE.equals(this.getTypeName()) && (mimeFolder = this.getMIMEFolder()) != null && (mpf = mimeFolder.getMPFolder("Popup", false)) != null) {
            DataFolder df = mpf.getDataFolder();
            ArrayList mimeFolderAttribs = new ArrayList();
            Enumeration e = df.getPrimaryFile().getAttributes();
            while (e.hasMoreElements()) {
                mimeFolderAttribs.add(e.nextElement());
            }
            if (mpf.getProperties().size() != 0 || mimeFolderAttribs.size() != 0) {
                HashSet mergedPopupItems = new HashSet(OptionUtilities.getGlobalPopupMenuItems());
                mergedPopupItems.addAll(mpf.getProperties());
                HashSet mergedPopupAttribs = new HashSet(OptionUtilities.getGlobalPopupAttribs());
                mergedPopupAttribs.addAll(mimeFolderAttribs);
                List orderedPopupItems = OptionUtilities.arrangeMergedPopup(mergedPopupItems, mergedPopupAttribs);
                super.setSettingValue("popup-menu-action-name-list", orderedPopupItems);
                return;
            }
        }
    }

    public IndentEngine getIndentEngine() {
        IndentEngine eng;
        Object o;
        if (this.inReadExternal) {
            return this.readExternalIndentEngine;
        }
        if (!BASE.equals(this.getTypeName())) {
            Map setMap;
            Object handle;
            MIMEOptionFile file;
            this.loadSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor);
            MIMEOptionFolder mimeFolder = this.getMIMEFolder();
            if (mimeFolder != null && (file = mimeFolder.getFile(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor, false)) != null && (handle = (setMap = file.getAllProperties()).get(INDENT_ENGINE_PROP)) instanceof String) {
                Object instance = null;
                String handleString = (String)handle;
                if (handleString.equals(NO_INDENT_ENGINE)) {
                    return IndentEngine.getDefault();
                }
                Lookup.Template tmp = new Lookup.Template(null, handleString, null);
                Lookup.Item item = Lookup.getDefault().lookupItem(tmp);
                if (item != null && (instance = item.getInstance()) instanceof IndentEngine) {
                    return (IndentEngine)instance;
                }
            }
        }
        if ((o = this.getProperty(INDENT_ENGINE_PROP)) instanceof ServiceType.Handle) {
            eng = (IndentEngine)((ServiceType.Handle)o).getServiceType();
            if (eng != null) {
                this.setIndentEngine(eng);
                return eng;
            }
        } else if (o instanceof IndentEngine) {
            this.setIndentEngine((IndentEngine)o);
            return (IndentEngine)o;
        }
        if ((eng = this.findDefaultIndentEngine()) != null) {
            this.setIndentEngine(eng);
        }
        return eng;
    }

    public void setIndentEngine(IndentEngine eng) {
        if (!this.inReadExternal) {
            String id = null;
            if (eng != null) {
                Lookup.Template tmp = new Lookup.Template(null, null, (Object)eng);
                Lookup.Item item = Lookup.getDefault().lookupItem(tmp);
                if (item != null) {
                    id = item.getId();
                }
            }
            if (!BASE.equals(this.getTypeName())) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (id == null) {
                    id = NO_INDENT_ENGINE;
                }
                map.put(INDENT_ENGINE_PROP, id);
                this.updateSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor, map, false);
            }
            this.refreshIndentEngineSettings();
        }
    }

    private void refreshIndentEngineSettings() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Settings.touchValue(BaseOptions.this.getKitClass(), BaseOptions.INDENT_ENGINE_PROP);
                Settings.touchValue(BaseOptions.this.getKitClass(), "formatter");
            }
        });
    }

    protected Class getDefaultIndentEngineClass() {
        return class$org$netbeans$modules$editor$SimpleIndentEngine == null ? (class$org$netbeans$modules$editor$SimpleIndentEngine = BaseOptions.class$("org.netbeans.modules.editor.SimpleIndentEngine")) : class$org$netbeans$modules$editor$SimpleIndentEngine;
    }

    private IndentEngine findDefaultIndentEngine() {
        if (this.getDefaultIndentEngineClass() != null) {
            return (IndentEngine)Lookup.getDefault().lookup(this.getDefaultIndentEngineClass());
        }
        return null;
    }

    public void setOptionsVersion(int optionsVersion) {
        int oldOptionsVersion = this.optionsVersion;
        this.optionsVersion = optionsVersion;
        if (optionsVersion != oldOptionsVersion) {
            this.firePropertyChange(OPTIONS_VERSION_PROP, new Integer(oldOptionsVersion), new Integer(optionsVersion));
        }
    }

    public int getOptionsVersion() {
        return this.optionsVersion;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalIndentEngine = this.getIndentEngine();
        this.inReadExternal = true;
        this.optionsVersion = 0;
        try {
            try {
                super.readExternal(in);
            }
            catch (OptionalDataException ode) {
                Object var4_3 = null;
                this.refreshIndentEngineSettings();
                if (this.optionsVersion < 21) {
                    this.upgradeOptions(this.optionsVersion, 21);
                }
                this.optionsVersion = 21;
                this.inReadExternal = false;
                this.readExternalIndentEngine = null;
            }
            Object var4_2 = null;
            this.refreshIndentEngineSettings();
            if (this.optionsVersion < 21) {
                this.upgradeOptions(this.optionsVersion, 21);
            }
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.refreshIndentEngineSettings();
            if (this.optionsVersion < 21) {
                this.upgradeOptions(this.optionsVersion, 21);
            }
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
            throw throwable;
        }
    }

    protected void upgradeOptions(int version, int latestVersion) {
        UpgradeOptions.upgradeOptions(this, version, latestVersion);
    }

    private void loadSettings(Class processor) {
        MIMEOptionFile file;
        if (BASE.equals(this.getTypeName())) {
            MIMEOptionFolder mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            file = mimeFolder.getFile(processor, false);
        } else {
            MIMEOptionFolder mimeFolder = this.getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            file = mimeFolder.getFile(processor, false);
        }
        if (file != null && !file.isLoaded()) {
            file.loadSettings();
        }
    }

    private void updateSettings(Class processor, Map settings) {
        this.updateSettings(processor, settings, true);
    }

    private void updateSettings(Class processor, Map settings, boolean useRequestProcessorForSaving) {
        MIMEOptionFile fileX;
        MIMEOptionFolder mimeFolder;
        if (BASE.equals(this.getTypeName())) {
            mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            fileX = mimeFolder.getFile(processor, true);
        } else {
            mimeFolder = this.getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            fileX = mimeFolder.getFile(processor, true);
        }
        final Map finalSettings = settings;
        final MIMEOptionFile file = fileX;
        if (file != null) {
            if (useRequestProcessorForSaving) {
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        file.updateSettings(finalSettings);
                    }
                });
            } else {
                file.updateSettings(finalSettings);
            }
        } else {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!" + processor.toString() + " type file haven't been found in folder:" + mimeFolder.getDataFolder());
        }
    }

    public void setSettingValue(String settingName, Object newValue) {
        this.setSettingValue(settingName, newValue, settingName);
    }

    private boolean isTheSame(String settingName, Object newValue) {
        if (settingName == null || settingName.equals(INDENT_ENGINE_PROP) || settingName.equals("formatter")) {
            return true;
        }
        Object oldValue = this.getSettingValue(settingName);
        return oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue);
    }

    public void setSettingValue(String settingName, Object newValue, String propertyName) {
        if (!this.isTheSame(settingName, newValue)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(settingName, newValue);
            this.updateSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor, map);
        }
        super.setSettingValue(settingName, newValue, propertyName);
    }

    public Object getSettingValue(String settingName) {
        this.loadSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor);
        return super.getSettingValue(settingName);
    }

    protected final void setSettingBoolean(String settingName, boolean newValue, String propertyName) {
        this.setSettingValue(settingName, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected final void setSettingInteger(String settingName, int newValue, String propertyName) {
        this.setSettingValue(settingName, new Integer(newValue));
    }

    protected void loadXMLSettings() {
        this.getKeyBindingList();
        this.getAbbrevMap();
        this.getMacroMap();
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        this.loadSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor);
    }

    public void writeExternal() throws IOException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        textAntialiasingHintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        textAntialiasingHintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        textAntialiasingHintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        kitClass2Options = new HashMap();
    }
}

