/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.editor.options.ColoringBean;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.NbBundle;

public class ColoringEditorPanel
extends JPanel {
    public static final String PROP_COLORING = "Coloring";
    private ColoringBean value = new ColoringBean(SettingsDefaults.defaultColoring, "null", SettingsDefaults.defaultColoring, true);
    private PropWithDefaultPanel fontPanel;
    private PropWithDefaultPanel fgColorPanel;
    private PropWithDefaultPanel bgColorPanel;
    private ColoringPreview preview;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FontEditor;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ColorEditor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$ColoringEditorPanel;

    public ColoringEditorPanel() {
        this.initComponents();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 0.3;
        this.fontPanel = new PropWithDefaultPanel(class$java$awt$Font == null ? (class$java$awt$Font = ColoringEditorPanel.class$("java.awt.Font")) : class$java$awt$Font, class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = ColoringEditorPanel.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor, this.getBundleString("CEP_FontTitle"), this.getBundleString("ACSD_CEP_Font"), this.getBundleString("CEP_FontTrans"), this.getBundleString("CEP_FontTrans_Mnemonic").charAt(0), this.getBundleString("ACSD_CEP_FontTrans"));
        this.fontPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("RealValue".equals(evt.getPropertyName())) {
                    Font newValue = (Font)ColoringEditorPanel.this.fontPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeFont(((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, newValue));
                }
            }
        });
        this.add((Component)this.fontPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        this.fgColorPanel = new PropWithDefaultPanel(class$java$awt$Color == null ? (class$java$awt$Color = ColoringEditorPanel.class$("java.awt.Color")) : class$java$awt$Color, class$org$netbeans$beaninfo$editors$ColorEditor == null ? (class$org$netbeans$beaninfo$editors$ColorEditor = ColoringEditorPanel.class$("org.netbeans.beaninfo.editors.ColorEditor")) : class$org$netbeans$beaninfo$editors$ColorEditor, this.getBundleString("CEP_FgTitle"), this.getBundleString("ACSD_CEP_Fg"), this.getBundleString("CEP_FgTrans"), this.getBundleString("CEP_FgTrans_Mnemonic").charAt(0), this.getBundleString("ACSD_CEP_FgTrans"));
        this.fgColorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("RealValue".equals(evt.getPropertyName())) {
                    Color newValue = (Color)ColoringEditorPanel.this.fgColorPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeForeColor(((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, newValue));
                }
            }
        });
        this.add((Component)this.fgColorPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        this.bgColorPanel = new PropWithDefaultPanel(class$java$awt$Color == null ? (class$java$awt$Color = ColoringEditorPanel.class$("java.awt.Color")) : class$java$awt$Color, class$org$netbeans$beaninfo$editors$ColorEditor == null ? (class$org$netbeans$beaninfo$editors$ColorEditor = ColoringEditorPanel.class$("org.netbeans.beaninfo.editors.ColorEditor")) : class$org$netbeans$beaninfo$editors$ColorEditor, this.getBundleString("CEP_BgTitle"), this.getBundleString("ACSD_CEP_Bg"), this.getBundleString("CEP_BgTrans"), this.getBundleString("CEP_BgTrans_Mnemonic").charAt(0), this.getBundleString("ACSD_CEP_BgTrans"));
        this.bgColorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("RealValue".equals(evt.getPropertyName())) {
                    Color newValue = (Color)ColoringEditorPanel.this.bgColorPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeBackColor(((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, newValue));
                }
            }
        });
        this.add((Component)this.bgColorPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.setBorder(new CompoundBorder(new TitledBorder(this.getBundleString("CEP_PreviewTitle")), new EmptyBorder(new Insets(9, 12, 11, 11))));
        this.preview = new ColoringPreview();
        this.preview.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_CEP_Preview"));
        this.preview.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_CEP_Preview"));
        previewPanel.add(this.preview);
        this.add((Component)previewPanel, gridBagConstraints1);
        this.updateEditors();
        Dimension small = this.getPreferredSize();
        small.width *= 2;
        small.height = (int)((double)small.height * 1.4);
        this.setPreferredSize(small);
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$options$ColoringEditorPanel == null ? (class$org$netbeans$modules$editor$options$ColoringEditorPanel = ColoringEditorPanel.class$("org.netbeans.modules.editor.options.ColoringEditorPanel")) : class$org$netbeans$modules$editor$options$ColoringEditorPanel), (String)s);
    }

    public ColoringBean getValue() {
        return this.value;
    }

    public void setValue(ColoringBean value) {
        if (value == null || value.coloring == null) {
            return;
        }
        if (this.value != value) {
            this.value = value;
            this.updateEditors();
            this.preview.setValue(value);
            this.firePropertyChange("value", null, null);
        }
    }

    private void setValueImpl(Coloring newColoring) {
        this.value = this.value.changeColoring(newColoring);
        this.preview.setValue(this.value);
        this.firePropertyChange("value", null, null);
    }

    private void updateEditors() {
        if (this.value == null) {
            return;
        }
        this.fontPanel.setValue(this.value.coloring.getFont());
        this.fontPanel.setDefaultValue(this.value.defaultColoring.getFont());
        this.fontPanel.setDefault(this.value.isDefault);
        this.fgColorPanel.setValue(this.value.coloring.getForeColor());
        this.fgColorPanel.setDefaultValue(this.value.defaultColoring.getForeColor());
        this.fgColorPanel.setDefault(this.value.isDefault);
        this.bgColorPanel.setValue(this.value.coloring.getBackColor());
        this.bgColorPanel.setDefaultValue(this.value.defaultColoring.getBackColor());
        this.bgColorPanel.setDefault(this.value.isDefault);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PropWithDefaultPanel
    extends JPanel {
        public static final String PROP_VALUE = "RealValue";
        Object value;
        Object defaultValue;
        PropertyModel model;
        JCheckBox defaultCheckBox;

        public PropWithDefaultPanel(Class propertyClass, Class propertyEditorClass, String title, String description, String checkBoxTitle, char checkBoxMnemonic, String checkBoxDescription) {
            this.setLayout(new BorderLayout());
            this.setBorder(new CompoundBorder(new TitledBorder(title), new EmptyBorder(new Insets(8, 12, 6, 11))));
            this.model = new PropertyModelSupport(propertyClass, propertyEditorClass);
            this.model.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ PropWithDefaultPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("value".equals(evt.getPropertyName())) {
                        Object newValue;
                        block4: {
                            newValue = null;
                            try {
                                newValue = this.this$0.model.getValue();
                            }
                            catch (InvocationTargetException e) {
                                if (!Boolean.getBoolean("org.netbeans.exceptions")) break block4;
                                e.printStackTrace();
                            }
                        }
                        if (this.this$0.value == null && newValue.equals(this.this$0.defaultValue)) {
                            return;
                        }
                        this.this$0.value = newValue;
                        this.this$0.defaultCheckBox.setSelected(false);
                        this.this$0.firePropertyChange("RealValue", null, null);
                        this.this$0.repaint();
                    }
                }
            });
            PropertyPanel pp = new PropertyPanel(this.model, 0);
            pp.setMinimumSize(new Dimension(50, 22));
            pp.getAccessibleContext().setAccessibleName(title);
            pp.getAccessibleContext().setAccessibleDescription(description);
            this.add((Component)pp, "Center");
            this.defaultCheckBox = new JCheckBox();
            this.defaultCheckBox.setText(checkBoxTitle);
            this.defaultCheckBox.setMnemonic(checkBoxMnemonic);
            this.defaultCheckBox.getAccessibleContext().setAccessibleDescription(checkBoxDescription);
            this.defaultCheckBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropWithDefaultPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent evt) {
                    if (!this.this$0.defaultCheckBox.isSelected()) {
                        this.this$0.value = this.this$0.defaultValue;
                        PropWithDefaultPanel.access$600(this.this$0, this.this$0.defaultValue);
                        this.this$0.firePropertyChange("RealValue", null, null);
                    } else {
                        this.this$0.value = null;
                        PropWithDefaultPanel.access$600(this.this$0, this.this$0.defaultValue);
                        this.this$0.firePropertyChange("RealValue", null, null);
                    }
                }
            });
            this.add((Component)this.defaultCheckBox, "South");
        }

        public void firePropertyChange(String s, Object old, Object newVal) {
            super.firePropertyChange(s, old, newVal);
        }

        public void setValue(Object value) {
            this.value = value;
            if (value == null) {
                this.modelSetValue(this.defaultValue);
                this.defaultCheckBox.setSelected(true);
            } else {
                this.modelSetValue(value);
                this.defaultCheckBox.setSelected(false);
            }
        }

        Object getValue() {
            return this.value;
        }

        public void setDefaultValue(Object def) {
            this.defaultValue = def;
            if (this.value == null) {
                this.modelSetValue(this.defaultValue);
            }
        }

        public void setDefault(boolean isDefault) {
            this.defaultCheckBox.setEnabled(!isDefault);
            if (isDefault) {
                this.defaultCheckBox.setSelected(false);
            }
        }

        private void modelSetValue(Object val) {
            block2: {
                try {
                    this.model.setValue(val);
                }
                catch (InvocationTargetException e) {
                    if (!Boolean.getBoolean("org.netbeans.exceptions")) break block2;
                    e.printStackTrace();
                }
            }
            this.repaint();
        }

        static /* synthetic */ void access$600(PropWithDefaultPanel x0, Object x1) {
            x0.modelSetValue(x1);
        }

        private class PropertyModelSupport
        implements PropertyModel {
            public static final String PROP_MOD_VALUE = "value";
            private PropertyChangeSupport support = new PropertyChangeSupport(this);
            Class type;
            Class editor;
            Object value;

            public PropertyModelSupport(Class propertyType, Class propertyEditor) {
                this.type = propertyType;
                this.editor = propertyEditor;
            }

            public Class getPropertyType() {
                return this.type;
            }

            public Class getPropertyEditorClass() {
                return this.editor;
            }

            public Object getValue() {
                return this.value;
            }

            public void setValue(Object v) {
                if (v != null && !v.equals(this.value)) {
                    this.value = v;
                    this.support.firePropertyChange(PROP_MOD_VALUE, null, null);
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
                this.support.addPropertyChangeListener(l);
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
                this.support.removePropertyChangeListener(l);
            }
        }
    }

    private class ColoringPreview
    extends JComponent
    implements Accessible {
        ColoringBean value;

        private ColoringPreview() {
        }

        void setValue(ColoringBean c) {
            this.value = c;
            this.repaint();
        }

        public void paint(Graphics g) {
            if (this.value != null) {
                Coloring coloring = this.value.coloring.apply(this.value.defaultColoring);
                Rectangle box = this.getBounds();
                g.setColor(coloring.getBackColor());
                g.fillRect(0, 0, box.width - 1, box.height - 1);
                g.setColor(coloring.getForeColor());
                g.setFont(coloring.getFont());
                FontMetrics fm = g.getFontMetrics();
                int x = Math.max((box.width - fm.stringWidth(this.value.example)) / 2, 0);
                int y = Math.max((box.height - fm.getHeight()) / 2 + fm.getAscent(), 0);
                g.drawString(this.value.example, x, y);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(this){
                    private final /* synthetic */ ColoringPreview this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.PANEL;
                    }
                };
            }
            return this.accessibleContext;
        }
    }
}

