/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Arrays;
import java.util.Iterator;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.options.ContextSystemOption;
import org.openide.options.SystemOption;

class ContextOptionsListener
implements BeanContextMembershipListener {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.options");
    private static final ContextOptionsListener sharedListener = new ContextOptionsListener();

    static void processExistingAndListen(ContextSystemOption cso) {
        SystemOption[] sos;
        BeanContextChild bcc = cso.getBeanContextProxy();
        if (bcc instanceof BeanContext) {
            ((BeanContext)bcc).addBeanContextMembershipListener(sharedListener);
        }
        if ((sos = cso.getOptions()) != null) {
            sharedListener.processInitializers(Arrays.asList(sos).iterator(), false);
        }
    }

    private ContextOptionsListener() {
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.processInitializers(bcme.iterator(), false);
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        this.processInitializers(bcme.iterator(), true);
    }

    private void processInitializers(Iterator it, boolean remove) {
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof OptionSupport)) continue;
            OptionSupport os = (OptionSupport)((Object)o);
            Settings.Initializer si = os.getSettingsInitializer();
            Settings.removeInitializer(si.getName());
            if (!remove) {
                Settings.addInitializer(si, 3);
            }
            if (!debug) continue;
            System.err.println((remove ? "Removed" : "Refreshed") + " initializer=" + si.getName());
        }
        Settings.reset();
    }
}

