/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class InstalledOptionsFolder
extends FolderInstance
implements TaskListener {
    public static final String FOLDER = "Editors/Options/Installed";
    private static Map globalMPFolder = new HashMap();
    private static InstalledOptionsFolder settingsFolder;
    private static Map installedOptions;
    private static PropertyChangeSupport propertySupport;
    public static final String INSTALLED_OPTIONS = "installedOptions";
    private static Map installedOld;

    private InstalledOptionsFolder(DataFolder fld) {
        super(fld);
        propertySupport = new PropertyChangeSupport((Object)this);
        this.addTaskListener(this);
        this.recreate();
    }

    public static synchronized InstalledOptionsFolder getDefault() {
        if (settingsFolder != null) {
            return settingsFolder;
        }
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER);
        if (f == null) {
            return null;
        }
        DataFolder df = DataFolder.findFolder((FileObject)f);
        if (df != null && settingsFolder == null) {
            settingsFolder = new InstalledOptionsFolder(df);
            return settingsFolder;
        }
        return null;
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        int i = 0;
        while (i < cookies.length) {
            System.out.println("installing:" + cookies[i].instanceName());
            if (!installedOptions.containsKey(cookies[i].instanceName())) {
                Object instance = cookies[i].instanceCreate();
                if (!(instance instanceof BaseOptions)) {
                    System.out.println("it is not instance of BO !!!");
                } else {
                    BaseOptions bop = (BaseOptions)((Object)instance);
                    System.out.println("installed");
                    installedOptions.put(bop.getKitClass(), bop);
                }
            }
            ++i;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(listener);
    }

    public void taskFinished(Task task) {
        propertySupport.firePropertyChange(INSTALLED_OPTIONS, installedOld, installedOptions);
        installedOld.putAll(installedOptions);
    }

    static {
        installedOptions = new Hashtable();
        installedOld = new HashMap();
    }
}

