/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyBindingsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "bindings";
    public static final String TAG_BIND = "bind";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_ACTION_NAME = "actionName";
    public static final String ATTR_REMOVE = "remove";
    static final String FILENAME = "keybindings";

    public KeyBindingsMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    private List getKBList() {
        Settings.KitAndValue[] kav = Settings.getValueHierarchy(this.base.getKitClass(), "key-bindings");
        List<MultiKeyBinding> kbList = null;
        int i = 0;
        while (i < kav.length) {
            if (kav[i].kitClass == this.base.getKitClass()) {
                kbList = (List)kav[i].value;
            }
            ++i;
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        int cnt = kbList.size();
        int i2 = 0;
        while (i2 < cnt) {
            Object o = kbList.get(i2);
            if (!(o instanceof MultiKeyBinding) && o != null) {
                JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
                kbList.set(i2, new MultiKeyBinding(b.key, b.actionName));
            }
            ++i2;
        }
        return new ArrayList(kbList);
    }

    protected synchronized void loadSettings(boolean propagate) {
        Document doc = this.dom;
        Element rootElement = doc.getDocumentElement();
        if (!TAG_ROOT.equals(rootElement.getTagName())) {
            return;
        }
        List keybs = this.getKBList();
        Map mapa = OptionUtilities.makeKeyBindingsMap(keybs);
        this.properties.clear();
        NodeList bind = rootElement.getElementsByTagName(TAG_BIND);
        int i = 0;
        while (i < bind.getLength()) {
            Node node = bind.item(i);
            Element bindElement = (Element)node;
            if (bindElement != null) {
                String key = bindElement.getAttribute(ATTR_KEY);
                String delete = bindElement.getAttribute(ATTR_REMOVE);
                String actionName = bindElement.getAttribute(ATTR_ACTION_NAME);
                if (actionName == null) {
                    actionName = "";
                }
                if (actionName.length() != 0 && !Boolean.valueOf(delete).booleanValue()) {
                    MultiKeyBinding mkb;
                    if (key.indexOf(36) > 0) {
                        mkb = new MultiKeyBinding(OptionUtilities.stringToKeys(key), actionName);
                        this.properties.put(key, mkb);
                    } else {
                        mkb = new MultiKeyBinding(OptionUtilities.stringToKey(key), actionName);
                        this.properties.put(key, mkb);
                    }
                } else {
                    this.properties.put(key, "");
                }
            }
            ++i;
        }
        if (this.properties.size() > 0) {
            mapa.putAll(this.properties);
            Iterator i2 = this.properties.keySet().iterator();
            while (i2.hasNext()) {
                String key = (String)i2.next();
                if (!(this.properties.get(key) instanceof String)) continue;
                mapa.remove(key);
            }
            if (propagate) {
                this.base.setKeyBindingList(new ArrayList(mapa.values()), false);
            }
        }
        if (propagate) {
            this.setLoaded(true);
        }
    }

    protected synchronized void updateSettings(Map changedProp) {
        this.properties.putAll(changedProp);
        Document doc = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
        Element rootElem = doc.getDocumentElement();
        ArrayList<String> removed = new ArrayList<String>();
        HashMap defaultKeybs = this.base.getDefaultKeyBindingsMap();
        if (defaultKeybs == null) {
            defaultKeybs = new HashMap();
        }
        Iterator i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (this.properties.get(key) instanceof String) {
                if (defaultKeybs.containsKey(key)) {
                    Element keybElem = doc.createElement(TAG_BIND);
                    keybElem.setAttribute(ATTR_KEY, key);
                    keybElem.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
                    rootElem.appendChild(keybElem);
                    continue;
                }
                removed.add(key);
                continue;
            }
            if (!(this.properties.get(key) instanceof MultiKeyBinding)) continue;
            MultiKeyBinding mkb = (MultiKeyBinding)this.properties.get(key);
            String curActionName = mkb.actionName;
            if (curActionName == null) {
                curActionName = "";
            }
            boolean save = true;
            if (defaultKeybs.get(key) instanceof MultiKeyBinding) {
                String defActionName = ((MultiKeyBinding)defaultKeybs.get((Object)key)).actionName;
                if (defaultKeybs.containsKey(key) && curActionName.equals(defActionName)) {
                    save = false;
                }
            }
            if (!save) continue;
            Element keybElem = doc.createElement(TAG_BIND);
            keybElem.setAttribute(ATTR_KEY, key);
            keybElem.setAttribute(ATTR_ACTION_NAME, curActionName);
            rootElem.appendChild(keybElem);
        }
        int i2 = 0;
        while (i2 < removed.size()) {
            this.properties.remove(removed.get(i2));
            ++i2;
        }
        doc.getDocumentElement().normalize();
        this.saveSettings(doc);
    }
}

